package com.ejianc.business.bedget.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.bedget.bean.PaymentDetailEntity;
import com.ejianc.business.bedget.bean.PaymentEntity;
import com.ejianc.business.bedget.service.IPaymentService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ComputeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Service("payment") 
public class PaymentBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IPaymentService service;


	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		logger.info("提交前回调------------------------------------");
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		logger.info("提交完回调------------------------------------");
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		logger.info("======================================有审批流的撤回前回调====================================== state:"+state);
		PaymentEntity paymentEntity = service.selectById(billId);
		if(queryTop(paymentEntity.getProjectId(),paymentEntity.getCreateTime())){
			throw new BusinessException("已有下期付款登记，本期不允许撤回！");
		}
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		logger.info("======================================有审批流的撤回后回调====================================== state:"+state);
		PaymentEntity paymentEntity = service.selectById(billId);
		for(PaymentDetailEntity paymentDetailEntity : paymentEntity.getPaymentDetailList()){
			paymentDetailEntity.setPastAdvanceTotal(new BigDecimal("0"));
			paymentDetailEntity.setPastScheduleTotal(new BigDecimal("0"));
			paymentDetailEntity.setPastSalaryTotal(new BigDecimal("0"));
		}
		service.saveOrUpdate(paymentEntity,false);
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		logger.info("终审审核完回调------------------------------------");
		PaymentEntity paymentEntity = service.selectById(billId);
		for(PaymentDetailEntity paymentDetailEntity : paymentEntity.getPaymentDetailList()){
			paymentDetailEntity.setPastAdvanceTotal(paymentDetailEntity.getPaymentAdvanceMoney());
			paymentDetailEntity.setPastScheduleTotal(paymentDetailEntity.getPaymentScheduleMoney());
			paymentDetailEntity.setPastSalaryTotal(paymentDetailEntity.getPaymentSalaryMoney());
		}
		service.saveOrUpdate(paymentEntity,false);
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		PaymentEntity paymentEntity = service.selectById(billId);
		if(queryTop(paymentEntity.getProjectId(),paymentEntity.getCreateTime())){
			throw new BusinessException("已有下期付款登记，本期不允许撤回！");
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		PaymentEntity paymentEntity = service.selectById(billId);
		for(PaymentDetailEntity paymentDetailEntity : paymentEntity.getPaymentDetailList()){
			paymentDetailEntity.setPastAdvanceTotal(new BigDecimal("0"));
			paymentDetailEntity.setPastScheduleTotal(new BigDecimal("0"));
		}
		service.saveOrUpdate(paymentEntity,false);
		return CommonResponse.success();
	}

	public Boolean queryTop(Long projectId, Date createTime) {
		LambdaQueryWrapper<PaymentEntity> lambdaFlower = Wrappers.<PaymentEntity>lambdaQuery();
		lambdaFlower.eq(PaymentEntity::getProjectId,projectId);
		lambdaFlower.gt(PaymentEntity::getCreateTime,createTime);
		List<PaymentEntity> paymentEntityList = service.list(lambdaFlower);
		if(paymentEntityList.size()>0){
			return true;
		}else{
			return false;
		}
	}

}
