package com.ejianc.business.bedget.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.bedget.bean.PaymentEntity;
import com.ejianc.business.bedget.mapper.PaymentMapper;
import com.ejianc.business.bedget.service.IPaymentService;
import com.ejianc.business.bedget.vo.PaymentDetailVO;
import com.ejianc.business.bedget.vo.PaymentVO;
import com.ejianc.business.utils.BigDecimalUtils;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 付款登记
 * 
 * @author generator
 * 
 */
@Service("paymentService")
public class PaymentServiceImpl extends BaseServiceImpl<PaymentMapper, PaymentEntity> implements IPaymentService{

    @Autowired
    private PaymentMapper paymentMapper;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public PaymentVO queryDetailList(Long projectId) {
        //根据项目查询所有合同信息
        List<PaymentDetailVO> queryOutcontractList = queryOutcontractList(projectId);
        //是否最终结算
        for(PaymentDetailVO paymentDetailVO : queryOutcontractList){
            paymentDetailVO.setId(IdWorker.getId());
            if("劳务分包".equals(paymentDetailVO.getSubcontractType()) || "专业分包".equals(paymentDetailVO.getSubcontractType())){
                paymentDetailVO.setIsComplete(querySettlementBookList(paymentDetailVO.getProjectId(),paymentDetailVO.getContractId()));
                paymentDetailVO.setTaxCurrentTotal(querySubcontractingvolume(paymentDetailVO.getProjectId(),paymentDetailVO.getContractId()));
                paymentDetailVO.setTotalMoneyTax(querySettlementBookListAmount(paymentDetailVO.getProjectId(),paymentDetailVO.getContractId()));
            }else if("物资采购".equals(paymentDetailVO.getSubcontractType()) ){
                logger.info("物资采购---"+paymentDetailVO.getContractId()+"-----" + paymentDetailVO.getContractName() + "------" +paymentDetailVO.getContractCode());
                paymentDetailVO.setIsComplete(queryPurchaseSettlementList(paymentDetailVO.getProjectId(),paymentDetailVO.getContractId()));
                paymentDetailVO.setTaxCurrentTotal(queryPurchasesettlement(paymentDetailVO.getProjectId(),paymentDetailVO.getContractId()));
                paymentDetailVO.setTotalMoneyTax(queryPurchaseSettlementListAmount(paymentDetailVO.getProjectId(),paymentDetailVO.getContractId()));
                logger.info("物资采购---"+paymentDetailVO.getContractId()+"-----" + paymentDetailVO.getContractName() + "------" +
                        paymentDetailVO.getContractCode() +"getTaxCurrentTotal---"+paymentDetailVO.getTaxCurrentTotal() + "getTotalMoneyTax---" + paymentDetailVO.getTotalMoneyTax());

            }else if("机械租赁".equals(paymentDetailVO.getSubcontractType()) ){
                paymentDetailVO.setIsComplete(queryMachinerySettlementList(paymentDetailVO.getProjectId(),paymentDetailVO.getContractId()));
                paymentDetailVO.setTaxCurrentTotal(queryMechanicallease(paymentDetailVO.getProjectId(),paymentDetailVO.getContractId()));
//                paymentDetailVO.setTotalMoneyTax(queryMachinerySettlementListAmount(paymentDetailVO.getProjectId(),paymentDetailVO.getContractId()));
                paymentDetailVO.setTotalMoneyTax(BigDecimal.ZERO);
            }else if("周转材租赁".equals(paymentDetailVO.getSubcontractType()) ){
                paymentDetailVO.setIsComplete(queryLeaseSettLementList(paymentDetailVO.getProjectId(),paymentDetailVO.getContractId()));
                paymentDetailVO.setTaxCurrentTotal(queryRevolvinglease(paymentDetailVO.getProjectId(),paymentDetailVO.getContractId()));
//                paymentDetailVO.setTotalMoneyTax(queryLeaseSettLementListAmount(paymentDetailVO.getProjectId(),paymentDetailVO.getContractId()));
                paymentDetailVO.setTotalMoneyTax(BigDecimal.ZERO);
            }else if("设计勘察".equals(paymentDetailVO.getSubcontractType()) ){
                paymentDetailVO.setIsComplete(queryDesignSettlementList(paymentDetailVO.getProjectId(),paymentDetailVO.getContractId()));
                paymentDetailVO.setTaxCurrentTotal(queryDesignsubcontractnode(paymentDetailVO.getProjectId(),paymentDetailVO.getContractId()));
                paymentDetailVO.setTotalMoneyTax(queryDesignSettlementListAmount(paymentDetailVO.getProjectId(),paymentDetailVO.getContractId()));
            }else  if("咨询服务".equals(paymentDetailVO.getSubcontractType()) || "其它合同".equals(paymentDetailVO.getSubcontractType())){
                paymentDetailVO.setIsComplete(queryConsultotherfinalList(paymentDetailVO.getProjectId(),paymentDetailVO.getContractId()));
                paymentDetailVO.setTaxCurrentTotal(queryConsultother(paymentDetailVO.getProjectId(),paymentDetailVO.getContractId()));
                paymentDetailVO.setTotalMoneyTax(queryConsultotherfinalListAmount(paymentDetailVO.getProjectId(),paymentDetailVO.getContractId()));
            }

            paymentDetailVO.setSettlementMoneyTotal(ComputeUtil.safeAdd(paymentDetailVO.getTaxCurrentTotal(), paymentDetailVO.getTotalMoneyTax()));
        }
        //查询历史数据
        List<PaymentDetailVO> paymentDetailVOList = queryDetailVOList(projectId);
        if(CollectionUtil.isNotEmpty(paymentDetailVOList)){
            //更新历史数据中的合同数据
            for(PaymentDetailVO paymentDetailVO : paymentDetailVOList){
                paymentDetailVO.setId(IdWorker.getId());
                if("劳务分包".equals(paymentDetailVO.getSubcontractType()) || "专业分包".equals(paymentDetailVO.getSubcontractType())){
                    paymentDetailVO.setIsComplete(querySettlementBookList(projectId,paymentDetailVO.getContractId()));
                    paymentDetailVO.setTaxCurrentTotal(querySubcontractingvolume(projectId,paymentDetailVO.getContractId()));
                    paymentDetailVO.setTotalMoneyTax(querySettlementBookListAmount(projectId,paymentDetailVO.getContractId()));
                }else if("物资采购".equals(paymentDetailVO.getSubcontractType()) ){
                    paymentDetailVO.setIsComplete(queryPurchaseSettlementList(projectId,paymentDetailVO.getContractId()));
                    paymentDetailVO.setTaxCurrentTotal(queryPurchasesettlement(projectId,paymentDetailVO.getContractId()));
                    paymentDetailVO.setTotalMoneyTax(queryPurchaseSettlementListAmount(projectId,paymentDetailVO.getContractId()));
                    logger.info("物资采购222---"+paymentDetailVO.getContractId()+"-----" + paymentDetailVO.getContractName() + "------" +
                            paymentDetailVO.getContractCode() +"getTaxCurrentTotal---"+paymentDetailVO.getTaxCurrentTotal() + "getTotalMoneyTax---" + paymentDetailVO.getTotalMoneyTax());

                }else if("机械租赁".equals(paymentDetailVO.getSubcontractType()) ){
                    paymentDetailVO.setIsComplete(queryMachinerySettlementList(projectId,paymentDetailVO.getContractId()));
                    paymentDetailVO.setTaxCurrentTotal(queryMechanicallease(projectId,paymentDetailVO.getContractId()));
//                    paymentDetailVO.setTotalMoneyTax(queryMachinerySettlementListAmount(projectId,paymentDetailVO.getContractId()));
                    paymentDetailVO.setTotalMoneyTax(BigDecimal.ZERO);
                }else if("周转材租赁".equals(paymentDetailVO.getSubcontractType()) ){
                    paymentDetailVO.setIsComplete(queryLeaseSettLementList(projectId,paymentDetailVO.getContractId()));
                    paymentDetailVO.setTaxCurrentTotal(queryRevolvinglease(projectId,paymentDetailVO.getContractId()));
//                    paymentDetailVO.setTotalMoneyTax(queryLeaseSettLementListAmount(projectId,paymentDetailVO.getContractId()));
                    paymentDetailVO.setTotalMoneyTax(BigDecimal.ZERO);
                }else if("设计勘察".equals(paymentDetailVO.getSubcontractType()) ){
                    paymentDetailVO.setIsComplete(queryDesignSettlementList(projectId,paymentDetailVO.getContractId()));
                    paymentDetailVO.setTaxCurrentTotal(queryDesignsubcontractnode(projectId,paymentDetailVO.getContractId()));
                    paymentDetailVO.setTotalMoneyTax(queryDesignSettlementListAmount(projectId,paymentDetailVO.getContractId()));
                }else  if("咨询服务".equals(paymentDetailVO.getSubcontractType()) || "其它合同".equals(paymentDetailVO.getSubcontractType())){
                    paymentDetailVO.setIsComplete(queryConsultotherfinalList(projectId,paymentDetailVO.getContractId()));
                    paymentDetailVO.setTaxCurrentTotal(queryConsultother(projectId,paymentDetailVO.getContractId()));
                    paymentDetailVO.setTotalMoneyTax(queryConsultotherfinalListAmount(projectId,paymentDetailVO.getContractId()));
                }

                paymentDetailVO.setSettlementMoneyTotal(ComputeUtil.safeAdd(paymentDetailVO.getTaxCurrentTotal(), paymentDetailVO.getTotalMoneyTax()));
            }
        }

        if(CollectionUtil.isNotEmpty(paymentDetailVOList)){
            for(PaymentDetailVO paymentDetailVO : paymentDetailVOList){
                paymentDetailVO.setId(IdWorker.getId());
            }
            Map<Long,PaymentDetailVO> maps = paymentDetailVOList.stream().collect(Collectors.toMap(x->x.getContractId(), Function.identity(),(k1, k2) ->k2));
            Long k;
            for(PaymentDetailVO vo : queryOutcontractList){
                k = vo.getContractId();
                if (!maps.containsKey(k)){
                    paymentDetailVOList.add(vo);
                }
            }
            //累计支付比例汇总
            BigDecimal paymentCopeWithRatio = new BigDecimal("0");
            //累计付款金额（含本期) 预付账款
            BigDecimal paymentAdvanceMoney = new BigDecimal("0");
            //累计已支付金额
            BigDecimal havePaidTotal  = new BigDecimal("0");
            // 累计欠款金额 合计
            BigDecimal debtMoneyTotal  = new BigDecimal("0");
            for(PaymentDetailVO vo : paymentDetailVOList){
                vo.setPaymentAdvanceMoney(ComputeUtil.safeAdd(vo.getPaymentAdvanceMoney(),vo.getCurrentAdvanceMoney()));
                vo.setPaymentScheduleMoney(ComputeUtil.safeAdd(vo.getPaymentScheduleMoney(),vo.getCurrentScheduleMoney()));
                vo.setPaymentMoneyTotal(ComputeUtil.safeAdd(vo.getPaymentAdvanceMoney(),vo.getPaymentScheduleMoney()));
                vo.setPaymentCopeWithRatio(ComputeUtil.safeDiv(vo.getPaymentMoneyTotal(),vo.getSettlementMoneyTotal()));

                //  累计欠款金额预付账款
                vo.setDebtAdvanceMoney(ComputeUtil.safeSub(vo.getAdvanceTotal(),vo.getPaymentAdvanceMoney()));
                // 累计欠款金额 进度账款 scheduleTotal - paymentScheduleMoney
                vo.setDebtScheduleMoney(ComputeUtil.safeSub(vo.getScheduleTotal(),vo.getPaymentScheduleMoney()));
                // 累计欠款金额 合计
                vo.setDebtMoneyTotal(ComputeUtil.safeAdd(vo.getDebtAdvanceMoney(),vo.getDebtScheduleMoney()));
                paymentCopeWithRatio = ComputeUtil.safeAdd(paymentCopeWithRatio,vo.getPaymentCopeWithRatio());
                paymentAdvanceMoney=  ComputeUtil.safeAdd(paymentAdvanceMoney,vo.getPaymentAdvanceMoney());
                havePaidTotal = ComputeUtil.safeAdd(havePaidTotal,vo.getPaymentMoneyTotal());
                debtMoneyTotal = ComputeUtil.safeAdd(debtMoneyTotal,vo.getDebtMoneyTotal());
                logger.info("物资采购333---"+vo.getContractId()+"-----" + vo.getContractName() + "------" +
                        vo.getContractCode() +"getTaxCurrentTotal---"+vo.getTaxCurrentTotal() + "getTotalMoneyTax---" + vo.getTotalMoneyTax());

            }

            //查询表头
            PaymentEntity paymentEntity = selectById(paymentDetailVOList.get(0).getPaymentId());
            paymentEntity.setPaymentRatioTotal(paymentCopeWithRatio);
            paymentEntity.setInAdvancePaymentMoney(paymentAdvanceMoney);
            paymentEntity.setHavePaidTotal(havePaidTotal);
            paymentEntity.setDebtMoneyTotal(debtMoneyTotal);
            PaymentVO paymentVO = BeanMapper.map(paymentEntity, PaymentVO.class);
            paymentVO.setPaymentDetailList(orderByList(paymentDetailVOList));

            return paymentVO;
        }else{
            PaymentVO paymentVO = new PaymentVO();
            paymentVO.setPaymentDetailList(orderByList(queryOutcontractList));
            return paymentVO;
        }
    }

    @Override
    public List<PaymentDetailVO> queryOutcontractList(Long projectId) {
        return paymentMapper.queryOutcontractList(projectId);
    }

    @Override
    public String querySettlementBookList(Long projectId,Long contractId) {
        List<PaymentDetailVO> paymentDetailVOS = paymentMapper.querySettlementBookList(projectId,contractId);
        if (CollectionUtil.isNotEmpty(paymentDetailVOS)) {
            return "是";
        }else{
            return "否";
        }
    }

    @Override
    public String queryPurchaseSettlementList(Long projectId, Long contractId) {
        List<PaymentDetailVO> paymentDetailVOS = paymentMapper.queryPurchaseSettlementList(projectId,contractId);
        if (CollectionUtil.isNotEmpty(paymentDetailVOS)) {
            return "是";
        }else{
            return "否";
        }
    }

    @Override
    public String queryLeaseSettLementList(Long projectId, Long contractId) {
        List<PaymentDetailVO> paymentDetailVOS = paymentMapper.queryLeaseSettLementList(projectId,contractId);
        if (CollectionUtil.isNotEmpty(paymentDetailVOS)) {
            return "是";
        }else{
            return "否";
        }
    }

    @Override
    public String queryMachinerySettlementList(Long projectId, Long contractId) {
        List<PaymentDetailVO> paymentDetailVOS = paymentMapper.queryMachinerySettlementList(projectId,contractId);
        if (CollectionUtil.isNotEmpty(paymentDetailVOS)) {
            return "是";
        }else{
            return "否";
        }
    }

    @Override
    public String queryDesignSettlementList(Long projectId, Long contractId) {
        List<PaymentDetailVO> paymentDetailVOS = paymentMapper.queryDesignSettlementList(projectId,contractId);
        if (CollectionUtil.isNotEmpty(paymentDetailVOS)) {
            return "是";
        }else{
            return "否";
        }
    }

    @Override
    public String queryConsultotherfinalList(Long projectId, Long contractId) {
        List<PaymentDetailVO> paymentDetailVOS = paymentMapper.queryConsultotherfinalList(projectId,contractId);
        if (CollectionUtil.isNotEmpty(paymentDetailVOS)) {
            return "是";
        }else{
            return "否";
        }
    }

    @Override
    public BigDecimal querySubcontractingvolume(Long projectId, Long contractId) {
        List<PaymentDetailVO> paymentDetailVOS = paymentMapper.querySubcontractingvolume(projectId,contractId);
        if (CollectionUtil.isNotEmpty(paymentDetailVOS)) {
            return paymentDetailVOS.get(0).getTotalMoneyTax();
        }else{
            return new BigDecimal("0");
        }
    }

    @Override
    public BigDecimal queryPurchasesettlement(Long projectId, Long contractId) {
        List<PaymentDetailVO> paymentDetailVOS = paymentMapper.queryPurchasesettlement(projectId,contractId);
        if (CollectionUtil.isNotEmpty(paymentDetailVOS)) {
            return paymentDetailVOS.get(0).getTotalMoneyTax();
        }else{
            return new BigDecimal("0");
        }
    }

    @Override
    public BigDecimal queryRevolvinglease(Long projectId, Long contractId) {
        List<PaymentDetailVO> paymentDetailVOS = paymentMapper.queryRevolvinglease(projectId,contractId);
        if (CollectionUtil.isNotEmpty(paymentDetailVOS)) {
            return paymentDetailVOS.get(0).getTotalMoneyTax();
        }else{
            return new BigDecimal("0");
        }
    }

    @Override
    public BigDecimal queryMechanicallease(Long projectId, Long contractId) {
        List<PaymentDetailVO> paymentDetailVOS = paymentMapper.queryMechanicallease(projectId,contractId);
        if (CollectionUtil.isNotEmpty(paymentDetailVOS)) {
            return paymentDetailVOS.get(0).getTotalMoneyTax();
        }else{
            return new BigDecimal("0");
        }
    }

    @Override
    public BigDecimal queryDesignsubcontractnode(Long projectId, Long contractId) {
        List<PaymentDetailVO> paymentDetailVOS = paymentMapper.queryDesignsubcontractnode(projectId,contractId);
        if (CollectionUtil.isNotEmpty(paymentDetailVOS)) {
            return paymentDetailVOS.get(0).getTotalMoneyTax();
        }else{
            return new BigDecimal("0");
        }
    }

    @Override
    public BigDecimal queryConsultother(Long projectId, Long contractId) {
        List<PaymentDetailVO> paymentDetailVOS = paymentMapper.queryConsultother(projectId,contractId);
        if (CollectionUtil.isNotEmpty(paymentDetailVOS)) {
            return paymentDetailVOS.get(0).getTotalMoneyTax();
        }else{
            return new BigDecimal("0");
        }
    }

    @Override
    public BigDecimal querySettlementBookListAmount(Long projectId, Long contractId) {
        List<PaymentDetailVO> paymentDetailVOS = paymentMapper.querySettlementBookListAmount(projectId,contractId);
        if (CollectionUtil.isNotEmpty(paymentDetailVOS)) {
            return paymentDetailVOS.get(0).getTotalMoneyTax();
        }else{
            return new BigDecimal("0");
        }
    }

    @Override
    public BigDecimal queryPurchaseSettlementListAmount(Long projectId, Long contractId) {
        List<PaymentDetailVO> paymentDetailVOS = paymentMapper.queryPurchaseSettlementListAmount(projectId,contractId);
        if (CollectionUtil.isNotEmpty(paymentDetailVOS)) {
            return paymentDetailVOS.get(0).getTotalMoneyTax();
        }else{
            return new BigDecimal("0");
        }
    }

    @Override
    public BigDecimal queryLeaseSettLementListAmount(Long projectId, Long contractId) {
        List<PaymentDetailVO> paymentDetailVOS = paymentMapper.queryLeaseSettLementListAmount(projectId,contractId);
        if (CollectionUtil.isNotEmpty(paymentDetailVOS)) {
            return paymentDetailVOS.get(0).getTotalMoneyTax();
        }else{
            return new BigDecimal("0");
        }
    }

    @Override
    public BigDecimal queryMachinerySettlementListAmount(Long projectId, Long contractId) {
        List<PaymentDetailVO> paymentDetailVOS = paymentMapper.queryMachinerySettlementListAmount(projectId,contractId);

        if (CollectionUtil.isNotEmpty(paymentDetailVOS)) {
            return paymentDetailVOS.get(0).getTotalMoneyTax();
        }else{
            return new BigDecimal("0");
        }
    }

    @Override
    public BigDecimal queryDesignSettlementListAmount(Long projectId, Long contractId) {
        List<PaymentDetailVO> paymentDetailVOS = paymentMapper.queryDesignSettlementListAmount(projectId,contractId);
        if (CollectionUtil.isNotEmpty(paymentDetailVOS)) {
            return paymentDetailVOS.get(0).getTotalMoneyTax();
        }else{
            return new BigDecimal("0");
        }
    }

    @Override
    public BigDecimal queryConsultotherfinalListAmount(Long projectId, Long contractId) {
        List<PaymentDetailVO> paymentDetailVOS = paymentMapper.queryConsultotherfinalListAmount(projectId,contractId);
        if (CollectionUtil.isNotEmpty(paymentDetailVOS)) {
            return paymentDetailVOS.get(0).getTotalMoneyTax();
        }else{
            return new BigDecimal("0");
        }
    }

    @Override
    public List<PaymentDetailVO> queryDetailVOList(Long projectId) {
        return paymentMapper.queryDetailVOList(projectId);
    }

    @Override
    public  List<PaymentDetailVO>  queryDetailListParams(Long paymentId,String searchText) {
        return paymentMapper.queryDetailListParams(paymentId,searchText);
    }

    @Override
    public Object detailImport(HttpServletRequest request, HttpServletResponse response, Long projectId, List<PaymentDetailVO> pcList) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<PaymentDetailVO> success = new ArrayList<>();
        List<PaymentDetailVO> errorList = new ArrayList<>();
        Map<String, PaymentDetailVO> map = new HashMap<>();
        List<PaymentDetailVO> costNewList = new ArrayList<>();
        List<PaymentDetailVO> costList = new ArrayList<>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }

        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                logger.info("resultsize---"+result.size());
                for (int i = 2; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    StringBuilder errorsMsgBuilder = new StringBuilder();
//                    {type: "input", title: "合同编码", key: "contractCode"},0
//                    {type: "input", title: "合同名称", key: "contractName"},1
//                    {type: "input", title: "分包分供名称", key: "supplierName"},2
//                    {type: "input", title: "分包类型", key: "subcontractType"},3
//                    {type: "input", title: "合同额（含税）", key: "contractAmountTax"},4
//                    {type: "input", title: "是否完工结算", key: "isComplete"},5
//                    {type: "input", title: "累计结算金额（含税）", key: "settlementMoneyTotal"},6
//                    {type: "input", title: "累计应付金额-应付比例 (%)", key: "copeWithRatioTotal"},7
//                    {type: "input", title: "累计应付金额-预付账款", key: "advanceTotal"},8
//                    {type: "input", title: "累计应付金额-进度账款", key: "scheduleTotal"},9
//                    {type: "input", title: "本期实付金额-预付款金额", key: "currentAdvanceMoney"},11
//                    {type: "input", title: "本期实付金额-进度款", key: "currentScheduleMoney"},12
//                    {type: "input", title: "本期实付金额-其中农民工工资", key: "currentSalaryMoney"},13

                    String contractCode = datas.get(0);
                    String contractName = datas.get(1);
                    String supplierName = datas.get(2);
                    String subcontractType = datas.get(3);
                    String contractAmountTax = datas.get(4);
                    String isComplete = datas.get(5);
                    String settlementMoneyTotal = datas.get(6);
                    String copeWithRatioTotal = datas.get(7);
                    logger.info("111111111111111"+copeWithRatioTotal);
                    String advanceTotal = datas.get(8);
                    String scheduleTotal = datas.get(9);
                    String accountsPayableTotal = datas.get(10);
                    String currentAdvanceMoney = datas.get(11);
                    String currentScheduleMoney = datas.get(12);
                    String currentSalaryMoney = datas.get(13);
//                    String currentMoneyTotal = datas.get(14);
                    //循环进来TPID
                    PaymentDetailVO paymentDetailVO = new PaymentDetailVO();
                    //三目判断值是否空
                    paymentDetailVO.setContractCode(StringUtils.isNotBlank(contractCode) ? contractCode : null); // 合同编码
                    paymentDetailVO.setContractName(StringUtils.isNotBlank(contractName) ? contractName : null); // 合同名称
                    paymentDetailVO.setSupplierName(StringUtils.isNotBlank(supplierName) ? supplierName : null); // 分包分供名称
                    paymentDetailVO.setSubcontractType(StringUtils.isNotBlank(subcontractType) ? subcontractType : null); // 分包类型
                    paymentDetailVO.setCopeWithRatioTotal(new BigDecimal(StringUtils.isNotBlank(copeWithRatioTotal) ? copeWithRatioTotal : "0.00"));//累计应付金额-应付比例 (%)
                    paymentDetailVO.setAdvanceTotal(new BigDecimal(StringUtils.isNotBlank(advanceTotal) ? advanceTotal : "0.00"));
                    paymentDetailVO.setScheduleTotal(new BigDecimal(StringUtils.isNotBlank(scheduleTotal) ? scheduleTotal : "0.00"));
                    paymentDetailVO.setCurrentAdvanceMoney(new BigDecimal(StringUtils.isNotBlank(currentAdvanceMoney) ? currentAdvanceMoney : "0.00"));
                    paymentDetailVO.setCurrentScheduleMoney(new BigDecimal(StringUtils.isNotBlank(currentScheduleMoney) ? currentScheduleMoney : "0.00"));
                    paymentDetailVO.setCurrentSalaryMoney(new BigDecimal(StringUtils.isNotBlank(currentSalaryMoney) ? currentSalaryMoney : "0.00"));
//                    paymentDetailVO.setCurrentMoneyTotal(new BigDecimal(StringUtils.isNotBlank(currentMoneyTotal) ? currentMoneyTotal : "0.00"));
                    //必填项校验
                    if (contractCode == null || TextUtils.isEmpty(contractCode)) {
                        paymentDetailVO.setErrorMsg("合同编码不能为空！");
                        errorsMsgBuilder.append("合同编码不能为空！");
                    }
                    if (contractName == null || TextUtils.isEmpty(contractName)) {
                        paymentDetailVO.setErrorMsg("合同名称不能为空！");
                        errorsMsgBuilder.append("合同名称不能为空！");
                    }
                    if (errorsMsgBuilder.length() > 0) {
                        errorList.add(paymentDetailVO);
                    } else {
                        success.add(paymentDetailVO);
                    }
                }

                Map<String,PaymentDetailVO> costMap = new HashMap<>();//excel中的数据
                for(PaymentDetailVO vo : success){
                    logger.info("successkey"+vo.getContractCode());
                    costMap.put(vo.getContractCode(),vo);
                }

                //计算
                if (CollectionUtils.isNotEmpty(pcList)){

                    for (PaymentDetailVO paymentDetailVO : pcList){
                        paymentDetailVO.setId(IdWorker.getId());
                        String key = paymentDetailVO.getContractCode();
                        logger.info("key"+key);
                        if (costMap.containsKey(key)){
                            PaymentDetailVO paymentDetailVOExcel = costMap.get(key);
//
                            paymentDetailVO.setCopeWithRatioTotal(paymentDetailVOExcel.getCopeWithRatioTotal());
                            paymentDetailVO.setAdvanceTotal(paymentDetailVOExcel.getAdvanceTotal());
                            paymentDetailVO.setScheduleTotal(paymentDetailVOExcel.getScheduleTotal());
                            paymentDetailVO.setCurrentAdvanceMoney(paymentDetailVOExcel.getCurrentAdvanceMoney());
                            paymentDetailVO.setCurrentScheduleMoney(paymentDetailVOExcel.getCurrentScheduleMoney());
                            paymentDetailVO.setCurrentSalaryMoney(paymentDetailVOExcel.getCurrentSalaryMoney());
                            //计算累计应付金额-合计
                            paymentDetailVO.setAccountsPayableTotal(BigDecimalUtils.add(paymentDetailVO.getAdvanceTotal(),paymentDetailVO.getScheduleTotal()));
                            //本期实付金额-合计
                            paymentDetailVO.setCurrentMoneyTotal(BigDecimalUtils.add(paymentDetailVO.getCurrentAdvanceMoney(),paymentDetailVO.getCurrentScheduleMoney()));
                            //累计付款金额（含本期）-预付账款
                            paymentDetailVO.setPaymentAdvanceMoney(BigDecimalUtils.add(paymentDetailVO.getPastAdvanceTotal(),paymentDetailVO.getCurrentAdvanceMoney()));
                            //累计付款金额（含本期）-进度账款
                            paymentDetailVO.setPaymentScheduleMoney(BigDecimalUtils.add(paymentDetailVO.getPastScheduleTotal(),paymentDetailVO.getCurrentScheduleMoney()));
                            //累计付款金额（含本期）-合计
                            paymentDetailVO.setPaymentMoneyTotal(BigDecimalUtils.add(paymentDetailVO.getPaymentAdvanceMoney(),paymentDetailVO.getPaymentScheduleMoney()));
                            //累计欠款金额 -预付账款
                            paymentDetailVO.setDebtAdvanceMoney(ComputeUtil.safeSub(paymentDetailVO.getAdvanceTotal(),paymentDetailVO.getPaymentAdvanceMoney()));
                            //累计欠款金额 -进度账款
                            paymentDetailVO.setDebtScheduleMoney(ComputeUtil.safeSub(paymentDetailVO.getScheduleTotal(),paymentDetailVO.getPaymentScheduleMoney()));
                            //累计欠款金额 -合计
                            paymentDetailVO.setDebtMoneyTotal(ComputeUtil.safeAdd(paymentDetailVO.getDebtAdvanceMoney(),paymentDetailVO.getDebtScheduleMoney()));
                            //本期实付金额-其中农民工工资
                            if (BigDecimalUtils.ofNullable(paymentDetailVO.getCurrentSalaryMoney()).compareTo(paymentDetailVO.getCurrentScheduleMoney()) == 1){
                                paymentDetailVO.setCurrentSalaryMoney(BigDecimal.ZERO);
                                paymentDetailVO.setPaymentSalaryMoney(paymentDetailVO.getPastSalaryTotal());
                            }else {
                                paymentDetailVO.setPaymentSalaryMoney(ComputeUtil.safeAdd(paymentDetailVO.getPastSalaryTotal(),paymentDetailVO.getCurrentSalaryMoney()));
                            }
                        }
                    }
                }
            }
        }

        JSONObject json = new JSONObject();
        Integer size = pcList.size();
        json.put("successNum", size);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        json.put("successList", pcList);
        json.put("total", pcList);
        return json;
    }

    public List<PaymentDetailVO> orderByList(List<PaymentDetailVO> paymentDetailVOList) {
        List<PaymentDetailVO> laowu = new ArrayList<>();
        List<PaymentDetailVO> zhuanye = new ArrayList<>();
        List<PaymentDetailVO> wzcg = new ArrayList<>();
        List<PaymentDetailVO> jxzl = new ArrayList<>();
        List<PaymentDetailVO> zzczl = new ArrayList<>();
        List<PaymentDetailVO> sjkc = new ArrayList<>();
        List<PaymentDetailVO> zxfw = new ArrayList<>();
        List<PaymentDetailVO> qtht = new ArrayList<>();
        //排完List
        List<PaymentDetailVO> paymentDetailVOS = new ArrayList<>();
        if(CollectionUtil.isNotEmpty(paymentDetailVOList)){
            for(PaymentDetailVO paymentDetailVO : paymentDetailVOList){
                if ("劳务分包".equals(paymentDetailVO.getSubcontractType())){
                    laowu.add(paymentDetailVO);
                }
                if ("专业分包".equals(paymentDetailVO.getSubcontractType())){
                    zhuanye.add(paymentDetailVO);
                }
                if ("物资采购".equals(paymentDetailVO.getSubcontractType())){
                    wzcg.add(paymentDetailVO);
                }
                if ("机械租赁".equals(paymentDetailVO.getSubcontractType())){
                    jxzl.add(paymentDetailVO);
                }
                if ("周转材租赁".equals(paymentDetailVO.getSubcontractType())){
                    zzczl.add(paymentDetailVO);
                }
                if ("设计勘察".equals(paymentDetailVO.getSubcontractType())){
                    sjkc.add(paymentDetailVO);
                }
                if ("咨询服务".equals(paymentDetailVO.getSubcontractType())){
                    zxfw.add(paymentDetailVO);
                }
                if ("其它合同".equals(paymentDetailVO.getSubcontractType())){
                    qtht.add(paymentDetailVO);
                }
            }

            if(CollectionUtil.isNotEmpty(laowu)){
                paymentDetailVOS.addAll(laowu);
            }
            if(CollectionUtil.isNotEmpty(zhuanye)){
                paymentDetailVOS.addAll(zhuanye);
            }
            if(CollectionUtil.isNotEmpty(wzcg)){
                paymentDetailVOS.addAll(wzcg);
            }
            if(CollectionUtil.isNotEmpty(jxzl)){
                paymentDetailVOS.addAll(jxzl);
            }
            if(CollectionUtil.isNotEmpty(zzczl)){
                paymentDetailVOS.addAll(zzczl);
            }
            if(CollectionUtil.isNotEmpty(sjkc)){
                paymentDetailVOS.addAll(sjkc);
            }
            if(CollectionUtil.isNotEmpty(zxfw)){
                paymentDetailVOS.addAll(zxfw);
            }
            if(CollectionUtil.isNotEmpty(qtht)){
                paymentDetailVOS.addAll(qtht);
            }
            return paymentDetailVOS;
        }else{
            return paymentDetailVOList;
        }
    }
}
