package com.ejianc.business.bedget.vo;

import com.ejianc.business.pub.tax.ITaxCalculate;
import com.ejianc.foundation.share.utils.ITreeNodeB;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;


/**
 * 施工图预算书分部分项子表
 *
 * @author generator
 *
 */
public class DrawSubVO extends BaseVO implements ITreeNodeB, ITaxCalculate {
    private static final long serialVersionUID = 1L;

    private Long drawId; // 预算书主键
    private Long parentId; // 父ID
    private String detailIndex; // 序号
    private String code; // 编码
    private String name; // 名称
    private String feature; // 特征
    private String unit; // 单位
    private BigDecimal num; // 工程量
    private BigDecimal taxRate; // 税率
    private BigDecimal price; // 综合单价(无税)
    private BigDecimal taxPrice; // 综合单价(含税)
    private BigDecimal mny; // 合价(无税)
    private BigDecimal taxMny; // 合价(含税)
    private BigDecimal tax; // 税额
    private String memo; // 备注
    private Boolean leafFlag; // 是否末级
    private Long sourceBaseId; // 初始来源主键
    private Long sourceId; // 来源主键

    private String tid;
    private String tpid;
    private String indexCode;//序号
    // 列是否可以导入，true=可以导入，false=不可导入
    private Boolean importFlag;
    //错误信息
    private String warnType;

    private String serialNumber;

    private List<ITreeNodeB> children;

    private List<DrawSubVO> subList = new ArrayList<>();

    @Override
    public Long getNodeID() {
        return getId();
    }

    @Override
    public Long getParentID() {
        return parentId;
    }

    @Override
    public List<ITreeNodeB> getChildren() {
        if (children == null) {
            children = new ArrayList<>();
        }
        return children;
    }

    public Long getDrawId() {
        return drawId;
    }

    public void setDrawId(Long drawId) {
        this.drawId = drawId;
    }
    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }
    public String getDetailIndex() {
        return detailIndex;
    }

    public void setDetailIndex(String detailIndex) {
        this.detailIndex = detailIndex;
    }
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public String getFeature() {
        return feature;
    }

    public void setFeature(String feature) {
        this.feature = feature;
    }
    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }
    public BigDecimal getNum() {
        return num;
    }

    public void setNum(BigDecimal num) {
        this.num = num;
    }
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }
    public BigDecimal getTaxPrice() {
        return taxPrice;
    }

    public void setTaxPrice(BigDecimal taxPrice) {
        this.taxPrice = taxPrice;
    }
    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Boolean getLeafFlag() {
        return leafFlag;
    }

    public void setLeafFlag(Boolean leafFlag) {
        this.leafFlag = leafFlag;
    }
    public Long getSourceBaseId() {
        return sourceBaseId;
    }

    public void setSourceBaseId(Long sourceBaseId) {
        this.sourceBaseId = sourceBaseId;
    }
    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public String getTid() {
        return tid;
    }

    public void setTid(String tid) {
        this.tid = tid;
    }

    public String getTpid() {
        return tpid;
    }

    public void setTpid(String tpid) {
        this.tpid = tpid;
    }

    public String getIndexCode() {
        return indexCode;
    }

    public void setIndexCode(String indexCode) {
        this.indexCode = indexCode;
    }

    public Boolean getImportFlag() {
        return importFlag;
    }

    public void setImportFlag(Boolean importFlag) {
        this.importFlag = importFlag;
    }

    public String getWarnType() {
        return warnType;
    }

    public void setWarnType(String warnType) {
        this.warnType = warnType;
    }

    public String getSerialNumber() {
        return serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public void setChildren(List<ITreeNodeB> children) {
        this.children = children;
    }

    @Override
    public String[] getPriceArray() {
        return new String[]{"price"};
    }

    @Override
    public String[] getTaxPriceArray() {
        return new String[]{"taxPrice"};
    }

    @Override
    public String[] getNumArray() {
        return new String[]{"num"};
    }

    @Override
    public String[] getMoneyArray() {
        return new String[]{"mny"};
    }

    @Override
    public String[] getTaxMoneyArray() {
        return new String[]{"taxMny"};
    }

    @Override
    public String[] getTaxRateArray() {
        return new String[]{"taxRate"};
    }

    @Override
    public String[] getTaxArray() {
        return new String[]{"tax"};
    }

    public List<DrawSubVO> getSubList() {
        return subList;
    }

    public void setSubList(List<DrawSubVO> subList) {
        this.subList = subList;
    }
}
