package com.ejianc.business.bedget.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.business.bedget.bean.PaymentDetailEntity;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 付款登记
 * 
 * @author generator
 * 
 */
public class PaymentVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private Long orgId; // 所属组织id
    private String orgName; // 所属组织名称
    private Long projectDepartmentId; // 项目部id
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date registerDate; // 登记日期
    private BigDecimal settlementAmountTotal; // 累计结算金额
    private BigDecimal accountsPayableTotal; // 累计应付金额
    private BigDecimal interimPaymentMoney; // 本期进度款金额
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private Long employeeId; // 经办人id
    private String employeeName; // 经办人名称
    private BigDecimal advancePaymentMoney; // 本期预付款金额
    private BigDecimal havePaidTotal; // 累计已支付金额
    private BigDecimal inAdvancePaymentMoney; // 其中累计预付款金额
    private BigDecimal paymentRatioTotal; // 累计支付比例
    private BigDecimal debtMoneyTotal; // 累计欠款金额


    private List<PaymentDetailVO> paymentDetailList = new ArrayList<>(); // 付款登记子表


    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    @ReferSerialTransfer(referCode="ejc-zjkj-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    public Date getRegisterDate() {
        return registerDate;
    }

    public void setRegisterDate(Date registerDate) {
        this.registerDate = registerDate;
    }
    public BigDecimal getSettlementAmountTotal() {
        return settlementAmountTotal;
    }

    public void setSettlementAmountTotal(BigDecimal settlementAmountTotal) {
        this.settlementAmountTotal = settlementAmountTotal;
    }
    public BigDecimal getAccountsPayableTotal() {
        return accountsPayableTotal;
    }

    public void setAccountsPayableTotal(BigDecimal accountsPayableTotal) {
        this.accountsPayableTotal = accountsPayableTotal;
    }
    public BigDecimal getInterimPaymentMoney() {
        return interimPaymentMoney;
    }

    public void setInterimPaymentMoney(BigDecimal interimPaymentMoney) {
        this.interimPaymentMoney = interimPaymentMoney;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public BigDecimal getAdvancePaymentMoney() {
        return advancePaymentMoney;
    }

    public void setAdvancePaymentMoney(BigDecimal advancePaymentMoney) {
        this.advancePaymentMoney = advancePaymentMoney;
    }
    public BigDecimal getHavePaidTotal() {
        return havePaidTotal;
    }

    public void setHavePaidTotal(BigDecimal havePaidTotal) {
        this.havePaidTotal = havePaidTotal;
    }
    public BigDecimal getInAdvancePaymentMoney() {
        return inAdvancePaymentMoney;
    }

    public void setInAdvancePaymentMoney(BigDecimal inAdvancePaymentMoney) {
        this.inAdvancePaymentMoney = inAdvancePaymentMoney;
    }
    public BigDecimal getPaymentRatioTotal() {
        return paymentRatioTotal;
    }

    public void setPaymentRatioTotal(BigDecimal paymentRatioTotal) {
        this.paymentRatioTotal = paymentRatioTotal;
    }
    public BigDecimal getDebtMoneyTotal() {
        return debtMoneyTotal;
    }

    public void setDebtMoneyTotal(BigDecimal debtMoneyTotal) {
        this.debtMoneyTotal = debtMoneyTotal;
    }

    public List<PaymentDetailVO> getPaymentDetailList() {
        return paymentDetailList;
    }

    public void setPaymentDetailList(List<PaymentDetailVO> paymentDetailList) {
        this.paymentDetailList = paymentDetailList;
    }
}
