package com.ejianc.business.change.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.bean.*;
import com.ejianc.business.bedget.service.*;
import com.ejianc.business.bedget.vo.ContrastanalysisdetailVO;
import com.ejianc.business.change.bean.ChangeContrastanalysistEntity;
import com.ejianc.business.change.service.IChangeContrastanalysistService;
import com.ejianc.business.change.vo.ChangeContrastanalysisdetailVO;
import com.ejianc.business.change.vo.ChangeContrastanalysistVO;
import com.ejianc.business.change.vo.ChangeconsdrawbudgetdetailVO;
import com.ejianc.business.record.vo.RecordContrastanalysisdetailVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;


/**
 * 对比分析变更表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("changeContrastanalysist")
public class ChangeContrastanalysistController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IChangeContrastanalysistService service;
    @Autowired
    private IContrastanalysisService contrastanalysisService;

    @Autowired
    private IQuotasummaryService quotasummaryService;

    @Autowired
    private IDesignestimateService designestimateService;
    @Autowired
    private IConsdrawbudgettotalService consdrawbudgettotalService;
    @Autowired
    private IQuotasummarydetailService quotasummarydetailService;
    @Autowired
    private IDesignestimatedetailService designestimatedetailService;
    @Autowired
    private IConsdrawbudgettotaldetailService consdrawbudgettotaldetailService;

    @Autowired
    private IContrastanalysisdetailsService contrastanalysisdetailsService;

    /**
     * 初始化更详情页面
     *
     * @param
     * @return
     */
    @GetMapping(value = "queryDetailByContrastanalysistId")
    @ResponseBody
    public CommonResponse<ChangeContrastanalysistVO> queryDetailByContrastanalysistId(@RequestParam(value = "contrastanalysisId") Long contrastanalysisId) {
        ContrastanalysisEntity contrastanalysisEntity = contrastanalysisService.selectById(contrastanalysisId);
        ChangeContrastanalysistVO changeVO = BeanMapper.map(contrastanalysisEntity, ChangeContrastanalysistVO.class);
        //变更单主表基础信息
        Long id = IdWorker.getId();
        changeVO.setContrastanalysisId(contrastanalysisId);
        changeVO.setBillState(null);
        changeVO.setCreateTime(null);
        changeVO.setCreateUserCode(null);
        changeVO.setTenantId(null);
        changeVO.setUpdateTime(null);
        changeVO.setUpdateUserCode(null);
        changeVO.setId(id);

        List<ChangeContrastanalysisdetailVO> contrastanalysisdetailVOList = new ArrayList<>();
        //查询固定表格的数据
        List<ContrastanalysisdetailsEntity> contrastanalysisdetailsEntity = contrastanalysisdetailsService.list();

        //根据项目id查询限额设计汇总表数据
        Long projectId = contrastanalysisEntity.getProjectId();
        QueryWrapper<QuotasummaryEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("project_id", projectId);
        queryWrapper.in("bill_state", 1,3);
        queryWrapper.eq("dr", 0);
        QuotasummaryEntity quotasummaryEntity = quotasummaryService.getOne(queryWrapper);
        //根据项目id查询限设计概算数据
        QueryWrapper<DesignestimateEntity> queryWrapper1 = new QueryWrapper<>();
        queryWrapper1.eq("project_id", projectId);
        queryWrapper1.in("bill_state", 1,3);
        queryWrapper1.eq("dr", 0);
        DesignestimateEntity designestimateEntity = designestimateService.getOne(queryWrapper1);
        //根据项目id查询限施工图预算汇总数据
        QueryWrapper<ConsdrawbudgettotalEntity> queryWrapper2 = new QueryWrapper<>();
        queryWrapper2.eq("project_id", projectId);
        queryWrapper2.in("bill_state", 1,3);
        queryWrapper2.eq("dr", 0);
        ConsdrawbudgettotalEntity consdrawbudgettotalEntity = consdrawbudgettotalService.getOne(queryWrapper2);

        for (ContrastanalysisdetailsEntity entity : contrastanalysisdetailsEntity) {
            ChangeContrastanalysisdetailVO contrastanalysisdetailVO = new ChangeContrastanalysisdetailVO();
            contrastanalysisdetailVO.setId(IdWorker.getId());
            contrastanalysisdetailVO.setSort(entity.getSort());
            contrastanalysisdetailVO.setCode(entity.getCode());
            contrastanalysisdetailVO.setName(entity.getName());
            contrastanalysisdetailVO.setTid(entity.getTid());
            contrastanalysisdetailVO.setTpid(entity.getTpid());

            String innateCode = entity.getCode();//固定列的清单编码
            String innateName = entity.getName();// 固定列的工程名称或费用名称

            //根据固定表中的name和限额设计汇总表id查询汇总子表数据
            if (quotasummaryEntity != null) {
                QueryWrapper<QuotasummarydetailEntity> queryWrapper3 = new QueryWrapper<>();
                queryWrapper3.eq("mid", quotasummaryEntity.getId());
                queryWrapper3.eq("sort",innateCode);
                if("01".equals(innateCode)){
                    if("装饰工程".equals(innateName)){
                        queryWrapper3.like("unit_project_name", "装饰");
                    }else {
                        queryWrapper3.notLike("unit_project_name", "装饰");
                    }
                }
                queryWrapper3.eq("dr", 0);
                List<QuotasummarydetailEntity> quotasummarydetailEntity = quotasummarydetailService.list(queryWrapper3);

                if (quotasummarydetailEntity != null && quotasummarydetailEntity.size() > 0) {
                    //工程规模
                    BigDecimal quotasummaryScale = new BigDecimal(0);
                    //项目造价
                    BigDecimal quotasummaryProjectCost = new BigDecimal(0);
                    //单位造价
                    BigDecimal quotasummarylUnitCost = new BigDecimal(0);
                    boolean isNullScale = true;
                    boolean isNullProjectCost = true;
                    boolean isNullUnitCost = true;
                    for (int i = 0; i < quotasummarydetailEntity.size(); i++) {
                        BigDecimal quotasummaryDetailScale = quotasummarydetailEntity.get(i).getScale();
                        BigDecimal quotasummaryDetailProjectCost = quotasummarydetailEntity.get(i).getProjectCost();
                        if(quotasummaryDetailScale != null){
                            quotasummaryScale = quotasummaryScale.add(quotasummaryDetailScale);
                            isNullScale = false;
                        }
                        if(quotasummaryDetailProjectCost != null){
                            quotasummaryProjectCost = quotasummaryProjectCost.add(quotasummaryDetailProjectCost);
                            isNullProjectCost = false;
                        }
                    }

                    if(quotasummaryProjectCost != null && quotasummaryScale != null && quotasummaryScale.compareTo(BigDecimal.ZERO) != 0){
                        quotasummarylUnitCost = quotasummaryProjectCost.divide(quotasummaryScale, 8, BigDecimal.ROUND_HALF_UP);
                        isNullUnitCost = false;
                    }

                    if(isNullScale){
                        contrastanalysisdetailVO.setQuataDesignTotal(null);
                    }else {
                        contrastanalysisdetailVO.setQuataDesignTotal(quotasummaryScale);
                    }

                    if(isNullProjectCost){
                        contrastanalysisdetailVO.setQuotaDesignBudgetTotal(null);
                    }else {
                        contrastanalysisdetailVO.setQuotaDesignBudgetTotal(quotasummaryProjectCost);
                    }

                    if(isNullUnitCost){
                        contrastanalysisdetailVO.setQuotaDesignBudgetPrice(null);
                    }else {
                        contrastanalysisdetailVO.setQuotaDesignBudgetPrice(quotasummarylUnitCost);
                    }
                }
            }

            //根据固定表中的name和设计概算表id查询汇总子表数据
            if (designestimateEntity != null) {
                QueryWrapper<DesignestimatedetailEntity> queryWrapper4 = new QueryWrapper<>();
                queryWrapper4.eq("mid", designestimateEntity.getId());
                queryWrapper4.eq("son_item_code", innateCode);
                if("01".equals(innateCode)){
                    if("装饰工程".equals(innateName)){
                        queryWrapper4.like("son_item_name", "装饰");
                    }else {
                        queryWrapper4.notLike("son_item_name", "装饰");
                    }
                }
                queryWrapper4.eq("dr", 0);
                List<DesignestimatedetailEntity> designestimatedetailEntity = designestimatedetailService.list(queryWrapper4);

                if (designestimatedetailEntity != null && designestimatedetailEntity.size() > 0) {
                    BigDecimal estimateScale = new BigDecimal(0);
                    BigDecimal estimateProjectCost = new BigDecimal(0);
                    BigDecimal estimatelUnitCost = new BigDecimal(0);
                    boolean isNullScale = true;
                    boolean isNullProjectCost = true;
                    boolean isNullUnitCost = true;

                    for (int i = 0; i < designestimatedetailEntity.size(); i++) {
                        BigDecimal estimateDetailProjectScale = designestimatedetailEntity.get(i).getProjectScale();
                        BigDecimal estimateDetailProjectCost = designestimatedetailEntity.get(i).getProjectCost();
                        if(estimateDetailProjectScale != null){
                            estimateScale = estimateScale.add(estimateDetailProjectScale);
                            isNullScale = false;
                        }
                        if(estimateDetailProjectCost != null){
                            estimateProjectCost = estimateProjectCost.add(estimateDetailProjectCost);
                            isNullProjectCost = false;
                        }
                    }

                    if(estimateProjectCost != null && estimateScale != null && estimateScale.compareTo(BigDecimal.ZERO) != 0){
                        estimatelUnitCost = estimateProjectCost.divide(estimateScale, 8, BigDecimal.ROUND_HALF_UP);
                        isNullUnitCost = false;
                    }

                    if(isNullScale){
                        contrastanalysisdetailVO.setDesignBugetEstimate(null);
                    }else {
                        contrastanalysisdetailVO.setDesignBugetEstimate(estimateScale);
                    }

                    if(isNullProjectCost){
                        contrastanalysisdetailVO.setDesignBugetEstimateTotal(null);
                    }else {
                        contrastanalysisdetailVO.setDesignBugetEstimateTotal(estimateProjectCost);
                    }

                    if(isNullUnitCost){
                        contrastanalysisdetailVO.setDesignBugetEstimatePrice(null);
                    }else {
                        contrastanalysisdetailVO.setDesignBugetEstimatePrice(estimatelUnitCost);
                    }
                }
            }

            if (consdrawbudgettotalEntity != null) {
                //根据固定表中的name和施工图预算表id查询汇总子表数据
                QueryWrapper<ConsdrawbudgettotaldetailEntity> queryWrapper5 = new QueryWrapper<>();
                queryWrapper5.eq("mid", consdrawbudgettotalEntity.getId());
                queryWrapper5.eq("subitem_code", innateCode);
                if("01".equals(innateCode)){
                    if("装饰工程".equals(innateName)){
                        queryWrapper5.like("project_unit_name", "装饰");
                    }else {
                        queryWrapper5.notLike("project_unit_name", "装饰");
                    }
                }
                queryWrapper5.eq("dr", 0);
                List<ConsdrawbudgettotaldetailEntity> consdrawbudgettotaldetailEntity = consdrawbudgettotaldetailService.list(queryWrapper5);

                if (consdrawbudgettotaldetailEntity != null && consdrawbudgettotaldetailEntity.size() > 0) {
                    //施工图工程规模
                    BigDecimal consdrawbudgettotalScale = new BigDecimal(0);
                    //施工图项目造价
                    BigDecimal consdrawbudgettotalProjectCost = new BigDecimal(0);
                    //施工图预算单价
                    BigDecimal consdrawbudgettotallUnitCost = new BigDecimal(0);
                    boolean isNullScale = true;
                    boolean isNullProjectCost = true;
                    boolean isNullUnitCost = true;

                    for (int i = 0; i < consdrawbudgettotaldetailEntity.size(); i++) {
                        //工程规模
                        BigDecimal consdrawbudgettotalDetailProjectScale = consdrawbudgettotaldetailEntity.get(i).getProjectScale();
                        //施工图项目造价
                        BigDecimal consdrawbudgettotalDetailProjectCost = consdrawbudgettotaldetailEntity.get(i).getProjectCost();
                        if(consdrawbudgettotalDetailProjectScale != null){
                            consdrawbudgettotalScale = consdrawbudgettotalScale.add(consdrawbudgettotalDetailProjectScale);
                            isNullScale = false;
                        }
                        if(consdrawbudgettotalDetailProjectCost != null){
                            consdrawbudgettotalProjectCost = consdrawbudgettotalProjectCost.add(consdrawbudgettotalDetailProjectCost);
                            isNullProjectCost = false;
                        }
                    }

                    if(consdrawbudgettotalProjectCost != null && consdrawbudgettotalScale != null && consdrawbudgettotalScale.compareTo(BigDecimal.ZERO) != 0){
                        consdrawbudgettotallUnitCost = consdrawbudgettotalProjectCost.divide(consdrawbudgettotalScale, 8, BigDecimal.ROUND_HALF_UP);
                        isNullUnitCost = false;
                    }

                    if(isNullScale){
                        contrastanalysisdetailVO.setConstructionBugetEstimate(null);
                    }else {
                        contrastanalysisdetailVO.setConstructionBugetEstimate(consdrawbudgettotalScale);
                    }

                    if(isNullProjectCost){
                        contrastanalysisdetailVO.setConstructionBugetEstimateTotal(null);
                    }else {
                        contrastanalysisdetailVO.setConstructionBugetEstimateTotal(consdrawbudgettotalProjectCost);
                    }

                    if(isNullUnitCost){
                        contrastanalysisdetailVO.setConstructionBugetEstimatePrice(null);
                    }else {
                        contrastanalysisdetailVO.setConstructionBugetEstimatePrice(consdrawbudgettotallUnitCost);
                    }

                    contrastanalysisdetailVO.setConstructionBugetEstimate(consdrawbudgettotalScale);
                    contrastanalysisdetailVO.setConstructionBugetEstimateTotal(consdrawbudgettotalProjectCost);
                    contrastanalysisdetailVO.setConstructionBugetEstimatePrice(consdrawbudgettotallUnitCost);
                }
            }

            contrastanalysisdetailVO.setRowState("add");
            contrastanalysisdetailVOList.add(contrastanalysisdetailVO);
        }
        changeVO.setContrastanalysisdetailEntities(createTreeData(contrastanalysisdetailVOList));
        return CommonResponse.success("查询详情成功！", changeVO);
    }

    public static List<ChangeContrastanalysisdetailVO> createTreeData(List<ChangeContrastanalysisdetailVO> list) {
        List<ChangeContrastanalysisdetailVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();

        //循环list，放入listMap重
        Map<String, ChangeContrastanalysisdetailVO> listMap = new HashMap<>();
        for(ChangeContrastanalysisdetailVO item:list) {
            listMap.put(item.getTid().toString(), item);
        }

        for(int i =0; i<list.size(); i++) {
            ChangeContrastanalysisdetailVO item = list.get(i);
            String parentId = (item.getTpid() != null) ? item.getTpid().toString():"";
            ChangeContrastanalysisdetailVO parent = listMap.get(parentId);
            if(parent != null) {
                List<ChangeContrastanalysisdetailVO> child = (List<ChangeContrastanalysisdetailVO>) parent.getChildren();
                if(child != null) {
                    child.add(item);
                }else{
                    List<ChangeContrastanalysisdetailVO> children = new ArrayList<ChangeContrastanalysisdetailVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getTid());
            }
        }

        for(String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveChange", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ChangeContrastanalysistVO> saveOrUpdate(@RequestBody ChangeContrastanalysistVO saveOrUpdateVO) {
        return service.saveChange(saveOrUpdateVO);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ChangeContrastanalysistVO> queryDetail(Long id) {
    	ChangeContrastanalysistEntity entity = service.selectById(id);
        ChangeContrastanalysistVO vo = BeanMapper.map(entity, ChangeContrastanalysistVO.class);

        //构建树形结构
        List<ChangeContrastanalysisdetailVO> changeContrastanalysisdetailVOList = vo.getContrastanalysisdetailEntities();
        changeContrastanalysisdetailVOList = createTreeData(changeContrastanalysisdetailVOList);
        vo.setContrastanalysisdetailEntities(changeContrastanalysisdetailVOList);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ChangeContrastanalysistVO> vos) {
        return service.delete(vos);
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ChangeContrastanalysistVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<ChangeContrastanalysistEntity> page = service.queryPage(param,false);
        IPage<ChangeContrastanalysistVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ChangeContrastanalysistVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ChangeContrastanalysistEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ChangeContrastanalysistEntiy-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refChangeContrastanalysistEntiyData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ChangeContrastanalysistVO>> refChangeContrastanalysistEntiyData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ChangeContrastanalysistEntity> page = service.queryPage(param,false);
        IPage<ChangeContrastanalysistVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ChangeContrastanalysistVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
