package com.ejianc.business.change.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.bean.QuotaanalysisEntity;
import com.ejianc.business.bedget.bean.QuotaanalysisdetailEntity;
import com.ejianc.business.bedget.bean.QuotaanalysisdetailInnateEntity;
import com.ejianc.business.bedget.service.IQuotaanalysisService;
import com.ejianc.business.bedget.service.IQuotaanalysisdetailInnateService;
import com.ejianc.business.bedget.vo.QuotadesigndetailVO;
import com.ejianc.business.change.bean.ChangeQuotaanalysisEntity;
import com.ejianc.business.change.service.IChangeQuotaanalysisService;
import com.ejianc.business.change.vo.ChangeQuotaanalysisVO;
import com.ejianc.business.change.vo.ChangeQuotaanalysisdetailVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;



/**
 * 限额设计指标分析变更表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("changeQuotaanalysis")
public class ChangeQuotaanalysisController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IChangeQuotaanalysisService service;
    @Autowired
    private IQuotaanalysisService quotaanalysisService;

    @Autowired
    private IQuotaanalysisdetailInnateService quotaanalysisdetailInnateService;

    /**
     * 初始化更详情页面
     *
     * @param originalId
     * @return
     */
    @GetMapping(value = "queryDetailByOriginalId")
    @ResponseBody
    public CommonResponse<ChangeQuotaanalysisVO> queryDetailByOriginalId(@RequestParam(value = "originalId") Long originalId) {
        QuotaanalysisEntity quotaanalysisVO = quotaanalysisService.selectById(originalId);
        ChangeQuotaanalysisVO changeVO = BeanMapper.map(quotaanalysisVO, ChangeQuotaanalysisVO.class);
        Long id = IdWorker.getId();
        changeVO.setOriginalId(originalId);
        changeVO.setBillState(null);
        changeVO.setCreateTime(null);
        changeVO.setCreateUserCode(null);
        changeVO.setTenantId(null);
        changeVO.setUpdateTime(null);
        changeVO.setUpdateUserCode(null);
        changeVO.setId(id);

        //限额设计指标分析清单
        List<QuotaanalysisdetailEntity> quotaanalysisdetailList = quotaanalysisVO.getQuotaanalysisdetailEntities();
        if(quotaanalysisdetailList!=null&&quotaanalysisdetailList.size()>0){
            List<ChangeQuotaanalysisdetailVO> changeQuotaanalysisdetailVos = new ArrayList<>();
            for(QuotaanalysisdetailEntity entity : quotaanalysisdetailList){
                ChangeQuotaanalysisdetailVO vo = BeanMapper.map(entity, ChangeQuotaanalysisdetailVO.class);
                vo.setMid(id);
                vo.setOriginalId(entity.getId());
                vo.setCreateTime(null);
                vo.setCreateUserCode(null);
                vo.setTenantId(null);
                vo.setUpdateTime(null);
                vo.setUpdateUserCode(null);
                vo.setRowState("edit");
                vo.setId(IdWorker.getId());
                changeQuotaanalysisdetailVos.add(vo);
            }

            //按序号排序
            Collections.sort(changeQuotaanalysisdetailVos, new Comparator<ChangeQuotaanalysisdetailVO>() {
                @Override
                public int compare(ChangeQuotaanalysisdetailVO o1, ChangeQuotaanalysisdetailVO o2) {
                    return Integer.parseInt(o1.getSort()) - (Integer.parseInt(o2.getSort()));
                }
            });
            changeVO.setChangeQuotaanalysisdetailEntities(changeQuotaanalysisdetailVos);
        }

        return CommonResponse.success("查询详情成功！", changeVO);

    }

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveChange", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ChangeQuotaanalysisVO> saveChange(@RequestBody ChangeQuotaanalysisVO saveOrUpdateVO) {
        return service.saveChange(saveOrUpdateVO);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ChangeQuotaanalysisVO> queryDetail(Long id) {
    	ChangeQuotaanalysisEntity entity = service.selectById(id);
    	ChangeQuotaanalysisVO vo = BeanMapper.map(entity, ChangeQuotaanalysisVO.class);
        List<ChangeQuotaanalysisdetailVO> voList = vo.getChangeQuotaanalysisdetailEntities();
        if(voList != null && voList.size() > 0){
            //按序号排序
            Collections.sort(voList, new Comparator<ChangeQuotaanalysisdetailVO>() {
                @Override
                public int compare(ChangeQuotaanalysisdetailVO o1, ChangeQuotaanalysisdetailVO o2) {
                    return Integer.parseInt(o1.getSort()) - (Integer.parseInt(o2.getSort()));
                }
            });
        }

        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description queryInnateColumns 查询固定列
     * @param
     */
    @RequestMapping(value = "/queryInnateColumns", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<QuotaanalysisdetailInnateEntity>> queryInnateColumns() {
        //查询固定列
        QueryWrapper<QuotaanalysisdetailInnateEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("dr", "0");
        queryWrapper.orderByAsc("id");
        List<QuotaanalysisdetailInnateEntity> pro = quotaanalysisdetailInnateService.list(queryWrapper);
        return CommonResponse.success("查询固定列数据成功！",pro);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ChangeQuotaanalysisVO> vos) {
        return service.delete(vos);
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ChangeQuotaanalysisVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        //param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<ChangeQuotaanalysisEntity> page = service.queryPage(param,false);
        IPage<ChangeQuotaanalysisVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ChangeQuotaanalysisVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ChangeQuotaanalysisEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ChangeQuotaanalysis-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refChangeQuotaanalysisData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ChangeQuotaanalysisVO>> refChangeQuotaanalysisData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        //param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ChangeQuotaanalysisEntity> page = service.queryPage(param,false);
        IPage<ChangeQuotaanalysisVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ChangeQuotaanalysisVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
