package com.ejianc.business.change.controller;

import java.io.Serializable;

import com.ejianc.business.bedget.bean.ConsdrawbudgetEntity;
import com.ejianc.business.bedget.bean.ConsdrawbudgetdetailEntity;
import com.ejianc.business.bedget.service.IConsdrawbudgetService;
import com.ejianc.business.bedget.vo.ConsdrawbudgetdetailVO;
import com.ejianc.business.change.bean.ChangeconsdrawbudgetEntity;
import com.ejianc.business.change.service.IChangeconsdrawbudgetService;
import com.ejianc.business.change.vo.ChangeconsdrawbudgetVO;
import com.ejianc.business.change.vo.ChangeconsdrawbudgetdetailVO;
import com.ejianc.business.change.vo.ChangequotadesigndetailVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;


/**
 * 施工预算图变更
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("changeconsdrawbudget")
public class ChangeconsdrawbudgetController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "budgetmanager-changeconsdrawbudget";//此处需要根据实际修改

    @Autowired
    private IChangeconsdrawbudgetService service;

    @Autowired
    private IConsdrawbudgetService consdrawbudgetService;

    /**
     * 初始化更详情页面
     *
     * @param
     * @return
     */
    @GetMapping(value = "queryDetailByConsdrawbudgetId")
    @ResponseBody
    public CommonResponse<ChangeconsdrawbudgetVO> queryDetailByConsdrawbudgetId(@RequestParam(value = "consdrawbudgetId") Long consdrawbudgetId) {
        ConsdrawbudgetEntity consdrawbudgetEntity = consdrawbudgetService.selectById(consdrawbudgetId);
        ChangeconsdrawbudgetVO changeVO = BeanMapper.map(consdrawbudgetEntity, ChangeconsdrawbudgetVO.class);
        Long id = IdWorker.getId();
        changeVO.setConsdrawbudgetId(consdrawbudgetId);
        changeVO.setBillState(null);
        changeVO.setCreateTime(null);
        changeVO.setCreateUserCode(null);
        changeVO.setTenantId(null);
        changeVO.setUpdateTime(null);
        changeVO.setUpdateUserCode(null);
        changeVO.setId(id);

        //限额设计指标分析清单
        List<ConsdrawbudgetdetailEntity> consdrawbudgetdetailEntities = consdrawbudgetEntity.getConsdrawbudgetdetailEntities();
        if(consdrawbudgetdetailEntities!=null&&consdrawbudgetdetailEntities.size()>0){
            List<ChangeconsdrawbudgetdetailVO> changeconsdrawbudgetdetailVOS = new ArrayList<>();
            for(ConsdrawbudgetdetailEntity entity : consdrawbudgetdetailEntities){
                ChangeconsdrawbudgetdetailVO vo = BeanMapper.map(entity, ChangeconsdrawbudgetdetailVO.class);
                vo.setChangeMid(id);
                vo.setOriginalId(entity.getId());
                vo.setCreateTime(null);
                vo.setCreateUserCode(null);
                vo.setTenantId(null);
                vo.setUpdateTime(null);
                vo.setUpdateUserCode(null);
                vo.setRowState("edit");
                vo.setId(IdWorker.getId());
                changeconsdrawbudgetdetailVOS.add(vo);
            }
            //构建树形结构
            changeconsdrawbudgetdetailVOS = createTreeData(changeconsdrawbudgetdetailVOS);
            changeVO.setConsdrawbudgetdetailEntities(changeconsdrawbudgetdetailVOS);
        }

        return CommonResponse.success("查询详情成功！", changeVO);

    }

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveChange", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ChangeconsdrawbudgetVO> saveOrUpdate(@RequestBody ChangeconsdrawbudgetVO saveorUpdateVO) {
        return service.saveChange(saveorUpdateVO);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ChangeconsdrawbudgetVO> queryDetail(Long id) {
    	ChangeconsdrawbudgetEntity entity = service.selectById(id);
    	ChangeconsdrawbudgetVO vo = BeanMapper.map(entity, ChangeconsdrawbudgetVO.class);

        //构建树形结构
        List<ChangeconsdrawbudgetdetailVO> changeconsdrawbudgetdetailVOList = vo.getConsdrawbudgetdetailEntities();
        List<ChangeconsdrawbudgetdetailVO> resChangeconsdrawbudgetdetailVOList = createTreeData(changeconsdrawbudgetdetailVOList);
        vo.setConsdrawbudgetdetailEntities(resChangeconsdrawbudgetdetailVOList);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ChangeconsdrawbudgetVO> vos) {
        return service.delete(vos);
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ChangeconsdrawbudgetVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        //param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<ChangeconsdrawbudgetEntity> page = service.queryPage(param,false);
        IPage<ChangeconsdrawbudgetVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ChangeconsdrawbudgetVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ChangeconsdrawbudgetEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Changeconsdrawbudget-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refChangeconsdrawbudgetData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ChangeconsdrawbudgetVO>> refChangeconsdrawbudgetData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        //param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ChangeconsdrawbudgetEntity> page = service.queryPage(param,false);
        IPage<ChangeconsdrawbudgetVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ChangeconsdrawbudgetVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 页面新增后重新构建树
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/refreshData", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> refreshData(@RequestBody List<ChangeconsdrawbudgetdetailVO> list, HttpServletResponse response) {
        JSONObject json = new JSONObject();
        Map<String, ChangeconsdrawbudgetdetailVO> map = new HashMap<>();
        ChangeconsdrawbudgetdetailVO add = list.get(list.size() - 1);
        add.setId(IdWorker.getId());
        add.setTid(String.valueOf(IdWorker.getId()));
        add.setRowState("edit");
        add.setInnercode(add.getSubitemCode() + "_" + add.getSection());//子目编码、区段、确定唯一性
//        if ("01".equals(add.getSubitemCode()) && add.getSubitemName().contains("装饰")) {
//            add.setInnercode("a1" + "_" + add.getSection());
//        }
        //判断是否是装饰工程的子节点编码
//        if (add.getSubitemCode().length() >= 4) {
//            //0111、0112、0113、0114、0115这五个节点都是装饰工程下的
//            String code = add.getSubitemCode().substring(0, 4);
//            if ("0111".equals(code) || "0112".equals(code) || "0113".equals(code) || "0114".equals(code) || "0115".equals(code)) {
////	    		若是的话，将内码改为a1xx
//                add.setInnercode("a1" + add.getSubitemCode().substring(2, add.getSubitemCode().length()) +  "_" + add.getSection());
//            }
//        }
        for (ChangeconsdrawbudgetdetailVO vo : list) {
            map.put(vo.getInnercode(), vo);
            if (!add.getId().equals(vo.getId()) && add.getInnercode().equals(vo.getInnercode())) {
                throw new BusinessException("子目编码已存在，请重新填写");
            }
        }
        //设置父级id
        for (ChangeconsdrawbudgetdetailVO vo : list) {
            String innercode = vo.getInnercode();
            String[] innercodeSubArr = innercode.split("_");
            String innercodeSub = "";
            String sectionSuf = "";
            if(innercodeSubArr.length > 1){
                innercodeSub = innercodeSubArr[0];
                sectionSuf = "_" + innercodeSubArr[1];
            }

            Long pid = null;
            if (innercodeSub.length() == 2) {
                //最上级
            } else if (innercodeSub.length() == 4) {
                String pcode = innercodeSub.substring(0, 2) + sectionSuf;
                //有父节点
                pid = this.setPid(pcode, map);

            } else if (innercodeSub.length() == 6) {
                String pcode = innercodeSub.substring(0, 4) + sectionSuf;
                //有父节点
                pid = this.setPid(pcode, map);
            } else if (innercodeSub.length() > 6) {
                String pcode = innercodeSub.substring(0, 6) + sectionSuf;
                //有父节点
                pid = this.setPid(pcode, map);
            }

            if (pid != null) {
                vo.setTpid(pid.toString());
            } else {
                vo.setTpid("");
            }
        }

        //排序、构建树
        list = handleChildren(list);

        //统计父级的合计数值
        getChildrenUnitTotalAmount(list);

        json.put("dataSource", list);
        return CommonResponse.success(json);
    }

    /**
     * 统计父级的合计数值
     * @param vos
     * @return
     */
    private ChangeconsdrawbudgetdetailVO getChildrenUnitTotalAmount(List<ChangeconsdrawbudgetdetailVO> vos){
        ChangeconsdrawbudgetdetailVO detail = new ChangeconsdrawbudgetdetailVO();
        detail.setTotalLaborCost(new BigDecimal(0));//人工费(综合)
        detail.setTotalMaterialCost(new BigDecimal(0));//材料费(综合)
        detail.setTotalMachineryCost(new BigDecimal(0));//机械费(综合)
        detail.setTotalBusinessManagerCost(new BigDecimal(0));//企业管理费(综合)
        detail.setTotalProfit(new BigDecimal(0));//利润(综合)
        detail.setSumTotalPrice(new BigDecimal(0));//合价(元)
        detail.setSocialSecurity(new BigDecimal(0));//社保
        detail.setHousing(new BigDecimal(0));//住房
        detail.setReserved1(new BigDecimal(0));//预留1
        detail.setReserved2(new BigDecimal(0));//预留2
        detail.setReserved3(new BigDecimal(0));//预留3
        detail.setTax(new BigDecimal(0));//税金
        detail.setProvisionalEstimate(new BigDecimal(0));//暂估价

        BigDecimal totalLaborCost = detail.getTotalLaborCost();
        BigDecimal totalMaterialCost = detail.getTotalMaterialCost();
        BigDecimal totalMachineryCost = detail.getTotalMachineryCost();
        BigDecimal totalBusinessManagerCost = detail.getTotalBusinessManagerCost();
        BigDecimal totalProfit = detail.getTotalProfit();
        BigDecimal sumTotalPrice = detail.getSumTotalPrice();
        BigDecimal socialSecurity = detail.getSocialSecurity();
        BigDecimal housing = detail.getHousing();
        BigDecimal reserved1 = detail.getReserved1();
        BigDecimal reserved2 = detail.getReserved2();
        BigDecimal reserved3 = detail.getReserved3();
        BigDecimal tax = detail.getTax();
        BigDecimal provisionalEstimate = detail.getProvisionalEstimate();

        for(ChangeconsdrawbudgetdetailVO vo: vos){
            if(vo.getChildren()!=null&&vo.getChildren().size()>0){
                //有孩子节点----清空工程量和综合单价--金额字段
                vo.setEngineeQuatity(null);// 工程量
                vo.setUnitLaborCost(null);// 人工费
                vo.setUnitMaterialCost(null);
                vo.setUnitMachineryCost(null);
                vo.setUnitBusinessManagerCost(null);
                vo.setUnitProfit(null);
                vo.setComprehensiveUnitPrice(null);

                //获取孩子节点的总计数据
                ChangeconsdrawbudgetdetailVO childrenUnitTotalAmount = this.getChildrenUnitTotalAmount(vo.getChildren());
                vo.setTotalLaborCost(childrenUnitTotalAmount.getTotalLaborCost());
                vo.setTotalMaterialCost(childrenUnitTotalAmount.getTotalMaterialCost());
                vo.setTotalMachineryCost(childrenUnitTotalAmount.getTotalMachineryCost());
                vo.setTotalBusinessManagerCost(childrenUnitTotalAmount.getTotalBusinessManagerCost());
                vo.setTotalProfit(childrenUnitTotalAmount.getTotalProfit());
                vo.setSumTotalPrice(childrenUnitTotalAmount.getSumTotalPrice());
                vo.setSocialSecurity(childrenUnitTotalAmount.getSocialSecurity());
                vo.setHousing(childrenUnitTotalAmount.getHousing());
                vo.setReserved1(childrenUnitTotalAmount.getReserved1());
                vo.setReserved2(childrenUnitTotalAmount.getReserved2());
                vo.setReserved3(childrenUnitTotalAmount.getReserved3());
                vo.setTax(childrenUnitTotalAmount.getTax());
                vo.setProvisionalEstimate(childrenUnitTotalAmount.getProvisionalEstimate());

                totalLaborCost = totalLaborCost.add(childrenUnitTotalAmount.getTotalLaborCost());
                totalMaterialCost = totalMaterialCost.add(childrenUnitTotalAmount.getTotalMaterialCost());
                totalMachineryCost = totalMachineryCost.add(childrenUnitTotalAmount.getTotalMachineryCost());
                totalBusinessManagerCost = totalBusinessManagerCost.add(childrenUnitTotalAmount.getTotalBusinessManagerCost());
                totalProfit = totalProfit.add(childrenUnitTotalAmount.getTotalProfit());
                sumTotalPrice = sumTotalPrice.add(childrenUnitTotalAmount.getSumTotalPrice());
                socialSecurity = socialSecurity.add(childrenUnitTotalAmount.getSocialSecurity());
                housing = housing.add(childrenUnitTotalAmount.getHousing());
                reserved1 = reserved1.add(childrenUnitTotalAmount.getReserved1());
                reserved2 = reserved2.add(childrenUnitTotalAmount.getReserved2());
                reserved3 = reserved3.add(childrenUnitTotalAmount.getReserved3());
                tax = tax.add(childrenUnitTotalAmount.getTax());
                provisionalEstimate = provisionalEstimate.add(childrenUnitTotalAmount.getProvisionalEstimate());
            }else{
                if(vo.getTotalLaborCost()!=null){
                    totalLaborCost = totalLaborCost.add(vo.getTotalLaborCost());
                }

                if(vo.getTotalMaterialCost()!=null){
                    totalMaterialCost = totalMaterialCost.add(vo.getTotalMaterialCost());
                }

                if(vo.getTotalMachineryCost()!=null){
                    totalMachineryCost = totalMachineryCost.add(vo.getTotalMachineryCost());
                }

                if(vo.getTotalBusinessManagerCost()!=null){
                    totalBusinessManagerCost = totalBusinessManagerCost.add(vo.getTotalBusinessManagerCost());
                }

                if(vo.getTotalProfit()!=null){
                    totalProfit = totalProfit.add(vo.getTotalProfit());
                }

                if(vo.getSumTotalPrice()!=null){
                    sumTotalPrice = sumTotalPrice.add(vo.getSumTotalPrice());
                }

                if(vo.getSocialSecurity()!=null){
                    socialSecurity = socialSecurity.add(vo.getSocialSecurity());
                }

                if(vo.getHousing()!=null){
                    housing = housing.add(vo.getHousing());
                }

                if(vo.getReserved1()!=null){
                    reserved1 = reserved1.add(vo.getReserved1());
                }

                if(vo.getReserved2()!=null){
                    reserved2 = reserved2.add(vo.getReserved2());
                }

                if(vo.getReserved3()!=null){
                    reserved3 = reserved3.add(vo.getReserved3());
                }

                if(vo.getTax()!=null){
                    tax = tax.add(vo.getTax());
                }

                if(vo.getProvisionalEstimate()!=null){
                    provisionalEstimate = provisionalEstimate.add(vo.getProvisionalEstimate());
                }
            }

            detail.setTotalLaborCost(totalLaborCost);
            detail.setTotalMaterialCost(totalMaterialCost);
            detail.setTotalMachineryCost(totalMachineryCost);
            detail.setTotalBusinessManagerCost(totalBusinessManagerCost);
            detail.setTotalProfit(totalProfit);
            detail.setSumTotalPrice(sumTotalPrice);
            detail.setSocialSecurity(socialSecurity);
            detail.setHousing(housing);
            detail.setReserved1(reserved1);
            detail.setReserved2(reserved2);
            detail.setReserved3(reserved3);
            detail.setTax(tax);
            detail.setProvisionalEstimate(provisionalEstimate);
        }
        return detail;
    }

    //子目编码规则定死------分别是2位/4位/6位/6为以上
    private Long setPid(String pcode, Map<String, ChangeconsdrawbudgetdetailVO> map) {
        if (map.get(pcode) != null) {
            return Long.valueOf(map.get(pcode).getTid());
        } else {
            //父级没有找到，则继续往上找
            String[] pcodeSubArr = pcode.split("_");
            String pcodeSub = "";
            String sectionSuf = "";//"_" + 区段
            if(pcodeSubArr.length > 1){
                pcodeSub = pcodeSubArr[0];
                sectionSuf = "_" + pcodeSubArr[1];
            }
            if (pcodeSub.length() == 2) {
                //最上级
                return null;
            } else if (pcodeSub.length() == 4) {
                String ppcode = pcodeSub.substring(0, 2);
                return this.setPid(ppcode + sectionSuf, map);
            } else if (pcodeSub.length() == 6) {
                String ppcode = pcode.substring(0, 4);
                return this.setPid(ppcode + sectionSuf, map);
            } else if (pcodeSub.length() > 6) {
                String ppcode = pcode.substring(0, 6);
                return this.setPid(ppcode + sectionSuf, map);
            } else {
                return null;
            }
        }
    }

    private List<ChangeconsdrawbudgetdetailVO> clearPData(ChangeconsdrawbudgetdetailVO handleVO, List<ChangeconsdrawbudgetdetailVO> list) {
        if (list == null || list.size() == 0) {
            return null;
        }

        String pid = handleVO.getTpid();
        if (pid == null || TextUtils.isEmpty(pid)) {
            return list;
        }

        for (int i = 0; i < list.size(); i++) {
            ChangeconsdrawbudgetdetailVO vo = list.get(i);
            if (pid.equals(vo.getTid())) {
                //清空父级单价和工程量
                vo.setEngineeQuatity(null);
                vo.setUnitLaborCost(null);
                vo.setUnitMaterialCost(null);
                vo.setUnitMachineryCost(null);
                vo.setUnitBusinessManagerCost(null);
                vo.setUnitProfit(null);
                vo.setComprehensiveUnitPrice(null);

                if (vo.getTpid() != null && !TextUtils.isEmpty(vo.getTpid())) {
                    clearPData(vo, list);
                    break;
                }
            }
        }

        return list;
    }

    /**
     * 对子表做排序、构建树等处理
     *
     * @param voList
     */
    private List<ChangeconsdrawbudgetdetailVO> handleChildren(List<ChangeconsdrawbudgetdetailVO> voList) {
        //按子目编码排序
        Collections.sort(voList, new Comparator<ChangeconsdrawbudgetdetailVO>() {
            @Override
            public int compare(ChangeconsdrawbudgetdetailVO o1, ChangeconsdrawbudgetdetailVO o2) {
                return (o1.getSubitemCode()+o1.getSection()).compareTo(o2.getSubitemCode()+o2.getSection());
            }
        });

        //构建树
        voList = createTreeData(voList);

        return voList;
    }

    public static List<ChangeconsdrawbudgetdetailVO> createTreeData(List<ChangeconsdrawbudgetdetailVO> list) {
        List<ChangeconsdrawbudgetdetailVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();

        //循环list，放入listMap重
        Map<String, ChangeconsdrawbudgetdetailVO> listMap = new HashMap<>();
        for(ChangeconsdrawbudgetdetailVO item:list) {
            listMap.put(item.getTid().toString(), item);
        }

        for(int i =0; i<list.size(); i++) {
            ChangeconsdrawbudgetdetailVO item = list.get(i);
            String parentId = (item.getTpid() != null) ? item.getTpid().toString():"";
            ChangeconsdrawbudgetdetailVO parent = listMap.get(parentId);
            if(parent != null) {
                List<ChangeconsdrawbudgetdetailVO> child = (List<ChangeconsdrawbudgetdetailVO>) parent.getChildren();
                if(child != null) {
                    child.add(item);
                }else{
                    List<ChangeconsdrawbudgetdetailVO> children = new ArrayList<ChangeconsdrawbudgetdetailVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getTid());
            }
        }

        for(String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }
}
