package com.ejianc.business.change.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.bean.ConsdrawbudgetEntity;
import com.ejianc.business.bedget.bean.ConsdrawbudgetdetailEntity;
import com.ejianc.business.bedget.bean.ConsdrawbudgettotalEntity;
import com.ejianc.business.bedget.service.IConsdrawbudgetService;
import com.ejianc.business.bedget.service.IConsdrawbudgetdetailService;
import com.ejianc.business.bedget.service.IConsdrawbudgettotalService;
import com.ejianc.business.change.bean.ChangeconsdrawbudgettotalEntity;
import com.ejianc.business.change.service.IChangeconsdrawbudgettotalService;
import com.ejianc.business.change.vo.*;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;



/**
 * 施工预算图汇总表变更
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("changeconsdrawbudgettotal")
public class ChangeconsdrawbudgettotalController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "change-budgetmanage-consdrawbudget_total";//此处需要根据实际修改

    @Autowired
    private IChangeconsdrawbudgettotalService service;
    @Autowired
    private IConsdrawbudgettotalService consdrawbudgettotalService;

    @Autowired
    private IConsdrawbudgetService consdrawbudgetService;
    @Autowired
    private IConsdrawbudgetdetailService consdrawbudgetdetailService;

    /**
     * 初始化更详情页面
     *
     * @param consdrawtotalId
     * @return
     */
    @GetMapping(value = "queryDetailByConsdrawtotalId")
    @ResponseBody
    public CommonResponse<ChangeconsdrawbudgettotalVO> queryDetailByConsdrawtotalId(@RequestParam(value = "consdrawtotalId") Long consdrawtotalId) {
        ConsdrawbudgettotalEntity consdrawbudgettotalEntity = consdrawbudgettotalService.selectById(consdrawtotalId);
        ChangeconsdrawbudgettotalVO changeVO = BeanMapper.map(consdrawbudgettotalEntity, ChangeconsdrawbudgettotalVO.class);

        List<ChangeconsdrawbudgettotaldetailVO> consdrawbudgettotaldetailVOList = new ArrayList<>();
        //变更单主表基础信息
        Long id = IdWorker.getId();
        changeVO.setOriginalId(consdrawtotalId);
        changeVO.setBillState(null);
        changeVO.setCreateTime(null);
        changeVO.setCreateUserCode(null);
        changeVO.setTenantId(null);
        changeVO.setUpdateTime(null);
        changeVO.setUpdateUserCode(null);
        changeVO.setId(id);

        Long projectId = consdrawbudgettotalEntity.getProjectId();

        //根据项目id查询限施工图预算表id
        QueryWrapper<ConsdrawbudgetEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("project_id", projectId);
        queryWrapper.eq("dr", 0);
        queryWrapper.in("bill_state", 1, 3);//审批通过的
        ConsdrawbudgetEntity entity = consdrawbudgetService.getOne(queryWrapper);

        //根据主表id和tpid为空 查询子表第一层数据
        QueryWrapper<ConsdrawbudgetdetailEntity> queryWrapper1 = new QueryWrapper<>();
        queryWrapper1.eq("mid", entity.getId());
        queryWrapper1.eq("dr", 0);
        queryWrapper1.eq("tpid", "");
        List<ConsdrawbudgetdetailEntity> list = consdrawbudgetdetailService.list(queryWrapper1);

        for (ConsdrawbudgetdetailEntity consdrawbudgetdetailEntity : list) {
            //循环将第一层数据的值赋值给清单
            ChangeconsdrawbudgettotaldetailVO consdrawbudgettotaldetailVO = new ChangeconsdrawbudgettotaldetailVO();
            consdrawbudgettotaldetailVO.setId(IdWorker.getId());
            consdrawbudgettotaldetailVO.setSubitemCode(consdrawbudgetdetailEntity.getSubitemCode());
            consdrawbudgettotaldetailVO.setSection(consdrawbudgetdetailEntity.getSection());
            consdrawbudgettotaldetailVO.setProjectUnitName(consdrawbudgetdetailEntity.getSubitemName());
            consdrawbudgettotaldetailVO.setUnitLaborCost(consdrawbudgetdetailEntity.getTotalLaborCost());
            consdrawbudgettotaldetailVO.setUnitMaterialCost(consdrawbudgetdetailEntity.getTotalMaterialCost());
            consdrawbudgettotaldetailVO.setUnitMachineryCost(consdrawbudgetdetailEntity.getTotalMachineryCost());
            consdrawbudgettotaldetailVO.setUnitBusinessManagerCost(consdrawbudgetdetailEntity.getTotalBusinessManagerCost());
            consdrawbudgettotaldetailVO.setUnitProfit(consdrawbudgetdetailEntity.getTotalProfit());
            consdrawbudgettotaldetailVO.setItemsSubTotal(consdrawbudgetdetailEntity.getSumTotalPrice());
            BigDecimal fees = new BigDecimal(0);
            BigDecimal socialSecurity = consdrawbudgetdetailEntity.getSocialSecurity();
            BigDecimal housing = consdrawbudgetdetailEntity.getHousing();
            BigDecimal reserved1 = consdrawbudgetdetailEntity.getReserved1();
            BigDecimal reserved2 = consdrawbudgetdetailEntity.getReserved2();
            BigDecimal reserved3 = consdrawbudgetdetailEntity.getReserved3();
            if (socialSecurity != null) {
                fees = fees.add(socialSecurity);
            }
            if (housing != null) {
                fees = fees.add(housing);
            }
            if (reserved1 != null) {
                fees = fees.add(reserved1);
            }
            if (reserved2 != null) {
                fees = fees.add(reserved2);
            }
            if (reserved3 != null) {
                fees = fees.add(reserved3);
            }
            consdrawbudgettotaldetailVO.setFees(fees);
            consdrawbudgettotaldetailVO.setTax(consdrawbudgetdetailEntity.getTax());
            consdrawbudgettotaldetailVO.setTid(consdrawbudgetdetailEntity.getTid());
            consdrawbudgettotaldetailVO.setTpid(consdrawbudgetdetailEntity.getTpid());
            //根据主表id和第一层数据的父id查询第二层数据
            QueryWrapper<ConsdrawbudgetdetailEntity> queryWrapper2 = new QueryWrapper<>();
            queryWrapper2.eq("mid", entity.getId());
            queryWrapper2.eq("dr", 0);
            queryWrapper2.eq("tpid", consdrawbudgetdetailEntity.getTid());
            List<ConsdrawbudgetdetailEntity> list1 = consdrawbudgetdetailService.list(queryWrapper2);
            if (list1 != null) {
                for (ConsdrawbudgetdetailEntity consdrawbudgetdetailEntity1 : list1) {
                    List<ChangeconsdrawbudgettotaldetailVO> consdrawbudgettotaldetailVOs = new ArrayList<>();
                    ChangeconsdrawbudgettotaldetailVO consdrawbudgettotaldetailVO1 = new ChangeconsdrawbudgettotaldetailVO();
                    consdrawbudgettotaldetailVO1.setId(IdWorker.getId());
                    consdrawbudgettotaldetailVO1.setSubitemCode(consdrawbudgetdetailEntity1.getSubitemCode());
                    consdrawbudgettotaldetailVO1.setSection(consdrawbudgetdetailEntity1.getSection());
                    consdrawbudgettotaldetailVO1.setProjectUnitName(consdrawbudgetdetailEntity1.getSubitemName());
                    consdrawbudgettotaldetailVO1.setUnitLaborCost(consdrawbudgetdetailEntity1.getTotalLaborCost());
                    consdrawbudgettotaldetailVO1.setUnitMaterialCost(consdrawbudgetdetailEntity1.getTotalMaterialCost());
                    consdrawbudgettotaldetailVO1.setUnitMachineryCost(consdrawbudgetdetailEntity1.getTotalMachineryCost());
                    consdrawbudgettotaldetailVO1.setUnitBusinessManagerCost(consdrawbudgetdetailEntity1.getTotalBusinessManagerCost());
                    consdrawbudgettotaldetailVO1.setUnitProfit(consdrawbudgetdetailEntity1.getTotalProfit());
                    consdrawbudgettotaldetailVO1.setItemsSubTotal(consdrawbudgetdetailEntity1.getSumTotalPrice());
                    BigDecimal fees1 = new BigDecimal(0);
                    BigDecimal socialSecurity1 = consdrawbudgetdetailEntity1.getSocialSecurity();
                    BigDecimal housing1 = consdrawbudgetdetailEntity1.getHousing();
                    BigDecimal reserved11 = consdrawbudgetdetailEntity1.getReserved1();
                    BigDecimal reserved21 = consdrawbudgetdetailEntity1.getReserved2();
                    BigDecimal reserved31 = consdrawbudgetdetailEntity1.getReserved3();
                    if (socialSecurity1 != null) {
                        fees1 = fees1.add(socialSecurity1);
                    }
                    if (housing1 != null) {
                        fees1 = fees1.add(housing1);
                    }
                    if (reserved11 != null) {
                        fees1 = fees1.add(reserved11);
                    }
                    if (reserved21 != null) {
                        fees1 = fees1.add(reserved21);
                    }
                    if (reserved31 != null) {
                        fees1 = fees1.add(reserved31);
                    }
                    consdrawbudgettotaldetailVO1.setFees(fees1);
                    consdrawbudgettotaldetailVO1.setTax(consdrawbudgetdetailEntity1.getTax());
                    consdrawbudgettotaldetailVO1.setTid(consdrawbudgetdetailEntity1.getTid());
                    consdrawbudgettotaldetailVO1.setTpid(consdrawbudgetdetailEntity1.getTpid());
                    consdrawbudgettotaldetailVOs.add(consdrawbudgettotaldetailVO1);
                    //将第二层数据添加到第一层数据下
                    consdrawbudgettotaldetailVO.setChildren(consdrawbudgettotaldetailVOs);
                }
            }
            consdrawbudgettotaldetailVOList.add(consdrawbudgettotaldetailVO);
        }

        changeVO.setConsdrawbudgettotaldetailEntities(consdrawbudgettotaldetailVOList);

        return CommonResponse.success("查询详情成功！", changeVO);

    }

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveChange", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ChangeconsdrawbudgettotalVO> saveChange(@RequestBody ChangeconsdrawbudgettotalVO saveOrUpdateVO) {
        return service.saveChange(saveOrUpdateVO);
    }
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ChangeconsdrawbudgettotalVO> saveOrUpdate(@RequestBody ChangeconsdrawbudgettotalVO saveorUpdateVO) {
    	ChangeconsdrawbudgettotalEntity entity = BeanMapper.map(saveorUpdateVO, ChangeconsdrawbudgettotalEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	ChangeconsdrawbudgettotalVO vo = BeanMapper.map(entity, ChangeconsdrawbudgettotalVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ChangeconsdrawbudgettotalVO> queryDetail(Long id) {
    	ChangeconsdrawbudgettotalEntity entity = service.selectById(id);
    	ChangeconsdrawbudgettotalVO vo = BeanMapper.map(entity, ChangeconsdrawbudgettotalVO.class);
        //构建树形结构
        List<ChangeconsdrawbudgettotaldetailVO> consdrawbudgettotaldetailVOList = vo.getConsdrawbudgettotaldetailEntities();
        vo.setConsdrawbudgettotaldetailEntities(handleChildren(consdrawbudgettotaldetailVOList));
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ChangeconsdrawbudgettotalVO> vos) {
        return service.delete(vos);
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ChangeconsdrawbudgettotalVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        //param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<ChangeconsdrawbudgettotalEntity> page = service.queryPage(param,false);
        IPage<ChangeconsdrawbudgettotalVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ChangeconsdrawbudgettotalVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ChangeconsdrawbudgettotalEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Changeconsdrawbudgettotal-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refChangeconsdrawbudgettotalData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ChangeconsdrawbudgettotalVO>> refChangeconsdrawbudgettotalData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        //param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ChangeconsdrawbudgettotalEntity> page = service.queryPage(param,false);
        IPage<ChangeconsdrawbudgettotalVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ChangeconsdrawbudgettotalVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 对子表做排序、构建树等处理
     *
     * @param voList
     */
    private List<ChangeconsdrawbudgettotaldetailVO> handleChildren(List<ChangeconsdrawbudgettotaldetailVO> voList) {
        //按子目编码排序
        Collections.sort(voList, new Comparator<ChangeconsdrawbudgettotaldetailVO>() {
            @Override
            public int compare(ChangeconsdrawbudgettotaldetailVO o1, ChangeconsdrawbudgettotaldetailVO o2) {
                return (o1.getSubitemCode()+o1.getSection()).compareTo(o2.getSubitemCode()+o2.getSection());
            }
        });

        //构建树
        voList = createTreeData(voList);

        return voList;
    }
    public static List<ChangeconsdrawbudgettotaldetailVO> createTreeData(List<ChangeconsdrawbudgettotaldetailVO> list) {
        List<ChangeconsdrawbudgettotaldetailVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();

        //循环list，放入listMap重
        Map<String, ChangeconsdrawbudgettotaldetailVO> listMap = new HashMap<>();
        for (ChangeconsdrawbudgettotaldetailVO item : list) {
            listMap.put(item.getTid().toString(), item);
        }

        for (int i = 0; i < list.size(); i++) {
            ChangeconsdrawbudgettotaldetailVO item = list.get(i);
            String parentId = (item.getTpid() != null) ? item.getTpid().toString() : "";
            ChangeconsdrawbudgettotaldetailVO parent = listMap.get(parentId);
            if (parent != null) {
                List<ChangeconsdrawbudgettotaldetailVO> child = (List<ChangeconsdrawbudgettotaldetailVO>) parent.getChildren();
                if (child != null) {
                    child.add(item);
                } else {
                    List<ChangeconsdrawbudgettotaldetailVO> children = new ArrayList<ChangeconsdrawbudgettotaldetailVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getTid());
            }
        }

        for (String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }
}
