package com.ejianc.business.change.excel;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.vo.ConsdrawbudgetdetailVO;
import com.ejianc.business.change.bean.ChangeconsdrawbudgetdetailEntity;
import com.ejianc.business.change.service.IChangeconsdrawbudgetdetailService;
import com.ejianc.business.change.vo.ChangeconsdrawbudgetVO;
import com.ejianc.business.change.vo.ChangeconsdrawbudgetdetailVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 施工图预算清单导入导出
 */
@Controller
@RequestMapping("changeConsdrawbudgetExport")
public class ExeclChangeConsdrawbudgetController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IChangeconsdrawbudgetdetailService changeconsdrawbudgetdetailService;

    /**
     * 导入模板下载
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadConsdrawbudget")
    @ResponseBody
    public void downloadConsdrawbudget(HttpServletRequest request, HttpServletResponse response){
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "consdrawbudgetdetail-import.xlsx", "施工图预算清单模板");
    }

    /**
     * excel导入
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelImportConsdrawbudget", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportConsdrawbudget(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<ChangeconsdrawbudgetdetailVO> successList = new ArrayList<>();
        List<ChangeconsdrawbudgetdetailVO> errorList = new ArrayList<>();
        Map<String, ChangeconsdrawbudgetdetailVO> map = new HashMap<>();
        DateFormat sdf=new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if(isFailed) {
            return CommonResponse.error("文件格式不合法");
        }else{
            List<List<String>> result = ExcelReader.readExcel(mf);
            if(result != null && result.size() > 0) {
                for(int i=2;i<result.size();i++) {
                    List<String> datas = result.get(i);
                    StringBuilder errorsMsgBuilder = new StringBuilder();

                    String subitemCode = datas.get(0);
                    String section = datas.get(1);
                    String subitemName = datas.get(2);

                    String engineeQuatity = datas.get(5);
                    String unitLaborCost = datas.get(6);
                    String unitmaterialCost = datas.get(7);
                    String unitMachineryCost = datas.get(8);
                    String unitBusinessManagerCost = datas.get(9);
                    String unitProfit = datas.get(10);
                    String comprehensiveUnitPrice = datas.get(11);
                    String totalLaborCost = datas.get(12);
                    String totalMaterialCost = datas.get(13);
                    String totalMachineryCost = datas.get(14);
                    String totalBusinessManagerCost = datas.get(15);
                    String totalProfit = datas.get(16);
                    String sumTotalPrice = datas.get(17);
                    String socialSecurity = datas.get(18);
                    String housing = datas.get(19);
                    String reserved1 = datas.get(20);
                    String reserved2 = datas.get(21);
                    String reserved3 = datas.get(22);
                    String tax = datas.get(23);
                    String provisionalEstimate = datas.get(24);

                    ChangeconsdrawbudgetdetailVO consdrawbudgetdetailVO = new ChangeconsdrawbudgetdetailVO();
                    consdrawbudgetdetailVO.setId(IdWorker.getId());//id
                    consdrawbudgetdetailVO.setTid(String.valueOf(IdWorker.getId()));//tid

                    consdrawbudgetdetailVO.setSubitemCode(StringUtils.isNotBlank(subitemCode) ? subitemCode : null); // 子目编码
                    consdrawbudgetdetailVO.setSection(StringUtils.isNotBlank(section) ? section : null); // 区段
                    consdrawbudgetdetailVO.setSubitemName(StringUtils.isNotBlank(subitemName) ? subitemName : null); // 子目名称
                    consdrawbudgetdetailVO.setCharacterDescrip(StringUtils.isNotBlank(datas.get(3)) ? datas.get(3) : null); // 子目特征描述
                    consdrawbudgetdetailVO.setEstimateUnit(StringUtils.isNotBlank(datas.get(4)) ? datas.get(4) : null); // 计量单位

                    //必填项校验
                    if (subitemCode == null || TextUtils.isEmpty(subitemCode)) {
                        consdrawbudgetdetailVO.setErrorMsg("子目编码不能为空！");
                        errorsMsgBuilder.append("子目编码不能为空！");
                    }
                    if (section == null || TextUtils.isEmpty(section)) {
                        consdrawbudgetdetailVO.setErrorMsg("区段不能为空！");
                        errorsMsgBuilder.append("区段不能为空！");
                    }
                    if (subitemName == null || TextUtils.isEmpty(subitemName)) {
                        consdrawbudgetdetailVO.setErrorMsg("子目名称不能为空！");
                        errorsMsgBuilder.append("子目名称不能为空！");
                    }

                    if(subitemCode != null){
                        consdrawbudgetdetailVO.setInnercode(subitemCode + "_" + section);//子目编码、区段、确定唯一性
//                        if ("01".equals(subitemCode) && subitemName != null && subitemName.contains("装饰")) {
//                            consdrawbudgetdetailVO.setInnercode("a1" + "_" + consdrawbudgetdetailVO.getSection());
//                        }
                        //判断是否是装饰工程的子节点编码
//                        if (subitemCode.length() >= 4) {
//                            //0111、0112、0113、0114、0115这五个节点都是装饰工程下的
//                            String code = subitemCode.substring(0, 4);
//                            if ("0111".equals(code) || "0112".equals(code) || "0113".equals(code) || "0114".equals(code) || "0115".equals(code)) {
//                                //若是的话，将内码改为a1xx
//                                consdrawbudgetdetailVO.setInnercode("a1" + subitemCode.substring(2, subitemCode.length()) + "_" + section);
//                            }
//                        }
                        //1、校验编码是否符合规则--2、4、6、9、9以上
                        if (subitemCode == null || !(subitemCode.length() == 2 || subitemCode.length() == 4 || subitemCode.length() == 6 || subitemCode.length() >= 9)) {
                            consdrawbudgetdetailVO.setErrorMsg("子目编码必须符合：2位、4位、6位、9位或9位以上中任意一规则");
                            errorsMsgBuilder.append("子目编码必须符合：2位、4位、6位、9位或9位以上中任意一规则！");
                        }
                        consdrawbudgetdetailVO.setSubitemCode(subitemCode);

                        //重复性校验
                        ChangeconsdrawbudgetdetailVO mapVO = map.get(consdrawbudgetdetailVO.getInnercode());
                        if(mapVO == null){
                            map.put(consdrawbudgetdetailVO.getInnercode(), consdrawbudgetdetailVO);
                        }else {
                            consdrawbudgetdetailVO.setErrorMsg("子目编码已存在！");
                            errorsMsgBuilder.append("子目编码已存在！");
                        }
                        consdrawbudgetdetailVO.setSubitemCode(subitemCode);
                    }

                    //格式校验
                    if (!TextUtils.isEmpty(engineeQuatity) && !NumberUtil.isNumber(engineeQuatity)) {
                        consdrawbudgetdetailVO.setErrorMsg("工程量格式不正确！");
                        errorsMsgBuilder.append("工程量格式不正确！");
                    } else {
                        consdrawbudgetdetailVO.setEngineeQuatity(StringUtils.isNotBlank(engineeQuatity) ? new BigDecimal(engineeQuatity) : null); // 工程量
                    }

                    if (!TextUtils.isEmpty(unitLaborCost) && !NumberUtil.isNumber(unitLaborCost)) {
                        consdrawbudgetdetailVO.setErrorMsg("人工费（单价）格式不正确！");
                        errorsMsgBuilder.append("人工费（单价）格式不正确！");
                    } else {
                        consdrawbudgetdetailVO.setUnitLaborCost(StringUtils.isNotBlank(unitLaborCost) ? new BigDecimal(unitLaborCost) : null); // 人工费(单价)
                    }

                    if (!TextUtils.isEmpty(unitmaterialCost) && !NumberUtil.isNumber(unitmaterialCost)) {
                        consdrawbudgetdetailVO.setErrorMsg("材料费（单价）格式不正确！");
                        errorsMsgBuilder.append("材料费（单价）格式不正确！");
                    } else {
                        consdrawbudgetdetailVO.setUnitMaterialCost(StringUtils.isNotBlank(unitmaterialCost) ? new BigDecimal(unitmaterialCost) : null); // 材料费(单价)
                    }

                    if (!TextUtils.isEmpty(unitMachineryCost) && !NumberUtil.isNumber(unitMachineryCost)) {
                        consdrawbudgetdetailVO.setErrorMsg("机械费（单价）格式不正确！");
                        errorsMsgBuilder.append("机械费（单价）格式不正确！");
                    } else {
                        consdrawbudgetdetailVO.setUnitMachineryCost(StringUtils.isNotBlank(unitMachineryCost) ? new BigDecimal(unitMachineryCost) : null); // 机械费(单价)
                    }

                    if (!TextUtils.isEmpty(unitBusinessManagerCost) && !NumberUtil.isNumber(unitBusinessManagerCost)) {
                        consdrawbudgetdetailVO.setErrorMsg("企业管理费（单价）格式不正确！");
                        errorsMsgBuilder.append("企业管理费（单价）格式不正确！");
                    } else {
                        consdrawbudgetdetailVO.setUnitBusinessManagerCost(StringUtils.isNotBlank(unitBusinessManagerCost) ? new BigDecimal(unitBusinessManagerCost) : null); // 企业管理费(单价)
                    }

                    if (!TextUtils.isEmpty(unitProfit) && !NumberUtil.isNumber(unitProfit)) {
                        consdrawbudgetdetailVO.setErrorMsg("利润（单价）格式不正确！");
                        errorsMsgBuilder.append("利润（单价）格式不正确！");
                    } else {
                        consdrawbudgetdetailVO.setUnitProfit(StringUtils.isNotBlank(unitProfit) ? new BigDecimal(unitProfit) : null); // 利润(单价)
                    }

                    if (!TextUtils.isEmpty(comprehensiveUnitPrice) && !NumberUtil.isNumber(comprehensiveUnitPrice)) {
                        consdrawbudgetdetailVO.setErrorMsg("综合单价格式不正确！");
                        errorsMsgBuilder.append("综合单价格式不正确！");
                    } else {
                        BigDecimal comprehensiveUnitPriceB = new BigDecimal(0);
                        if(unitLaborCost != null && NumberUtil.isNumber(unitLaborCost)){//人工费（单价）
                            comprehensiveUnitPriceB = comprehensiveUnitPriceB.add(new BigDecimal(unitLaborCost));
                        }else {
                            unitLaborCost = null;
                        }
                        if(unitmaterialCost != null && NumberUtil.isNumber(unitmaterialCost)){
                            comprehensiveUnitPriceB = comprehensiveUnitPriceB.add(new BigDecimal(unitmaterialCost));
                        }else {
                            unitmaterialCost = null;
                        }
                        if(unitMachineryCost != null && NumberUtil.isNumber(unitMachineryCost)){
                            comprehensiveUnitPriceB = comprehensiveUnitPriceB.add(new BigDecimal(unitMachineryCost));
                        }else {
                            unitMachineryCost = null;
                        }
                        if(unitBusinessManagerCost != null && NumberUtil.isNumber(unitBusinessManagerCost)){
                            comprehensiveUnitPriceB = comprehensiveUnitPriceB.add(new BigDecimal(unitBusinessManagerCost));
                        }else {
                            unitBusinessManagerCost = null;
                        }
                        if(unitProfit != null && NumberUtil.isNumber(unitProfit)){
                            comprehensiveUnitPriceB = comprehensiveUnitPriceB.add(new BigDecimal(unitProfit));
                        }else {
                            unitProfit = null;
                        }

                        if(unitLaborCost == null && unitmaterialCost == null && unitMachineryCost == null && unitBusinessManagerCost == null && unitProfit == null){
                            comprehensiveUnitPriceB = null;
                        }

                        consdrawbudgetdetailVO.setComprehensiveUnitPrice(StringUtils.isNotBlank(comprehensiveUnitPrice) ? new BigDecimal(comprehensiveUnitPrice) : comprehensiveUnitPriceB); // 综合单价
                    }

                    if (!TextUtils.isEmpty(totalLaborCost) && !NumberUtil.isNumber(totalLaborCost)) {
                        consdrawbudgetdetailVO.setErrorMsg("人工费（合价）格式不正确！");
                        errorsMsgBuilder.append("人工费（合价）格式不正确！");
                    } else {
                        BigDecimal totalLaborCostB = null;
                        if(engineeQuatity != null && NumberUtil.isNumber(engineeQuatity) && unitLaborCost != null && NumberUtil.isNumber(unitLaborCost)){
                            totalLaborCostB = new BigDecimal(engineeQuatity).multiply(new BigDecimal(unitLaborCost));
                        }
                        consdrawbudgetdetailVO.setTotalLaborCost(StringUtils.isNotBlank(totalLaborCost) ? new BigDecimal(totalLaborCost) : totalLaborCostB); // 人工费(综合)
                    }

                    if (!TextUtils.isEmpty(totalMaterialCost) && !NumberUtil.isNumber(totalMaterialCost)) {
                        consdrawbudgetdetailVO.setErrorMsg("材料费（合价）格式不正确！");
                        errorsMsgBuilder.append("材料费（合价）格式不正确！");
                    } else {
                        BigDecimal totalMaterialCostB = null;
                        if(engineeQuatity != null && NumberUtil.isNumber(engineeQuatity) && unitmaterialCost != null && NumberUtil.isNumber(unitmaterialCost)){
                            totalMaterialCostB = new BigDecimal(engineeQuatity).multiply(new BigDecimal(unitmaterialCost));
                        }
                        consdrawbudgetdetailVO.setTotalMaterialCost(StringUtils.isNotBlank(totalMaterialCost) ? new BigDecimal(totalMaterialCost) : totalMaterialCostB); // 材料费(综合)
                    }

                    if (!TextUtils.isEmpty(totalMachineryCost) && !NumberUtil.isNumber(totalMachineryCost)) {
                        consdrawbudgetdetailVO.setErrorMsg("机械费（合价）格式不正确！");
                        errorsMsgBuilder.append("机械费（合价）格式不正确！");
                    } else {
                        BigDecimal totalMachineryCostB = null;
                        if(engineeQuatity != null && NumberUtil.isNumber(engineeQuatity) && unitMachineryCost != null && NumberUtil.isNumber(unitMachineryCost)){
                            totalMachineryCostB = new BigDecimal(engineeQuatity).multiply(new BigDecimal(unitMachineryCost));
                        }
                        consdrawbudgetdetailVO.setTotalMachineryCost(StringUtils.isNotBlank(totalMachineryCost) ? new BigDecimal(totalMachineryCost) : totalMachineryCostB); // 机械费(综合)
                    }

                    if (!TextUtils.isEmpty(totalBusinessManagerCost) && !NumberUtil.isNumber(totalBusinessManagerCost)) {
                        consdrawbudgetdetailVO.setErrorMsg("企业管理费（合价）格式不正确！");
                        errorsMsgBuilder.append("企业管理费（合价）格式不正确！");
                    } else {
                        BigDecimal totalBusinessManagerCostB = null;
                        if(engineeQuatity != null && NumberUtil.isNumber(engineeQuatity) && unitBusinessManagerCost != null && NumberUtil.isNumber(unitBusinessManagerCost)){
                            totalBusinessManagerCostB = new BigDecimal(engineeQuatity).multiply(new BigDecimal(unitBusinessManagerCost));
                        }
                        consdrawbudgetdetailVO.setTotalBusinessManagerCost(StringUtils.isNotBlank(totalBusinessManagerCost) ? new BigDecimal(totalBusinessManagerCost) : totalBusinessManagerCostB); // 企业管理费(综合)
                    }

                    if (!TextUtils.isEmpty(totalProfit) && !NumberUtil.isNumber(totalProfit)) {
                        consdrawbudgetdetailVO.setErrorMsg("利润（合价）格式不正确！");
                        errorsMsgBuilder.append("利润（合价）格式不正确！");
                    } else {
                        BigDecimal totalProfitB = null;
                        if(engineeQuatity != null && NumberUtil.isNumber(engineeQuatity) && unitProfit != null && NumberUtil.isNumber(unitProfit)){
                            totalProfitB = new BigDecimal(engineeQuatity).multiply(new BigDecimal(unitProfit));
                        }
                        consdrawbudgetdetailVO.setTotalProfit(StringUtils.isNotBlank(totalProfit) ? new BigDecimal(totalProfit) : totalProfitB); // 利润(综合)
                    }

                    if (!TextUtils.isEmpty(sumTotalPrice) && !NumberUtil.isNumber(sumTotalPrice)) {
                        consdrawbudgetdetailVO.setErrorMsg("合价格式不正确！");
                        errorsMsgBuilder.append("合价格式不正确！");
                    } else {
                        BigDecimal sumTotalPriceB = new BigDecimal(0);
                        BigDecimal totalLaborCostB = consdrawbudgetdetailVO.getTotalLaborCost();
                        BigDecimal totalMaterialCostB = consdrawbudgetdetailVO.getTotalMaterialCost();
                        BigDecimal totalMachineryCostB = consdrawbudgetdetailVO.getTotalMachineryCost();
                        BigDecimal totalBusinessManagerCostB = consdrawbudgetdetailVO.getTotalBusinessManagerCost();
                        BigDecimal totalProfitB = consdrawbudgetdetailVO.getTotalProfit();
                        if(totalLaborCostB != null){
                            sumTotalPriceB = sumTotalPriceB.add(totalLaborCostB);
                        }

                        if(totalMaterialCostB != null){
                            sumTotalPriceB = sumTotalPriceB.add(totalMaterialCostB);
                        }

                        if(totalMachineryCostB != null){
                            sumTotalPriceB = sumTotalPriceB.add(totalMachineryCostB);
                        }

                        if(totalBusinessManagerCostB != null){
                            sumTotalPriceB = sumTotalPriceB.add(totalBusinessManagerCostB);
                        }

                        if(totalProfitB != null){
                            sumTotalPriceB = sumTotalPriceB.add(totalProfitB);
                        }

                        if(totalLaborCostB == null && totalMaterialCostB == null && totalMachineryCostB == null && totalBusinessManagerCostB == null && totalProfitB == null){
                            sumTotalPriceB = null;
                        }
                        consdrawbudgetdetailVO.setSumTotalPrice(StringUtils.isNotBlank(sumTotalPrice) ? new BigDecimal(sumTotalPrice) : sumTotalPriceB); // 合价
                    }

                    if (!TextUtils.isEmpty(socialSecurity) && !NumberUtil.isNumber(socialSecurity)) {
                        consdrawbudgetdetailVO.setErrorMsg("社保格式不正确！");
                        errorsMsgBuilder.append("社保格式不正确！");
                    } else {
                        consdrawbudgetdetailVO.setSocialSecurity(StringUtils.isNotBlank(socialSecurity) ? new BigDecimal(socialSecurity) : null); // 社保
                    }

                    if(!TextUtils.isEmpty(housing) && !NumberUtil.isNumber(housing)){
                        consdrawbudgetdetailVO.setErrorMsg("住房格式不正确！");
                        errorsMsgBuilder.append("住房格式不正确！");
                    }else {
                        consdrawbudgetdetailVO.setHousing(StringUtils.isNotBlank(housing) ? new BigDecimal(housing) : null); // 住房
                    }

                    if(!TextUtils.isEmpty(reserved1) && !NumberUtil.isNumber(reserved1)){
                        consdrawbudgetdetailVO.setErrorMsg("预留1格式不正确！");
                        errorsMsgBuilder.append("预留1格式不正确！");
                    }else {
                        consdrawbudgetdetailVO.setReserved1(StringUtils.isNotBlank(reserved1) ? new BigDecimal(reserved1) : null); // 预留1
                    }

                    if(!TextUtils.isEmpty(reserved2) && !NumberUtil.isNumber(reserved2)){
                        consdrawbudgetdetailVO.setErrorMsg("预留2格式不正确！");
                        errorsMsgBuilder.append("预留2格式不正确！");
                    }else {
                        consdrawbudgetdetailVO.setReserved2(StringUtils.isNotBlank(reserved2) ? new BigDecimal(reserved2) : null); // 预留2
                    }

                    if(!TextUtils.isEmpty(reserved3) && !NumberUtil.isNumber(reserved3)){
                        consdrawbudgetdetailVO.setErrorMsg("预留3格式不正确！");
                        errorsMsgBuilder.append("预留3格式不正确！");
                    }else {
                        consdrawbudgetdetailVO.setReserved3(StringUtils.isNotBlank(reserved3) ? new BigDecimal(reserved3) : null); // 预留3
                    }

                    if(!TextUtils.isEmpty(tax) && !NumberUtil.isNumber(tax)){
                        consdrawbudgetdetailVO.setErrorMsg("税金格式不正确！");
                        errorsMsgBuilder.append("税金格式不正确！");
                    }else {
                        consdrawbudgetdetailVO.setTax(StringUtils.isNotBlank(tax) ? new BigDecimal(tax) : null); // 税金
                    }

                    if(!TextUtils.isEmpty(provisionalEstimate) && !NumberUtil.isNumber(provisionalEstimate)){
                        consdrawbudgetdetailVO.setErrorMsg("暂估价格式不正确！");
                        errorsMsgBuilder.append("暂估价格式不正确！");
                    }else {
                        consdrawbudgetdetailVO.setProvisionalEstimate(StringUtils.isNotBlank(provisionalEstimate) ? new BigDecimal(provisionalEstimate) : null); // 暂估价
                    }

                    if(errorsMsgBuilder.length() > 0){
                        errorList.add(consdrawbudgetdetailVO);
                    }else {
                        successList.add(consdrawbudgetdetailVO);
                    }
                }
            }
        }
        //按子目编码排序
        Collections.sort(successList, new Comparator<ChangeconsdrawbudgetdetailVO>() {
            @Override
            public int compare(ChangeconsdrawbudgetdetailVO o1, ChangeconsdrawbudgetdetailVO o2) {
                return (o1.getSubitemCode()+o1.getSection()).compareTo(o2.getSubitemCode()+o2.getSection());
            }
        });

        //设置tid和tpid
        List<ChangeconsdrawbudgetdetailVO> resList = setTidAndTpid(successList, map);
        //构建树
        resList = createTreeData(resList);

        //统计父级的合计数值
        getChildrenUnitTotalAmount(resList);

        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", resList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());

        ChangeconsdrawbudgetVO resVo = new ChangeconsdrawbudgetVO();
        json.put("total", getTotalAmount(resList, resVo));
        return CommonResponse.success(json);
    }

    /**
     * 统计父级的合计数值
     * @param vos
     * @return
     */
    private ChangeconsdrawbudgetdetailVO getChildrenUnitTotalAmount(List<ChangeconsdrawbudgetdetailVO> vos){
        ChangeconsdrawbudgetdetailVO detail = new ChangeconsdrawbudgetdetailVO();
        detail.setTotalLaborCost(new BigDecimal(0));//人工费(综合)
        detail.setTotalMaterialCost(new BigDecimal(0));//材料费(综合)
        detail.setTotalMachineryCost(new BigDecimal(0));//机械费(综合)
        detail.setTotalBusinessManagerCost(new BigDecimal(0));//企业管理费(综合)
        detail.setTotalProfit(new BigDecimal(0));//利润(综合)
        detail.setSumTotalPrice(new BigDecimal(0));//合价(元)
        detail.setSocialSecurity(new BigDecimal(0));//社保
        detail.setHousing(new BigDecimal(0));//住房
        detail.setReserved1(new BigDecimal(0));//预留1
        detail.setReserved2(new BigDecimal(0));//预留2
        detail.setReserved3(new BigDecimal(0));//预留3
        detail.setTax(new BigDecimal(0));//税金
        detail.setProvisionalEstimate(new BigDecimal(0));//暂估价

        BigDecimal totalLaborCost = detail.getTotalLaborCost();
        BigDecimal totalMaterialCost = detail.getTotalMaterialCost();
        BigDecimal totalMachineryCost = detail.getTotalMachineryCost();
        BigDecimal totalBusinessManagerCost = detail.getTotalBusinessManagerCost();
        BigDecimal totalProfit = detail.getTotalProfit();
        BigDecimal sumTotalPrice = detail.getSumTotalPrice();
        BigDecimal socialSecurity = detail.getSocialSecurity();
        BigDecimal housing = detail.getHousing();
        BigDecimal reserved1 = detail.getReserved1();
        BigDecimal reserved2 = detail.getReserved2();
        BigDecimal reserved3 = detail.getReserved3();
        BigDecimal tax = detail.getTax();
        BigDecimal provisionalEstimate = detail.getProvisionalEstimate();

        for(ChangeconsdrawbudgetdetailVO vo: vos){
            if(vo.getChildren()!=null&&vo.getChildren().size()>0){
                //有孩子节点----清空工程量和综合单价--金额字段
                vo.setEngineeQuatity(null);// 工程量
                vo.setUnitLaborCost(null);// 人工费
                vo.setUnitMaterialCost(null);
                vo.setUnitMachineryCost(null);
                vo.setUnitBusinessManagerCost(null);
                vo.setUnitProfit(null);
                vo.setComprehensiveUnitPrice(null);

                //获取孩子节点的总计数据
                ChangeconsdrawbudgetdetailVO childrenUnitTotalAmount = this.getChildrenUnitTotalAmount(vo.getChildren());
                vo.setTotalLaborCost(childrenUnitTotalAmount.getTotalLaborCost());
                vo.setTotalMaterialCost(childrenUnitTotalAmount.getTotalMaterialCost());
                vo.setTotalMachineryCost(childrenUnitTotalAmount.getTotalMachineryCost());
                vo.setTotalBusinessManagerCost(childrenUnitTotalAmount.getTotalBusinessManagerCost());
                vo.setTotalProfit(childrenUnitTotalAmount.getTotalProfit());
                vo.setSumTotalPrice(childrenUnitTotalAmount.getSumTotalPrice());
                vo.setSocialSecurity(childrenUnitTotalAmount.getSocialSecurity());
                vo.setHousing(childrenUnitTotalAmount.getHousing());
                vo.setReserved1(childrenUnitTotalAmount.getReserved1());
                vo.setReserved2(childrenUnitTotalAmount.getReserved2());
                vo.setReserved3(childrenUnitTotalAmount.getReserved3());
                vo.setTax(childrenUnitTotalAmount.getTax());
                vo.setProvisionalEstimate(childrenUnitTotalAmount.getProvisionalEstimate());

                totalLaborCost = totalLaborCost.add(childrenUnitTotalAmount.getTotalLaborCost());
                totalMaterialCost = totalMaterialCost.add(childrenUnitTotalAmount.getTotalMaterialCost());
                totalMachineryCost = totalMachineryCost.add(childrenUnitTotalAmount.getTotalMachineryCost());
                totalBusinessManagerCost = totalBusinessManagerCost.add(childrenUnitTotalAmount.getTotalBusinessManagerCost());
                totalProfit = totalProfit.add(childrenUnitTotalAmount.getTotalProfit());
                sumTotalPrice = sumTotalPrice.add(childrenUnitTotalAmount.getSumTotalPrice());
                socialSecurity = socialSecurity.add(childrenUnitTotalAmount.getSocialSecurity());
                housing = housing.add(childrenUnitTotalAmount.getHousing());
                reserved1 = reserved1.add(childrenUnitTotalAmount.getReserved1());
                reserved2 = reserved2.add(childrenUnitTotalAmount.getReserved2());
                reserved3 = reserved3.add(childrenUnitTotalAmount.getReserved3());
                tax = tax.add(childrenUnitTotalAmount.getTax());
                provisionalEstimate = provisionalEstimate.add(childrenUnitTotalAmount.getProvisionalEstimate());
            }else{
                if(vo.getTotalLaborCost()!=null){
                    totalLaborCost = totalLaborCost.add(vo.getTotalLaborCost());
                }

                if(vo.getTotalMaterialCost()!=null){
                    totalMaterialCost = totalMaterialCost.add(vo.getTotalMaterialCost());
                }

                if(vo.getTotalMachineryCost()!=null){
                    totalMachineryCost = totalMachineryCost.add(vo.getTotalMachineryCost());
                }

                if(vo.getTotalBusinessManagerCost()!=null){
                    totalBusinessManagerCost = totalBusinessManagerCost.add(vo.getTotalBusinessManagerCost());
                }

                if(vo.getTotalProfit()!=null){
                    totalProfit = totalProfit.add(vo.getTotalProfit());
                }

                if(vo.getSumTotalPrice()!=null){
                    sumTotalPrice = sumTotalPrice.add(vo.getSumTotalPrice());
                }

                if(vo.getSocialSecurity()!=null){
                    socialSecurity = socialSecurity.add(vo.getSocialSecurity());
                }

                if(vo.getHousing()!=null){
                    housing = housing.add(vo.getHousing());
                }

                if(vo.getReserved1()!=null){
                    reserved1 = reserved1.add(vo.getReserved1());
                }

                if(vo.getReserved2()!=null){
                    reserved2 = reserved2.add(vo.getReserved2());
                }

                if(vo.getReserved3()!=null){
                    reserved3 = reserved3.add(vo.getReserved3());
                }

                if(vo.getTax()!=null){
                    tax = tax.add(vo.getTax());
                }

                if(vo.getProvisionalEstimate()!=null){
                    provisionalEstimate = provisionalEstimate.add(vo.getProvisionalEstimate());
                }
            }

            detail.setTotalLaborCost(totalLaborCost);
            detail.setTotalMaterialCost(totalMaterialCost);
            detail.setTotalMachineryCost(totalMachineryCost);
            detail.setTotalBusinessManagerCost(totalBusinessManagerCost);
            detail.setTotalProfit(totalProfit);
            detail.setSumTotalPrice(sumTotalPrice);
            detail.setSocialSecurity(socialSecurity);
            detail.setHousing(housing);
            detail.setReserved1(reserved1);
            detail.setReserved2(reserved2);
            detail.setReserved3(reserved3);
            detail.setTax(tax);
            detail.setProvisionalEstimate(provisionalEstimate);
        }
        return detail;
    }

    /**
     * 设置tid和tpid
     *
     * @param vos
     * @param map
     * @return
     */
    private List<ChangeconsdrawbudgetdetailVO> setTidAndTpid(List<ChangeconsdrawbudgetdetailVO> vos, Map<String, ChangeconsdrawbudgetdetailVO> map) {
        if(vos == null){
            return null;
        }

        for (int i = 0; i < vos.size(); i++) {
            ChangeconsdrawbudgetdetailVO consdrawbudgetdetailVO = vos.get(i);
            //设置父级id
            String innercode = consdrawbudgetdetailVO.getInnercode();
            String[] innercodeSubArr = innercode.split("_");
            String innercodeSub = "";
            String sectionSuf = "";
            if (innercodeSubArr.length > 1) {
                innercodeSub = innercodeSubArr[0];
                sectionSuf = "_" + innercodeSubArr[1];
            }

            Long pid = null;
            if (innercodeSub.length() == 2) {
                //最上级
            } else if (innercodeSub.length() == 4) {
                String pcode = innercodeSub.substring(0, 2) + sectionSuf;
                //有父节点
                pid = this.setPid(pcode, map);
            } else if (innercodeSub.length() == 6) {
                String pcode = innercodeSub.substring(0, 4) + sectionSuf;
                //有父节点
                pid = this.setPid(pcode, map);
            } else if (innercodeSub.length() > 6) {
                String pcode = innercodeSub.substring(0, 6) + sectionSuf;
                //有父节点
                pid = this.setPid(pcode, map);
            }

            if (pid != null) {
                consdrawbudgetdetailVO.setTpid(pid.toString());
            } else {
                consdrawbudgetdetailVO.setTpid("");
            }
        }

        return vos;
    }

    /**
     * 构建树
     *
     * @param list
     * @return
     */
    public static List<ChangeconsdrawbudgetdetailVO> createTreeData(List<ChangeconsdrawbudgetdetailVO> list) {
        List<ChangeconsdrawbudgetdetailVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();

        //循环list，放入listMap重
        Map<String, ChangeconsdrawbudgetdetailVO> listMap = new HashMap<>();
        for (ChangeconsdrawbudgetdetailVO item : list) {
            listMap.put(item.getTid().toString(), item);
        }

        for (int i = 0; i < list.size(); i++) {
            ChangeconsdrawbudgetdetailVO item = list.get(i);
            String parentId = (item.getTpid() != null) ? item.getTpid().toString() : "";
            ChangeconsdrawbudgetdetailVO parent = listMap.get(parentId);
            if (parent != null) {
                List<ChangeconsdrawbudgetdetailVO> child = (List<ChangeconsdrawbudgetdetailVO>) parent.getChildren();
                if (child != null) {
                    child.add(item);
                } else {
                    List<ChangeconsdrawbudgetdetailVO> children = new ArrayList<ChangeconsdrawbudgetdetailVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getTid());
            }
        }

        for (String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }

    private ChangeconsdrawbudgetVO getTotalAmount(List<ChangeconsdrawbudgetdetailVO> vos, ChangeconsdrawbudgetVO resVo) {
        BigDecimal conDrawBudgetTotal = new BigDecimal(0);
        BigDecimal feesTotal = new BigDecimal(0);
        BigDecimal taxTotal = new BigDecimal(0);
        BigDecimal provisionalEstimateTotal = new BigDecimal(0);

        for (ChangeconsdrawbudgetdetailVO vo : vos) {
            if (vo.getSumTotalPrice() != null) {
                conDrawBudgetTotal = conDrawBudgetTotal.add(vo.getSumTotalPrice());
            }

            if (vo.getTax() != null) {
                taxTotal = taxTotal.add(vo.getTax());
            }

            //规费合计
            if (vo.getSocialSecurity() != null) {
                feesTotal = feesTotal.add(vo.getSocialSecurity());
            }
            if (vo.getHousing() != null) {
                feesTotal = feesTotal.add(vo.getHousing());
            }
            if (vo.getReserved1() != null) {
                feesTotal = feesTotal.add(vo.getReserved1());
            }
            if (vo.getReserved2() != null) {
                feesTotal = feesTotal.add(vo.getReserved2());
            }
            if (vo.getReserved3() != null) {
                feesTotal = feesTotal.add(vo.getReserved3());
            }

            if (vo.getProvisionalEstimate() != null) {
                provisionalEstimateTotal = provisionalEstimateTotal.add(vo.getProvisionalEstimate());
            }
        }

        resVo.setConDrawBudgetTotal(conDrawBudgetTotal);
        resVo.setProvisionalEstimateTotal(provisionalEstimateTotal);
        resVo.setFeesTotal(feesTotal);
        resVo.setTaxTotal(taxTotal);
        return resVo;
    }

    //子目编码规则定死------分别是2位/4位/6位/6为以上
    private Long setPid(String pcode, Map<String, ChangeconsdrawbudgetdetailVO> map) {
        if (map.get(pcode) != null) {
            return Long.valueOf(map.get(pcode).getTid());
        } else {
            //父级没有找到，则继续往上找
            String[] pcodeSubArr = pcode.split("_");
            String pcodeSub = "";
            String sectionSuf = "";//"_" + 区段
            if (pcodeSubArr.length > 1) {
                pcodeSub = pcodeSubArr[0];
                sectionSuf = "_" + pcodeSubArr[1];
            }
            if (pcodeSub.length() == 2) {
                //最上级
                return null;
            } else if (pcodeSub.length() == 4) {
                String ppcode = pcodeSub.substring(0, 2);
                return this.setPid(ppcode + sectionSuf, map);
            } else if (pcodeSub.length() == 6) {
                String ppcode = pcode.substring(0, 4);
                return this.setPid(ppcode + sectionSuf, map);
            } else if (pcodeSub.length() > 6) {
                String ppcode = pcode.substring(0, 6);
                return this.setPid(ppcode + sectionSuf, map);
            } else {
                return null;
            }
        }
    }

    /**
     * excel导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportConsdrawbudgetFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportConsdrawbudgetFromDatabase(@RequestBody ChangeconsdrawbudgetVO changeconsdrawbudgetVO, HttpServletResponse response) {
        QueryWrapper<ChangeconsdrawbudgetdetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", changeconsdrawbudgetVO.getId());
        queryWrapper.eq("dr", 0);
        List<ChangeconsdrawbudgetdetailEntity> list = changeconsdrawbudgetdetailService.list(queryWrapper);
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("consdrawbudgetdetail-export.xlsx", beans, response);
    }

    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportConsdrawbudgetFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportConsdrawbudgetFromPage(@RequestBody List<ChangeconsdrawbudgetdetailVO> list, HttpServletResponse response) {
        List<ChangeconsdrawbudgetdetailVO> concatList = new ArrayList<>();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                ChangeconsdrawbudgetdetailVO changeconsdrawbudgetdetailVO = list.get(i);
                concatList.add(changeconsdrawbudgetdetailVO);
            }
        }

        //children拍平
        List<ChangeconsdrawbudgetdetailVO> allList = handleList(list, concatList);

        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", allList);
        ExcelExport.getInstance().export("consdrawbudgetdetail-export.xlsx", beans, response);
    }

    /**
     * 导出页面数据处理children
     *
     * @param list
     */
    private List<ChangeconsdrawbudgetdetailVO> handleList(List<ChangeconsdrawbudgetdetailVO> list, List<ChangeconsdrawbudgetdetailVO> concatList) {
        if (list == null || list.size() == 0) {
            return concatList;
        }

        for (int i = 0; i < list.size(); i++) {
            ChangeconsdrawbudgetdetailVO changeconsdrawbudgetdetailVO = list.get(i);
            List<ChangeconsdrawbudgetdetailVO> children = changeconsdrawbudgetdetailVO.getChildren();
            if (children != null && children.size() > 0) {
                concatList.addAll(children);
                handleList(children, concatList);
            }
        }

        return concatList;
    }
}
