package com.ejianc.business.change.excel;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.bean.QuotaanalysisdetailEntity;
import com.ejianc.business.bedget.bean.QuotaanalysisdetailInnateEntity;
import com.ejianc.business.bedget.service.IQuotaanalysisdetailInnateService;
import com.ejianc.business.bedget.service.IQuotaanalysisdetailService;
import com.ejianc.business.bedget.vo.QuotaanalysisVO;
import com.ejianc.business.bedget.vo.QuotaanalysisdetailVO;
import com.ejianc.business.change.bean.ChangeQuotaanalysisdetailEntity;
import com.ejianc.business.change.service.IChangeQuotaanalysisdetailService;
import com.ejianc.business.change.vo.ChangeQuotaanalysisVO;
import com.ejianc.business.change.vo.ChangeQuotaanalysisdetailVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;

/**
 * 限额设计指标分析导入导出
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("changeQuotaanalysisExport")
public class ExporChangeQuotaanalysisController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IChangeQuotaanalysisdetailService changeQuotaanalysisdetailService;
    @Autowired
    private IQuotaanalysisdetailInnateService quotaanalysisdetailInnateService;
    
	/********************限额设计指标分析清单表导入导出start**************/
    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadQuotaanalysis")
    @ResponseBody
    public void downloadTotalPrice(HttpServletRequest request, HttpServletResponse response){
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "quotaanalysisdetail-import.xlsx", "限额设计指标分析模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImportQuotaanalysis", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportTotalPric(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<ChangeQuotaanalysisdetailVO> successList = new ArrayList<>();
        List<ChangeQuotaanalysisdetailVO> errorList = new ArrayList<>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if(isFailed) {
            return CommonResponse.error("文件格式不合法");
        }else{
            List<List<String>> result = ExcelReader.readExcel(mf);
            if(result != null && result.size() > 0) {
                //查询固定列
                QueryWrapper<QuotaanalysisdetailInnateEntity> queryWrapper = new QueryWrapper<>();
                queryWrapper.eq("dr", "0");
                queryWrapper.orderByAsc("id");
                List<QuotaanalysisdetailInnateEntity> pro = quotaanalysisdetailInnateService.list(queryWrapper);
                boolean isNeedCheck = false;
                if(pro != null && pro.size() > 0){
                    isNeedCheck = true;
                }

                for(int i=1;i<result.size();i++) {
                    int proIndex = i - 1;

                    List<String> datas = result.get(i);
                    ChangeQuotaanalysisdetailVO changeQuotaanalysisdetailVO = new ChangeQuotaanalysisdetailVO();

                    String sort = datas.get(0);
                    String name = datas.get(1);
                    String unit = datas.get(2);

                    changeQuotaanalysisdetailVO.setId(IdWorker.getId());
                    changeQuotaanalysisdetailVO.setSort(sort);
                    changeQuotaanalysisdetailVO.setName(name); // 分项名称
                    changeQuotaanalysisdetailVO.setUnit(unit); // 单位
                    changeQuotaanalysisdetailVO.setTenderProjectNumber(StringUtils.isNotBlank(datas.get(3))?new Double(datas.get(3)):null);//投标工程量
                    changeQuotaanalysisdetailVO.setBuildArea(StringUtils.isNotBlank(datas.get(4))?new Double(datas.get(4)):null);
                    changeQuotaanalysisdetailVO.setTenderTarget(StringUtils.isNotBlank(datas.get(5))?new BigDecimal(datas.get(5)):null); // 投标指标
                    changeQuotaanalysisdetailVO.setNormTarget(StringUtils.isNotBlank(datas.get(6))?new BigDecimal(datas.get(6)):null); // (计划成本)限额设计指标
                    changeQuotaanalysisdetailVO.setMemo(datas.get(7)); // 备注

                    //校验固定列
                    if(isNeedCheck && proIndex < pro.size()){
                        QuotaanalysisdetailInnateEntity quotaanalysisdetailInnate = pro.get(proIndex);
                        if(!quotaanalysisdetailInnate.getSort().equals(sort)){//校验序号
                            changeQuotaanalysisdetailVO.setErrorMsg("序号与模板不一致，灰色区域不允许改动");
                            errorList.add(changeQuotaanalysisdetailVO);
                            continue;
                        }
                        if(!quotaanalysisdetailInnate.getName().equals(name)){//校验名称
                            changeQuotaanalysisdetailVO.setErrorMsg("名称与模板不一致，灰色区域不允许改动");
                            errorList.add(changeQuotaanalysisdetailVO);
                            continue;
                        }
                        if(!quotaanalysisdetailInnate.getUnit().equals(unit)){//校验单位
                            changeQuotaanalysisdetailVO.setErrorMsg("单位与模板不一致，灰色区域不允许改动");
                            errorList.add(changeQuotaanalysisdetailVO);
                            continue;
                        }
                    }else {
                        if(StringUtils.isEmpty(datas.get(0))) {
                            changeQuotaanalysisdetailVO.setErrorMsg("序号不能为空！");
                            errorList.add(changeQuotaanalysisdetailVO);
                            continue;
                        }
                        if(StringUtils.isEmpty(datas.get(1))) {
                            changeQuotaanalysisdetailVO.setErrorMsg("名称不能为空！");
                            errorList.add(changeQuotaanalysisdetailVO);
                            continue;
                        }
                        if(StringUtils.isEmpty(datas.get(2))) {
                            changeQuotaanalysisdetailVO.setErrorMsg("单位不能为空！");
                            errorList.add(changeQuotaanalysisdetailVO);
                            continue;
                        }
                        if(StringUtils.isEmpty(datas.get(3))) {
                            changeQuotaanalysisdetailVO.setErrorMsg("投标工程量不能为空！");
                            errorList.add(changeQuotaanalysisdetailVO);
                            continue;
                        }
                        if(StringUtils.isEmpty(datas.get(4))) {
                            changeQuotaanalysisdetailVO.setErrorMsg("建筑面积(m²)不能为空！");
                            errorList.add(changeQuotaanalysisdetailVO);
                            continue;
                        }
                        if(StringUtils.isEmpty(datas.get(5))) {
                            changeQuotaanalysisdetailVO.setErrorMsg("投标指标不能为空！");
                            errorList.add(changeQuotaanalysisdetailVO);
                            continue;
                        }
                        if(StringUtils.isEmpty(datas.get(6))) {
                            changeQuotaanalysisdetailVO.setErrorMsg("(计划成本)限额设计指标不能为空！");
                            errorList.add(changeQuotaanalysisdetailVO);
                            continue;
                        }
                    }
                    successList.add(changeQuotaanalysisdetailVO);
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

    /**
     * excel导出数据库数据
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/excelExportQuotaanalysisFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportQuotaanalysisFromDatabase(@RequestBody ChangeQuotaanalysisVO changeQuotaanalysisVO, HttpServletResponse response) {
        QueryWrapper<ChangeQuotaanalysisdetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", changeQuotaanalysisVO.getId());
        queryWrapper.eq("dr", 0);
        List<ChangeQuotaanalysisdetailEntity> list = changeQuotaanalysisdetailService.list(queryWrapper );
        List<ChangeQuotaanalysisdetailVO> voList = BeanMapper.mapList(list, ChangeQuotaanalysisdetailVO.class);

        //按序号排序
        Collections.sort(voList, new Comparator<ChangeQuotaanalysisdetailVO>() {
            @Override
            public int compare(ChangeQuotaanalysisdetailVO o1, ChangeQuotaanalysisdetailVO o2) {
                return Integer.parseInt(o1.getSort())- (Integer.parseInt(o2.getSort()));
            }
        });
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("quotaanalysisdetail-export.xlsx", beans, response);
    }

    /**
     * excel导出页面数据
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/excelExportQuotaanalysisFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportQuotaanalysisFromPage(@RequestBody List< ChangeQuotaanalysisdetailVO> list, HttpServletResponse response) {
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("quotaanalysisdetail-export.xlsx", beans, response);
    }
}
