package com.ejianc.business.change.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.bean.ConsdrawbudgetEntity;
import com.ejianc.business.bedget.service.IConsdrawbudgetService;
import com.ejianc.business.change.bean.ChangeconsdrawbudgetEntity;
import com.ejianc.business.change.mapper.ChangeconsdrawbudgetMapper;
import com.ejianc.business.change.service.IChangeconsdrawbudgetService;
import com.ejianc.business.change.vo.ChangeconsdrawbudgetVO;
import com.ejianc.business.change.vo.ChangeconsdrawbudgetdetailVO;
import com.ejianc.business.record.bean.RecordconsdrawbudgetEntity;
import com.ejianc.business.record.service.IRecordconsdrawbudgetService;
import com.ejianc.business.utils.BigDecimalUtils;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;


/**
 * 施工预算图变更
 * 
 * @author generator
 * 
 */
@Service("changeconsdrawbudgetService")
public class ChangeconsdrawbudgetServiceImpl extends BaseServiceImpl<ChangeconsdrawbudgetMapper, ChangeconsdrawbudgetEntity> implements IChangeconsdrawbudgetService {
    @Autowired
    private IConsdrawbudgetService consdrawbudgetService;

    @Autowired
    private IRecordconsdrawbudgetService recordconsdrawbudgetService;

    @Override
    public CommonResponse<ChangeconsdrawbudgetVO> saveChange(ChangeconsdrawbudgetVO saveOrUpdateVO) {
        //检验该单据是否存在
        boolean exitBill = false;
        if(saveOrUpdateVO.getId()!=null){
            ChangeconsdrawbudgetEntity e = this.getById(saveOrUpdateVO);
            if(e!=null){
                exitBill = true;
            }
        }
        ChangeconsdrawbudgetEntity entity = BeanMapper.map(saveOrUpdateVO, ChangeconsdrawbudgetEntity.class);
        //检验是否存在未生效的变更单据，若存在，则不能变更
        QueryWrapper<ChangeconsdrawbudgetEntity> queryWrapper = new QueryWrapper<ChangeconsdrawbudgetEntity>();
        queryWrapper.eq("consdrawbudget_id", saveOrUpdateVO.getConsdrawbudgetId());
        queryWrapper.eq("dr", 0);
        queryWrapper.notIn("bill_state", 1,3);
        if(saveOrUpdateVO.getId()!=null){
            queryWrapper.ne("id", saveOrUpdateVO.getId());
        }
        List<ChangeconsdrawbudgetEntity> exit = this.list(queryWrapper);
        if(exit!=null&&exit.size()>0){
            throw new BusinessException("已存在未完成的变更单据，不能新增新的变更单据");
        }
        //计算表头合计字段
        BigDecimal total = BigDecimalUtils.ofNullable(entity.getFeesTotal())
                .add(BigDecimalUtils.ofNullable(entity.getTaxTotal()))
                .add(BigDecimalUtils.ofNullable(entity.getProvisionalEstimateTotal()));
        entity.setTotal(total);
        //处理子表数据
        //施工图预算子表
        this.saveOrUpdate(entity, false);

        ChangeconsdrawbudgetVO vo = BeanMapper.map(entity, ChangeconsdrawbudgetVO.class);
        vo.setConsdrawbudgetdetailEntities(saveOrUpdateVO.getConsdrawbudgetdetailEntities());
        vo.setRecordconsdrawbudgetdetailVOS(saveOrUpdateVO.getRecordconsdrawbudgetdetailVOS());
        if(!exitBill){
            //查询原始单据信息，将状态改为变更中
            ConsdrawbudgetEntity consdrawbudgetEntity = consdrawbudgetService.selectById(vo.getConsdrawbudgetId());
            consdrawbudgetEntity.setChangeState("2");//状态改为变更中
            consdrawbudgetEntity.setChangeId(vo.getId());

            consdrawbudgetService.saveOrUpdate(consdrawbudgetEntity, false);
        }

        //构建树形结构
        List<ChangeconsdrawbudgetdetailVO> changeconsdrawbudgetdetailVOList = vo.getConsdrawbudgetdetailEntities();
        List<ChangeconsdrawbudgetdetailVO> resChangeconsdrawbudgetdetailVOList = createTreeData(changeconsdrawbudgetdetailVOList);
        vo.setConsdrawbudgetdetailEntities(resChangeconsdrawbudgetdetailVOList);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    @Override
    public CommonResponse<String> delete(List<ChangeconsdrawbudgetVO> vos) {
        for(ChangeconsdrawbudgetVO vo : vos){
            ChangeconsdrawbudgetEntity entity = this.getById(vo.getId());
            ConsdrawbudgetEntity consdrawbudgetEntity = consdrawbudgetService.selectById(entity.getConsdrawbudgetId());
            QueryWrapper<RecordconsdrawbudgetEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("dr", 0);
            queryWrapper.eq("consdrawbudget_id", consdrawbudgetEntity.getId());
            List<RecordconsdrawbudgetEntity> records = recordconsdrawbudgetService.list(queryWrapper);
            if(records!=null&&records.size()>0){
                consdrawbudgetEntity.setChangeState("3");//状态改为已变更
            }else{
                consdrawbudgetEntity.setChangeState("1");//状态改为未变更
            }
            consdrawbudgetEntity.setChangeId(null);
            consdrawbudgetService.saveOrUpdate(consdrawbudgetEntity, false);
        }
        this.removeByIds(vos.stream().map(ChangeconsdrawbudgetVO::getId).collect(Collectors.toList()),true);

        return CommonResponse.success("删除成功！");
    }

    public static List<ChangeconsdrawbudgetdetailVO> createTreeData(List<ChangeconsdrawbudgetdetailVO> list) {
        List<ChangeconsdrawbudgetdetailVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();

        //循环list，放入listMap重
        Map<String, ChangeconsdrawbudgetdetailVO> listMap = new HashMap<>();
        for(ChangeconsdrawbudgetdetailVO item:list) {
            listMap.put(item.getTid().toString(), item);
        }

        for(int i =0; i<list.size(); i++) {
            ChangeconsdrawbudgetdetailVO item = list.get(i);
            String parentId = (item.getTpid() != null) ? item.getTpid().toString():"";
            ChangeconsdrawbudgetdetailVO parent = listMap.get(parentId);
            if(parent != null) {
                List<ChangeconsdrawbudgetdetailVO> child = (List<ChangeconsdrawbudgetdetailVO>) parent.getChildren();
                if(child != null) {
                    child.add(item);
                }else{
                    List<ChangeconsdrawbudgetdetailVO> children = new ArrayList<ChangeconsdrawbudgetdetailVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getTid());
            }
        }

        for(String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }
}
