package com.ejianc.business.change.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.bean.EstimatesummaryEntity;
import com.ejianc.business.bedget.service.IEstimatesummaryService;
import com.ejianc.business.change.bean.ChangeestimatesummaryEntity;
import com.ejianc.business.change.mapper.ChangeestimatesummaryMapper;
import com.ejianc.business.change.service.IChangeestimatesummaryService;
import com.ejianc.business.change.vo.ChangeestimatesummaryVO;
import com.ejianc.business.change.vo.ChangeestimatesummarydetailVO;
import com.ejianc.business.change.vo.ChangequotadesignVO;
import com.ejianc.business.record.bean.RecordestimatesummaryEntity;
import com.ejianc.business.record.bean.RecordquotadesignEntity;
import com.ejianc.business.record.service.IRecordestimatesummaryService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import java.util.*;
import java.util.stream.Collectors;


/**
 * 设计概算汇总表变更
 * 
 * @author generator
 * 
 */
@Service("changeestimatesummaryService")
public class ChangeestimatesummaryServiceImpl extends BaseServiceImpl<ChangeestimatesummaryMapper, ChangeestimatesummaryEntity> implements IChangeestimatesummaryService {
    @Autowired
    private IEstimatesummaryService estimatesummaryService;

    @Autowired
    private IRecordestimatesummaryService recordestimatesummaryService;


    @Override
    public CommonResponse<ChangeestimatesummaryVO> saveChange(ChangeestimatesummaryVO saveOrUpdateVO) {
        //检验该单据是否存在
        boolean exitBill = false;
        if(saveOrUpdateVO.getId()!=null){
            ChangeestimatesummaryEntity e = this.getById(saveOrUpdateVO);
            if(e!=null){
                exitBill = true;
            }
        }
        ChangeestimatesummaryEntity entity = BeanMapper.map(saveOrUpdateVO, ChangeestimatesummaryEntity.class);
        //检验是否存在未生效的变更单据，若存在，则不能变更
        QueryWrapper<ChangeestimatesummaryEntity> queryWrapper = new QueryWrapper<ChangeestimatesummaryEntity>();
        queryWrapper.eq("budgetestimatesummar_id", saveOrUpdateVO.getBudgetestimatesummarId());
        queryWrapper.eq("dr", 0);
        queryWrapper.in("bill_state", "[0,4]");
        if(saveOrUpdateVO.getId()!=null){
            queryWrapper.ne("id", saveOrUpdateVO.getId());
        }
        List<ChangeestimatesummaryEntity> exit = this.list(queryWrapper);
        if(exit!=null&&exit.size()>0){
            throw new BusinessException("已存在未完成的变更单据，不能新增新的变更单据");
        }

        //处理子表数据
        //设计概算指标分析子表
        this.saveOrUpdate(entity, false);

        ChangeestimatesummaryVO vo = BeanMapper.map(entity, ChangeestimatesummaryVO.class);
        vo.setChangeestimatesummarydetailEntities(handleChildren(saveOrUpdateVO.getChangeestimatesummarydetailEntities()));
        vo.setRecorddesignestimatedetailVOList(saveOrUpdateVO.getRecorddesignestimatedetailVOList());
        if(!exitBill){
            //查询当前合同信息，将状态改为变更中
            EstimatesummaryEntity estimatesummaryEntity = estimatesummaryService.selectById(vo.getBudgetestimatesummarId());
            estimatesummaryEntity.setChangeState("2");//状态改为变更中
            estimatesummaryEntity.setChangeId(vo.getId());
            estimatesummaryService.saveOrUpdate(estimatesummaryEntity, false);
        }
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    @Override
    public CommonResponse<String> delete(List<ChangeestimatesummaryVO> vos) {
        for(ChangeestimatesummaryVO vo : vos){
            ChangeestimatesummaryEntity entity = this.getById(vo.getId());
            EstimatesummaryEntity estimatesummaryEntity = estimatesummaryService.selectById(entity.getBudgetestimatesummarId());
            QueryWrapper<RecordestimatesummaryEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("dr", 0);
            queryWrapper.eq("budgetestimatesummary_id", estimatesummaryEntity.getId());
            List<RecordestimatesummaryEntity> records = recordestimatesummaryService.list(queryWrapper);
            if(records!=null&&records.size()>0){
                estimatesummaryEntity.setChangeState("3");//状态改为已变更
            }else{
                estimatesummaryEntity.setChangeState("1");//状态改为未变更
            }
            estimatesummaryEntity.setChangeId(null);
            estimatesummaryService.saveOrUpdate(estimatesummaryEntity, false);
        }
        this.removeByIds(vos.stream().map(ChangeestimatesummaryVO::getId).collect(Collectors.toList()),true);

        return CommonResponse.success("删除成功！");
    }

    /**
     * 对子表做排序、构建树等处理
     * @param voList
     */
    private List<ChangeestimatesummarydetailVO> handleChildren(List<ChangeestimatesummarydetailVO> voList) {
        //按子目编码排序
        Collections.sort(voList, new Comparator<ChangeestimatesummarydetailVO>() {
            @Override
            public int compare(ChangeestimatesummarydetailVO o1, ChangeestimatesummarydetailVO o2) {
                return o1.getInventoryCode().compareTo(o2.getInventoryCode());
            }
        });

        //构建树
        voList = createTreeData(voList);

        return voList;
    }

    public static List<ChangeestimatesummarydetailVO> createTreeData(List<ChangeestimatesummarydetailVO> list) {
        List<ChangeestimatesummarydetailVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();

        //循环list，放入listMap重
        Map<String, ChangeestimatesummarydetailVO> listMap = new HashMap<>();
        for(ChangeestimatesummarydetailVO item:list) {
            listMap.put(item.getTid().toString(), item);
        }

        for(int i =0; i<list.size(); i++) {
            ChangeestimatesummarydetailVO item = list.get(i);
            String parentId = (item.getTpid() != null) ? item.getTpid().toString():"";
            ChangeestimatesummarydetailVO parent = listMap.get(parentId);
            if(parent != null) {
                List<ChangeestimatesummarydetailVO> child = (List<ChangeestimatesummarydetailVO>) parent.getChildren();
                if(child != null) {
                    child.add(item);
                }else{
                    List<ChangeestimatesummarydetailVO> children = new ArrayList<>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getTid());
            }
        }

        for(String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }
}
