package com.ejianc.business.change.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.bean.MaterialanalysisEntity;
import com.ejianc.business.bedget.bean.MaterialanalysisdetailEntity;
import com.ejianc.business.bedget.service.IMaterialanalysisService;
import com.ejianc.business.change.bean.ChangematerialanalysisEntity;
import com.ejianc.business.change.bean.ChangematerialanalysisdetailEntity;
import com.ejianc.business.change.service.IChangematerialanalysisService;
import com.ejianc.business.record.bean.RecordmaterialanalysisEntity;
import com.ejianc.business.record.bean.RecordmaterialanalysisdetailEntity;
import com.ejianc.business.record.service.IRecordmaterialanalysisService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.support.idworker.util.IdWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service("changematerialanalysis") 
public class ChangematerialanalysisBpmServiceImpl implements ICommonBusinessService {
	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}



	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("变更单不允许弃审");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}


	private Logger logger = LoggerFactory.getLogger(this.getClass());
	//业务类型
	private static final String Materialanalysis = "zjkj-designestimate";//限额设计指标分析
	private static final String Materialanalysis_CHANGE = "zjkj-designestimateChange";//限额设计指标分析变更
	private static final String Materialanalysis_RECORD = "zjkj-designestimateRecord";//限额设计指标分析变更记录

	//单据类型
	private static final String Materialanalysis_BILLTYPE_CODE = "BT202202000030";//限额设计指标分析
	private static final String Materialanalysis_CHANGE_BILLTYPE_CODE = "BT202202000031";//限额设计指标分析变更
	private static final String Materialanalysis_RECORD_BILLTYPE_CODE = "BT202202000032";//限额设计指标分析变更记录


	@Autowired
	private IAttachmentApi attachmentApi;
	@Autowired
	private IChangematerialanalysisService changematerialanalysisService;
	@Autowired
	private IRecordmaterialanalysisService recordmaterialanalysisService;
	@Autowired
	private IMaterialanalysisService materialanalysisService;


	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {

		logger.info("---------进来啦--------");
		//TODO
		//1、获取目前单据信息、变更信息
		ChangematerialanalysisEntity changeEntity = changematerialanalysisService.selectById(billId);
		logger.info("变更单主表id=" + changeEntity.getOriginalId());
		MaterialanalysisEntity materialanalysisEntity = materialanalysisService.selectById(changeEntity.getOriginalId());
		logger.info("主单据id=" + changeEntity.getId() + "主单据创建人" + changeEntity.getCreateUserCode());

		//获取历史版本条数
		QueryWrapper<RecordmaterialanalysisEntity> recordWrapper = new QueryWrapper<>();
		recordWrapper.eq("original_id", materialanalysisEntity.getId());
		recordWrapper.eq("dr", 0);
		Integer count = recordmaterialanalysisService.count(recordWrapper);

		logger.info("---------给变更记录表赋值--------");
		RecordmaterialanalysisEntity recordmaterialanalysisEntity = BeanMapper.map(materialanalysisEntity, RecordmaterialanalysisEntity.class);
		Long recordId = IdWorker.getId();
		this.clearBaseData(recordmaterialanalysisEntity);
		recordmaterialanalysisEntity.setBillState(null);
		recordmaterialanalysisEntity.setOriginalId(materialanalysisEntity.getId());
		recordmaterialanalysisEntity.setMaterialanalysisCode(materialanalysisEntity.getBillCode()+"-"+(count+1));
		recordmaterialanalysisEntity.setId(recordId);
		recordmaterialanalysisEntity.setBillCode(materialanalysisEntity.getBillCode());
		recordmaterialanalysisEntity.setChangeReason(changeEntity.getChangeReason());
		recordmaterialanalysisEntity.setEffectDate(new Date());

		logger.info("---------给变更记录子表赋值--------");
		List<MaterialanalysisdetailEntity> quotaanalysisdetailEntities = materialanalysisEntity.getMaterialanalysisdetailEntities();
		if(quotaanalysisdetailEntities!=null&&quotaanalysisdetailEntities.size()>0){
			List<RecordmaterialanalysisdetailEntity> recorddesignestimatedetailEntities = new ArrayList<>();
			for(MaterialanalysisdetailEntity entity : quotaanalysisdetailEntities){
				RecordmaterialanalysisdetailEntity reEntity = BeanMapper.map(entity, RecordmaterialanalysisdetailEntity.class);
				this.clearBaseData(reEntity);
				reEntity.setId(recordId);
				recorddesignestimatedetailEntities.add(reEntity);
				entity.setRowState("del");
			}
			recordmaterialanalysisEntity.setMaterialanalysisdetailEntities(recorddesignestimatedetailEntities);
		}
		logger.info("---------赋值附件信息--------");
		//复制附件信息到记录中
		String sourceBillType = "";
		sourceBillType = Materialanalysis_BILLTYPE_CODE;
		String targetBillType = "";
		targetBillType = Materialanalysis_RECORD_BILLTYPE_CODE;

		attachmentApi.copyFilesFromSourceBillToTargetBill(materialanalysisEntity.getId().toString(), sourceBillType, Materialanalysis , recordId.toString(), targetBillType, Materialanalysis_RECORD);
		recordmaterialanalysisService.saveOrUpdate(recordmaterialanalysisEntity, false);

		logger.info("---------修改当前单据状态--------");
		logger.info("创建人=" + recordmaterialanalysisEntity.getCreateUserCode());
		//3、修改当前单据状态
		MaterialanalysisEntity materialanalysisEntity1 = BeanMapper.map(changeEntity, MaterialanalysisEntity.class);
		materialanalysisEntity1.setChangeState("3");//状态改为已变更
		materialanalysisEntity1.setChangeId(null);
		materialanalysisEntity1.setBillState(materialanalysisEntity.getBillState());
		materialanalysisEntity1.setId(materialanalysisEntity.getId());
		materialanalysisEntity1.setCreateTime(materialanalysisEntity.getCreateTime());
		materialanalysisEntity1.setCreateUserCode(materialanalysisEntity.getCreateUserCode());
		materialanalysisEntity1.setTenantId(materialanalysisEntity.getTenantId());
		materialanalysisEntity1.setVersion(materialanalysisEntity.getVersion());

		logger.info("---------处理子表变更--------");
		//子表
		//处理子表变更
		List<ChangematerialanalysisdetailEntity> changedesignestimatedetailEntities = changeEntity.getMaterialanalysisdetailEntities();
		if(changedesignestimatedetailEntities!=null&&changedesignestimatedetailEntities.size()>0){
			List<MaterialanalysisdetailEntity> newDesignestimatedetailEntity = BeanMapper.mapList(changedesignestimatedetailEntities, MaterialanalysisdetailEntity.class);
			for (MaterialanalysisdetailEntity materialanalysisdetailEntity : newDesignestimatedetailEntity) {
				materialanalysisdetailEntity.setId(IdWorker.getId());
			}

			newDesignestimatedetailEntity.addAll(quotaanalysisdetailEntities);
			materialanalysisEntity1.setMaterialanalysisdetailEntities(newDesignestimatedetailEntity);
		}
		logger.info("---------保存--------");
		materialanalysisService.saveOrUpdate(materialanalysisEntity1, false);

		sourceBillType = Materialanalysis_CHANGE_BILLTYPE_CODE;
		targetBillType = Materialanalysis_BILLTYPE_CODE;

		attachmentApi.copyFilesFromSourceBillToTargetBill(changeEntity.getId().toString(), sourceBillType, Materialanalysis_CHANGE, materialanalysisEntity.getId().toString(), targetBillType, Materialanalysis);
		recordmaterialanalysisService.saveOrUpdate(recordmaterialanalysisEntity, false);

		logger.info("---------结束--------");
		return CommonResponse.success();
	}

	public void clearBaseData(BaseEntity entity){
		entity.setCreateTime(null);
		entity.setCreateUserCode(null);
		entity.setTenantId(null);
		entity.setUpdateTime(null);
		entity.setUpdateUserCode(null);
	}


}
