package com.ejianc.business.change.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.bean.QuotadesignEntity;
import com.ejianc.business.bedget.service.IQuotadesignService;
import com.ejianc.business.change.bean.ChangequotadesignEntity;
import com.ejianc.business.change.mapper.ChangequotadesignMapper;
import com.ejianc.business.change.service.IChangequotadesignService;
import com.ejianc.business.change.vo.ChangequotadesignVO;
import com.ejianc.business.change.vo.ChangequotadesigndetailVO;
import com.ejianc.business.record.bean.RecordquotadesignEntity;
import com.ejianc.business.record.service.IRecordquotadesignService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;


/**
 * 限额设计表变更
 * 
 * @author generator
 * 
 */
@Service("changequotadesignService")
public class ChangequotadesignServiceImpl extends BaseServiceImpl<ChangequotadesignMapper, ChangequotadesignEntity> implements IChangequotadesignService {

    @Autowired
    private IQuotadesignService quotadesignService;

    @Autowired
    private IRecordquotadesignService recordquotadesignService;
    @Override
    public CommonResponse<ChangequotadesignVO> saveChange(ChangequotadesignVO saveOrUpdateVO) {
        //检验该单据是否存在
        boolean exitBill = false;
        if(saveOrUpdateVO.getId()!=null){
            ChangequotadesignEntity e = this.getById(saveOrUpdateVO);
            if(e!=null){
                exitBill = true;
            }
        }
        ChangequotadesignEntity entity = BeanMapper.map(saveOrUpdateVO, ChangequotadesignEntity.class);
        //检验是否存在未生效的变更单据，若存在，则不能变更
        QueryWrapper<ChangequotadesignEntity> queryWrapper = new QueryWrapper<ChangequotadesignEntity>();
        queryWrapper.eq("original_id", saveOrUpdateVO.getOriginalId());
        queryWrapper.eq("dr", 0);
        queryWrapper.notIn("bill_state", 1, 3);
        if(saveOrUpdateVO.getId()!=null){
            queryWrapper.ne("id", saveOrUpdateVO.getId());
        }
        List<ChangequotadesignEntity> exit = this.list(queryWrapper);
        if(exit!=null&&exit.size()>0){
            throw new BusinessException("已存在未完成的变更单据，不能新增新的变更单据");
        }

        //处理子表数据
        //限额设计指标分析子表
        this.saveOrUpdate(entity, false);

        ChangequotadesignVO vo = BeanMapper.map(entity, ChangequotadesignVO.class);
        vo.setQuotadesigndetailEntities(saveOrUpdateVO.getQuotadesigndetailEntities());
        vo.setRecordquotadesignList(saveOrUpdateVO.getRecordquotadesignList());
        if(!exitBill){
            //查询当前合同信息，将状态改为变更中
            QuotadesignEntity quotadesignEntity = quotadesignService.selectById(vo.getOriginalId());
            quotadesignEntity.setChangeState("2");//状态改为变更中
            quotadesignEntity.setChangeId(vo.getId());
            quotadesignService.saveOrUpdate(quotadesignEntity, false);
        }

        //构建树形结构
        List<ChangequotadesigndetailVO> changequotadesigndetailVOList = vo.getQuotadesigndetailEntities();
        List<ChangequotadesigndetailVO> resQuotadesigndetailVOList = createTreeData(changequotadesigndetailVOList);
        vo.setQuotadesigndetailEntities(resQuotadesigndetailVOList);

        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    public static List<ChangequotadesigndetailVO> createTreeData(List<ChangequotadesigndetailVO> list) {
        List<ChangequotadesigndetailVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();

        //循环list，放入listMap重
        Map<String, ChangequotadesigndetailVO> listMap = new HashMap<>();
        for(ChangequotadesigndetailVO item:list) {
            listMap.put(item.getTid().toString(), item);
        }

        for(int i =0; i<list.size(); i++) {
            ChangequotadesigndetailVO item = list.get(i);
            String parentId = (item.getTpid() != null) ? item.getTpid().toString():"";
            ChangequotadesigndetailVO parent = listMap.get(parentId);
            if(parent != null) {
                List<ChangequotadesigndetailVO> child = (List<ChangequotadesigndetailVO>) parent.getChildren();
                if(child != null) {
                    child.add(item);
                }else{
                    List<ChangequotadesigndetailVO> children = new ArrayList<ChangequotadesigndetailVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getTid());
            }
        }

        for(String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }

    @Override
    public CommonResponse<String> delete(List<ChangequotadesignVO> vos) {
        for(ChangequotadesignVO vo : vos){
            ChangequotadesignEntity entity = this.getById(vo.getId());
            QuotadesignEntity quotadesignEntity = quotadesignService.selectById(entity.getOriginalId());
            QueryWrapper<RecordquotadesignEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("dr", 0);
            queryWrapper.eq("original_id", quotadesignEntity.getId());
            List<RecordquotadesignEntity> records = recordquotadesignService.list(queryWrapper);
            if(records!=null&&records.size()>0){
                quotadesignEntity.setChangeState("3");//状态改为已变更
            }else{
                quotadesignEntity.setChangeState("1");//状态改为未变更
            }
            quotadesignEntity.setChangeId(null);
            quotadesignService.saveOrUpdate(quotadesignEntity, false);
        }
        this.removeByIds(vos.stream().map(ChangequotadesignVO::getId).collect(Collectors.toList()),true);

        return CommonResponse.success("删除成功！");
    }
}
