package com.ejianc.business.record.controller;

import java.io.Serializable;

import com.ejianc.business.record.bean.RecordContrastanalysistEntity;
import com.ejianc.business.record.service.IRecordContrastanalysistService;
import com.ejianc.business.record.vo.RecordContrastanalysisdetailVO;
import com.ejianc.business.record.vo.RecordContrastanalysistVO;
import com.ejianc.business.record.vo.RecordconsdrawbudgetdetailVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;


/**
 * 对比分析变更记录表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("recordContrastanalysist")
public class RecordContrastanalysistController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IRecordContrastanalysistService service;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<RecordContrastanalysistVO> saveOrUpdate(@RequestBody RecordContrastanalysistVO saveorUpdateVO) {
    	RecordContrastanalysistEntity entity = BeanMapper.map(saveorUpdateVO, RecordContrastanalysistEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	RecordContrastanalysistVO vo = BeanMapper.map(entity, RecordContrastanalysistVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RecordContrastanalysistVO> queryDetail(Long id) {
    	RecordContrastanalysistEntity entity = service.selectById(id);
    	RecordContrastanalysistVO vo = BeanMapper.map(entity, RecordContrastanalysistVO.class);
        //构建树形结构
        List<RecordContrastanalysisdetailVO> recordContrastanalysisdetailVOList = vo.getContrastanalysisdetailEntities();
        recordContrastanalysisdetailVOList = createTreeData(recordContrastanalysisdetailVOList);
        vo.setContrastanalysisdetailEntities(recordContrastanalysisdetailVOList);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<RecordContrastanalysistVO> vos) {
        service.removeByIds(vos.stream().map(RecordContrastanalysistVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<RecordContrastanalysistVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<RecordContrastanalysistEntity> page = service.queryPage(param,false);
        IPage<RecordContrastanalysistVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), RecordContrastanalysistVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<RecordContrastanalysistEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("RecordContrastanalysist-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refRecordContrastanalysistData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<RecordContrastanalysistVO>> refRecordContrastanalysistData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<RecordContrastanalysistEntity> page = service.queryPage(param,false);
        IPage<RecordContrastanalysistVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), RecordContrastanalysistVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 对子表做排序、构建树等处理
     *
     * @param voList
     */
    private List<RecordContrastanalysisdetailVO> handleChildren(List<RecordContrastanalysisdetailVO> voList) {
        //按子目编码排序
        Collections.sort(voList, new Comparator<RecordContrastanalysisdetailVO>() {
            @Override
            public int compare(RecordContrastanalysisdetailVO o1, RecordContrastanalysisdetailVO o2) {
                return o1.getSort().compareTo(o2.getSort());
            }
        });

        //构建树
        voList = createTreeData(voList);

        return voList;
    }

    public static List<RecordContrastanalysisdetailVO> createTreeData(List<RecordContrastanalysisdetailVO> list) {
        List<RecordContrastanalysisdetailVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();

        //循环list，放入listMap重
        Map<String, RecordContrastanalysisdetailVO> listMap = new HashMap<>();
        for (RecordContrastanalysisdetailVO item : list) {
            listMap.put(item.getTid().toString(), item);
        }

        for (int i = 0; i < list.size(); i++) {
            RecordContrastanalysisdetailVO item = list.get(i);
            String parentId = (item.getTpid() != null) ? item.getTpid().toString() : "";
            RecordContrastanalysisdetailVO parent = listMap.get(parentId);
            if (parent != null) {
                List<RecordContrastanalysisdetailVO> child = (List<RecordContrastanalysisdetailVO>) parent.getChildren();
                if (child != null) {
                    child.add(item);
                } else {
                    List<RecordContrastanalysisdetailVO> children = new ArrayList<RecordContrastanalysisdetailVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getTid());
            }
        }

        for (String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }
}
