package com.ejianc.business.utils;

import java.math.BigDecimal;

/**
 * @authoer:禹鹏杰
 * @createDate:2023/1/5
 * @description:
 */
public class BigDecimalUtils {
    /**
     * 判断decimal是否为空  为空则赋值0
     * @param bigDecimal
     * @return
     */
    public static BigDecimal ofNullable(BigDecimal bigDecimal){
        return bigDecimal == null ? BigDecimal.ZERO : bigDecimal;
    }
    public static BigDecimal add(BigDecimal bigDecimal1,BigDecimal bigDecimal2){
        return ofNullable(bigDecimal1).add(ofNullable(bigDecimal2));
    }

    /**
     * BigDecimal除法运算排除0的情况不保留位数
     * @param molecule
     * @param denominator
     * @return
     */
    public static BigDecimal divideExcludeZero(BigDecimal molecule,BigDecimal denominator){
        return molecule.divide(denominator.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ONE : denominator);
    }
    /**
     * BigDecimal除法运算排除分母为0的情况
     * @param molecule  分子
     * @param denominator  分母
     * @param scale   保留位数 四舍五入
     * @return
     */
    public static BigDecimal divideExcludeZero(BigDecimal molecule,BigDecimal denominator,int scale){
        return molecule.divide(denominator.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ONE : denominator,scale,BigDecimal.ROUND_HALF_UP);
    }
}
