/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.busniessplan.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.busniessplan.bean.MaintargetEntity;
import com.ejianc.business.busniessplan.bean.MaintargetdetailinnateEntity;
import com.ejianc.business.busniessplan.service.IMaintargetService;
import com.ejianc.business.busniessplan.service.IMaintargetdetailinnateService;
import com.ejianc.business.busniessplan.vo.MaintargetVO;
import com.ejianc.business.busniessplan.vo.MaintargetdetailVO;
import com.ejianc.business.record.service.IRecordMaintargetService;
import com.ejianc.business.record.vo.RecordMaintargetVO;
import com.ejianc.business.utils.DateUtils;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"maintarget"})
public class MaintargetController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IMaintargetdetailinnateService maintargetdetailinnateService;
    private static final String BILL_CODE = "businessplan-maintarget";
    @Autowired
    private IMaintargetService service;
    @Autowired
    private IRecordMaintargetService recordMaintargetService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<MaintargetVO> saveOrUpdate(@RequestBody MaintargetVO saveorUpdateVO) {
        MaintargetEntity entity = (MaintargetEntity)((Object)BeanMapper.map((Object)((Object)saveorUpdateVO), MaintargetEntity.class));
        entity = this.checkBillCodeUniq(entity);
        this.checkProject(entity);
        entity.setChangeState("1");
        List<MaintargetdetailVO> handleData = saveorUpdateVO.getMaintargetdetailEntities();
        if (saveorUpdateVO.getId() == null && handleData != null) {
            for (int i = 0; i < handleData.size(); ++i) {
                MaintargetdetailVO maintargetdetailVO = handleData.get(i);
                maintargetdetailVO.setId(null);
                handleData.set(i, maintargetdetailVO);
            }
            saveorUpdateVO.setMaintargetdetailEntities(handleData);
        }
        this.service.saveOrUpdate((Object)entity, false);
        MaintargetVO vo = (MaintargetVO)((Object)BeanMapper.map((Object)((Object)entity), MaintargetVO.class));
        List<MaintargetdetailVO> maintargetdetailEntities = vo.getMaintargetdetailEntities();
        List<MaintargetdetailVO> treeData = MaintargetController.createTreeData(maintargetdetailEntities);
        vo.setMaintargetdetailEntities(treeData);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private MaintargetEntity checkBillCodeUniq(MaintargetEntity entity) {
        if (entity.getBillCode() == null || StringUtils.isEmpty((CharSequence)entity.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (!billCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            entity.setBillCode((String)billCode.getData());
            return entity;
        } else {
            QueryWrapper queryWrapperBillCode = new QueryWrapper();
            queryWrapperBillCode.eq((Object)"bill_code", (Object)entity.getBillCode());
            queryWrapperBillCode.eq((Object)"dr", (Object)"0");
            List proBillCode = this.service.list((Wrapper)queryWrapperBillCode);
            if (proBillCode == null || proBillCode.size() <= 0) return entity;
            for (int i = 0; i < proBillCode.size(); ++i) {
                MaintargetEntity maintargetEntity = (MaintargetEntity)((Object)proBillCode.get(i));
                if (maintargetEntity.getId().equals(entity.getId())) continue;
                throw new BusinessException("\u5355\u636e\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165!");
            }
        }
        return entity;
    }

    private void checkProject(MaintargetEntity entity) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"project_id", (Object)entity.getProjectId());
        queryWrapper.eq((Object)"dr", (Object)"0");
        List pro = this.service.list((Wrapper)queryWrapper);
        if (pro != null && pro.size() > 0) {
            if (entity.getId() == null || entity.getId() == 0L) {
                throw new BusinessException("\u8be5\u9879\u76ee\u5df2\u7ecf\u521b\u5efa\u4e00\u4e2a\u9879\u76ee\u8d44\u91d1\u7ba1\u7406\u7b56\u5212\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u521b\u5efa!");
            }
            for (MaintargetEntity maintarget : pro) {
                if (entity.getProjectId().equals(maintarget.getProjectId())) continue;
                throw new BusinessException("\u8be5\u9879\u76ee\u5df2\u7ecf\u521b\u5efa\u4e00\u4e2a\u9879\u76ee\u8d44\u91d1\u7ba1\u7406\u7b56\u5212\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u521b\u5efa!");
            }
        }
    }

    public static List<MaintargetdetailVO> createTreeData(List<MaintargetdetailVO> list) {
        ArrayList<MaintargetdetailVO> resp = new ArrayList<MaintargetdetailVO>();
        ArrayList<String> rootItems = new ArrayList<String>();
        HashMap<String, MaintargetdetailVO> listMap = new HashMap<String, MaintargetdetailVO>();
        for (MaintargetdetailVO item : list) {
            listMap.put(item.getTid().toString(), item);
        }
        for (int i = 0; i < list.size(); ++i) {
            MaintargetdetailVO item;
            item = list.get(i);
            String parentId = item.getTpid() != null ? item.getTpid().toString() : "";
            MaintargetdetailVO parent = (MaintargetdetailVO)((Object)listMap.get(parentId));
            if (parent != null) {
                List<MaintargetdetailVO> child = parent.getChildren();
                if (child != null) {
                    child.add(item);
                    continue;
                }
                ArrayList<MaintargetdetailVO> children = new ArrayList<MaintargetdetailVO>();
                children.add(item);
                parent.setChildren(children);
                continue;
            }
            rootItems.add(item.getTid());
        }
        for (String rootId : rootItems) {
            resp.add((MaintargetdetailVO)((Object)listMap.get(rootId)));
        }
        return resp;
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MaintargetVO> queryDetail(Long id) {
        MaintargetEntity entity = (MaintargetEntity)((Object)this.service.selectById(id));
        MaintargetVO vo = (MaintargetVO)((Object)BeanMapper.map((Object)((Object)entity), MaintargetVO.class));
        List<MaintargetdetailVO> maintargetdetailEntities = vo.getMaintargetdetailEntities();
        List<MaintargetdetailVO> resMaintargetdetailEntities = MaintargetController.createTreeData(maintargetdetailEntities);
        vo.setMaintargetdetailEntities(resMaintargetdetailEntities);
        if (!"1".equals(vo.getChangeState())) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"dr", (Object)0);
            queryWrapper.eq((Object)"maintarget_id", (Object)vo.getId());
            List records = this.recordMaintargetService.list((Wrapper)queryWrapper);
            if (records != null && records.size() > 0) {
                vo.setRecordMaintargetList(BeanMapper.mapList((Iterable)records, RecordMaintargetVO.class));
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryInnateColumns"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<MaintargetdetailinnateEntity>> queryInnateColumns() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)"0");
        queryWrapper.orderByAsc((Object)"id");
        List pro = this.maintargetdetailinnateService.list((Wrapper)queryWrapper);
        return CommonResponse.success((String)"\u67e5\u8be2\u56fa\u5b9a\u5217\u6570\u636e\u6210\u529f\uff01", (Object)pro);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MaintargetVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<MaintargetVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        fuzzyFields.add("bill_code");
        fuzzyFields.add("contract_name");
        fuzzyFields.add("project_name");
        fuzzyFields.add("agent_name");
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MaintargetVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        List maintargetVOList = BeanMapper.mapList((Iterable)list, MaintargetVO.class);
        for (int i = 0; i < maintargetVOList.size(); ++i) {
            MaintargetVO maintargetVO = (MaintargetVO)((Object)maintargetVOList.get(i));
            maintargetVO.setSort(String.valueOf(i + 1));
            if (maintargetVO.getCreateTime() != null) {
                maintargetVO.setCreateTimeShow(DateUtils.dateSimple2(maintargetVO.getCreateTime()));
            }
            String billStateStr = maintargetVO.getBillState().toString();
            String changeState = maintargetVO.getChangeState();
            if (billStateStr != null) {
                if ("0".equals(billStateStr)) {
                    billStateStr = "\u81ea\u7531\u6001";
                } else if ("1".equals(billStateStr)) {
                    billStateStr = "\u5df2\u63d0\u4ea4";
                } else if ("2".equals(billStateStr) || "5".equals(billStateStr)) {
                    billStateStr = "\u5ba1\u6279\u4e2d";
                } else if ("3".equals(billStateStr)) {
                    billStateStr = "\u5ba1\u6279\u901a\u8fc7";
                } else if ("4".equals(billStateStr)) {
                    billStateStr = "\u9a73\u56de";
                }
                maintargetVO.setBillStateStr(billStateStr);
            }
            if (changeState == null) continue;
            if ("1".equals(changeState)) {
                changeState = "\u672a\u53d8\u66f4";
            } else if ("2".equals(changeState)) {
                changeState = "\u53d8\u66f4\u4e2d";
            } else if ("3".equals(changeState)) {
                changeState = "\u5df2\u53d8\u66f4";
            }
            maintargetVO.setChangeState(changeState);
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", maintargetVOList);
        ExcelExport.getInstance().export("MaintargetMain-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refMaintargetData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<MaintargetVO>> refMaintargetData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MaintargetVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

