/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.busniessplan.controller;

import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.busniessplan.bean.ProjoverviewEntity;
import com.ejianc.business.busniessplan.service.IProjoverviewService;
import com.ejianc.business.busniessplan.vo.ProjectcontractVO;
import com.ejianc.business.busniessplan.vo.ProjectdetailVO;
import com.ejianc.business.busniessplan.vo.ProjoverviewVO;
import com.ejianc.business.record.service.IRecordProjoverviewService;
import com.ejianc.business.record.vo.RecordProjoverviewVO;
import com.ejianc.business.utils.DateUtils;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"projoverview"})
public class ProjoverviewController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "busniessplan-projoverview";
    @Autowired
    private IProjoverviewService service;
    @Autowired
    private IRecordProjoverviewService recordProjoverviewService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ProjoverviewVO> saveOrUpdate(@RequestBody ProjoverviewVO saveorUpdateVO) {
        ProjoverviewEntity entity = (ProjoverviewEntity)((Object)BeanMapper.map((Object)((Object)saveorUpdateVO), ProjoverviewEntity.class));
        CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
        if (!billCode.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        entity.setChangeState("1");
        entity.setBillCode((String)billCode.getData());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"project_id", (Object)entity.getProjectId());
        queryWrapper.eq((Object)"dr", (Object)"0");
        List pro = this.service.list((Wrapper)queryWrapper);
        if (entity.getId() == null || entity.getId() == 0L) {
            if (pro.size() > 0) {
                throw new BusinessException("\u8be5\u9879\u76ee\u5df2\u7ecf\u521b\u5efa\u4e00\u4e2a\u5de5\u7a0b\u6982\u8ff0\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u521b\u5efa!");
            }
        } else if (pro.size() > 0) {
            for (int i = 0; i < pro.size(); ++i) {
                if (entity.getId().equals(((ProjoverviewEntity)((Object)pro.get(i))).getId())) continue;
                throw new BusinessException("\u8be5\u5355\u636e\u5df2\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u521b\u5efa!");
            }
        }
        if (saveorUpdateVO.getProjectdetailList() != null && saveorUpdateVO.getProjectdetailList().size() > 0) {
            ProjectdetailVO projectdetailVO = saveorUpdateVO.getProjectdetailList().get(0);
            entity.setProjectBidWinPrice(projectdetailVO.getProjectBidWinPrice());
            entity.setCivilEngineering(projectdetailVO.getCivilEngineering());
            entity.setFix(projectdetailVO.getFix());
            entity.setWaterSupplyDrainage(projectdetailVO.getWaterSupplyDrainage());
            entity.setStrongCurrent(projectdetailVO.getStrongCurrent());
            entity.setHeateVentilation(projectdetailVO.getHeateVentilation());
            entity.setFixOther(projectdetailVO.getFixOther());
            entity.setDecorate(projectdetailVO.getDecorate());
            entity.setOther(projectdetailVO.getOther());
        } else {
            entity.setProjectBidWinPrice(null);
            entity.setCivilEngineering(null);
            entity.setFix(null);
            entity.setWaterSupplyDrainage(null);
            entity.setStrongCurrent(null);
            entity.setHeateVentilation(null);
            entity.setFixOther(null);
            entity.setDecorate(null);
            entity.setOther(null);
        }
        if (saveorUpdateVO.getProjectcontractList() != null && saveorUpdateVO.getProjectcontractList().size() > 0) {
            ProjectcontractVO projectcontractVO = saveorUpdateVO.getProjectcontractList().get(0);
            entity.setContractAmount(projectcontractVO.getContractAmount());
            entity.setSelfConstructionContractAmount(projectcontractVO.getSelfConstructionContractAmount());
            entity.setBelong(projectcontractVO.getBelong());
        } else {
            entity.setContractAmount(null);
            entity.setSelfConstructionContractAmount(null);
            entity.setBelong(null);
        }
        this.service.saveOrUpdate((Object)entity, false);
        ProjoverviewVO vo = (ProjoverviewVO)((Object)BeanMapper.map((Object)((Object)entity), ProjoverviewVO.class));
        vo.setProjectdetailList(saveorUpdateVO.getProjectdetailList());
        vo.setProjectcontractList(saveorUpdateVO.getProjectcontractList());
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ProjoverviewVO> queryDetail(Long id) {
        ProjoverviewEntity entity = (ProjoverviewEntity)((Object)this.service.selectById(id));
        ProjoverviewVO vo = (ProjoverviewVO)((Object)BeanMapper.map((Object)((Object)entity), ProjoverviewVO.class));
        ArrayList<ProjectdetailVO> ProjectdetailList = new ArrayList<ProjectdetailVO>();
        ProjectdetailVO ProjectdetailVO2 = (ProjectdetailVO)((Object)BeanMapper.map((Object)((Object)entity), ProjectdetailVO.class));
        ProjectdetailVO2.setRowState("add");
        ProjectdetailList.add(ProjectdetailVO2);
        vo.setProjectdetailList(ProjectdetailList);
        ArrayList<ProjectcontractVO> ProjectcontractList = new ArrayList<ProjectcontractVO>();
        ProjectcontractVO projectcontractVO = (ProjectcontractVO)((Object)BeanMapper.map((Object)((Object)entity), ProjectcontractVO.class));
        projectcontractVO.setRowState("add");
        ProjectcontractList.add(projectcontractVO);
        vo.setProjectcontractList(ProjectcontractList);
        if (!"1".equals(vo.getChangeState())) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"dr", (Object)0);
            queryWrapper.eq((Object)"original_id", (Object)vo.getId());
            List records = this.recordProjoverviewService.list((Wrapper)queryWrapper);
            if (records != null && records.size() > 0) {
                vo.setRecordProjoverviewList(BeanMapper.mapList((Iterable)records, RecordProjoverviewVO.class));
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProjoverviewVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ProjoverviewVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        for (String field : param.getParams().keySet()) {
            if (!StringUtils.equals((CharSequence)field, (CharSequence)"duration")) continue;
            String value = (String)((Parameter)param.getParams().get("duration")).getValue();
            String[] split = value.split(",");
            long between = DateUtil.between((Date)DateUtil.parseDate((String)split[1]), (Date)DateUtil.parseDate((String)split[0]), (DateUnit)DateUnit.DAY);
            param.getParams().put("duration", new Parameter("le", (Object)between));
        }
        fuzzyFields.add("project_name");
        fuzzyFields.add("bill_code");
        fuzzyFields.add("agent_name");
        fuzzyFields.add("project_code");
        fuzzyFields.add("build_unit_name");
        fuzzyFields.add("construction_unit_name");
        fuzzyFields.add("project_alias_name");
        fuzzyFields.add("contractual_model_name");
        fuzzyFields.add("investment_source_name");
        fuzzyFields.add("type_name");
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProjoverviewVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        for (String field : param.getParams().keySet()) {
            if (!StringUtils.equals((CharSequence)field, (CharSequence)"duration")) continue;
            String value = (String)((Parameter)param.getParams().get("duration")).getValue();
            String[] split = value.split(",");
            long between = DateUtil.between((Date)DateUtil.parseDate((String)split[1]), (Date)DateUtil.parseDate((String)split[0]), (DateUnit)DateUnit.DAY);
            param.getParams().put("duration", new Parameter("le", (Object)between));
        }
        List list = this.service.queryList(param);
        List projoverviewVOList = BeanMapper.mapList((Iterable)list, ProjoverviewVO.class);
        for (int i = 0; i < projoverviewVOList.size(); ++i) {
            ProjoverviewVO projoverviewVO = (ProjoverviewVO)((Object)projoverviewVOList.get(i));
            projoverviewVO.setSort(String.valueOf(i + 1));
            if (projoverviewVO.getCreateTime() != null) {
                projoverviewVO.setCreateTimeShow(DateUtils.dateSimple2(projoverviewVO.getCreateTime()));
            }
            String billStateStr = projoverviewVO.getBillState().toString();
            String changeState = projoverviewVO.getChangeState();
            if (billStateStr != null) {
                if ("0".equals(billStateStr)) {
                    billStateStr = "\u81ea\u7531\u6001";
                } else if ("1".equals(billStateStr)) {
                    billStateStr = "\u5df2\u63d0\u4ea4";
                } else if ("2".equals(billStateStr) || "5".equals(billStateStr)) {
                    billStateStr = "\u5ba1\u6279\u4e2d";
                } else if ("3".equals(billStateStr)) {
                    billStateStr = "\u5ba1\u6279\u901a\u8fc7";
                } else if ("4".equals(billStateStr)) {
                    billStateStr = "\u9a73\u56de";
                }
                projoverviewVO.setBillStateStr(billStateStr);
            }
            if (changeState == null) continue;
            if ("1".equals(changeState)) {
                changeState = "\u672a\u53d8\u66f4";
            } else if ("2".equals(changeState)) {
                changeState = "\u53d8\u66f4\u4e2d";
            } else if ("3".equals(changeState)) {
                changeState = "\u5df2\u53d8\u66f4";
            }
            projoverviewVO.setChangeState(changeState);
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", projoverviewVOList);
        ExcelExport.getInstance().export("ProjoverviewMain-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refProjoverviewData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ProjoverviewVO>> refProjoverviewData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProjoverviewVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

