/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.busniessplan.excel;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.busniessplan.service.IMaintargetdetailService;
import com.ejianc.business.busniessplan.vo.MaintargetVO;
import com.ejianc.business.busniessplan.vo.MaintargetdetailVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"maintargetExport"})
public class ExcelMaintargetController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IMaintargetdetailService maintargetdetailService;

    @RequestMapping(value={"/downloadMaintarget"})
    @ResponseBody
    public void downloadTotalPrice(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"maintarget-import.xlsx", (String)"\u5546\u52a1\u7b56\u5212\u4e66\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportMaintarget"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportTotalPric(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<MaintargetdetailVO> successList = new ArrayList<MaintargetdetailVO>();
        ArrayList<MaintargetdetailVO> errorList = new ArrayList<MaintargetdetailVO>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            String[] innateSort = new String[]{"1", "2", "3", "4", "4.1", "4.2", "4.3", "5", "5.1", "5.2", "5.3", "5.4", "5.5", "6", "6.1", "6.2", "7", "8", "9", "10"};
            String[] innateName = new String[]{"\u5411\u516c\u53f8\u4e0a\u7f34\u5229\u6da6", "\u9884\u7559\u98ce\u9669\u91d1", "\u9879\u76ee\u8ba1\u5212\u5b9e\u73b0\u5229\u6da6", "\u7ed3\u7b97\u786e\u6743\u76ee\u6807", "\u4e2d\u95f4\u786e\u6743\u7387", "\u4e2d\u95f4\u8ba1\u91cf\u786e\u8ba4\u7387", "\u4e2d\u95f4\u9636\u6bb5\u7ed3\u7b97\u76ee\u6807", "\u6210\u672c\u7ba1\u7406\u76ee\u6807", "\u81ea\u884c\u5b8c\u6210\u5408\u540c\u9020\u4ef7", "\u6807\u51c6\u6210\u672c\uff08\u542b\u7a0e\uff09", "\u8d23\u4efb\u6210\u672c\uff08\u542b\u7a0e\uff09", "\u9879\u76ee\u8ba1\u5212\u6210\u672c\uff08\u542b\u7a0e)", "\u6210\u672c\u8ba1\u5212\u964d\u4f4e\u989d", "\u5206\u4f9b\u65b9\u7ed3\u7b97\u76ee\u6807", "\u4f9b\u65b9\u7ed3\u7b97\u76ee\u6807", "\u5206\u5305\u7ed3\u7b97\u76ee\u6807", "\u5de5\u7a0b\u6b3e\u56de\u6536\u76ee\u6807", "\u8d28\u91cf\u76ee\u6807", "\u73b0\u573a\u7ba1\u7406\u76ee\u6807", "\u5b89\u5168\u548c\u73af\u5883\u76ee\u6807"};
            if (result.size() >= innateSort.length) {
                for (int i = 1; i < innateSort.length + 1; ++i) {
                    int arrIndex = i - 1;
                    List datas = (List)result.get(i);
                    MaintargetdetailVO maintargetdetailVO = new MaintargetdetailVO();
                    maintargetdetailVO.setId(IdWorker.getId());
                    String sort = (String)datas.get(0);
                    String projectName = (String)datas.get(1);
                    maintargetdetailVO.setSort(StringUtils.isNotBlank((CharSequence)sort) ? sort : null);
                    maintargetdetailVO.setProjectName(StringUtils.isNotBlank((CharSequence)projectName) ? projectName : null);
                    maintargetdetailVO.setTarget(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(2))) ? (String)datas.get(2) : null);
                    maintargetdetailVO.setRemarks(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(3))) ? (String)datas.get(3) : null);
                    if (i < innateSort.length + 1) {
                        if (!innateSort[arrIndex].equals(sort)) {
                            maintargetdetailVO.setErrorMsg("\u5e8f\u53f7\u4e0e\u6a21\u677f\u4e0d\u4e00\u81f4");
                            errorList.add(maintargetdetailVO);
                            continue;
                        }
                        if (!innateName[arrIndex].equals(projectName)) {
                            maintargetdetailVO.setErrorMsg("\u9879\u76ee\u4e0e\u6a21\u677f\u4e0d\u4e00\u81f4");
                            errorList.add(maintargetdetailVO);
                            continue;
                        }
                    } else {
                        if (StringUtils.isEmpty((CharSequence)sort)) {
                            maintargetdetailVO.setErrorMsg("\u5e8f\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                            errorList.add(maintargetdetailVO);
                            continue;
                        }
                        if (StringUtils.isEmpty((CharSequence)projectName)) {
                            maintargetdetailVO.setErrorMsg("\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                            errorList.add(maintargetdetailVO);
                            continue;
                        }
                    }
                    successList.add(maintargetdetailVO);
                }
                Integer diffSize = result.size() - innateSort.length;
                ArrayList sortList = new ArrayList();
                if (diffSize != 0) {
                    for (int i = 1; i < result.size(); ++i) {
                        sortList.add(((List)result.get(i)).get(0));
                    }
                    HashSet sortSet = new HashSet(sortList);
                    Boolean isNoSimple = sortSet.size() == sortList.size();
                    for (int i = innateSort.length + 1; i < result.size(); ++i) {
                        List datas = (List)result.get(i);
                        String sort = (String)datas.get(0);
                        MaintargetdetailVO maintargetdetailVO = new MaintargetdetailVO();
                        List collect = Arrays.stream(innateSort).filter(item -> item.equals(sort)).collect(Collectors.toList());
                        maintargetdetailVO.setId(IdWorker.getId());
                        String projectName = (String)datas.get(1);
                        maintargetdetailVO.setSort(StringUtils.isNotBlank((CharSequence)sort) ? sort : null);
                        maintargetdetailVO.setProjectName(StringUtils.isNotBlank((CharSequence)projectName) ? projectName : null);
                        maintargetdetailVO.setTarget(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(2))) ? (String)datas.get(2) : null);
                        maintargetdetailVO.setRemarks(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(3))) ? (String)datas.get(3) : null);
                        if (collect.size() > 0 || !isNoSimple.booleanValue()) {
                            maintargetdetailVO.setErrorMsg("\u65b0\u589e\u5e8f\u53f7\u91cd\u590d,\u8bf7\u4fee\u6539!");
                            errorList.add(maintargetdetailVO);
                            continue;
                        }
                        successList.add(maintargetdetailVO);
                    }
                }
            }
        }
        List<MaintargetdetailVO> resList = this.setTidAndTpid(successList);
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", resList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }

    private List<MaintargetdetailVO> setTidAndTpid(List<MaintargetdetailVO> originalList) {
        ArrayList<MaintargetdetailVO> treeList = new ArrayList<MaintargetdetailVO>();
        String currentTime = String.valueOf(System.currentTimeMillis());
        if (originalList != null && originalList.size() > 0) {
            for (int i = 0; i < originalList.size(); ++i) {
                MaintargetdetailVO maintargetdetailVO = originalList.get(i);
                String sort = maintargetdetailVO.getSort();
                String[] arr = sort.split("\\.");
                maintargetdetailVO.setId(IdWorker.getId());
                maintargetdetailVO.setTid(currentTime + "_" + sort);
                if (arr.length == 1) {
                    maintargetdetailVO.setTpid("");
                } else if (arr.length > 1) {
                    maintargetdetailVO.setTpid(currentTime + "_" + sort.substring(0, sort.length() - 2));
                }
                treeList.add(maintargetdetailVO);
            }
        }
        return ExcelMaintargetController.createTreeData(treeList);
    }

    public static List<MaintargetdetailVO> createTreeData(List<MaintargetdetailVO> list) {
        ArrayList<MaintargetdetailVO> resp = new ArrayList<MaintargetdetailVO>();
        ArrayList<String> rootItems = new ArrayList<String>();
        HashMap<String, MaintargetdetailVO> listMap = new HashMap<String, MaintargetdetailVO>();
        for (MaintargetdetailVO item : list) {
            listMap.put(item.getTid().toString(), item);
        }
        for (int i = 0; i < list.size(); ++i) {
            MaintargetdetailVO item;
            item = list.get(i);
            String parentId = item.getTpid() != null ? item.getTpid().toString() : "";
            MaintargetdetailVO parent = (MaintargetdetailVO)((Object)listMap.get(parentId));
            if (parent != null) {
                List<MaintargetdetailVO> child = parent.getChildren();
                if (child != null) {
                    child.add(item);
                    continue;
                }
                ArrayList<MaintargetdetailVO> children = new ArrayList<MaintargetdetailVO>();
                children.add(item);
                parent.setChildren(children);
                continue;
            }
            rootItems.add(item.getTid());
        }
        for (String rootId : rootItems) {
            resp.add((MaintargetdetailVO)((Object)listMap.get(rootId)));
        }
        return resp;
    }

    @RequestMapping(value={"/excelExportMaintargetFromDatabase"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportbusinessplanningeffectFromDatabase(@RequestBody MaintargetVO maintargetVO, HttpServletResponse response) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"mid", (Object)maintargetVO.getId());
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.maintargetdetailService.list((Wrapper)queryWrapper);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("maintarget-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelExportMaintargetFromPage"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportbusinessplanningeffectFromPage(@RequestBody List<MaintargetdetailVO> list, HttpServletResponse response) {
        ArrayList<MaintargetdetailVO> concatList = new ArrayList<MaintargetdetailVO>();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                MaintargetdetailVO maintargetdetailVO = list.get(i);
                maintargetdetailVO.setSort(String.valueOf(i + 1));
                concatList.add(maintargetdetailVO);
            }
        }
        List<MaintargetdetailVO> allList = this.handleList(list, concatList);
        Collections.sort(allList, new Comparator<MaintargetdetailVO>(){

            @Override
            public int compare(MaintargetdetailVO o1, MaintargetdetailVO o2) {
                return o1.getTid().compareTo(o2.getTid());
            }
        });
        HashMap<String, List<MaintargetdetailVO>> beans = new HashMap<String, List<MaintargetdetailVO>>();
        beans.put("records", allList);
        ExcelExport.getInstance().export("maintarget-export.xlsx", beans, response);
    }

    private List<MaintargetdetailVO> handleList(List<MaintargetdetailVO> list, List<MaintargetdetailVO> concatList) {
        if (list == null || list.size() == 0) {
            return concatList;
        }
        for (int i = 0; i < list.size(); ++i) {
            MaintargetdetailVO maintargetdetailVO = list.get(i);
            List<MaintargetdetailVO> children = maintargetdetailVO.getChildren();
            if (children == null || children.size() <= 0) continue;
            concatList.addAll(children);
            this.handleList(children, concatList);
        }
        return concatList;
    }
}

