/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.change.excel;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.busniessplan.service.ISubpackagepackgedetailService;
import com.ejianc.business.busniessplan.vo.SubpackageVO;
import com.ejianc.business.busniessplan.vo.SubpackagepackgedetailVO;
import com.ejianc.business.utils.DateUtils;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"changeSubpackageExport"})
public class ExcelChangeSubpakageController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISubpackagepackgedetailService subpackagepackgedetailService;

    @RequestMapping(value={"/downloadSubpackage"})
    @ResponseBody
    public void downloadTotalPrice(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"subpackage-import.xlsx", (String)"\u5206\u5305\u7ba1\u7406\u7b56\u5212\u8868\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportSubpackage"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportTotalPric(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<SubpackagepackgedetailVO> successList = new ArrayList<SubpackagepackgedetailVO>();
        ArrayList errorList = new ArrayList();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            for (int i = 1; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                SubpackagepackgedetailVO subpackagepackgedetailVO = new SubpackagepackgedetailVO();
                subpackagepackgedetailVO.setId(IdWorker.getId());
                subpackagepackgedetailVO.setSort((String)datas.get(0));
                subpackagepackgedetailVO.setManagerContent(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(1))) ? (String)datas.get(1) : null);
                subpackagepackgedetailVO.setManagerAim(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(2))) ? (String)datas.get(2) : null);
                subpackagepackgedetailVO.setManagerMeasures(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(3))) ? (String)datas.get(3) : null);
                subpackagepackgedetailVO.setPersonLiable(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(4))) ? (String)datas.get(4) : null);
                subpackagepackgedetailVO.setPlanCompleteTime(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(5))) ? DateUtils.Date((String)datas.get(5)) : null);
                subpackagepackgedetailVO.setImplementationEffect(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(6))) ? (String)datas.get(6) : null);
                successList.add(subpackagepackgedetailVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }

    @RequestMapping(value={"/excelExportSubpackageFromDatabase"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportSubpackageFromDatabase(@RequestBody SubpackageVO subpackageVO, HttpServletResponse response) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"mid", (Object)subpackageVO.getId());
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.subpackagepackgedetailService.list((Wrapper)queryWrapper);
        List resList = BeanMapper.mapList((Iterable)list, SubpackagepackgedetailVO.class);
        if (resList != null && resList.size() > 0) {
            for (int i = 0; i < resList.size(); ++i) {
                SubpackagepackgedetailVO subpackagepackgedetailVO = (SubpackagepackgedetailVO)((Object)resList.get(i));
                subpackagepackgedetailVO.setSort(String.valueOf(i + 1));
                if (subpackagepackgedetailVO.getPlanCompleteTime() == null) continue;
                subpackagepackgedetailVO.setPlanCompleteTimeShow(DateUtils.dateSimple(subpackagepackgedetailVO.getPlanCompleteTime()));
            }
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", resList);
        ExcelExport.getInstance().export("subpackage-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelExportSubpackageFromPage"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportbusinessplanningeffectFromPage(@RequestBody List<SubpackagepackgedetailVO> list, HttpServletResponse response) {
        for (int i = 0; i < list.size(); ++i) {
            SubpackagepackgedetailVO subpackagepackgedetailVO = list.get(i);
            subpackagepackgedetailVO.setSort(String.valueOf(i + 1));
            if (subpackagepackgedetailVO.getPlanCompleteTime() == null) continue;
            subpackagepackgedetailVO.setPlanCompleteTimeShow(DateUtils.dateSimple(subpackagepackgedetailVO.getPlanCompleteTime()));
        }
        HashMap<String, List<SubpackagepackgedetailVO>> beans = new HashMap<String, List<SubpackagepackgedetailVO>>();
        beans.put("records", list);
        ExcelExport.getInstance().export("subpackage-export.xlsx", beans, response);
    }
}

