package com.ejianc.business.busniessplan.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.busniessplan.bean.CountersignatureEntity;
import com.ejianc.business.busniessplan.bean.OrgstructureEntity;
import com.ejianc.business.busniessplan.vo.BusinessplanningeffectdetailVO;
import com.ejianc.business.record.bean.RecordbusinessplanningeffectEntity;
import com.ejianc.business.utils.DateUtils;
import com.ejianc.business.record.service.IRecordbusinessplanningeffectService;
import com.ejianc.business.record.vo.RecordbusinessplanningeffectVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.busniessplan.bean.BusinessplanningeffectEntity;
import com.ejianc.business.busniessplan.service.IBusinessplanningeffectService;
import com.ejianc.business.busniessplan.vo.BusinessplanningeffectVO;

/**
 * 项目商务策划效果
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("businessplanningeffect")
public class BusinessplanningeffectController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "businessplan-businessplanningeffect";//此处需要根据实际修改

    @Autowired
    private IBusinessplanningeffectService service;
    @Autowired
    private IRecordbusinessplanningeffectService recordbusinessplanningeffectService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BusinessplanningeffectVO> saveOrUpdate(@RequestBody BusinessplanningeffectVO saveorUpdateVO) {
    	BusinessplanningeffectEntity entity = BeanMapper.map(saveorUpdateVO, BusinessplanningeffectEntity.class);

        QueryWrapper<BusinessplanningeffectEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("project_id", entity.getProjectId());
        List<BusinessplanningeffectEntity> pro = service.list(queryWrapper);
        queryWrapper.eq("dr", "0");
    	if(entity.getId() == null || entity.getId() == 0){
            if( pro.size() > 0){
                throw new BusinessException("该项目已经创建一个项目策划效果，不允许重复创建!");
            }
        }else {
            if(pro.size() > 0){
                for (int i = 0; i < pro.size(); i++) {
                    if(!entity.getId().equals(pro.get(i).getId())){
                        throw new BusinessException("该项目已经创建一个项目策划效果，不允许重复创建!");
                    }
                }
            }
        }
        BusinessplanningeffectEntity businessplanningeffectEntity = checkBillCodeUniq(entity);
        entity.setChangeState("1");
        businessplanningeffectEntity.setCostEstimateTotal(saveorUpdateVO.getCostEstimateTotal()==null? null : saveorUpdateVO.getCostEstimateTotal());
        businessplanningeffectEntity.setReportAmountTotal(saveorUpdateVO.getReportAmountTotal()==null? null : saveorUpdateVO.getReportAmountTotal());
        businessplanningeffectEntity.setTargetAmountTotal(saveorUpdateVO.getTargetAmountTotal()==null? null : saveorUpdateVO.getTargetAmountTotal());
        businessplanningeffectEntity.setCompleteAmountTotal(saveorUpdateVO.getCompleteAmountTotal()==null? null : saveorUpdateVO.getCompleteAmountTotal());
        businessplanningeffectEntity.setEstimateProfitsTotal(saveorUpdateVO.getEstimateProfitsTotal()==null? null : saveorUpdateVO.getEstimateProfitsTotal());

        service.saveOrUpdate(businessplanningeffectEntity, false);
    	BusinessplanningeffectVO vo = BeanMapper.map(entity, BusinessplanningeffectVO.class);

        //构建树形结构
        List<BusinessplanningeffectdetailVO> businessplanningeffectVO = vo.getBusinessplanningeffectdetailEntities();
        List<BusinessplanningeffectdetailVO> resBusinessplanningeffectVO = createTreeData(businessplanningeffectVO);
        vo.setBusinessplanningeffectdetailEntities(resBusinessplanningeffectVO);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    /**
     * 单据编码唯一性校验
     * @param entity
     */
    private BusinessplanningeffectEntity checkBillCodeUniq(BusinessplanningeffectEntity entity) {
        if(entity.getBillCode() == null || StringUtils.isEmpty(entity.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }else {
            //单据编码唯一性
            QueryWrapper<BusinessplanningeffectEntity> queryWrapperBillCode = new QueryWrapper<>();
            queryWrapperBillCode.eq("bill_code", entity.getBillCode());
            queryWrapperBillCode.eq("dr", "0");
            List<BusinessplanningeffectEntity> proBillCode = service.list(queryWrapperBillCode);
            if(proBillCode != null && proBillCode.size() > 0){
                for (int i = 0; i < proBillCode.size(); i++) {
                    BusinessplanningeffectEntity businessplanningeffectCode = proBillCode.get(i);
                    if(!businessplanningeffectCode.getId().equals(entity.getId())){
                        throw new BusinessException("单据编码已存在，请重新录入!");
                    }
                }
            }
        }

        return entity;
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BusinessplanningeffectVO> queryDetail(Long id) {
    	BusinessplanningeffectEntity entity = service.selectById(id);
    	BusinessplanningeffectVO vo = BeanMapper.map(entity, BusinessplanningeffectVO.class);

        //构建树形结构
        List<BusinessplanningeffectdetailVO> businessplanningeffectVO = vo.getBusinessplanningeffectdetailEntities();
        List<BusinessplanningeffectdetailVO> resBusinessplanningeffectVO = createTreeData(businessplanningeffectVO);
        vo.setBusinessplanningeffectdetailEntities(resBusinessplanningeffectVO);

        //当前单据变更过则显示变更记录
        if(!"1".equals(vo.getChangeState())){
            QueryWrapper<RecordbusinessplanningeffectEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("dr", 0);
            queryWrapper.eq("businessplanningeffect_id", vo.getId());
            List<RecordbusinessplanningeffectEntity> records = recordbusinessplanningeffectService.list(queryWrapper);
            if(records!=null&&records.size()>0){
                vo.setRecordbusinessplanningeffectList(BeanMapper.mapList(records, RecordbusinessplanningeffectVO.class));
            }
        }

        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BusinessplanningeffectVO> vos) {
        service.removeByIds(vos.stream().map(BusinessplanningeffectVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<BusinessplanningeffectVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        fuzzyFields.add("project_name");
        fuzzyFields.add("bill_code");
        fuzzyFields.add("agent_name");
        IPage<BusinessplanningeffectEntity> page = service.queryPage(param,false);
        IPage<BusinessplanningeffectVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), BusinessplanningeffectVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<BusinessplanningeffectEntity> list = service.queryList(param);
        //时间转换
        List<BusinessplanningeffectVO> businessplanningeffectList = BeanMapper.mapList(list, BusinessplanningeffectVO.class);
        for (int i = 0; i < businessplanningeffectList.size(); i++) {
            BusinessplanningeffectVO businessplanningeffectVO = businessplanningeffectList.get(i);
            businessplanningeffectVO.setSort(String.valueOf(i+1));
            if (businessplanningeffectVO.getCreateTime()!=null){
                businessplanningeffectVO.setCreateTimeShow(DateUtils.dateSimple2(businessplanningeffectVO.getCreateTime()));
            }

            String billStateStr = businessplanningeffectVO.getBillState().toString();
            String changeState = businessplanningeffectVO.getChangeState();
            if (billStateStr != null){
                if("0".equals(billStateStr)){//自由态
                    billStateStr = "自由态";
                }else if("1".equals(billStateStr)){//已提交
                    billStateStr = "已提交";
                }else if("2".equals(billStateStr) || "5".equals(billStateStr)){//审批中
                    billStateStr = "审批中";
                }else if("3".equals(billStateStr)){//审批通过
                    billStateStr = "审批通过";
                }else if("4".equals(billStateStr)){//驳回
                    billStateStr = "驳回";
                }

                businessplanningeffectVO.setBillStateStr(billStateStr);
            }

            if (changeState != null){
                if("1".equals(changeState)){//1:未变更
                    changeState = "未变更";
                }else if("2".equals(changeState)){//2:变更中
                    changeState = "变更中";
                }else if("3".equals(changeState)){//3:已变更
                    changeState = "已变更";
                }

                businessplanningeffectVO.setChangeState(changeState);
            }
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", businessplanningeffectList);
        ExcelExport.getInstance().export("BusinessplanningeffectMain-export.xlsx", beans, response);
    }

    /**
     * 参照
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchObject
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/refBusinessplanningeffectData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<BusinessplanningeffectVO>> refBusinessplanningeffectData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<BusinessplanningeffectEntity> page = service.queryPage(param,false);
        IPage<BusinessplanningeffectVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), BusinessplanningeffectVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    public static List<BusinessplanningeffectdetailVO> createTreeData(List<BusinessplanningeffectdetailVO> list) {
        List<BusinessplanningeffectdetailVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();

        //循环list，放入listMap重
        Map<String, BusinessplanningeffectdetailVO> listMap = new HashMap<>();
        for(BusinessplanningeffectdetailVO item:list) {
            listMap.put(item.getTid().toString(), item);
        }

        for(int i =0; i<list.size(); i++) {
            BusinessplanningeffectdetailVO item = list.get(i);
            String parentId = (item.getTpid() != null) ? item.getTpid().toString():"";
            BusinessplanningeffectdetailVO parent = listMap.get(parentId);
            if(parent != null) {
                List<BusinessplanningeffectdetailVO> child = (List<BusinessplanningeffectdetailVO>) parent.getChildren();
                if(child != null) {
                    child.add(item);
                }else{
                    List<BusinessplanningeffectdetailVO> children = new ArrayList<BusinessplanningeffectdetailVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getTid());
            }
        }

        for(String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }
}
