package com.ejianc.business.busniessplan.controller;

import java.io.Serializable;

import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.busniessplan.bean.PlanprojectEntity;
import com.ejianc.business.busniessplan.vo.ProjectcontractVO;
import com.ejianc.business.busniessplan.vo.ProjectdetailVO;
import com.ejianc.business.busniessplan.vo.ProjoverviewVO;
import com.ejianc.business.record.bean.RecordProjoverviewEntity;
import com.ejianc.business.record.service.IRecordProjoverviewService;
import com.ejianc.business.record.vo.RecordProjoverviewVO;
import com.ejianc.business.utils.DateUtils;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.busniessplan.bean.ProjoverviewEntity;
import com.ejianc.business.busniessplan.service.IProjoverviewService;

/**
 * 工程概述
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("projoverview")
public class ProjoverviewController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "busniessplan-projoverview";//此处需要根据实际修改

    @Autowired
    private IProjoverviewService service;
    @Autowired
    private IRecordProjoverviewService recordProjoverviewService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ProjoverviewVO> saveOrUpdate(@RequestBody ProjoverviewVO saveorUpdateVO) {
    	ProjoverviewEntity entity = BeanMapper.map(saveorUpdateVO, ProjoverviewEntity.class);
        CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
        if(billCode.isSuccess()) {
            entity.setChangeState("1");//未变更
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
            entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
        }else{
            throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
        }
        //创建条件构造器
        QueryWrapper<ProjoverviewEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("project_id", entity.getProjectId());
        queryWrapper.eq("dr", "0");
        List<ProjoverviewEntity> pro = service.list(queryWrapper);

    	if(entity.getId() == null || entity.getId() == 0){//新增
            if(pro.size() > 0){
                throw new BusinessException("该项目已经创建一个工程概述，不允许重复创建!");
            }
        }else {//更新
            if(pro.size() > 0){
                for (int i = 0; i < pro.size(); i++) {
                    if(!entity.getId().equals(pro.get(i).getId())){
                        throw new BusinessException("该单据已存在，不允许重复创建!");
                    }
                }
            }
        }


        //处理子表数据
        if(saveorUpdateVO.getProjectdetailList()!=null&&saveorUpdateVO.getProjectdetailList().size()>0){
            ProjectdetailVO projectdetailVO = saveorUpdateVO.getProjectdetailList().get(0);
            entity.setProjectBidWinPrice(projectdetailVO.getProjectBidWinPrice());
            entity.setCivilEngineering(projectdetailVO.getCivilEngineering());
            entity.setFix(projectdetailVO.getFix());
            entity.setWaterSupplyDrainage(projectdetailVO.getWaterSupplyDrainage());
            entity.setStrongCurrent(projectdetailVO.getStrongCurrent());
            entity.setHeateVentilation(projectdetailVO.getHeateVentilation());
            entity.setFixOther(projectdetailVO.getFixOther());
            entity.setDecorate(projectdetailVO.getDecorate());
            entity.setOther(projectdetailVO.getOther());
        }else{
            entity.setProjectBidWinPrice(null);
            entity.setCivilEngineering(null);
            entity.setFix(null);
            entity.setWaterSupplyDrainage(null);
            entity.setStrongCurrent(null);
            entity.setHeateVentilation(null);
            entity.setFixOther(null);
            entity.setDecorate(null);
            entity.setOther(null);
        }
        if(saveorUpdateVO.getProjectcontractList()!=null&&saveorUpdateVO.getProjectcontractList().size()>0){
            ProjectcontractVO projectcontractVO = saveorUpdateVO.getProjectcontractList().get(0);
            entity.setContractAmount(projectcontractVO.getContractAmount());
            entity.setSelfConstructionContractAmount(projectcontractVO.getSelfConstructionContractAmount());
            entity.setBelong(projectcontractVO.getBelong());
        }else{
            entity.setContractAmount(null);
            entity.setSelfConstructionContractAmount(null);
            entity.setBelong(null);
        }
    	service.saveOrUpdate(entity, false);
    	ProjoverviewVO vo = BeanMapper.map(entity, ProjoverviewVO.class);
        vo.setProjectdetailList(saveorUpdateVO.getProjectdetailList());
        vo.setProjectcontractList(saveorUpdateVO.getProjectcontractList());
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * 单据编码唯一性校验
     * @param entity
     */
    /*private ProjoverviewEntity checkBillCodeUniq(ProjoverviewEntity entity) {
        if(entity.getBillCode() == null || StringUtils.isEmpty(entity.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }else {
            //单据编码唯一性
            QueryWrapper<ProjoverviewEntity> queryWrapperBillCode = new QueryWrapper<>();
            queryWrapperBillCode.eq("bill_code", entity.getBillCode());
            queryWrapperBillCode.eq("dr", "0");
            List<ProjoverviewEntity> proBillCode = service.list(queryWrapperBillCode);
            if(proBillCode != null && proBillCode.size() > 0){
                for (int i = 0; i < proBillCode.size(); i++) {
                    ProjoverviewEntity projoverviewEntityCode = proBillCode.get(i);
                    if(!projoverviewEntityCode.getId().equals(entity.getId())){
                        throw new BusinessException("单据编码已存在，请重新录入!");
                    }
                }
            }
        }
        return entity;
    }*/

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProjoverviewVO> queryDetail(Long id) {
    	ProjoverviewEntity entity = service.selectById(id);
    	ProjoverviewVO vo = BeanMapper.map(entity, ProjoverviewVO.class);

        List<ProjectdetailVO> ProjectdetailList = new ArrayList<>();
        ProjectdetailVO ProjectdetailVO = BeanMapper.map(entity, ProjectdetailVO.class);
        ProjectdetailVO.setRowState("add");
        ProjectdetailList.add(ProjectdetailVO);
        vo.setProjectdetailList(ProjectdetailList);

        List<ProjectcontractVO> ProjectcontractList = new ArrayList<>();
        ProjectcontractVO projectcontractVO = BeanMapper.map(entity, ProjectcontractVO.class);
        projectcontractVO.setRowState("add");
        ProjectcontractList.add(projectcontractVO);
        vo.setProjectcontractList(ProjectcontractList);

        //当前单据变更过则显示变更记录
        if(!"1".equals(vo.getChangeState())){
            QueryWrapper<RecordProjoverviewEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("dr", 0);
            queryWrapper.eq("original_id", vo.getId());
            List<RecordProjoverviewEntity> records = recordProjoverviewService.list(queryWrapper);
            if(records!=null&&records.size()>0){
                vo.setRecordProjoverviewList(BeanMapper.mapList(records, RecordProjoverviewVO.class));
            }
        }


        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProjoverviewVO> vos) {
        service.removeByIds(vos.stream().map(ProjoverviewVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ProjoverviewVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        for (String field : param.getParams().keySet()) {
            if(StringUtils.equals(field,"duration")){
                String value = (String) param.getParams().get("duration").getValue();
                String[] split = value.split(",");
                long between = DateUtil.between(DateUtil.parseDate(split[1]), DateUtil.parseDate(split[0]), DateUnit.DAY);
                param.getParams().put("duration",new Parameter(QueryParam.LE,between));
            }
        }
        fuzzyFields.add("project_name");
        fuzzyFields.add("bill_code");
        fuzzyFields.add("agent_name");
        fuzzyFields.add("project_code");
        fuzzyFields.add("build_unit_name");
        fuzzyFields.add("construction_unit_name");
        fuzzyFields.add("project_alias_name");
        fuzzyFields.add("contractual_model_name");
        fuzzyFields.add("investment_source_name");
        fuzzyFields.add("type_name");
        IPage<ProjoverviewEntity> page = service.queryPage(param,false);
        IPage<ProjoverviewVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProjoverviewVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        for (String field : param.getParams().keySet()) {
            if(StringUtils.equals(field,"duration")){
                String value = (String) param.getParams().get("duration").getValue();
                String[] split = value.split(",");
                long between = DateUtil.between(DateUtil.parseDate(split[1]), DateUtil.parseDate(split[0]), DateUnit.DAY);
                param.getParams().put("duration",new Parameter(QueryParam.LE,between));
            }
        }
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ProjoverviewEntity> list = service.queryList(param);
        //时间转换
        List<ProjoverviewVO> projoverviewVOList = BeanMapper.mapList(list, ProjoverviewVO.class);
        for (int i = 0; i < projoverviewVOList.size(); i++) {
            ProjoverviewVO projoverviewVO = projoverviewVOList.get(i);
            projoverviewVO.setSort(String.valueOf(i+1));
            if (projoverviewVO.getCreateTime()!=null){
                projoverviewVO.setCreateTimeShow(DateUtils.dateSimple2(projoverviewVO.getCreateTime()));
            }

            String billStateStr = projoverviewVO.getBillState().toString();
            String changeState = projoverviewVO.getChangeState();
            if (billStateStr != null){
                if("0".equals(billStateStr)){//自由态
                    billStateStr = "自由态";
                }else if("1".equals(billStateStr)){//已提交
                    billStateStr = "已提交";
                }else if("2".equals(billStateStr) || "5".equals(billStateStr)){//审批中
                    billStateStr = "审批中";
                }else if("3".equals(billStateStr)){//审批通过
                    billStateStr = "审批通过";
                }else if("4".equals(billStateStr)){//驳回
                    billStateStr = "驳回";
                }

                projoverviewVO.setBillStateStr(billStateStr);
            }

            if (changeState != null){
                if("1".equals(changeState)){//1:未变更
                    changeState = "未变更";
                }else if("2".equals(changeState)){//2:变更中
                    changeState = "变更中";
                }else if("3".equals(changeState)){//3:已变更
                    changeState = "已变更";
                }

                projoverviewVO.setChangeState(changeState);
            }
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", projoverviewVOList);
        ExcelExport.getInstance().export("ProjoverviewMain-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refProjoverviewData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ProjoverviewVO>> refProjoverviewData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ProjoverviewEntity> page = service.queryPage(param,false);
        IPage<ProjoverviewVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProjoverviewVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
