package com.ejianc.business.busniessplan.excel;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.busniessplan.bean.FundsplanningEntity;
import com.ejianc.business.busniessplan.bean.FundsplanningdetailEntity;
import com.ejianc.business.busniessplan.service.IFundsplanningService;
import com.ejianc.business.busniessplan.service.IFundsplanningdetailService;
import com.ejianc.business.busniessplan.vo.FundsplanningVO;
import com.ejianc.business.busniessplan.vo.FundsplanningdetailVO;
import com.ejianc.business.utils.DateUtils;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 项目资金管理策划导入导出
 */
@Controller
@RequestMapping("fundsplanningExport")
public class ExeclFundsplanningController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IFundsplanningdetailService fundsplanningdetailService;
    @Autowired
    private IFundsplanningService service;

    /**
     * 导入模板下载
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadFundsplanning")
    @ResponseBody
    public void downloadTotalPrice(HttpServletRequest request, HttpServletResponse response){
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "fundsplanning-import.xlsx", "项目资金策划表模板");
    }

    /**
     * excel导入
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelImportFundsplanning", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportTotalPric(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<FundsplanningdetailVO> successList = new ArrayList<>();
        List<FundsplanningdetailVO> errorList = new ArrayList<>();
        DateFormat sdf=new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if(isFailed) {
            return CommonResponse.error("文件格式不合法");
        }else{
            List<List<String>> result = ExcelReader.readExcel(mf);
            if(result != null && result.size() > 0) {
                for(int i=2;i<result.size();i++) {
                    List<String> datas = result.get(i);
                    FundsplanningdetailVO fundsplanningdetailVO = new FundsplanningdetailVO();

                    fundsplanningdetailVO.setId(IdWorker.getId());//id
                    fundsplanningdetailVO.setSort(datas.get(0)); // 序号
                    fundsplanningdetailVO.setCollectbranchTime(StringUtils.isNotBlank(datas.get(1))? DateUtils.Date((datas.get(1))):null); // 收支时间(日期)
                    fundsplanningdetailVO.setImagenode(StringUtils.isNotBlank(datas.get(2))?datas.get(2):null); // 形象进度节点情况
                    fundsplanningdetailVO.setPlancomplete(StringUtils.isNotBlank(datas.get(3))?new BigDecimal(datas.get(3)):null); // 计划完成产值
                    fundsplanningdetailVO.setCivilengineering(StringUtils.isNotBlank(datas.get(4))?new BigDecimal(datas.get(4)):new BigDecimal(0)); // 土建
                    fundsplanningdetailVO.setInstallation(StringUtils.isNotBlank(datas.get(5))?new BigDecimal(datas.get(5)):new BigDecimal(0)); // 安装
                    fundsplanningdetailVO.setOther(StringUtils.isNotBlank(datas.get(6))?new BigDecimal(datas.get(6)):new BigDecimal(0)); // 其它

                    //总计
                    if(fundsplanningdetailVO.getCioAmount()==null || StringUtils.isBlank(datas.get(7))){
                        fundsplanningdetailVO.setCioAmount(String.valueOf(fundsplanningdetailVO.getOther().add(fundsplanningdetailVO.getCivilengineering()).add(fundsplanningdetailVO.getInstallation())));
                    }else{
                        fundsplanningdetailVO.setCioAmount(datas.get(7));
                    }

                    fundsplanningdetailVO.setLabourservices(StringUtils.isNotBlank(datas.get(8))?new BigDecimal(datas.get(8)):new BigDecimal(0)); // 劳务
                    fundsplanningdetailVO.setMaterial(StringUtils.isNotBlank(datas.get(9))?new BigDecimal(datas.get(9)):new BigDecimal(0)); // 材料
                    fundsplanningdetailVO.setProfessional(StringUtils.isNotBlank(datas.get(10))?new BigDecimal(datas.get(10)):new BigDecimal(0)); // 专业分包
                    fundsplanningdetailVO.setOthercost(StringUtils.isNotBlank(datas.get(12))?new BigDecimal(datas.get(12)):new BigDecimal(0)); // 其它费用
                    fundsplanningdetailVO.setAnswer(StringUtils.isNotBlank(datas.get(15))?new BigDecimal(datas.get(15)):null); // 应对措施
                    fundsplanningdetailVO.setRemarks(StringUtils.isNotBlank(datas.get(16))?datas.get(16):null); // 备注
                    fundsplanningdetailVO.setSalary(StringUtils.isNotBlank(datas.get(11)) ? new BigDecimal(datas.get(11)):new BigDecimal(0));

                    //当期
                    if(fundsplanningdetailVO.getCurrent()==null || StringUtils.isBlank(datas.get(13))){
                       BigDecimal currentDec = fundsplanningdetailVO.getLabourservices().add(fundsplanningdetailVO.getMaterial())
                               .add(fundsplanningdetailVO.getProfessional()).add(fundsplanningdetailVO.getOthercost())
                               .add(fundsplanningdetailVO.getSalary());
                        fundsplanningdetailVO.setCurrent(new BigDecimal(fundsplanningdetailVO.getCioAmount()).subtract(currentDec));
                    }else{
                        fundsplanningdetailVO.setCurrent(new BigDecimal(datas.get(13)));
                    }

                    //累计
                    if(fundsplanningdetailVO.getCumulative() == null || StringUtils.isBlank(datas.get(14))){
                        BigDecimal oldCumulative = new BigDecimal(0);
                        QueryWrapper<FundsplanningEntity> queryWrapper = new QueryWrapper<>();
                        queryWrapper.eq("bill_state",3);
                        queryWrapper.le("create_time",DateUtil.now());
                        List<FundsplanningEntity> fundsplanningEntityList = service.list(queryWrapper);
                        for (FundsplanningEntity entity : fundsplanningEntityList) {
                            QueryWrapper<FundsplanningdetailEntity> wrapper = new QueryWrapper<>();
                            wrapper.eq("mid",entity.getId());
                            List<FundsplanningdetailEntity> fundsplanningdetailEntityList = fundsplanningdetailService.list(wrapper);
                            for (FundsplanningdetailEntity fundsplanningdetailEntity : fundsplanningdetailEntityList) {
                                oldCumulative.add(fundsplanningdetailEntity.getCurrent());
                            }
                        }
                        fundsplanningdetailVO.setCumulative(oldCumulative.add(fundsplanningdetailVO.getCurrent()));
                    }else{
                        fundsplanningdetailVO.setCumulative(new BigDecimal(datas.get(14)));
                    }

                    if(StringUtils.isEmpty(datas.get(0))) {
                        fundsplanningdetailVO.setErrorMsg("序号不能为空！");
                        errorList.add(fundsplanningdetailVO);
                        continue;
                    }
                    successList.add(fundsplanningdetailVO);
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

    /**
     * excel导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportFundsplanningFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportbusinessplanningeffectFromDatabase(@RequestBody FundsplanningVO fundsplanningVO, HttpServletResponse response) {
        QueryWrapper<FundsplanningdetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", fundsplanningVO.getId());
        queryWrapper.eq("dr", 0);
        List<FundsplanningdetailEntity> list = fundsplanningdetailService.list(queryWrapper);
        Integer count = 1;
        for (FundsplanningdetailEntity entity : list) {
            entity.setSort(String.valueOf(count++));
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("fundsplanning-export.xlsx", beans, response);
    }

    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportFundsplanningFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportbusinessplanningeffectFromPage(@RequestBody List<FundsplanningdetailVO> list, HttpServletResponse response) {
        for (int i = 0; i < list.size(); i++) {
            FundsplanningdetailVO fundsplanningdetailVO = list.get(i);
            if (fundsplanningdetailVO.getCollectbranchTime()!=null){
                fundsplanningdetailVO.setCollectbranchTimeShow(DateUtils.dateSimple(fundsplanningdetailVO.getCollectbranchTime()));
            }
            fundsplanningdetailVO.setSort(String.valueOf(i+1));
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("fundsplanning-export.xlsx", beans, response);
    }

}
