package com.ejianc.business.busniessplan.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.busniessplan.bean.CountersignatureEntity;
import com.ejianc.business.busniessplan.bean.ProjoverviewEntity;
import com.ejianc.business.busniessplan.vo.FundrecoveryplanVO;
import com.ejianc.business.record.bean.RecordFundrecoveryplanEntity;
import com.ejianc.business.record.service.IRecordFundrecoveryplanService;
import com.ejianc.business.record.vo.RecordFundrecoveryplanVO;
import com.ejianc.business.utils.DateUtils;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.busniessplan.bean.FundrecoveryplanEntity;
import com.ejianc.business.busniessplan.service.IFundrecoveryplanService;

/**
 * 项目资金回收流程策划
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("fundrecoveryplan")
public class FundrecoveryplanController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "busniessplan-fundrecoveryplan";//此处需要根据实际修改

    @Autowired
    private IFundrecoveryplanService service;
    @Autowired
    private IRecordFundrecoveryplanService recordFundrecoveryplanService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<FundrecoveryplanVO> saveOrUpdate(@RequestBody FundrecoveryplanVO saveorUpdateVO) {
    	FundrecoveryplanEntity entity = BeanMapper.map(saveorUpdateVO, FundrecoveryplanEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            QueryWrapper<FundrecoveryplanEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("project_id", entity.getProjectId());
            queryWrapper.eq("dr", "0");
            List<FundrecoveryplanEntity> pro = service.list(queryWrapper);
            if( pro.size() > 0){
                throw new BusinessException("该项目已经创建一个项目资金回收流程策划，不允许重复创建!");
            }
        }
        FundrecoveryplanEntity fundrecoveryplanEntity = checkBillCodeUniq(entity);
        entity.setChangeState("1");
        service.saveOrUpdate(fundrecoveryplanEntity, false);
    	FundrecoveryplanVO vo = BeanMapper.map(fundrecoveryplanEntity, FundrecoveryplanVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * 单据编码唯一性校验
     * @param entity
     */
    private FundrecoveryplanEntity checkBillCodeUniq(FundrecoveryplanEntity entity) {
        if(entity.getBillCode() == null || StringUtils.isEmpty(entity.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }else {
            //单据编码唯一性
            QueryWrapper<FundrecoveryplanEntity> queryWrapperBillCode = new QueryWrapper<>();
            queryWrapperBillCode.eq("bill_code", entity.getBillCode());
            queryWrapperBillCode.eq("dr", "0");
            List<FundrecoveryplanEntity> proBillCode = service.list(queryWrapperBillCode);
            if(proBillCode != null && proBillCode.size() > 0){
                for (int i = 0; i < proBillCode.size(); i++) {
                    FundrecoveryplanEntity fundrecoveryplanEntityCode = proBillCode.get(i);
                    if(!fundrecoveryplanEntityCode.getId().equals(entity.getId())){
                        throw new BusinessException("单据编码已存在，请重新录入!");
                    }
                }
            }
        }
        return entity;
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<FundrecoveryplanVO> queryDetail(Long id) {
    	FundrecoveryplanEntity entity = service.selectById(id);
    	FundrecoveryplanVO vo = BeanMapper.map(entity, FundrecoveryplanVO.class);

        //当前单据变更过则显示变更记录
        if(!"1".equals(vo.getChangeState())){
            QueryWrapper<RecordFundrecoveryplanEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("dr", 0);
            queryWrapper.eq("fundrecoveryplanning_id", vo.getId());
            List<RecordFundrecoveryplanEntity> records = recordFundrecoveryplanService.list(queryWrapper);
            if(records!=null&&records.size()>0){
                vo.setRecordFundrecoveryplanList(BeanMapper.mapList(records, RecordFundrecoveryplanVO.class));
            }
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<FundrecoveryplanVO> vos) {
        service.removeByIds(vos.stream().map(FundrecoveryplanVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<FundrecoveryplanVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        fuzzyFields.add("project_name");
        fuzzyFields.add("bill_code");
        fuzzyFields.add("agent_name");
        IPage<FundrecoveryplanEntity> page = service.queryPage(param,false);
        IPage<FundrecoveryplanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), FundrecoveryplanVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<FundrecoveryplanEntity> list = service.queryList(param);
        //时间转换
        List<FundrecoveryplanVO> FundrecoveryplanVOList = BeanMapper.mapList(list, FundrecoveryplanVO.class);
        for (int i = 0; i < FundrecoveryplanVOList.size(); i++) {
            FundrecoveryplanVO FundrecoveryplanVO = FundrecoveryplanVOList.get(i);
            FundrecoveryplanVO.setSort(String.valueOf(i+1));
            if (FundrecoveryplanVO.getCreateTime()!=null){
                FundrecoveryplanVO.setCreateTimeShow(DateUtils.dateSimple2(FundrecoveryplanVO.getCreateTime()));
            }

            String billStateStr = FundrecoveryplanVO.getBillState().toString();
            String changeState = FundrecoveryplanVO.getChangeState();
            if (billStateStr != null){
                if("0".equals(billStateStr)){//自由态
                    billStateStr = "自由态";
                }else if("1".equals(billStateStr)){//已提交
                    billStateStr = "已提交";
                }else if("2".equals(billStateStr) || "5".equals(billStateStr)){//审批中
                    billStateStr = "审批中";
                }else if("3".equals(billStateStr)){//审批通过
                    billStateStr = "审批通过";
                }else if("4".equals(billStateStr)){//驳回
                    billStateStr = "驳回";
                }

                FundrecoveryplanVO.setBillStateStr(billStateStr);
            }

            if (changeState != null){
                if("1".equals(changeState)){//1:未变更
                    changeState = "未变更";
                }else if("2".equals(changeState)){//2:变更中
                    changeState = "变更中";
                }else if("3".equals(changeState)){//3:已变更
                    changeState = "已变更";
                }

                FundrecoveryplanVO.setChangeState(changeState);
            }
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", FundrecoveryplanVOList);
        ExcelExport.getInstance().export("FundrecoveryplanMain-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refFundrecoveryplanData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<FundrecoveryplanVO>> refFundrecoveryplanData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<FundrecoveryplanEntity> page = service.queryPage(param,false);
        IPage<FundrecoveryplanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), FundrecoveryplanVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
