package com.ejianc.business.busniessplan.excel;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.busniessplan.bean.BusinessplanningeffectdetailEntity;
import com.ejianc.business.busniessplan.service.IBusinessplanningeffectdetailService;
import com.ejianc.business.busniessplan.vo.BusinessplanningeffectVO;
import com.ejianc.business.busniessplan.vo.BusinessplanningeffectdetailVO;
import com.ejianc.business.utils.DateUtils;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.*;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 項目商務策劃效果導入導出
 */
@Controller
@RequestMapping("businessplanningeffectExport")
public class ExcelBusinessplaneffectController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBusinessplanningeffectdetailService businessplanningeffectdetailService;

    /**
     * 导入模板下载
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadBusinessplanningeffect")
    @ResponseBody
    public void downloadTotalPrice(HttpServletRequest request, HttpServletResponse response){
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "businessplanningeffect-import.xlsx", "项目商务策划立项清单模板");
    }

    /**
     * excel导入
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelImportBusinessplanningeffect", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportTotalPric(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<BusinessplanningeffectdetailVO> successList = new ArrayList<>();
        List<BusinessplanningeffectdetailVO> errorList = new ArrayList<>();
        DateFormat sdf=new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if(isFailed) {
            return CommonResponse.error("文件格式不合法");
        }else{
            List<List<String>> result = ExcelReader.readExcel(mf);
            if(result != null && result.size() > 0) {
                for(int i=3;i<result.size();i++) {
                    List<String> datas = result.get(i);
                    BusinessplanningeffectdetailVO businessplanningeffectdetailVO = new BusinessplanningeffectdetailVO();
                    businessplanningeffectdetailVO.setId(IdWorker.getId());//id
                    businessplanningeffectdetailVO.setSort(datas.get(0)); // 序号
                    businessplanningeffectdetailVO.setCategoryAndName(StringUtils.isNotBlank(datas.get(1))?datas.get(1):null); // 类别及项目名称
                    businessplanningeffectdetailVO.setInitiateReason(StringUtils.isNotBlank(datas.get(2))?datas.get(2):null); // 立项理由及依据
                    businessplanningeffectdetailVO.setInitiateDate(StringUtils.isNotBlank(datas.get(3))? DateUtils.Date(datas.get(3)):null); // 立项时间
                    //System.out.println("时间打印："+datas.get(3));
                    businessplanningeffectdetailVO.setCostEstimate(StringUtils.isNotBlank(datas.get(4))?new BigDecimal(datas.get(4)):null); // 成本估算(成本分析)(元)
                    businessplanningeffectdetailVO.setReportAmount(StringUtils.isNotBlank(datas.get(5))?new BigDecimal(datas.get(5)):null); // 上报金额(元)
                    businessplanningeffectdetailVO.setTargetAmount(StringUtils.isNotBlank(datas.get(6))?new BigDecimal(datas.get(6)):null); // 策划目标金额(元)
                    businessplanningeffectdetailVO.setCompleteAmount(StringUtils.isNotBlank(datas.get(7))?new BigDecimal(datas.get(7)):null); // 已完成目标金额(元)
                    businessplanningeffectdetailVO.setEstimateProfits(StringUtils.isNotBlank(datas.get(8))?new BigDecimal(datas.get(8)):null); // 预计利润(元)
                    businessplanningeffectdetailVO.setProposedCompleteTime(StringUtils.isNotBlank(datas.get(9))?DateUtils.Date(datas.get(9)):null); // 拟完成时间节点
                    businessplanningeffectdetailVO.setCompleteTime(StringUtils.isNotBlank(datas.get(10))?DateUtils.Date(datas.get(10)):null); // 完成时间
                    businessplanningeffectdetailVO.setSupportingDetails(StringUtils.isNotBlank(datas.get(11))?datas.get(11):null); // 证明资料明细
                    businessplanningeffectdetailVO.setReportToThismonthProgress(StringUtils.isNotBlank(datas.get(12))?new BigDecimal(datas.get(12)):null); // 报公司截至本月进度(元)
                    businessplanningeffectdetailVO.setFirstResponsiblePerson(StringUtils.isNotBlank(datas.get(13))?datas.get(13):null); // 第一责任人
                    businessplanningeffectdetailVO.setMainResponsiblePerson(StringUtils.isNotBlank(datas.get(14))?datas.get(14):null); // 主要负责人
                    businessplanningeffectdetailVO.setFinalCompleteTime(StringUtils.isNotBlank(datas.get(15))?DateUtils.Date(datas.get(15)):null); // (最后)完成时间
                    businessplanningeffectdetailVO.setAttention(StringUtils.isNotBlank(datas.get(16))?datas.get(16):null); // 推荐情况、存在问题、注意事项
                    businessplanningeffectdetailVO.setSupervisionNotReportedMoney(StringUtils.isNotBlank(datas.get(17))?new BigDecimal(datas.get(17)):null); // 监理未上报金额
                    businessplanningeffectdetailVO.setSupervisionNotReportedTime(StringUtils.isNotBlank(datas.get(18))?DateUtils.Date(datas.get(18)):null); // 监理未上报预计上报时间
                    businessplanningeffectdetailVO.setSupervisionReportedMoney(StringUtils.isNotBlank(datas.get(19))?new BigDecimal(datas.get(19)):null); // 监理已上报未批复金额
                    businessplanningeffectdetailVO.setSupervisionReportedTime(StringUtils.isNotBlank(datas.get(20))?DateUtils.Date(datas.get(20)):null); // 监理已上报未批复上报时间
                    businessplanningeffectdetailVO.setSupervisionApprovedMoney(StringUtils.isNotBlank(datas.get(21))?new BigDecimal(datas.get(21)):null); // 监理已批复金额
                    businessplanningeffectdetailVO.setSupervisionApprovedTime(StringUtils.isNotBlank(datas.get(22))?DateUtils.Date(datas.get(22)):null); // 监理已批复上报时间
                    businessplanningeffectdetailVO.setOwnerNotReportedMoney(StringUtils.isNotBlank(datas.get(23))?new BigDecimal(datas.get(23)):null); // 业主未上报金额
                    businessplanningeffectdetailVO.setOwnerNotReportedTime(StringUtils.isNotBlank(datas.get(24))?DateUtils.Date(datas.get(24)):null); // 业主未上报预计上报时间
                    businessplanningeffectdetailVO.setOwnerReportedMoney(StringUtils.isNotBlank(datas.get(25))?new BigDecimal(datas.get(25)):null); // 业主已上报未批复金额
                    businessplanningeffectdetailVO.setOwnerReportedTime(StringUtils.isNotBlank(datas.get(26))?DateUtils.Date(datas.get(26)):null); // 业主已上报未批复上报时间
                    businessplanningeffectdetailVO.setOwnerApprovedMoney(StringUtils.isNotBlank(datas.get(27))?new BigDecimal(datas.get(27)):null); // 业主已批复金额
                    businessplanningeffectdetailVO.setOwnerApprovedTime(StringUtils.isNotBlank(datas.get(28))?DateUtils.Date(datas.get(28)):null); // 业主已批复上报时间
                    businessplanningeffectdetailVO.setApprovedMoney(StringUtils.isNotBlank(datas.get(29))?new BigDecimal(datas.get(29)):null); // 已批复金额
                    businessplanningeffectdetailVO.setPricedMoney(StringUtils.isNotBlank(datas.get(30))?new BigDecimal(datas.get(30)):null); // 已计价金额
                    businessplanningeffectdetailVO.setPricedActualMoney(StringUtils.isNotBlank(datas.get(31))?new BigDecimal(datas.get(31)):null); // 已计价部分实际金额
                    businessplanningeffectdetailVO.setPricedPartBenefit(StringUtils.isNotBlank(datas.get(32))?new BigDecimal(datas.get(32)):null); // 已计价部分的效益
                    businessplanningeffectdetailVO.setRemarks(StringUtils.isNotBlank(datas.get(33))?datas.get(33):null); // 备注

                    if(datas.get(0)==null || datas.get(0) == ""){
                        businessplanningeffectdetailVO.setErrorMsg("序号不能为空");
                        errorList.add(businessplanningeffectdetailVO);
                        continue;
                    }else{
                        businessplanningeffectdetailVO.setSort(datas.get(0));
                    }
                    if(datas.get(1) == null || StringUtils.isBlank(datas.get(1))){
                        businessplanningeffectdetailVO.setErrorMsg("类别及项目名称不能为空");
                        errorList.add(businessplanningeffectdetailVO);
                        continue;
                    }else{
                        businessplanningeffectdetailVO.setCategoryAndName(datas.get(1));
                    }
                    /*if(StringUtils.isEmpty(datas.get(0))) {
                        businessplanningeffectdetailVO.setErrorMsg("序号不能为空！");
                        errorList.add(businessplanningeffectdetailVO);
                        continue;
                    }
                    if(StringUtils.isEmpty(datas.get(1))) {
                        businessplanningeffectdetailVO.setErrorMsg("名称不能为空！");
                        errorList.add(businessplanningeffectdetailVO);
                        continue;
                    }
                    if(StringUtils.isEmpty(datas.get(2))) {
                        businessplanningeffectdetailVO.setErrorMsg("单位不能为空！");
                        errorList.add(businessplanningeffectdetailVO);
                        continue;
                    }
                    if(StringUtils.isEmpty(datas.get(3))) {
                        businessplanningeffectdetailVO.setErrorMsg("投标工程量不能为空！");
                        errorList.add(businessplanningeffectdetailVO);
                        continue;
                    }
                    if(StringUtils.isEmpty(datas.get(4))) {
                        businessplanningeffectdetailVO.setErrorMsg("建筑面积(m²)不能为空！");
                        errorList.add(businessplanningeffectdetailVO);
                        continue;
                    }
                    if(StringUtils.isEmpty(datas.get(5))) {
                        businessplanningeffectdetailVO.setErrorMsg("投标指标不能为空！");
                        errorList.add(businessplanningeffectdetailVO);
                        continue;
                    }
                    if(StringUtils.isEmpty(datas.get(6))) {
                        businessplanningeffectdetailVO.setErrorMsg("(计划成本)限额设计指标不能为空！");
                        errorList.add(businessplanningeffectdetailVO);
                        continue;
                    }*/
                    successList.add(businessplanningeffectdetailVO);
                }
            }
        }
        //设置tid和tpid
        List<BusinessplanningeffectdetailVO> resList = setTidAndTpid(successList);

        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", resList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

    /**
     * 设置tid和tpid
     * @param originalList
     * @return
     */
    private List<BusinessplanningeffectdetailVO> setTidAndTpid(List<BusinessplanningeffectdetailVO> originalList) {
        List<BusinessplanningeffectdetailVO> treeList = new ArrayList<>();
        String currentTime = String.valueOf(System.currentTimeMillis());
        if (originalList != null && originalList.size() > 0) {
            for (int i = 0; i < originalList.size(); i++) {
                BusinessplanningeffectdetailVO businessplanningeffectdetailVO = originalList.get(i);
                String sort = businessplanningeffectdetailVO.getSort();
                String[] arr = sort.split("\\.");

                if (arr.length == 1) {
                    businessplanningeffectdetailVO.setTid(currentTime + "_" + sort);
                    businessplanningeffectdetailVO.setTpid("");
                    treeList.add(businessplanningeffectdetailVO);
                } else if (arr.length > 1) {
                    businessplanningeffectdetailVO.setTid(currentTime + "_" + sort);
                    businessplanningeffectdetailVO.setTpid(currentTime + "_" + sort.substring(0, sort.length() - 2));
                    treeList.add(businessplanningeffectdetailVO);
                }
            }
        }
        return createTreeData(treeList);
    }

    /**
     * 构建树
     * @param list
     * @return
     */
    public static List<BusinessplanningeffectdetailVO> createTreeData(List<BusinessplanningeffectdetailVO> list) {
        List<BusinessplanningeffectdetailVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();

        //循环list，放入listMap重
        Map<String, BusinessplanningeffectdetailVO> listMap = new HashMap<>();
        for (BusinessplanningeffectdetailVO item : list) {
            listMap.put(item.getTid().toString(), item);
        }

        for (int i = 0; i < list.size(); i++) {
            BusinessplanningeffectdetailVO item = list.get(i);
            String parentId = (item.getTpid() != null) ? item.getTpid().toString() : "";
            BusinessplanningeffectdetailVO parent = listMap.get(parentId);
            if (parent != null) {
                List<BusinessplanningeffectdetailVO> child = (List<BusinessplanningeffectdetailVO>) parent.getChildren();
                if (child != null) {
                    child.add(item);
                } else {
                    List<BusinessplanningeffectdetailVO> children = new ArrayList<BusinessplanningeffectdetailVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getTid());
            }
        }

        for (String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }

    /**
     * excel导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportBusinessplanningeffectFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportbusinessplanningeffectFromDatabase(@RequestBody BusinessplanningeffectVO businessplanningeffectVO, HttpServletResponse response) {
        QueryWrapper<BusinessplanningeffectdetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", businessplanningeffectVO.getId());
        queryWrapper.eq("dr", 0);
        List<BusinessplanningeffectdetailEntity> list = businessplanningeffectdetailService.list(queryWrapper);
        List<BusinessplanningeffectdetailVO> resList = BeanMapper.mapList(list, BusinessplanningeffectdetailVO.class);

        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", handleSpecialField(resList));
        ExcelExport.getInstance().export("businessplanningeffect-export.xlsx", beans, response);
    }

    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportBusinessplanningeffectFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportbusinessplanningeffectFromPage(@RequestBody List<BusinessplanningeffectdetailVO> list, HttpServletResponse response) {
        List<BusinessplanningeffectdetailVO> concatList = new ArrayList<>();
        for (int i = 0; i < list.size(); i++) {
            BusinessplanningeffectdetailVO businessplanningeffectdetailVO = list.get(i);
            concatList.add(businessplanningeffectdetailVO);
        }

        //children拍平
        List<BusinessplanningeffectdetailVO> allList = handleList(list, concatList);
        //按序号排序
        Collections.sort(allList, new Comparator<BusinessplanningeffectdetailVO>() {
            @Override
            public int compare(BusinessplanningeffectdetailVO o1, BusinessplanningeffectdetailVO o2) {
                return o1.getSort().compareTo(o2.getSort());
            }
        });

        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", handleSpecialField(allList));
        ExcelExport.getInstance().export("businessplanningeffect-export.xlsx", beans, response);
    }

    /**
     * 处理特殊字段 如：日期
     * @param allList
     */
    private List<BusinessplanningeffectdetailVO> handleSpecialField(List<BusinessplanningeffectdetailVO> allList) {
        //处理日期字段
        for (int i = 0; i < allList.size(); i++) {
            BusinessplanningeffectdetailVO businessplanningeffectdetailVO = allList.get(i);
            if (businessplanningeffectdetailVO.getCompleteTime()!=null){
                businessplanningeffectdetailVO.setCompleteTimeShow(DateUtils.dateSimple(businessplanningeffectdetailVO.getCompleteTime()));
            }
            if (businessplanningeffectdetailVO.getInitiateDate()!=null){
                businessplanningeffectdetailVO.setLxDateShow(DateUtils.dateSimple(businessplanningeffectdetailVO.getInitiateDate()));
            }
            if (businessplanningeffectdetailVO.getProposedCompleteTime()!=null){
                businessplanningeffectdetailVO.setProposedCompleteTimeShow(DateUtils.dateSimple(businessplanningeffectdetailVO.getProposedCompleteTime()));
            }
            if (businessplanningeffectdetailVO.getFinalCompleteTime()!=null){
                businessplanningeffectdetailVO.setFinalCompleteTimeShow(DateUtils.dateSimple(businessplanningeffectdetailVO.getFinalCompleteTime()));
            }
            if (businessplanningeffectdetailVO.getSupervisionNotReportedTime()!=null){
                businessplanningeffectdetailVO.setSupervisionNotReportedTimeShow(DateUtils.dateSimple(businessplanningeffectdetailVO.getSupervisionNotReportedTime()));
            }
            if (businessplanningeffectdetailVO.getSupervisionReportedTime()!=null){
                businessplanningeffectdetailVO.setSupervisionReportedTimeShow(DateUtils.dateSimple(businessplanningeffectdetailVO.getSupervisionReportedTime()));
            }
            if (businessplanningeffectdetailVO.getSupervisionApprovedTime()!=null){
                businessplanningeffectdetailVO.setSupervisionApprovedTimeShow(DateUtils.dateSimple(businessplanningeffectdetailVO.getSupervisionApprovedTime()));
            }
            if (businessplanningeffectdetailVO.getOwnerNotReportedTime()!=null){
                businessplanningeffectdetailVO.setOwnerNotReportedTimeShow(DateUtils.dateSimple(businessplanningeffectdetailVO.getOwnerNotReportedTime()));
            }
            if (businessplanningeffectdetailVO.getOwnerReportedTime()!=null){
                businessplanningeffectdetailVO.setOwnerReportedTimeShow(DateUtils.dateSimple(businessplanningeffectdetailVO.getOwnerReportedTime()));
            }
            if (businessplanningeffectdetailVO.getOwnerApprovedTime()!=null){
                businessplanningeffectdetailVO.setOwnerApprovedTimeShow(DateUtils.dateSimple(businessplanningeffectdetailVO.getOwnerApprovedTime()));
            }
        }

        return allList;
    }

    /**
     * 导出页面数据处理children
     * @param list
     */
    private List<BusinessplanningeffectdetailVO> handleList(List<BusinessplanningeffectdetailVO> list, List<BusinessplanningeffectdetailVO> concatList) {
        if(list == null || list.size() == 0){
            return concatList;
        }

        for (int i = 0; i < list.size(); i++) {
            BusinessplanningeffectdetailVO businessplanningeffectdetailVO = list.get(i);
            List<BusinessplanningeffectdetailVO> children = businessplanningeffectdetailVO.getChildren();
            if (children != null && children.size() > 0) {
                concatList.addAll(children);
                handleList(children, concatList);
            }
        }

        return concatList;
    }
}
