package com.ejianc.business.change.controller;

import java.io.Serializable;

import com.ejianc.business.busniessplan.bean.*;
import com.ejianc.business.busniessplan.service.ISubpackageService;
import com.ejianc.business.change.bean.ChangesubpackageEntity;
import com.ejianc.business.change.service.IChangesubpackageService;
import com.ejianc.business.change.vo.*;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;



/**
 * 分包分供管理策划变更
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("changesubpackage")
public class ChangesubpackageController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IChangesubpackageService service;
    @Autowired
    private ISubpackageService subpackageService;

    /**
     * 初始化更详情页面
     *
     * @param id
     * @return
     */
    @GetMapping(value = "queryDetailBySubpackageId")
    @ResponseBody
    public CommonResponse<ChangesubpackageVO> queryDetailBySubpackageId(@RequestParam(value = "subpackageId") Long subpackageId) {
        SubpackageEntity subpackageVO = subpackageService.selectById(subpackageId);
        ChangesubpackageVO changeVO = BeanMapper.map(subpackageVO, ChangesubpackageVO.class);
        Long id = IdWorker.getId();
        changeVO.setSubpackageId(subpackageId);
        changeVO.setBillState(null);
        changeVO.setCreateTime(null);
        changeVO.setCreateUserCode(null);
        changeVO.setTenantId(null);
        changeVO.setUpdateTime(null);
        changeVO.setUpdateUserCode(null);
        changeVO.setId(id);

        //分包子表
        List<SubpackagepackgedetailEntity> subpackagepackgedetailList = subpackageVO.getSubpackagepackagedetailEntities();
        if(subpackagepackgedetailList!=null&&subpackagepackgedetailList.size()>0){
            List<ChangesubpackagedetaillVO> changesubpackagedetaillVO = new ArrayList<>();
            for(SubpackagepackgedetailEntity entity : subpackagepackgedetailList){
                ChangesubpackagedetaillVO vo = BeanMapper.map(entity, ChangesubpackagedetaillVO.class);
                vo.setMid(id);
                vo.setCreateTime(null);
                vo.setCreateUserCode(null);
                vo.setTenantId(null);
                vo.setUpdateTime(null);
                vo.setUpdateUserCode(null);
                vo.setRowState("edit");
                vo.setId(IdWorker.getId());
                changesubpackagedetaillVO.add(vo);
            }
            changeVO.setSubpackagepackagedetailEntities(changesubpackagedetaillVO);
        }
        //分供子表
        List<SubpackagesupplydetailEntity> subpackagesupplydetailList = subpackageVO.getSubpackagesupplydetailEntities();
        if(subpackagesupplydetailList!=null&&subpackagesupplydetailList.size()>0){
            List<ChangesubpackagesupplydetailVO> changesubpackagesupplydetailVO = new ArrayList<>();
            for(SubpackagesupplydetailEntity entity : subpackagesupplydetailList){
                ChangesubpackagesupplydetailVO vo = BeanMapper.map(entity, ChangesubpackagesupplydetailVO.class);
                vo.setMid(id);
                vo.setCreateTime(null);
                vo.setCreateUserCode(null);
                vo.setTenantId(null);
                vo.setUpdateTime(null);
                vo.setUpdateUserCode(null);
                vo.setRowState("edit");
                vo.setId(IdWorker.getId());
                changesubpackagesupplydetailVO.add(vo);
            }
            List<ChangesubpackagesupplydetailVO> resChangebusinessplaneffectdetail = createTreeData(changesubpackagesupplydetailVO);
            changeVO.setSubpackagesupplydetailEntities(resChangebusinessplaneffectdetail);
        }

        return CommonResponse.success("查询详情成功！", changeVO);

    }
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveChange", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ChangesubpackageVO> saveOrUpdate(@RequestBody ChangesubpackageVO saveOrUpdateVO) {
        return service.saveChange(saveOrUpdateVO);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ChangesubpackageVO> queryDetail(Long id) {
    	ChangesubpackageEntity entity = service.selectById(id);
    	ChangesubpackageVO vo = BeanMapper.map(entity, ChangesubpackageVO.class);

        List<ChangesubpackagesupplydetailVO> changesubpackagesupplydetailVO = createTreeData(vo.getSubpackagesupplydetailEntities());
        vo.setSubpackagesupplydetailEntities(changesubpackagesupplydetailVO);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ChangesubpackageVO> vos) {
        return service.delete(vos);
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ChangesubpackageVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<ChangesubpackageEntity> page = service.queryPage(param,false);
        IPage<ChangesubpackageVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ChangesubpackageVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ChangesubpackageEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Changesubpackage-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refChangesubpackageData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ChangesubpackageVO>> refChangesubpackageData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ChangesubpackageEntity> page = service.queryPage(param,false);
        IPage<ChangesubpackageVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ChangesubpackageVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    public static List<ChangesubpackagesupplydetailVO> createTreeData(List<ChangesubpackagesupplydetailVO> list) {
        List<ChangesubpackagesupplydetailVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();

        //循环list，放入listMap重
        Map<String, ChangesubpackagesupplydetailVO> listMap = new HashMap<>();
        for(ChangesubpackagesupplydetailVO item:list) {
            listMap.put(item.getTid().toString(), item);
        }

        for(int i =0; i<list.size(); i++) {
            ChangesubpackagesupplydetailVO item = list.get(i);
            String parentId = (item.getTpid() != null) ? item.getTpid().toString():"";
            ChangesubpackagesupplydetailVO parent = listMap.get(parentId);
            if(parent != null) {
                List<ChangesubpackagesupplydetailVO> child = (List<ChangesubpackagesupplydetailVO>) parent.getChildren();
                if(child != null) {
                    child.add(item);
                }else{
                    List<ChangesubpackagesupplydetailVO> children = new ArrayList<ChangesubpackagesupplydetailVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getTid());
            }
        }

        for(String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }
}
