package com.ejianc.business.change.excel;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.busniessplan.bean.BusinessplanningeffectdetailEntity;
import com.ejianc.business.busniessplan.service.IBusinessplanningeffectdetailService;
import com.ejianc.business.busniessplan.vo.BusinessplanningeffectVO;
import com.ejianc.business.busniessplan.vo.BusinessplanningeffectdetailVO;
import com.ejianc.business.change.bean.ChangebusinessplaneffectdetailEntity;
import com.ejianc.business.change.service.IChangebusinessplaneffectdetailService;
import com.ejianc.business.change.vo.ChangebusinessplaneffectdetailVO;
import com.ejianc.business.utils.DateUtils;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 項目商務策劃效果導入導出
 */
@Controller
@RequestMapping("changeBusinessplanningeffectExport")
public class ExcelChangeBusinessplaneffectController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IChangebusinessplaneffectdetailService changebusinessplaneffectdetailService;

    /**
     * 导入模板下载
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadBusinessplanningeffect")
    @ResponseBody
    public void downloadTotalPrice(HttpServletRequest request, HttpServletResponse response){
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "businessplanningeffect-import.xlsx", "项目商务策划立项清单模板");
    }

    /**
     * excel导入
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelImportBusinessplanningeffect", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportTotalPric(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<ChangebusinessplaneffectdetailVO> successList = new ArrayList<>();
        List<ChangebusinessplaneffectdetailVO> errorList = new ArrayList<>();
        DateFormat sdf=new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if(isFailed) {
            return CommonResponse.error("文件格式不合法");
        }else{
            List<List<String>> result = ExcelReader.readExcel(mf);
            if(result != null && result.size() > 0) {
                for(int i=3;i<result.size();i++) {
                    List<String> datas = result.get(i);
                    ChangebusinessplaneffectdetailVO changebusinessplaneffectdetailVO = new ChangebusinessplaneffectdetailVO();
                    changebusinessplaneffectdetailVO.setId(IdWorker.getId());//id
                    changebusinessplaneffectdetailVO.setSort(datas.get(0)); // 序号
                    changebusinessplaneffectdetailVO.setCategoryAndName(StringUtils.isNotBlank(datas.get(1))?datas.get(1):null); // 类别及项目名称
                    changebusinessplaneffectdetailVO.setInitiateReason(StringUtils.isNotBlank(datas.get(2))?datas.get(2):null); // 立项理由及依据
                    changebusinessplaneffectdetailVO.setInitiateDate(StringUtils.isNotBlank(datas.get(3))? DateUtils.Date(datas.get(3)):null); // 立项时间
                    //System.out.println("时间打印："+datas.get(3));
                    changebusinessplaneffectdetailVO.setCostEstimate(StringUtils.isNotBlank(datas.get(4))?new BigDecimal(datas.get(4)):null); // 成本估算(成本分析)(元)
                    changebusinessplaneffectdetailVO.setReportAmount(StringUtils.isNotBlank(datas.get(5))?new BigDecimal(datas.get(5)):null); // 上报金额(元)
                    changebusinessplaneffectdetailVO.setTargetAmount(StringUtils.isNotBlank(datas.get(6))?new BigDecimal(datas.get(6)):null); // 策划目标金额(元)
                    changebusinessplaneffectdetailVO.setCompleteAmount(StringUtils.isNotBlank(datas.get(7))?new BigDecimal(datas.get(7)):null); // 已完成目标金额(元)
                    changebusinessplaneffectdetailVO.setEstimateProfits(StringUtils.isNotBlank(datas.get(8))?new BigDecimal(datas.get(8)):null); // 预计利润(元)
                    changebusinessplaneffectdetailVO.setProposedCompleteTime(StringUtils.isNotBlank(datas.get(9))?DateUtils.Date(datas.get(9)):null); // 拟完成时间节点
                    changebusinessplaneffectdetailVO.setCompleteTime(StringUtils.isNotBlank(datas.get(10))?DateUtils.Date(datas.get(10)):null); // 完成时间
                    changebusinessplaneffectdetailVO.setSupportingDetails(StringUtils.isNotBlank(datas.get(11))?datas.get(11):null); // 证明资料明细
                    changebusinessplaneffectdetailVO.setReportToThismonthProgress(StringUtils.isNotBlank(datas.get(12))?new BigDecimal(datas.get(12)):null); // 报公司截至本月进度(元)
                    changebusinessplaneffectdetailVO.setFirstResponsiblePerson(StringUtils.isNotBlank(datas.get(13))?datas.get(13):null); // 第一责任人
                    changebusinessplaneffectdetailVO.setMainResponsiblePerson(StringUtils.isNotBlank(datas.get(14))?datas.get(14):null); // 主要负责人
                    changebusinessplaneffectdetailVO.setFinalCompleteTime(StringUtils.isNotBlank(datas.get(15))?DateUtils.Date(datas.get(15)):null); // (最后)完成时间
                    changebusinessplaneffectdetailVO.setAttention(StringUtils.isNotBlank(datas.get(16))?datas.get(16):null); // 推荐情况、存在问题、注意事项
                    changebusinessplaneffectdetailVO.setSupervisionNotReportedMoney(StringUtils.isNotBlank(datas.get(17))?new BigDecimal(datas.get(17)):null); // 监理未上报金额
                    changebusinessplaneffectdetailVO.setSupervisionNotReportedTime(StringUtils.isNotBlank(datas.get(18))?DateUtils.Date(datas.get(18)):null); // 监理未上报预计上报时间
                    changebusinessplaneffectdetailVO.setSupervisionReportedMoney(StringUtils.isNotBlank(datas.get(19))?new BigDecimal(datas.get(19)):null); // 监理已上报未批复金额
                    changebusinessplaneffectdetailVO.setSupervisionReportedTime(StringUtils.isNotBlank(datas.get(20))?DateUtils.Date(datas.get(20)):null); // 监理已上报未批复上报时间
                    changebusinessplaneffectdetailVO.setSupervisionApprovedMoney(StringUtils.isNotBlank(datas.get(21))?new BigDecimal(datas.get(21)):null); // 监理已批复金额
                    changebusinessplaneffectdetailVO.setSupervisionApprovedTime(StringUtils.isNotBlank(datas.get(22))?DateUtils.Date(datas.get(22)):null); // 监理已批复上报时间
                    changebusinessplaneffectdetailVO.setOwnerNotReportedMoney(StringUtils.isNotBlank(datas.get(23))?new BigDecimal(datas.get(23)):null); // 业主未上报金额
                    changebusinessplaneffectdetailVO.setOwnerNotReportedTime(StringUtils.isNotBlank(datas.get(24))?DateUtils.Date(datas.get(24)):null); // 业主未上报预计上报时间
                    changebusinessplaneffectdetailVO.setOwnerReportedMoney(StringUtils.isNotBlank(datas.get(25))?new BigDecimal(datas.get(25)):null); // 业主已上报未批复金额
                    changebusinessplaneffectdetailVO.setOwnerReportedTime(StringUtils.isNotBlank(datas.get(26))?DateUtils.Date(datas.get(26)):null); // 业主已上报未批复上报时间
                    changebusinessplaneffectdetailVO.setOwnerApprovedMoney(StringUtils.isNotBlank(datas.get(27))?new BigDecimal(datas.get(27)):null); // 业主已批复金额
                    changebusinessplaneffectdetailVO.setOwnerApprovedTime(StringUtils.isNotBlank(datas.get(28))?DateUtils.Date(datas.get(28)):null); // 业主已批复上报时间
                    changebusinessplaneffectdetailVO.setApprovedMoney(StringUtils.isNotBlank(datas.get(29))?new BigDecimal(datas.get(29)):null); // 已批复金额
                    changebusinessplaneffectdetailVO.setPricedMoney(StringUtils.isNotBlank(datas.get(30))?new BigDecimal(datas.get(30)):null); // 已计价金额
                    changebusinessplaneffectdetailVO.setPricedActualMoney(StringUtils.isNotBlank(datas.get(31))?new BigDecimal(datas.get(31)):null); // 已计价部分实际金额
                    changebusinessplaneffectdetailVO.setPricedPartBenefit(StringUtils.isNotBlank(datas.get(32))?new BigDecimal(datas.get(32)):null); // 已计价部分的效益
                    changebusinessplaneffectdetailVO.setRemarks(StringUtils.isNotBlank(datas.get(33))?datas.get(33):null); // 备注

                    successList.add(changebusinessplaneffectdetailVO);
                }
            }
        }
        //设置tid和tpid
        List<ChangebusinessplaneffectdetailVO> resList = setTidAndTpid(successList);

        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", resList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

    /**
     * 设置tid和tpid
     * @param originalList
     * @return
     */
    private List<ChangebusinessplaneffectdetailVO> setTidAndTpid(List<ChangebusinessplaneffectdetailVO> originalList) {
        List<ChangebusinessplaneffectdetailVO> treeList = new ArrayList<>();
        String currentTime = String.valueOf(System.currentTimeMillis());
        if (originalList != null && originalList.size() > 0) {
            for (int i = 0; i < originalList.size(); i++) {
                ChangebusinessplaneffectdetailVO changebusinessplaneffectdetailVO = originalList.get(i);
                String sort = changebusinessplaneffectdetailVO.getSort();
                String[] arr = sort.split("\\.");

                if (arr.length == 1) {
                    changebusinessplaneffectdetailVO.setTid(currentTime + "_" + sort);
                    changebusinessplaneffectdetailVO.setTpid("");
                    changebusinessplaneffectdetailVO.setShadowId(currentTime + "_" + sort);
                    treeList.add(changebusinessplaneffectdetailVO);
                } else if (arr.length > 1) {
                    changebusinessplaneffectdetailVO.setTid(currentTime + "_" + sort);
                    changebusinessplaneffectdetailVO.setShadowId(currentTime + "_" + sort);
                    changebusinessplaneffectdetailVO.setTpid(currentTime + "_" + sort.substring(0, sort.length() - 2));
                    treeList.add(changebusinessplaneffectdetailVO);
                }
            }
        }
        return createTreeData(treeList);
    }

    /**
     * 构建树
     * @param list
     * @return
     */
    public static List<ChangebusinessplaneffectdetailVO> createTreeData(List<ChangebusinessplaneffectdetailVO> list) {
        List<ChangebusinessplaneffectdetailVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();

        //循环list，放入listMap重
        Map<String, ChangebusinessplaneffectdetailVO> listMap = new HashMap<>();
        for (ChangebusinessplaneffectdetailVO item : list) {
            listMap.put(item.getTid().toString(), item);
        }

        for (int i = 0; i < list.size(); i++) {
            ChangebusinessplaneffectdetailVO item = list.get(i);
            String parentId = (item.getTpid() != null) ? item.getTpid().toString() : "";
            ChangebusinessplaneffectdetailVO parent = listMap.get(parentId);
            if (parent != null) {
                List<ChangebusinessplaneffectdetailVO> child = (List<ChangebusinessplaneffectdetailVO>) parent.getChildren();
                if (child != null) {
                    child.add(item);
                } else {
                    List<ChangebusinessplaneffectdetailVO> children = new ArrayList<ChangebusinessplaneffectdetailVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getTid());
            }
        }

        for (String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }

    /**
     * excel导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportBusinessplanningeffectFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportbusinessplanningeffectFromDatabase(@RequestBody ChangebusinessplaneffectdetailVO changebusinessplaneffectdetailVO, HttpServletResponse response) {
        QueryWrapper<ChangebusinessplaneffectdetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", changebusinessplaneffectdetailVO.getId());
        queryWrapper.eq("dr", 0);
        List<ChangebusinessplaneffectdetailEntity> list = changebusinessplaneffectdetailService.list(queryWrapper);
        List<ChangebusinessplaneffectdetailVO> resList = BeanMapper.mapList(list, ChangebusinessplaneffectdetailVO.class);

        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", handleSpecialField(resList));
        ExcelExport.getInstance().export("businessplanningeffect-export.xlsx", beans, response);
    }

    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportBusinessplanningeffectFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportbusinessplanningeffectFromPage(@RequestBody List<ChangebusinessplaneffectdetailVO> list, HttpServletResponse response) {
        List<ChangebusinessplaneffectdetailVO> concatList = new ArrayList<>();
        for (int i = 0; i < list.size(); i++) {
            ChangebusinessplaneffectdetailVO changebusinessplaneffectdetailVO = list.get(i);
            concatList.add(changebusinessplaneffectdetailVO);
        }

        //children拍平
        List<ChangebusinessplaneffectdetailVO> allList = handleList(list, concatList);
        //按序号排序
        Collections.sort(allList, new Comparator<ChangebusinessplaneffectdetailVO>() {
            @Override
            public int compare(ChangebusinessplaneffectdetailVO o1, ChangebusinessplaneffectdetailVO o2) {
                return o1.getSort().compareTo(o2.getSort());
            }
        });

        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", handleSpecialField(allList));
        ExcelExport.getInstance().export("businessplanningeffect-export.xlsx", beans, response);
    }

    /**
     * 处理特殊字段 如：日期
     * @param allList
     */
    private List<ChangebusinessplaneffectdetailVO> handleSpecialField(List<ChangebusinessplaneffectdetailVO> allList) {
        //处理日期字段
        for (int i = 0; i < allList.size(); i++) {
            ChangebusinessplaneffectdetailVO businessplanningeffectdetailVO = allList.get(i);
            if (businessplanningeffectdetailVO.getCompleteTime()!=null){
                businessplanningeffectdetailVO.setCompleteTimeShow(DateUtils.dateSimple(businessplanningeffectdetailVO.getCompleteTime()));
            }
            if (businessplanningeffectdetailVO.getInitiateDate()!=null){
                businessplanningeffectdetailVO.setLxDateShow(DateUtils.dateSimple(businessplanningeffectdetailVO.getInitiateDate()));
            }
            if (businessplanningeffectdetailVO.getProposedCompleteTime()!=null){
                businessplanningeffectdetailVO.setProposedCompleteTimeShow(DateUtils.dateSimple(businessplanningeffectdetailVO.getProposedCompleteTime()));
            }
            if (businessplanningeffectdetailVO.getFinalCompleteTime()!=null){
                businessplanningeffectdetailVO.setFinalCompleteTimeShow(DateUtils.dateSimple(businessplanningeffectdetailVO.getFinalCompleteTime()));
            }
            if (businessplanningeffectdetailVO.getSupervisionNotReportedTime()!=null){
                businessplanningeffectdetailVO.setSupervisionNotReportedTimeShow(DateUtils.dateSimple(businessplanningeffectdetailVO.getSupervisionNotReportedTime()));
            }
            if (businessplanningeffectdetailVO.getSupervisionReportedTime()!=null){
                businessplanningeffectdetailVO.setSupervisionReportedTimeShow(DateUtils.dateSimple(businessplanningeffectdetailVO.getSupervisionReportedTime()));
            }
            if (businessplanningeffectdetailVO.getSupervisionApprovedTime()!=null){
                businessplanningeffectdetailVO.setSupervisionApprovedTimeShow(DateUtils.dateSimple(businessplanningeffectdetailVO.getSupervisionApprovedTime()));
            }
            if (businessplanningeffectdetailVO.getOwnerNotReportedTime()!=null){
                businessplanningeffectdetailVO.setOwnerNotReportedTimeShow(DateUtils.dateSimple(businessplanningeffectdetailVO.getOwnerNotReportedTime()));
            }
            if (businessplanningeffectdetailVO.getOwnerReportedTime()!=null){
                businessplanningeffectdetailVO.setOwnerReportedTimeShow(DateUtils.dateSimple(businessplanningeffectdetailVO.getOwnerReportedTime()));
            }
            if (businessplanningeffectdetailVO.getOwnerApprovedTime()!=null){
                businessplanningeffectdetailVO.setOwnerApprovedTimeShow(DateUtils.dateSimple(businessplanningeffectdetailVO.getOwnerApprovedTime()));
            }
        }

        return allList;
    }

    /**
     * 导出页面数据处理children
     * @param list
     */
    private List<ChangebusinessplaneffectdetailVO> handleList(List<ChangebusinessplaneffectdetailVO> list, List<ChangebusinessplaneffectdetailVO> concatList) {
        if(list == null || list.size() == 0){
            return concatList;
        }

        for (int i = 0; i < list.size(); i++) {
            ChangebusinessplaneffectdetailVO changebusinessplaneffectdetailVO = list.get(i);
            List<ChangebusinessplaneffectdetailVO> children = changebusinessplaneffectdetailVO.getChildren();
            if (children != null && children.size() > 0) {
                concatList.addAll(children);
                handleList(children, concatList);
            }
        }

        return concatList;
    }
}
