package com.ejianc.business.change.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.busniessplan.bean.FundsplanningEntity;
import com.ejianc.business.busniessplan.bean.FundsplanningdetailEntity;
import com.ejianc.business.busniessplan.service.IFundsplanningService;
import com.ejianc.business.change.bean.ChangeFundsplanningEntity;
import com.ejianc.business.change.service.IChangeFundsplanningService;
import com.ejianc.business.record.bean.RecordFundsplanningEntity;
import com.ejianc.business.record.bean.RecordFundsplanningdetailEntity;
import com.ejianc.business.record.service.IRecordFundsplanningService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.support.idworker.util.IdWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service("changeFundsplanning") 
public class ChangeFundsplanningBpmServiceImpl implements ICommonBusinessService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());

	//业务类型
	private static final String Fundsplanning = "zjkj-fundsplanning";//项目商务策划立项
	private static final String Fundsplanning_CHANGE = "zjkj-fundsplanningChange";//项目商务策划立项变更
	private static final String Fundsplanning_RECORD = "zjkj-fundsplanningRecord";//项目商务策划立项变更记录

	//单据类型
	private static final String Fundsplanning_BILLTYPE_CODE = "BT202202000016";//项目商务策划立项
	private static final String Fundsplanning_CHANGE_BILLTYPE_CODE = "BT202203000061";//项目商务策划立项变更
	private static final String Fundsplanning_RECORD_BILLTYPE_CODE = "BT202202000016";//项目商务策划立项变更记录

	@Autowired
	private IAttachmentApi attachmentApi;
	@Autowired
	private IChangeFundsplanningService changeFundsplanningService;
	@Autowired
	private IFundsplanningService fundsplanningService;
	@Autowired
	private IRecordFundsplanningService recordFundsplanningService;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		//TODO
		//1、获取目前单据信息、变更信息
		ChangeFundsplanningEntity changeFundsplanningEntity = changeFundsplanningService.selectById(billId);
		logger.info("变更单主表id=" + changeFundsplanningEntity.getFundsplanningId());
		FundsplanningEntity fundsplanningEntity = fundsplanningService.selectById(changeFundsplanningEntity.getFundsplanningId());
		logger.info("主单据id=" + changeFundsplanningEntity.getId() + "主单据创建人" + changeFundsplanningEntity.getCreateUserCode());

		//获取历史版本条数
		QueryWrapper<RecordFundsplanningEntity> recordWrapper = new QueryWrapper<>();
		recordWrapper.eq("fundsplanning_id", fundsplanningEntity.getId());
		recordWrapper.eq("dr", 0);
		Integer count = recordFundsplanningService.count(recordWrapper);

		logger.info("---------给变更记录表赋值--------");
		RecordFundsplanningEntity recordFundsplanningEntity = BeanMapper.map(fundsplanningEntity, RecordFundsplanningEntity.class);
		Long recordId = IdWorker.getId();
		this.clearBaseData(recordFundsplanningEntity);
		recordFundsplanningEntity.setBillState(null);
		recordFundsplanningEntity.setProjectId(fundsplanningEntity.getId());
		recordFundsplanningEntity.setProjectName(fundsplanningEntity.getBillCode()+"-"+(count+1));
		recordFundsplanningEntity.setId(recordId);
		recordFundsplanningEntity.setBillCode(fundsplanningEntity.getBillCode());
		recordFundsplanningEntity.setChangeReason(fundsplanningEntity.getChangeReason());
		recordFundsplanningEntity.setEffectTime(new Date());

		logger.info("---------给变更记录子表赋值--------");
		List<FundsplanningdetailEntity> fundsplanningdetailEntities = fundsplanningEntity.getFundsplanningdetailEntities();
		if(fundsplanningdetailEntities!=null&&fundsplanningdetailEntities.size()>0){
			List<RecordFundsplanningdetailEntity> recordPlanprojectdetailEntity = new ArrayList<>();
			for(FundsplanningdetailEntity entity : fundsplanningdetailEntities){
				RecordFundsplanningdetailEntity reEntity = BeanMapper.map(entity, RecordFundsplanningdetailEntity.class);
				this.clearBaseData(reEntity);
				reEntity.setMid(recordId);
				recordPlanprojectdetailEntity.add(reEntity);
				entity.setRowState("del");
			}
			recordFundsplanningEntity.setRecordFundsplanningdetailEntities(recordPlanprojectdetailEntity);
		}
		logger.info("---------赋值附件信息--------");
		//复制附件信息到记录中
		String sourceBillType = "";
		//原单据类型
		sourceBillType = Fundsplanning_BILLTYPE_CODE;
		String targetBillType = "";
		//变更记录单剧类型
		targetBillType = Fundsplanning_RECORD_BILLTYPE_CODE;

		attachmentApi.copyFilesFromSourceBillToTargetBill(fundsplanningEntity.getId().toString(), sourceBillType, Fundsplanning , recordId.toString(), targetBillType, Fundsplanning_RECORD);
		recordFundsplanningService.saveOrUpdate(recordFundsplanningEntity, false);

		logger.info("---------修改当前单据状态--------");
		logger.info("创建人=" + fundsplanningEntity.getCreateUserCode());
		//3、修改当前单据状态
		FundsplanningEntity newFundsplanningEntity = BeanMapper.map(fundsplanningEntity, FundsplanningEntity.class);
		newFundsplanningEntity.setChangeState("3");//状态改为已变更
		newFundsplanningEntity.setChangeId(null);
		newFundsplanningEntity.setBillState(fundsplanningEntity.getBillState());
		newFundsplanningEntity.setId(fundsplanningEntity.getId());
		newFundsplanningEntity.setCreateTime(fundsplanningEntity.getCreateTime());
		newFundsplanningEntity.setCreateUserCode(fundsplanningEntity.getCreateUserCode());
		newFundsplanningEntity.setTenantId(fundsplanningEntity.getTenantId());
		newFundsplanningEntity.setVersion(fundsplanningEntity.getVersion());

		logger.info("---------处理子表变更--------");
		//子表
		//处理子表变更
		List<FundsplanningdetailEntity> fundsplanningdetailEntityList = fundsplanningEntity.getFundsplanningdetailEntities();
		if(fundsplanningdetailEntityList!=null&&fundsplanningdetailEntityList.size()>0){
			List<FundsplanningdetailEntity> newQuotaanalysisdetailList = BeanMapper.mapList(fundsplanningdetailEntityList, FundsplanningdetailEntity.class);
			newQuotaanalysisdetailList.addAll(fundsplanningdetailEntities);
			newFundsplanningEntity.setFundsplanningdetailEntities(newQuotaanalysisdetailList);
		}
		logger.info("---------保存--------");
		fundsplanningService.saveOrUpdate(newFundsplanningEntity, false);

		sourceBillType = Fundsplanning_CHANGE_BILLTYPE_CODE;
		targetBillType = Fundsplanning_BILLTYPE_CODE;

		attachmentApi.copyFilesFromSourceBillToTargetBill(fundsplanningEntity.getId().toString(), sourceBillType, Fundsplanning_CHANGE, fundsplanningEntity.getId().toString(), targetBillType, Fundsplanning);
		recordFundsplanningService.saveOrUpdate(recordFundsplanningEntity, false);

		logger.info("---------结束--------");

		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	public void clearBaseData(BaseEntity entity){
		entity.setCreateTime(null);
		entity.setCreateUserCode(null);
		entity.setTenantId(null);
		entity.setUpdateTime(null);
		entity.setUpdateUserCode(null);
	}
}
