package com.ejianc.business.change.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.busniessplan.bean.CountersignatureEntity;
import com.ejianc.business.busniessplan.service.ICountersignatureService;
import com.ejianc.business.change.bean.ChangecountersignatureEntity;
import com.ejianc.business.change.service.IChangecountersignatureService;
import com.ejianc.business.record.bean.RecordcountersignatureEntity;
import com.ejianc.business.record.service.IRecordcountersignatureService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.support.idworker.util.IdWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.Date;

@Service("changecountersignature") 
public class ChangecountersignatureBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	//业务类型
	private static final String Countersignatur = "zjkj-countersignature";//商务策划会签
	private static final String Countersignatur_CHANGE = "zjkj-countersignatureChange";//商务策划会签变更
	private static final String Countersignatur_RECORD = "zjkj-countersignatureRecord";//商务策划会签变更记录

	//单据类型
	private static final String Countersignatur_BILLTYPE_CODE = "BT202202000018";//商务策划会签
	private static final String Countersignatur_CHANGE_BILLTYPE_CODE = "BT202202000059";//商务策划会签变更
	private static final String Countersignatur_RECORD_BILLTYPE_CODE = "BT202202000064";//商务策划会签变更记录

	@Autowired
	private IAttachmentApi attachmentApi;
	@Autowired
	private IChangecountersignatureService changecountersignatureService;
	@Autowired
	private ICountersignatureService countersignatureService;
	@Autowired
	private IRecordcountersignatureService recordcountersignatureService;
	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		//TODO
		//1、获取目前单据信息、变更信息
		ChangecountersignatureEntity changeEntity = changecountersignatureService.selectById(billId);
		logger.info("变更单主表id=" + changeEntity.getCountersignatureId());
		CountersignatureEntity countersignatureEntity = countersignatureService.selectById(changeEntity.getCountersignatureId());
		logger.info("主单据id=" + changeEntity.getId() + "主单据创建人" + changeEntity.getCreateUserCode());

		//获取历史版本条数
		QueryWrapper<RecordcountersignatureEntity> recordWrapper = new QueryWrapper<>();
		recordWrapper.eq("countersignature_id", countersignatureEntity.getId());
		recordWrapper.eq("dr", 0);
		Integer count = recordcountersignatureService.count(recordWrapper);

		logger.info("---------给变更记录表赋值--------");
		RecordcountersignatureEntity recordcountersignatureEntity = BeanMapper.map(countersignatureEntity, RecordcountersignatureEntity.class);
		Long recordId = IdWorker.getId();
		this.clearBaseData(recordcountersignatureEntity);
		recordcountersignatureEntity.setBillState(null);
		recordcountersignatureEntity.setCountersignatureId(countersignatureEntity.getId());
		recordcountersignatureEntity.setCountersignatureCode(countersignatureEntity.getBillCode()+"-"+(count+1));
		recordcountersignatureEntity.setId(recordId);
		recordcountersignatureEntity.setBillCode(countersignatureEntity.getBillCode());
		recordcountersignatureEntity.setChangeReason(changeEntity.getChangeReason());
		recordcountersignatureEntity.setEffectTime(new Date());

		logger.info("---------赋值附件信息--------");
		//复制附件信息到记录中
		String sourceBillType = "";
		//原单据类型
		sourceBillType = Countersignatur_BILLTYPE_CODE;
		String targetBillType = "";
		//变更记录单剧类型
		targetBillType = Countersignatur_RECORD_BILLTYPE_CODE;

		attachmentApi.copyFilesFromSourceBillToTargetBill(countersignatureEntity.getId().toString(), sourceBillType, Countersignatur , recordId.toString(), targetBillType, Countersignatur_RECORD);
		recordcountersignatureService.saveOrUpdate(recordcountersignatureEntity, false);

		logger.info("---------修改当前单据状态--------");
		logger.info("创建人=" + countersignatureEntity.getCreateUserCode());
		//3、修改当前单据状态
		CountersignatureEntity newCountersignatureEntity = BeanMapper.map(changeEntity, CountersignatureEntity.class);
		newCountersignatureEntity.setChangeState("3");//状态改为已变更
		newCountersignatureEntity.setChangeId(null);
		newCountersignatureEntity.setBillState(countersignatureEntity.getBillState());
		newCountersignatureEntity.setId(countersignatureEntity.getId());
		newCountersignatureEntity.setCreateTime(countersignatureEntity.getCreateTime());
		newCountersignatureEntity.setCreateUserCode(countersignatureEntity.getCreateUserCode());
		newCountersignatureEntity.setTenantId(countersignatureEntity.getTenantId());
		newCountersignatureEntity.setVersion(countersignatureEntity.getVersion());

		logger.info("---------保存--------");
		countersignatureService.saveOrUpdate(newCountersignatureEntity, false);

		sourceBillType = Countersignatur_CHANGE_BILLTYPE_CODE;
		targetBillType = Countersignatur_BILLTYPE_CODE;

		attachmentApi.copyFilesFromSourceBillToTargetBill(changeEntity.getId().toString(), sourceBillType, Countersignatur_CHANGE, countersignatureEntity.getId().toString(), targetBillType, Countersignatur);
		recordcountersignatureService.saveOrUpdate(recordcountersignatureEntity, false);

		logger.info("---------结束--------");
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}
	public void clearBaseData(BaseEntity entity){
		entity.setCreateTime(null);
		entity.setCreateUserCode(null);
		entity.setTenantId(null);
		entity.setUpdateTime(null);
		entity.setUpdateUserCode(null);
	}

}
