package com.ejianc.business.busniessplan.excel;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.busniessplan.bean.MaintargetdetailEntity;
import com.ejianc.business.busniessplan.service.IMaintargetdetailService;
import com.ejianc.business.busniessplan.vo.MaintargetVO;
import com.ejianc.business.busniessplan.vo.MaintargetdetailVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import static org.bouncycastle.crypto.tls.CipherType.stream;

/**
 * 项目主要目标导入导出
 */
@Controller
@RequestMapping("maintargetExport")
public class ExcelMaintargetController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IMaintargetdetailService maintargetdetailService;

    /**
     * 导入模板下载
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadMaintarget")
    @ResponseBody
    public void downloadTotalPrice(HttpServletRequest request, HttpServletResponse response){
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "maintarget-import.xlsx", "商务策划书导入模板");
    }

    /**
     * excel导入
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelImportMaintarget", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportTotalPric(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<MaintargetdetailVO> successList = new ArrayList<>();
        List<MaintargetdetailVO> errorList = new ArrayList<>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if(isFailed) {
            return CommonResponse.error("文件格式不合法");
        }else{
            List<List<String>> result = ExcelReader.readExcel(mf);
            if(result != null && result.size() > 0) {
                String[] innateSort = new String[]{
                        "1", "2", "3", "4", "4.1", "4.2", "4.3",
                        "5", "5.1", "5.2", "5.3", "5.4", "5.5", "6",
                        "6.1", "6.2", "7", "8", "9", "10"
                };
                String[] innateName = new String[]{
                        "向公司上缴利润", "预留风险金", "项目计划实现利润", "结算确权目标", "中间确权率", "中间计量确认率",
                        "中间阶段结算目标", "成本管理目标", "自行完成合同造价", "标准成本（含税）", "责任成本（含税）", "项目计划成本（含税)",
                        "成本计划降低额", "分供方结算目标", "供方结算目标", "分包结算目标", "工程款回收目标", "质量目标",
                        "现场管理目标", "安全和环境目标"
                };
                //校验原数据上新增的数据
                if(result.size()>=innateSort.length){
                    //原序号部分
                    for(int i = 1; i < innateSort.length+1; i++) {
                        int arrIndex = i - 1;
                        List<String> datas = result.get(i);
                        MaintargetdetailVO maintargetdetailVO = new MaintargetdetailVO();
                        maintargetdetailVO.setId(IdWorker.getId());//id
                        String sort = datas.get(0);
                        String projectName = datas.get(1);
                        maintargetdetailVO.setSort(StringUtils.isNotBlank(sort) ? sort : null); // 序号
                        maintargetdetailVO.setProjectName(StringUtils.isNotBlank(projectName)?projectName:null);//项目名称
                        maintargetdetailVO.setTarget(StringUtils.isNotBlank(datas.get(2))?datas.get(2):null); // 目标
                        maintargetdetailVO.setRemarks(StringUtils.isNotBlank(datas.get(3))?datas.get(3):null); // 备注

                        //校验固定列
                        if(i < innateSort.length + 1){
                            if(!innateSort[arrIndex].equals(sort)){//校验序号
                                maintargetdetailVO.setErrorMsg("序号与模板不一致");
                                errorList.add(maintargetdetailVO);
                                continue;
                            }
                            if(!innateName[arrIndex].equals(projectName)){//校验名称
                                maintargetdetailVO.setErrorMsg("项目与模板不一致");
                                errorList.add(maintargetdetailVO);
                                continue;
                            }
                        } else {
                            if(StringUtils.isEmpty(sort)) {
                                maintargetdetailVO.setErrorMsg("序号不能为空！");
                                errorList.add(maintargetdetailVO);
                                continue;
                            }
                            if(StringUtils.isEmpty(projectName)) {
                                maintargetdetailVO.setErrorMsg("项目不能为空！");
                                errorList.add(maintargetdetailVO);
                                continue;
                            }
                        }
                        successList.add(maintargetdetailVO);
                    }
                    //超过原序号部分直接新增
                    Integer diffSize = result.size() - innateSort.length;
                    ArrayList<String> sortList = new ArrayList<>();
                    if(diffSize!=0){
                        for (int i = 1 ; i < result.size(); i++) {
                            sortList.add(result.get(i).get(0));
                        }
                        HashSet<String> sortSet = new HashSet<>(sortList);
                        Boolean isNoSimple = sortSet.size() == sortList.size() ? true : false;
                        for (int i = innateSort.length+1; i < result.size(); i++) {
                            List<String> datas = result.get(i);
                            String sort = datas.get(0);
                            MaintargetdetailVO maintargetdetailVO = new MaintargetdetailVO();
                            List<String> collect = Arrays.stream(innateSort).filter(item -> item.equals(sort)).collect(Collectors.toList());
                            maintargetdetailVO.setId(IdWorker.getId());//id
                            String projectName = datas.get(1);
                            maintargetdetailVO.setSort(StringUtils.isNotBlank(sort) ? sort : null); // 序号
                            maintargetdetailVO.setProjectName(StringUtils.isNotBlank(projectName)?projectName:null);//项目名称
                            maintargetdetailVO.setTarget(StringUtils.isNotBlank(datas.get(2))?datas.get(2):null); // 目标
                            maintargetdetailVO.setRemarks(StringUtils.isNotBlank(datas.get(3))?datas.get(3):null); // 备注
                            if(collect.size()>0 || !isNoSimple){
                                maintargetdetailVO.setErrorMsg("新增序号重复,请修改!");
                                errorList.add(maintargetdetailVO);
                                continue;
                            }
                            successList.add(maintargetdetailVO);
                        }
                    }
                }
            }
        }
        //设置tid和tpid
        List<MaintargetdetailVO> resList = setTidAndTpid(successList);

        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", resList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

    /**
     * 设置tid和tpid
     *
     * @param originalList
     * @return
     */
    private List<MaintargetdetailVO> setTidAndTpid(List<MaintargetdetailVO> originalList) {
        List<MaintargetdetailVO> treeList = new ArrayList<>();
        String currentTime = String.valueOf(System.currentTimeMillis());
        if (originalList != null && originalList.size() > 0) {
            for (int i = 0; i < originalList.size(); i++) {
                MaintargetdetailVO maintargetdetailVO = originalList.get(i);
                String sort = maintargetdetailVO.getSort();
                String[] arr = sort.split("\\.");

                maintargetdetailVO.setId(IdWorker.getId());
                maintargetdetailVO.setTid(currentTime + "_" + sort);
                if (arr.length == 1) {
                    maintargetdetailVO.setTpid("");
                } else if (arr.length > 1) {
                    maintargetdetailVO.setTpid(currentTime + "_" + sort.substring(0, sort.length() - 2));
                }
                treeList.add(maintargetdetailVO);
            }
        }
        return createTreeData(treeList);
    }

    /**
     * 构建树
     *
     * @param list
     * @return
     */
    public static List<MaintargetdetailVO> createTreeData(List<MaintargetdetailVO> list) {
        List<MaintargetdetailVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();

        //循环list，放入listMap重
        Map<String, MaintargetdetailVO> listMap = new HashMap<>();
        for (MaintargetdetailVO item : list) {
            listMap.put(item.getTid().toString(), item);
        }

        for (int i = 0; i < list.size(); i++) {
            MaintargetdetailVO item = list.get(i);
            String parentId = (item.getTpid() != null) ? item.getTpid().toString() : "";
            MaintargetdetailVO parent = listMap.get(parentId);
            if (parent != null) {
                List<MaintargetdetailVO> child = (List<MaintargetdetailVO>) parent.getChildren();
                if (child != null) {
                    child.add(item);
                } else {
                    List<MaintargetdetailVO> children = new ArrayList<MaintargetdetailVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getTid());
            }
        }

        for (String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }

    /**
     * excel导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportMaintargetFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportbusinessplanningeffectFromDatabase(@RequestBody MaintargetVO maintargetVO, HttpServletResponse response) {
        QueryWrapper<MaintargetdetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", maintargetVO.getId());
        queryWrapper.eq("dr", 0);
        List<MaintargetdetailEntity> list = maintargetdetailService.list(queryWrapper);
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("maintarget-export.xlsx", beans, response);
    }

    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportMaintargetFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportbusinessplanningeffectFromPage(@RequestBody List<MaintargetdetailVO> list, HttpServletResponse response) {
        Map<String, Object> beans = new HashMap<String, Object>();

        List<MaintargetdetailVO> records = new ArrayList<>();
        for(MaintargetdetailVO vo : list){
            records.add(vo);
            if(vo.getChildren()!=null&&vo.getChildren().size()>0){
                this.splitList(vo.getChildren(),records);
            }
        }

        beans.put("records", records);
        ExcelExport.getInstance().export("maintarget-export.xlsx", beans, response);
    }

    /**
     * 导出遍历加上所有子表
     * @param list
     * @param records
     */
    private void splitList(List<MaintargetdetailVO> list,List<MaintargetdetailVO> records) {
        for(MaintargetdetailVO vo : list){
            records.add(vo);
            if(vo.getChildren()!=null&&vo.getChildren().size()>0){
                this.splitList(vo.getChildren(),records);
            }
        }
    }

    /**
     * 导出页面数据处理children
     *
     * @param list
     */
    private List<MaintargetdetailVO> handleList(List<MaintargetdetailVO> list, List<MaintargetdetailVO> concatList) {
        if (list == null || list.size() == 0) {
            return concatList;
        }

        for (int i = 0; i < list.size(); i++) {
            MaintargetdetailVO maintargetdetailVO = list.get(i);
            List<MaintargetdetailVO> children = maintargetdetailVO.getChildren();
            if (children != null && children.size() > 0) {
                concatList.addAll(children);
                handleList(children, concatList);
            }
        }

        return concatList;
    }
}
