package com.ejianc.business.change.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.busniessplan.bean.OrgstructureEntity;
import com.ejianc.business.busniessplan.bean.OrgstructuredetailEntity;
import com.ejianc.business.busniessplan.service.IOrgstructureService;
import com.ejianc.business.change.bean.ChangeOrgstructureEntity;
import com.ejianc.business.change.bean.ChangeOrgstructuredetailEntity;
import com.ejianc.business.change.service.IChangeOrgstructureService;
import com.ejianc.business.record.bean.RecordOrgstructureEntity;
import com.ejianc.business.record.bean.RecordOrgstructuredetailEntity;
import com.ejianc.business.record.service.IRecordOrgstructureService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.support.idworker.util.IdWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service("changeOrgstructure") 
public class ChangeOrgstructureBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	//业务类型
	private static final String Orgstructur = "zjkj-orgstructur";//商务组织架构
	private static final String Orgstructur_CHANGE = "zjkj-orgstructurChange";//商务组织架构变更
	private static final String Orgstructur_RECORD = "zjkj-orgstructurRecord";//商务组织架构变更记录

	//单据类型
	private static final String Orgstructur_BILLTYPE_CODE = "BT202202000010";//商务组织架构
	private static final String Orgstructu_CHANGE_BILLTYPE_CODE = "BT202202000052";//商务组织架构变更
	private static final String Orgstructu_RECORD_BILLTYPE_CODE = "BT202202000053";//商务组织架构变更记录

	@Autowired
	private IAttachmentApi attachmentApi;
	@Autowired
	private IChangeOrgstructureService changeOrgstructureService;
	@Autowired
	private IOrgstructureService orgstructureService;
	@Autowired
	private IRecordOrgstructureService recordOrgstructureService;
	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		//1、获取目前单据信息、变更信息
		ChangeOrgstructureEntity changeEntity = changeOrgstructureService.selectById(billId);
		logger.info("变更单主表id=" + changeEntity.getOriginalId());
		OrgstructureEntity orgstructureEntity = orgstructureService.selectById(changeEntity.getOriginalId());
		logger.info("主单据id=" + changeEntity.getId() + "主单据创建人" + changeEntity.getCreateUserCode());

		//获取历史版本条数
		QueryWrapper<RecordOrgstructureEntity> recordWrapper = new QueryWrapper<>();
		recordWrapper.eq("original_id", orgstructureEntity.getId());
		recordWrapper.eq("dr", 0);
		Integer count = recordOrgstructureService.count(recordWrapper);

		logger.info("---------给变更记录表赋值--------");
		RecordOrgstructureEntity recordOrgstructureEntity = BeanMapper.map(orgstructureEntity, RecordOrgstructureEntity.class);
		Long recordId = IdWorker.getId();
		this.clearBaseData(recordOrgstructureEntity);
		recordOrgstructureEntity.setBillState(null);
		recordOrgstructureEntity.setOriginalId(orgstructureEntity.getId());
		recordOrgstructureEntity.setOrgstructureCode(orgstructureEntity.getBillCode()+"-"+(count+1));
		recordOrgstructureEntity.setId(recordId);
		recordOrgstructureEntity.setBillCode(orgstructureEntity.getBillCode());
		recordOrgstructureEntity.setChangeReason(changeEntity.getChangeReason());
		recordOrgstructureEntity.setEffectDate(new Date());

		logger.info("---------给变更记录子表赋值--------");
		List<OrgstructuredetailEntity> orgstructuredetailEntities = orgstructureEntity.getOrgstructuredetailEntities();
		if(orgstructuredetailEntities!=null&&orgstructuredetailEntities.size()>0){
			List<RecordOrgstructuredetailEntity> recordOrgstructuredetailEntities = new ArrayList<>();
			for(OrgstructuredetailEntity entity : orgstructuredetailEntities){
				RecordOrgstructuredetailEntity reEntity = BeanMapper.map(entity, RecordOrgstructuredetailEntity.class);
				this.clearBaseData(reEntity);
				reEntity.setOriginalId(recordId);
				recordOrgstructuredetailEntities.add(reEntity);
				entity.setRowState("del");
			}
			recordOrgstructureEntity.setOrgstructuredetailEntities(recordOrgstructuredetailEntities);
		}
		logger.info("---------赋值附件信息--------");
		//复制附件信息到记录中
		String sourceBillType = "";
		//原单据类型
		sourceBillType = Orgstructur_BILLTYPE_CODE;
		String targetBillType = "";
		//变更记录单剧类型
		targetBillType = Orgstructu_RECORD_BILLTYPE_CODE;

		attachmentApi.copyFilesFromSourceBillToTargetBill(orgstructureEntity.getId().toString(), sourceBillType, Orgstructur , recordId.toString(), targetBillType, Orgstructur_RECORD);
		recordOrgstructureService.saveOrUpdate(recordOrgstructureEntity, false);

		logger.info("---------修改当前单据状态--------");
		logger.info("创建人=" + orgstructureEntity.getCreateUserCode());
		//3、修改当前单据状态
		OrgstructureEntity newOrgstructureEntity = BeanMapper.map(changeEntity, OrgstructureEntity.class);
		newOrgstructureEntity.setChangeState("3");//状态改为已变更
		newOrgstructureEntity.setChangeId(null);
		newOrgstructureEntity.setBillState(orgstructureEntity.getBillState());
		newOrgstructureEntity.setId(orgstructureEntity.getId());
		newOrgstructureEntity.setCreateTime(orgstructureEntity.getCreateTime());
		newOrgstructureEntity.setCreateUserCode(orgstructureEntity.getCreateUserCode());
		newOrgstructureEntity.setTenantId(orgstructureEntity.getTenantId());
		newOrgstructureEntity.setVersion(orgstructureEntity.getVersion());

		logger.info("---------处理子表变更--------");
		//子表
		//处理子表变更
		List<ChangeOrgstructuredetailEntity> changeOrgstructuredetailList = changeEntity.getChangeOrgstructuredetailEntities();
		if(changeOrgstructuredetailList!=null&&changeOrgstructuredetailList.size()>0){
			List<OrgstructuredetailEntity> newOrgstructuredetailList = BeanMapper.mapList(changeOrgstructuredetailList, OrgstructuredetailEntity.class);
			newOrgstructuredetailList.addAll(orgstructuredetailEntities);
			newOrgstructureEntity.setOrgstructuredetailEntities(newOrgstructuredetailList);
		}
		logger.info("---------保存--------");
		orgstructureService.saveOrUpdate(newOrgstructureEntity, false);

		sourceBillType = Orgstructu_CHANGE_BILLTYPE_CODE;
		targetBillType = Orgstructur_BILLTYPE_CODE;

		attachmentApi.copyFilesFromSourceBillToTargetBill(changeEntity.getId().toString(), sourceBillType, Orgstructur_CHANGE, orgstructureEntity.getId().toString(), targetBillType, Orgstructur);
		recordOrgstructureService.saveOrUpdate(recordOrgstructureEntity, false);

		logger.info("---------结束--------");
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	public void clearBaseData(BaseEntity entity){
		entity.setCreateTime(null);
		entity.setCreateUserCode(null);
		entity.setTenantId(null);
		entity.setUpdateTime(null);
		entity.setUpdateUserCode(null);
	}

}
