package com.ejianc.business.change.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.busniessplan.bean.FundrecoveryplanEntity;
import com.ejianc.business.busniessplan.bean.FundrecoveryplanningdetailEntity;
import com.ejianc.business.busniessplan.service.IFundrecoveryplanService;
import com.ejianc.business.change.bean.ChangeFundrecoveryplanEntity;
import com.ejianc.business.change.bean.ChangeFundrecoveryplanningdetailEntity;
import com.ejianc.business.change.service.IChangeFundrecoveryplanService;
import com.ejianc.business.record.bean.RecordFundrecoveryplanEntity;
import com.ejianc.business.record.bean.RecordFundrecoveryplanningdetailEntity;
import com.ejianc.business.record.service.IRecordFundrecoveryplanService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.support.idworker.util.IdWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service("changeFundrecoveryplan") 
public class ChangeFundrecoveryplanBpmServiceImpl  implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	//业务类型
	private static final String Fundrecoveryplan = "zjkj-fundrecoveryplan";//项目资金回收流程策划
	private static final String Fundrecoveryplan_CHANGE = "zjkj-fundrecoveryplanChange";//项目资金回收流程策划变更
	private static final String Fundrecoveryplan_RECORD = "zjkj-fundrecoveryplanRecord";//项目资金回收流程策划变更记录

	//单据类型
	private static final String Fundrecoveryplan_BILLTYPE_CODE = "BT202202000014";//项目资金回收流程策划
	private static final String Fundrecoveryplan_CHANGE_BILLTYPE_CODE = "BT202202000060";//项目资金回收流程策划变更
	private static final String Fundrecoveryplan_RECORD_BILLTYPE_CODE = "BT202202000062";//项目资金回收流程策划变更记录

	@Autowired
	private IAttachmentApi attachmentApi;
	@Autowired
	private IChangeFundrecoveryplanService changeFundrecoveryplanService;
	@Autowired
	private IFundrecoveryplanService fundrecoveryplanService;
	@Autowired
	private IRecordFundrecoveryplanService recordFundrecoveryplanService;
	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		//1、获取目前单据信息、变更信息
		ChangeFundrecoveryplanEntity changeEntity = changeFundrecoveryplanService.selectById(billId);
		logger.info("变更单主表id=" + changeEntity.getFundrecoveryplanningId());
		FundrecoveryplanEntity fundrecoveryplanEntity = fundrecoveryplanService.selectById(changeEntity.getFundrecoveryplanningId());
		logger.info("主单据id=" + changeEntity.getId() + "主单据创建人" + changeEntity.getCreateUserCode());

		//获取历史版本条数
		QueryWrapper<RecordFundrecoveryplanEntity> recordWrapper = new QueryWrapper<>();
		recordWrapper.eq("fundrecoveryplanning_id", fundrecoveryplanEntity.getId());
		recordWrapper.eq("dr", 0);
		Integer count = recordFundrecoveryplanService.count(recordWrapper);

		logger.info("---------给变更记录表赋值--------");
		RecordFundrecoveryplanEntity recordFundrecoveryplanEntity = BeanMapper.map(fundrecoveryplanEntity, RecordFundrecoveryplanEntity.class);
		Long recordId = IdWorker.getId();
		this.clearBaseData(recordFundrecoveryplanEntity);
		recordFundrecoveryplanEntity.setBillState(null);
		recordFundrecoveryplanEntity.setFundrecoveryplanningId(fundrecoveryplanEntity.getId());
		recordFundrecoveryplanEntity.setFundrecoveryplanningCode(fundrecoveryplanEntity.getBillCode()+"-"+(count+1));
		recordFundrecoveryplanEntity.setId(recordId);
		recordFundrecoveryplanEntity.setBillCode(fundrecoveryplanEntity.getBillCode());
		recordFundrecoveryplanEntity.setChangeReason(changeEntity.getChangeReason());
		recordFundrecoveryplanEntity.setEffectTime(new Date());

		logger.info("---------给变更记录子表赋值--------");
		List<FundrecoveryplanningdetailEntity> fundrecoveryplanningdetailEntities = fundrecoveryplanEntity.getFundrecoveryplanningdetailEntities();
		if(fundrecoveryplanningdetailEntities!=null&&fundrecoveryplanningdetailEntities.size()>0){
			List<RecordFundrecoveryplanningdetailEntity> fundrecoveryplanningdetailvo = new ArrayList<>();
			for(FundrecoveryplanningdetailEntity entity : fundrecoveryplanningdetailEntities){
				RecordFundrecoveryplanningdetailEntity reEntity = BeanMapper.map(entity, RecordFundrecoveryplanningdetailEntity.class);
				this.clearBaseData(reEntity);
				reEntity.setMid(recordId);
				fundrecoveryplanningdetailvo.add(reEntity);
				entity.setRowState("del");
			}
			recordFundrecoveryplanEntity.setFundrecoveryplanningdetailEntities(fundrecoveryplanningdetailvo);
		}
		logger.info("---------赋值附件信息--------");
		//复制附件信息到记录中
		String sourceBillType = "";
		//原单据类型
		sourceBillType = Fundrecoveryplan_BILLTYPE_CODE;
		String targetBillType = "";
		//变更记录单剧类型
		targetBillType = Fundrecoveryplan_RECORD_BILLTYPE_CODE;

		attachmentApi.copyFilesFromSourceBillToTargetBill(fundrecoveryplanEntity.getId().toString(), sourceBillType, Fundrecoveryplan , recordId.toString(), targetBillType, Fundrecoveryplan_RECORD);
		recordFundrecoveryplanService.saveOrUpdate(recordFundrecoveryplanEntity, false);

		logger.info("---------修改当前单据状态--------");
		logger.info("创建人=" + fundrecoveryplanEntity.getCreateUserCode());
		//3、修改当前单据状态
		FundrecoveryplanEntity newFundrecoveryplanEntity = BeanMapper.map(changeEntity, FundrecoveryplanEntity.class);
		newFundrecoveryplanEntity.setChangeState("3");//状态改为已变更
		newFundrecoveryplanEntity.setChangeId(null);
		newFundrecoveryplanEntity.setBillState(fundrecoveryplanEntity.getBillState());
		newFundrecoveryplanEntity.setId(fundrecoveryplanEntity.getId());
		newFundrecoveryplanEntity.setCreateTime(fundrecoveryplanEntity.getCreateTime());
		newFundrecoveryplanEntity.setCreateUserCode(fundrecoveryplanEntity.getCreateUserCode());
		newFundrecoveryplanEntity.setTenantId(fundrecoveryplanEntity.getTenantId());
		newFundrecoveryplanEntity.setVersion(fundrecoveryplanEntity.getVersion());

		logger.info("---------处理子表变更--------");
		//子表
		//处理子表变更
		List<ChangeFundrecoveryplanningdetailEntity> changeQuotaanalysisdetailList = changeEntity.getFundrecoveryplanningdetailEntities();
		if(changeQuotaanalysisdetailList!=null&&changeQuotaanalysisdetailList.size()>0){
			List<FundrecoveryplanningdetailEntity> newFundrecoveryplanningdetailList = BeanMapper.mapList(changeQuotaanalysisdetailList, FundrecoveryplanningdetailEntity.class);
			newFundrecoveryplanningdetailList.addAll(fundrecoveryplanningdetailEntities);
			newFundrecoveryplanEntity.setFundrecoveryplanningdetailEntities(newFundrecoveryplanningdetailList);
		}
		logger.info("---------保存--------");
		fundrecoveryplanService.saveOrUpdate(newFundrecoveryplanEntity, false);

		sourceBillType = Fundrecoveryplan_CHANGE_BILLTYPE_CODE;
		targetBillType = Fundrecoveryplan_BILLTYPE_CODE;

		attachmentApi.copyFilesFromSourceBillToTargetBill(changeEntity.getId().toString(), sourceBillType, Fundrecoveryplan_CHANGE, fundrecoveryplanEntity.getId().toString(), targetBillType, Fundrecoveryplan);
		recordFundrecoveryplanService.saveOrUpdate(recordFundrecoveryplanEntity, false);

		logger.info("---------结束--------");
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	public void clearBaseData(BaseEntity entity){
		entity.setCreateTime(null);
		entity.setCreateUserCode(null);
		entity.setTenantId(null);
		entity.setUpdateTime(null);
		entity.setUpdateUserCode(null);
	}

}
