package com.ejianc.business.busniessplan.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.busniessplan.bean.MaintargetEntity;
import com.ejianc.business.busniessplan.bean.MaintargetdetailEntity;
import com.ejianc.business.busniessplan.bean.MaintargetdetailinnateEntity;
import com.ejianc.business.busniessplan.service.IMaintargetService;
import com.ejianc.business.busniessplan.service.IMaintargetdetailinnateService;
import com.ejianc.business.busniessplan.vo.MaintargetVO;
import com.ejianc.business.busniessplan.vo.MaintargetdetailVO;
import com.ejianc.business.record.bean.RecordMaintargetEntity;
import com.ejianc.business.record.service.IRecordMaintargetService;
import com.ejianc.business.record.vo.RecordMaintargetVO;
import com.ejianc.business.utils.DateUtils;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 项目主要目标
 *
 * @author generator
 */
@Controller
@RequestMapping("maintarget")
public class MaintargetController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IMaintargetdetailinnateService maintargetdetailinnateService;

    private static final String BILL_CODE = "businessplan-maintarget";//此处需要根据实际修改

    @Autowired
    private IMaintargetService service;
    @Autowired
    private IRecordMaintargetService recordMaintargetService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<MaintargetVO> saveOrUpdate(@RequestBody MaintargetVO saveorUpdateVO) {
        MaintargetEntity entity = BeanMapper.map(saveorUpdateVO, MaintargetEntity.class);

        //校验单据编码唯一性
        entity = checkBillCodeUniq(entity);

        //校验项目唯一性
        checkProject(entity);

        entity.setChangeState("1");//未变更

        List<MaintargetdetailVO> handleData = saveorUpdateVO.getMaintargetdetailEntities();
        //新增时去除预置内容的虚拟id
        if (saveorUpdateVO.getId() == null && handleData != null) {
            for (int i = 0; i < handleData.size(); i++) {
                MaintargetdetailVO maintargetdetailVO = handleData.get(i);
                maintargetdetailVO.setId(null);
                handleData.set(i, maintargetdetailVO);
            }

            saveorUpdateVO.setMaintargetdetailEntities(handleData);
        }
        //获取子表值副职主表
        List<MaintargetdetailEntity> entityMaintargetdetailEntities = entity.getMaintargetdetailEntities();
        if (CollectionUtils.isNotEmpty(entityMaintargetdetailEntities)){
            for (MaintargetdetailEntity maintargetdetailEntity : entityMaintargetdetailEntities){
                if (maintargetdetailEntity.getSort().equals("1")){
                    entity.setCompanyRate(maintargetdetailEntity.getTarget() == null ? BigDecimal.ZERO : new BigDecimal(maintargetdetailEntity.getTarget()));
                }
                if (maintargetdetailEntity.getSort().equals("3")){
                    entity.setPlanProfit(maintargetdetailEntity.getTarget() == null ? BigDecimal.ZERO :new BigDecimal(maintargetdetailEntity.getTarget()));
                }
            }
        }
        service.saveOrUpdate(entity, false);
        MaintargetVO vo = BeanMapper.map(entity, MaintargetVO.class);

        //构建树形结构
        List<MaintargetdetailVO> maintargetdetailEntities = vo.getMaintargetdetailEntities();
        List<MaintargetdetailVO> treeData = createTreeData(maintargetdetailEntities);
        vo.setMaintargetdetailEntities(treeData);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * 单据编码唯一性校验
     * @param entity
     */
    private MaintargetEntity checkBillCodeUniq(MaintargetEntity entity) {
        if(entity.getBillCode() == null || StringUtils.isEmpty(entity.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }else {
            //单据编码唯一性
            QueryWrapper<MaintargetEntity> queryWrapperBillCode = new QueryWrapper<>();
            queryWrapperBillCode.eq("bill_code", entity.getBillCode());
            queryWrapperBillCode.eq("dr", "0");
            List<MaintargetEntity> proBillCode = service.list(queryWrapperBillCode);
            if(proBillCode != null && proBillCode.size() > 0){
                for (int i = 0; i < proBillCode.size(); i++) {
                    MaintargetEntity maintargetEntity = proBillCode.get(i);
                    if(!maintargetEntity.getId().equals(entity.getId())){
                        throw new BusinessException("单据编码已存在，请重新录入!");
                    }
                }
            }
        }

        return entity;
    }

    /**
     * 校验项目唯一性
     * @param entity
     */
    private void checkProject(MaintargetEntity entity) {
        //创建条件构造器
        QueryWrapper<MaintargetEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("project_id", entity.getProjectId());
        queryWrapper.eq("dr", "0");
        List<MaintargetEntity> pro = service.list(queryWrapper);

        if (pro != null && pro.size() > 0) {
            if (entity.getId() == null || entity.getId() == 0) {
                throw new BusinessException("该项目已经创建一个项目项目主要管理目标，不允许重复创建!");
            } else {
                for (MaintargetEntity maintarget : pro) {
                    if (!entity.getProjectId().equals(maintarget.getProjectId())) {
                        throw new BusinessException("该项目已经创建一个项目项目主要管理目标，不允许重复创建!");
                    }
                }
            }
        }
    }

    public static List<MaintargetdetailVO> createTreeData(List<MaintargetdetailVO> list) {
        List<MaintargetdetailVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();

        //循环list，放入listMap重
        Map<String, MaintargetdetailVO> listMap = new HashMap<>();
        for(MaintargetdetailVO item:list) {
            listMap.put(item.getTid().toString(), item);
        }

        for(int i =0; i<list.size(); i++) {
            MaintargetdetailVO item = list.get(i);
            String parentId = (item.getTpid() != null) ? item.getTpid().toString():"";
            MaintargetdetailVO parent = listMap.get(parentId);
            if(parent != null) {
                List<MaintargetdetailVO> child = (List<MaintargetdetailVO>) parent.getChildren();
                if(child != null) {
                    child.add(item);
                }else{
                    List<MaintargetdetailVO> children = new ArrayList<MaintargetdetailVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getTid());
            }
        }

        for(String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MaintargetVO> queryDetail(Long id) {
        MaintargetEntity entity = service.selectById(id);
        MaintargetVO vo = BeanMapper.map(entity, MaintargetVO.class);

        //构建树形结构
        List<MaintargetdetailVO> maintargetdetailEntities = vo.getMaintargetdetailEntities();
        List<MaintargetdetailVO> resMaintargetdetailEntities = createTreeData(maintargetdetailEntities);
        vo.setMaintargetdetailEntities(resMaintargetdetailEntities);


        //当前单据变更过则显示变更记录
        if (!"1".equals(vo.getChangeState())) {
            QueryWrapper<RecordMaintargetEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("dr", 0);
            queryWrapper.eq("maintarget_id", vo.getId());
            List<RecordMaintargetEntity> records = recordMaintargetService.list(queryWrapper);
            if (records != null && records.size() > 0) {
                vo.setRecordMaintargetList(BeanMapper.mapList(records, RecordMaintargetVO.class));
            }
        }
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description queryInnateColumns 查询固定列
     * @param
     */
    @RequestMapping(value = "/queryInnateColumns", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<MaintargetdetailinnateEntity>> queryInnateColumns() {
        //查询固定列
        QueryWrapper<MaintargetdetailinnateEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("dr", "0");
        queryWrapper.orderByAsc("id");
        List<MaintargetdetailinnateEntity> pro = maintargetdetailinnateService.list(queryWrapper);
        return CommonResponse.success("查询固定列数据成功！",pro);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MaintargetVO> vos) {
        service.removeByIds(vos.stream().map(MaintargetVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MaintargetVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
/** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        fuzzyFields.add("bill_code");
        fuzzyFields.add("contract_name");
        fuzzyFields.add("project_name");
        fuzzyFields.add("agent_name");
        IPage<MaintargetEntity> page = service.queryPage(param, false);
        IPage<MaintargetVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MaintargetVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("bill_code");
        fuzzyFields.add("contract_name");
        fuzzyFields.add("project_name");
        fuzzyFields.add("agent_name");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        List<MaintargetEntity> list = service.queryList(param);
        //时间转换
        List<MaintargetVO> maintargetVOList = BeanMapper.mapList(list, MaintargetVO.class);
        for (int i = 0; i < maintargetVOList.size(); i++) {
            MaintargetVO maintargetVO = maintargetVOList.get(i);
            maintargetVO.setSort(String.valueOf(i + 1));
            if (maintargetVO.getCreateTime() != null) {
                maintargetVO.setCreateTimeShow(DateUtils.dateSimple2(maintargetVO.getCreateTime()));
            }

            String billStateStr = maintargetVO.getBillState().toString();
            String changeState = maintargetVO.getChangeState();
            if (billStateStr != null) {
                if ("0".equals(billStateStr)) {//自由态
                    billStateStr = "自由态";
                } else if ("1".equals(billStateStr)) {//已提交
                    billStateStr = "已提交";
                } else if ("2".equals(billStateStr) || "5".equals(billStateStr)) {//审批中
                    billStateStr = "审批中";
                } else if ("3".equals(billStateStr)) {//审批通过
                    billStateStr = "审批通过";
                } else if ("4".equals(billStateStr)) {//驳回
                    billStateStr = "驳回";
                }

                maintargetVO.setBillStateStr(billStateStr);
            }

            if (changeState != null) {
                if ("1".equals(changeState)) {//1:未变更
                    changeState = "未变更";
                } else if ("2".equals(changeState)) {//2:变更中
                    changeState = "变更中";
                } else if ("3".equals(changeState)) {//3:已变更
                    changeState = "已变更";
                }

                maintargetVO.setChangeState(changeState);
            }
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", maintargetVOList);
        ExcelExport.getInstance().export("MaintargetMain-export.xlsx", beans, response);
    }

    /**
     * @param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refMaintargetData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<MaintargetVO>> refMaintargetData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                 String condition,
                                                                 String searchObject,
                                                                 String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<MaintargetEntity> page = service.queryPage(param, false);
        IPage<MaintargetVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MaintargetVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }
}
