package com.ejianc.business.busniessplan.excel;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.busniessplan.bean.BusinessplanningeffectdetailEntity;
import com.ejianc.business.busniessplan.service.IBusinessplanningeffectdetailService;
import com.ejianc.business.busniessplan.vo.BusinessplanningeffectVO;
import com.ejianc.business.busniessplan.vo.BusinessplanningeffectdetailVO;
import com.ejianc.business.utils.DateUtils;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.*;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.units.qual.A;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 項目商務策劃效果導入導出
 */
@Controller
@RequestMapping("businessplanningeffectExport")
public class ExcelBusinessplaneffectController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBusinessplanningeffectdetailService businessplanningeffectdetailService;
    @Autowired(required = false)
    private RestHighLevelClient client;
    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadBusinessplanningeffect")
    @ResponseBody
    public void downloadTotalPrice(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "businessplanningeffect-import.xlsx", "项目商务策划立项清单模板");
    }
    /**
     * 导入页面数据处理children
     *
     * @param list
     */
    private List<BusinessplanningeffectdetailVO> openList(List<BusinessplanningeffectdetailVO> list) {
        List<BusinessplanningeffectdetailVO> succesList = new ArrayList<>();
        for (BusinessplanningeffectdetailVO vo : list) {
            if (CollectionUtils.isNotEmpty(vo.getChildren())) {
                succesList.addAll(openList(vo.getChildren()));
            }
            succesList.add(vo);
        }
        return succesList;
    }
    /**
     * excel导入
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelImportBusinessplanningeffect", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportTotalPric(HttpServletRequest request, HttpServletResponse response,String detailList) throws ParseException {
        // detailList 字符串转换成list
        List<BusinessplanningeffectdetailVO> list = JSONArray.parseArray(detailList, BusinessplanningeffectdetailVO.class);
        List<BusinessplanningeffectdetailVO> pcList = openList(list);
        List<String> pcStrList = new ArrayList<>();
        for (BusinessplanningeffectdetailVO vo : pcList) {
            // 序号+类别及项目名称 作为校验依据
            pcStrList.add(vo.getSort() + vo.getCategoryAndName());
        }
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<BusinessplanningeffectdetailVO> successList = new ArrayList<>();
        List<BusinessplanningeffectdetailVO> errorList = new ArrayList<>();
        DateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            List<String> planTypeList = new ArrayList<>();
            planTypeList.add("1.1 合同条件优化");
            planTypeList.add("1.2 签证索赔");
            planTypeList.add("1.3 设计优化、设计变更");
            planTypeList.add("1.4 总包管理策划");
            planTypeList.add("1.5 认质认价与采购效益");
            planTypeList.add("1.6 其他");
            planTypeList.add("2.1 设计优化、设计变更");
            planTypeList.add("2.2 施工组织及方案优化");
            planTypeList.add("2.3 钢筋翻样、钢筋管控量差");
            planTypeList.add("2.4 其他");
            if (result != null && result.size() > 0) {
                for (int i = 3; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    if (pcStrList.contains(datas.get(0) + datas.get(1))) {

                    }
                    StringBuilder errorsMsgBuilder = new StringBuilder();

                    String initiateDate = datas.get(6);//立项时间
                    String incomeBeforePlan = datas.get(7);//成本估算(成本分析)(元)
                    String costBeforePlan = datas.get(8);//上报金额(元)
                    String benefitBeforePlan = datas.get(9);//策划目标金额(元)
                    String estimatedRevenueAfterPlan = datas.get(10);//已完成目标金额(元)
                    String estimatedCostAfterPlan = datas.get(11);//预计利润(元)
                    String estimatedBenefitsAfterPlan = datas.get(12);
                    String planExpectAchieveResults = datas.get(13);
                    String proposedCompleteTime = datas.get(14);//拟完成时间节点
                    String revenueAfterPlan = datas.get(15);
                    String actualCost = datas.get(16);
                    String benefitAfterPlan = datas.get(17);
                    String includePlannedActualEffect = datas.get(18);


                    String supervisionNotReportedMoney = datas.get(20);//（监理单位未上报）金额
                    String supervisionNotReportedTime = datas.get(21);//（监理单位未上报）预计上报时间
                    String supervisionReportedMoney = datas.get(22);//（监理单位已上报未批复）金额
                    String supervisionReportedTime = datas.get(23);//（监理单位已上报未批复）上报时间
                    String supervisionApprovedMoney = datas.get(24);//（监理单位已批复）金额
                    String supervisionApprovedTime = datas.get(25);//（监理单位已批复）上报时间
                    String ownerNotReportedMoney = datas.get(26);//（业主单位未上报）金额
                    String ownerNotReportedTime = datas.get(27);//（业主单位未上报）预计上报时间
                    String ownerReportedMoney = datas.get(28);//（业主单位已上报未批复）金额
                    String ownerReportedTime = datas.get(29);//（业主单位已上报未批复）上报时间
                    String ownerApprovedMoney = datas.get(30);//（业主单位已批复）金额
                    String ownerApprovedTime = datas.get(31);//（业主单位已批复）上报时间

                    BusinessplanningeffectdetailVO businessplanningeffectdetailVO = new BusinessplanningeffectdetailVO();
                    businessplanningeffectdetailVO.setId(IdWorker.getId());//id
                    businessplanningeffectdetailVO.setSort(datas.get(0)); // 序号
                    businessplanningeffectdetailVO.setCategoryAndName(StringUtils.isNotBlank(datas.get(1)) ? datas.get(1) : null); // 类别及项目名称
                    businessplanningeffectdetailVO.setInitiateReason(StringUtils.isNotBlank(datas.get(2)) ? datas.get(2) : null); // 立项理由及依据
                    businessplanningeffectdetailVO.setPlanCategory(StringUtils.isNotBlank(datas.get(3)) ? datas.get(3) : null); // 立项理由及依据
                    businessplanningeffectdetailVO.setPlanType(StringUtils.isNotBlank(datas.get(4)) ? datas.get(4) : null); // 立项理由及依据
                    businessplanningeffectdetailVO.setPlanStatus(StringUtils.isNotBlank(datas.get(5)) ? datas.get(5) : null);
                    businessplanningeffectdetailVO.setAttention(StringUtils.isNotBlank(datas.get(19)) ? datas.get(19) : null); // 推荐情况、存在问题、注意事项
                    businessplanningeffectdetailVO.setRemarks(StringUtils.isNotBlank(datas.get(32)) ? datas.get(32) : null); // 备注

                    //必填项校验
                    if (datas.get(0) == null || datas.get(0) == "") {
                        businessplanningeffectdetailVO.setErrorMsg("序号不能为空");
                        errorsMsgBuilder.append("序号不能为空");
                    } else {
                        businessplanningeffectdetailVO.setSort(datas.get(0));
                    }
                    if (datas.get(1) == null || StringUtils.isBlank(datas.get(1))) {
                        businessplanningeffectdetailVO.setErrorMsg("类别及项目名称不能为空");
                        errorsMsgBuilder.append("类别及项目名称不能为空");
                    } else {
                        businessplanningeffectdetailVO.setCategoryAndName(datas.get(1));
                    }
                    if (StringUtils.isNotBlank(datas.get(4))) {
                        if (!planTypeList.contains(datas.get(4))) {
                            businessplanningeffectdetailVO.setErrorMsg("策划类型有误!");
                            errorsMsgBuilder.append("策划类型有误!");
                        }
                    }
                    if (datas.get(5) == null || StringUtils.isBlank(datas.get(5))) {
                        businessplanningeffectdetailVO.setErrorMsg("策划状态不能为空");
                        errorsMsgBuilder.append("策划状态不能为空");
                    } else if("计划".equals(datas.get(5)) || "实施中".equals(datas.get(5)) || "已完成".equals(datas.get(5))){
                        businessplanningeffectdetailVO.setPlanStatus(datas.get(5));
                    }else{
                        businessplanningeffectdetailVO.setErrorMsg("策划状态不对,只能是 计划,实施中,已完成");
                        errorsMsgBuilder.append("策划状态不对,只能是 计划,实施中,已完成");
                    }
                    if (datas.get(3) == null || StringUtils.isBlank(datas.get(3))) {
                        businessplanningeffectdetailVO.setErrorMsg("策划类别不能为空");
                        errorsMsgBuilder.append("策划类别不能为空");
                    } else if("开源".equals(datas.get(3)) || "节流".equals(datas.get(3))){
                        businessplanningeffectdetailVO.setPlanCategory(datas.get(3));
                    }else{
                        businessplanningeffectdetailVO.setErrorMsg("策划类别不对,只能是 开源,节流");
                        errorsMsgBuilder.append("策划类别不对,只能是 开源,节流");
                    }

                    //格式校验
                    if (StringUtils.isNotBlank(initiateDate)) {
                        if (DateUtils.grepDate(initiateDate)) {
                            businessplanningeffectdetailVO.setInitiateDate(DateUtils.Date(initiateDate));
                        } else {
                            businessplanningeffectdetailVO.setErrorMsg("立项时间格式不正确！");
                            errorsMsgBuilder.append("立项时间格式不正确！");
                        }
                    }

                    if (StringUtils.isNotBlank(incomeBeforePlan)) {
                        if (NumberUtil.isNumber(incomeBeforePlan)) {
                            businessplanningeffectdetailVO.setIncomeBeforePlan(new BigDecimal(incomeBeforePlan));
                        } else {
                            businessplanningeffectdetailVO.setErrorMsg("策划前收入 （万元）格式不正确！");
                            errorsMsgBuilder.append("策划前收入 （万元）格式不正确！");
                        }
                    }

                    if (StringUtils.isNotBlank(costBeforePlan)) {
                        if (NumberUtil.isNumber(costBeforePlan)) {
                            businessplanningeffectdetailVO.setCostBeforePlan(new BigDecimal(costBeforePlan));
                        } else {
                            businessplanningeffectdetailVO.setErrorMsg("策划前成本（万元）格式不正确！");
                            errorsMsgBuilder.append("策划前成本（万元）格式不正确！");
                        }
                    }

//                    if (StringUtils.isNotBlank(benefitBeforePlan)) {
//                        if (NumberUtil.isNumber(benefitBeforePlan)) {
//                            businessplanningeffectdetailVO.setBenefitBeforePlan(new BigDecimal(benefitBeforePlan));
//                        } else {
//                            businessplanningeffectdetailVO.setErrorMsg("策划前效益（万元）格式不正确！");
//                            errorsMsgBuilder.append("策划前效益（万元）格式不正确！");
//                        }
//                    } else {
                    //为空则自动计算: 策划前收入 （万元）- 策划前成本（万元）
                    BigDecimal benefitBeforePlanC = new BigDecimal(0);
                    BigDecimal incomeBeforePlanB = businessplanningeffectdetailVO.getIncomeBeforePlan();
                    BigDecimal costBeforePlanB = businessplanningeffectdetailVO.getCostBeforePlan();
                    if (incomeBeforePlanB != null && costBeforePlanB != null) {
                        benefitBeforePlanC = incomeBeforePlanB.subtract(costBeforePlanB);
                        businessplanningeffectdetailVO.setBenefitBeforePlan(benefitBeforePlanC);
                    }
//                    }

                    if (StringUtils.isNotBlank(estimatedRevenueAfterPlan)) {
                        if (NumberUtil.isNumber(estimatedRevenueAfterPlan)) {
                            businessplanningeffectdetailVO.setEstimatedRevenueAfterPlan(new BigDecimal(estimatedRevenueAfterPlan));
                        } else {
                            businessplanningeffectdetailVO.setErrorMsg("策划后预计收入（万元）格式不正确！");
                            errorsMsgBuilder.append("策划后预计收入（万元）格式不正确！");
                        }
                    }

                    if (StringUtils.isNotBlank(estimatedCostAfterPlan)) {
                        if (NumberUtil.isNumber(estimatedCostAfterPlan)) {
                            businessplanningeffectdetailVO.setEstimatedCostAfterPlan(new BigDecimal(estimatedCostAfterPlan));
                        } else {
                            businessplanningeffectdetailVO.setErrorMsg("策划后预计成本（万元）格式不正确！");
                            errorsMsgBuilder.append("策划后预计成本（万元）格式不正确！");
                        }
                    }
                    //
//                    if (StringUtils.isNotBlank(estimatedBenefitsAfterPlan)) {
//                        if (NumberUtil.isNumber(estimatedBenefitsAfterPlan)) {
//                            businessplanningeffectdetailVO.setEstimatedBenefitsAfterPlan(new BigDecimal(estimatedBenefitsAfterPlan));
//                        } else {
//                            businessplanningeffectdetailVO.setErrorMsg("策划后预计效益（万元）格式不正确！");
//                            errorsMsgBuilder.append("策划后预计效益（万元）格式不正确！");
//                        }
//                    } else {
                        //为空则自动计算: 策划后预计收入（万元）- 策划后预计成本（万元）
                        BigDecimal estimatedBenefitsAfterPlanB = new BigDecimal(0);
                        BigDecimal estimatedRevenueAfterPlanB = businessplanningeffectdetailVO.getEstimatedRevenueAfterPlan();
                        BigDecimal estimatedCostAfterPlanB = businessplanningeffectdetailVO.getEstimatedCostAfterPlan();
                        if (estimatedRevenueAfterPlanB != null && estimatedCostAfterPlanB != null) {
                            estimatedBenefitsAfterPlanB = estimatedRevenueAfterPlanB.subtract(estimatedCostAfterPlanB);
                            businessplanningeffectdetailVO.setEstimatedBenefitsAfterPlan(estimatedBenefitsAfterPlanB);
                        }
//                    }
//                    if (StringUtils.isNotBlank(planExpectAchieveResults)) {
//                        if (NumberUtil.isNumber(planExpectAchieveResults)) {
//                            businessplanningeffectdetailVO.setPlanExpectAchieveResults(new BigDecimal(planExpectAchieveResults));
//                        } else {
//                            businessplanningeffectdetailVO.setErrorMsg("策划预计创效（万元）格式不正确！");
//                            errorsMsgBuilder.append("策划预计创效（万元）格式不正确！");
//                        }
//                    }else{
                        //为空则自动计算: 策划后预计收入（万元）- 策划后预计成本（万元）
                        BigDecimal estimatedBenefitsAfterPlanC = businessplanningeffectdetailVO.getEstimatedBenefitsAfterPlan();
                        BigDecimal benefitBeforePlanB = businessplanningeffectdetailVO.getBenefitBeforePlan();
                        if (estimatedBenefitsAfterPlanC != null && benefitBeforePlanB != null) {
                            businessplanningeffectdetailVO.setPlanExpectAchieveResults(estimatedBenefitsAfterPlanC.subtract(benefitBeforePlanB));
                        }
//                    }


                    if (StringUtils.isNotBlank(proposedCompleteTime)) {
                        if (DateUtils.grepDate(proposedCompleteTime)) {
                            businessplanningeffectdetailVO.setProposedCompleteTime(DateUtils.Date(proposedCompleteTime));
                        } else {
                            businessplanningeffectdetailVO.setErrorMsg("拟完成时间节点格式不正确！");
                            errorsMsgBuilder.append("拟完成时间节点格式不正确！");
                        }
                    }

                    if (StringUtils.isNotBlank(supervisionNotReportedMoney)) {
                        if (NumberUtil.isNumber(supervisionNotReportedMoney)) {
                            businessplanningeffectdetailVO.setSupervisionNotReportedMoney(new BigDecimal(supervisionNotReportedMoney));
                        } else {
                            businessplanningeffectdetailVO.setErrorMsg("（监理单位未上报）金额格式不正确！");
                            errorsMsgBuilder.append("（监理单位未上报）金额格式不正确！");
                        }
                    }

                    if (StringUtils.isNotBlank(supervisionNotReportedTime)) {
                        if (DateUtils.grepDate(supervisionNotReportedTime)) {
                            businessplanningeffectdetailVO.setSupervisionNotReportedTime(DateUtils.Date(supervisionNotReportedTime));
                        } else {
                            businessplanningeffectdetailVO.setErrorMsg("（监理单位未上报）预计上报时间格式不正确！");
                            errorsMsgBuilder.append("（监理单位未上报）预计上报时间格式不正确！");
                        }
                    }

                    if (StringUtils.isNotBlank(supervisionReportedMoney)) {
                        if (NumberUtil.isNumber(supervisionReportedMoney)) {
                            businessplanningeffectdetailVO.setSupervisionReportedMoney(new BigDecimal(supervisionReportedMoney));
                        } else {
                            businessplanningeffectdetailVO.setErrorMsg("（监理单位已上报未批复）金额格式不正确！");
                            errorsMsgBuilder.append("（监理单位已上报未批复）金额格式不正确！");
                        }
                    }

                    if (StringUtils.isNotBlank(supervisionReportedTime)) {
                        if (DateUtils.grepDate(supervisionReportedTime)) {
                            businessplanningeffectdetailVO.setSupervisionReportedTime(DateUtils.Date(supervisionReportedTime));
                        } else {
                            businessplanningeffectdetailVO.setErrorMsg("（监理单位已上报未批复）上报时间格式不正确！");
                            errorsMsgBuilder.append("（监理单位已上报未批复）上报时间格式不正确！");
                        }
                    }

                    if (StringUtils.isNotBlank(supervisionApprovedMoney)) {
                        if (NumberUtil.isNumber(supervisionApprovedMoney)) {
                            businessplanningeffectdetailVO.setSupervisionApprovedMoney(new BigDecimal(supervisionApprovedMoney));
                        } else {
                            businessplanningeffectdetailVO.setErrorMsg("（监理单位已批复）金额格式不正确！");
                            errorsMsgBuilder.append("（监理单位已批复）金额格式不正确！");
                        }
                    }

                    if (StringUtils.isNotBlank(supervisionApprovedTime)) {
                        if (DateUtils.grepDate(supervisionApprovedTime)) {
                            businessplanningeffectdetailVO.setSupervisionApprovedTime(DateUtils.Date(supervisionApprovedTime));
                        } else {
                            businessplanningeffectdetailVO.setErrorMsg("（监理单位已批复）上报时间格式不正确！");
                            errorsMsgBuilder.append("（监理单位已批复）上报时间格式不正确！");
                        }
                    }

                    if (StringUtils.isNotBlank(ownerNotReportedMoney)) {
                        if (NumberUtil.isNumber(ownerNotReportedMoney)) {
                            businessplanningeffectdetailVO.setOwnerNotReportedMoney(new BigDecimal(ownerNotReportedMoney));
                        } else {
                            businessplanningeffectdetailVO.setErrorMsg("（业主单位未上报）金额格式不正确！");
                            errorsMsgBuilder.append("（业主单位未上报）金额格式不正确！");
                        }
                    }

                    if (StringUtils.isNotBlank(ownerNotReportedTime)) {
                        if (DateUtils.grepDate(ownerNotReportedTime)) {
                            businessplanningeffectdetailVO.setOwnerNotReportedTime(DateUtils.Date(ownerNotReportedTime));
                        } else {
                            businessplanningeffectdetailVO.setErrorMsg("（业主单位未上报）预计上报时间格式不正确！");
                            errorsMsgBuilder.append("（业主单位未上报）预计上报时间格式不正确！");
                        }
                    }

                    if (StringUtils.isNotBlank(ownerReportedMoney)) {
                        if (NumberUtil.isNumber(ownerReportedMoney)) {
                            businessplanningeffectdetailVO.setOwnerReportedMoney(new BigDecimal(ownerReportedMoney));
                        } else {
                            businessplanningeffectdetailVO.setErrorMsg("（业主单位已上报未批复）金额格式不正确！");
                            errorsMsgBuilder.append("（业主单位已上报未批复）金额格式不正确！");
                        }
                    }

                    if (StringUtils.isNotBlank(ownerReportedTime)) {
                        if (DateUtils.grepDate(ownerReportedTime)) {
                            businessplanningeffectdetailVO.setOwnerReportedTime(DateUtils.Date(ownerReportedTime));
                        } else {
                            businessplanningeffectdetailVO.setErrorMsg("业主单位已上报未批复）上报时间格式不正确！");
                            errorsMsgBuilder.append("业主单位已上报未批复）上报时间格式不正确！");
                        }
                    }

                    if (StringUtils.isNotBlank(ownerApprovedMoney)) {
                        if (NumberUtil.isNumber(ownerApprovedMoney)) {
                            businessplanningeffectdetailVO.setOwnerApprovedMoney(new BigDecimal(ownerApprovedMoney));
                        } else {
                            businessplanningeffectdetailVO.setErrorMsg("（业主单位已批复）金额格式不正确！");
                            errorsMsgBuilder.append("（业主单位已批复）金额格式不正确！");
                        }
                    }

                    if (StringUtils.isNotBlank(ownerApprovedTime)) {
                        if (DateUtils.grepDate(ownerApprovedTime)) {
                            businessplanningeffectdetailVO.setOwnerApprovedTime(DateUtils.Date(ownerApprovedTime));
                        } else {
                            businessplanningeffectdetailVO.setErrorMsg("（业主单位已批复）上报时间格式不正确！");
                            errorsMsgBuilder.append("（业主单位已批复）上报时间格式不正确！");
                        }
                    }

                    if (StringUtils.isNotBlank(revenueAfterPlan)) {
                        if (NumberUtil.isNumber(revenueAfterPlan)) {
                            businessplanningeffectdetailVO.setRevenueAfterPlan(new BigDecimal(revenueAfterPlan));
                        } else {
                            businessplanningeffectdetailVO.setErrorMsg("策划后收入（万元）格式不正确！");
                            errorsMsgBuilder.append("策划后收入（万元）格式不正确！");
                        }
                    }

                    if (StringUtils.isNotBlank(actualCost)) {
                        if (NumberUtil.isNumber(actualCost)) {
                            businessplanningeffectdetailVO.setActualCost(new BigDecimal(actualCost));
                        } else {
                            businessplanningeffectdetailVO.setErrorMsg("实际成本（万元）格式不正确！");
                            errorsMsgBuilder.append("实际成本（万元）格式不正确！");
                        }
                    }

//                    if (StringUtils.isNotBlank(benefitAfterPlan)) {
//                        if (NumberUtil.isNumber(benefitAfterPlan)) {
//                            businessplanningeffectdetailVO.setBenefitAfterPlan(new BigDecimal(benefitAfterPlan));
//                        } else {
//                            businessplanningeffectdetailVO.setErrorMsg("策划后效益（万元）格式不正确！");
//                            errorsMsgBuilder.append("策划后效益（万元）格式不正确！");
//                        }
//                    } else {
                        //为空则自动计算: 策划后收入（万元）- 实际成本（万元
                        BigDecimal benefitAfterPlanB = new BigDecimal(0);
                        BigDecimal revenueAfterPlanB = businessplanningeffectdetailVO.getRevenueAfterPlan();
                        BigDecimal actualCostB = businessplanningeffectdetailVO.getActualCost();
                        if (revenueAfterPlanB != null && actualCostB != null) {
                            benefitAfterPlanB = revenueAfterPlanB.subtract(actualCostB);
                            businessplanningeffectdetailVO.setBenefitAfterPlan(benefitAfterPlanB);
                        }
//                    }

//                    if (StringUtils.isNotBlank(includePlannedActualEffect)) {
//                        if (NumberUtil.isNumber(includePlannedActualEffect)) {
//                            businessplanningeffectdetailVO.setIncludePlannedActualEffect(new BigDecimal(includePlannedActualEffect));
//                        } else {
//                            businessplanningeffectdetailVO.setErrorMsg("其中：策划实际创效（万元）格式不正确！");
//                            errorsMsgBuilder.append("其中：策划实际创效（万元）格式不正确！");
//                        }
//                    } else {
                        //为空则自动计算: 策划后效益（万元）- 策划前效益（万元）
                        BigDecimal includePlannedActualEffectB = new BigDecimal(0);
                        BigDecimal benefitAfterPlanC = businessplanningeffectdetailVO.getBenefitAfterPlan();
                        BigDecimal benefitBeforePlanD = businessplanningeffectdetailVO.getBenefitBeforePlan();
                        if (benefitAfterPlanC != null && benefitBeforePlanD != null) {
                            includePlannedActualEffectB = benefitAfterPlanC.subtract(benefitBeforePlanD);
                            businessplanningeffectdetailVO.setIncludePlannedActualEffect(includePlannedActualEffectB);
                        }
//                    }
                    if (!pcStrList.contains(businessplanningeffectdetailVO.getSort().toString() + businessplanningeffectdetailVO.getCategoryAndName().toString())) {
                        businessplanningeffectdetailVO.setErrorMsg("未在表体中，不允许新增！");
                        errorsMsgBuilder.append("未在表体中，不允许新增！");
                    }
                    if (errorsMsgBuilder.length() > 0) {
                        errorList.add(businessplanningeffectdetailVO);
                    } else {
                        successList.add(businessplanningeffectdetailVO);
                    }
                }
            }
        }
        //设置tid和tpid
        List<BusinessplanningeffectdetailVO> resList = setTidAndTpid(successList);

        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", resList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

    /**
     * 设置tid和tpid
     *
     * @param originalList
     * @return
     */
    private List<BusinessplanningeffectdetailVO> setTidAndTpid(List<BusinessplanningeffectdetailVO> originalList) {
        List<BusinessplanningeffectdetailVO> treeList = new ArrayList<>();
        String currentTime = String.valueOf(System.currentTimeMillis());
        if (originalList != null && originalList.size() > 0) {
            for (int i = 0; i < originalList.size(); i++) {
                BusinessplanningeffectdetailVO businessplanningeffectdetailVO = originalList.get(i);
                String sort = businessplanningeffectdetailVO.getSort();
                String[] arr = sort.split("\\.");

                if (arr.length == 1) {
                    businessplanningeffectdetailVO.setTid(currentTime + "_" + sort);
                    businessplanningeffectdetailVO.setTpid("");
                    treeList.add(businessplanningeffectdetailVO);
                } else if (arr.length > 1) {
                    businessplanningeffectdetailVO.setTid(currentTime + "_" + sort);
                    businessplanningeffectdetailVO.setTpid(currentTime + "_" + sort.substring(0, sort.length() - 2));
                    treeList.add(businessplanningeffectdetailVO);
                }
            }
        }
        return createTreeData(treeList);
    }

    /**
     * 构建树
     *
     * @param list
     * @return
     */
    public static List<BusinessplanningeffectdetailVO> createTreeData(List<BusinessplanningeffectdetailVO> list) {
        List<BusinessplanningeffectdetailVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();

        //循环list，放入listMap重
        Map<String, BusinessplanningeffectdetailVO> listMap = new HashMap<>();
        for (BusinessplanningeffectdetailVO item : list) {
            listMap.put(item.getTid().toString(), item);
        }

        for (int i = 0; i < list.size(); i++) {
            BusinessplanningeffectdetailVO item = list.get(i);
            String parentId = (item.getTpid() != null) ? item.getTpid().toString() : "";
            BusinessplanningeffectdetailVO parent = listMap.get(parentId);
            if (parent != null) {
                List<BusinessplanningeffectdetailVO> child = (List<BusinessplanningeffectdetailVO>) parent.getChildren();
                if (child != null) {
                    child.add(item);
                } else {
                    List<BusinessplanningeffectdetailVO> children = new ArrayList<BusinessplanningeffectdetailVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getTid());
            }
        }

        for (String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }

    /**
     * excel导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportBusinessplanningeffectFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportbusinessplanningeffectFromDatabase(@RequestBody BusinessplanningeffectVO businessplanningeffectVO, HttpServletResponse response) {
        QueryWrapper<BusinessplanningeffectdetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", businessplanningeffectVO.getId());
        queryWrapper.eq("dr", 0);
        List<BusinessplanningeffectdetailEntity> list = businessplanningeffectdetailService.list(queryWrapper);
        List<BusinessplanningeffectdetailVO> resList = BeanMapper.mapList(list, BusinessplanningeffectdetailVO.class);

        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", handleSpecialField(resList));
        ExcelExport.getInstance().export("businessplanningeffect-export.xlsx", beans, response);
    }

    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportBusinessplanningeffectFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportbusinessplanningeffectFromPage(@RequestBody List<BusinessplanningeffectdetailVO> list, HttpServletResponse response) {
        List<BusinessplanningeffectdetailVO> concatList = new ArrayList<>();
        for (int i = 0; i < list.size(); i++) {
            BusinessplanningeffectdetailVO businessplanningeffectdetailVO = list.get(i);
            concatList.add(businessplanningeffectdetailVO);
        }

        //children拍平
        List<BusinessplanningeffectdetailVO> allList = handleList(list, concatList);
        //按序号排序
        Collections.sort(allList, new Comparator<BusinessplanningeffectdetailVO>() {
            @Override
            public int compare(BusinessplanningeffectdetailVO o1, BusinessplanningeffectdetailVO o2) {
                return o1.getSort().compareTo(o2.getSort());
            }
        });

        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", handleSpecialField(allList));
        ExcelExport.getInstance().export("businessplanningeffect-export.xlsx", beans, response);
    }

    /**
     * 处理特殊字段 如：日期
     *
     * @param allList
     */
    private List<BusinessplanningeffectdetailVO> handleSpecialField(List<BusinessplanningeffectdetailVO> allList) {
        //处理日期字段
        for (int i = 0; i < allList.size(); i++) {
            BusinessplanningeffectdetailVO businessplanningeffectdetailVO = allList.get(i);
            if (businessplanningeffectdetailVO.getCompleteTime() != null) {
                businessplanningeffectdetailVO.setCompleteTimeShow(DateUtils.dateSimple(businessplanningeffectdetailVO.getCompleteTime()));
            }
            if (businessplanningeffectdetailVO.getInitiateDate() != null) {
                businessplanningeffectdetailVO.setLxDateShow(DateUtils.dateSimple(businessplanningeffectdetailVO.getInitiateDate()));
            }
            if (businessplanningeffectdetailVO.getProposedCompleteTime() != null) {
                businessplanningeffectdetailVO.setProposedCompleteTimeShow(DateUtils.dateSimple(businessplanningeffectdetailVO.getProposedCompleteTime()));
            }
            if (businessplanningeffectdetailVO.getFinalCompleteTime() != null) {
                businessplanningeffectdetailVO.setFinalCompleteTimeShow(DateUtils.dateSimple(businessplanningeffectdetailVO.getFinalCompleteTime()));
            }
            if (businessplanningeffectdetailVO.getSupervisionNotReportedTime() != null) {
                businessplanningeffectdetailVO.setSupervisionNotReportedTimeShow(DateUtils.dateSimple(businessplanningeffectdetailVO.getSupervisionNotReportedTime()));
            }
            if (businessplanningeffectdetailVO.getSupervisionReportedTime() != null) {
                businessplanningeffectdetailVO.setSupervisionReportedTimeShow(DateUtils.dateSimple(businessplanningeffectdetailVO.getSupervisionReportedTime()));
            }
            if (businessplanningeffectdetailVO.getSupervisionApprovedTime() != null) {
                businessplanningeffectdetailVO.setSupervisionApprovedTimeShow(DateUtils.dateSimple(businessplanningeffectdetailVO.getSupervisionApprovedTime()));
            }
            if (businessplanningeffectdetailVO.getOwnerNotReportedTime() != null) {
                businessplanningeffectdetailVO.setOwnerNotReportedTimeShow(DateUtils.dateSimple(businessplanningeffectdetailVO.getOwnerNotReportedTime()));
            }
            if (businessplanningeffectdetailVO.getOwnerReportedTime() != null) {
                businessplanningeffectdetailVO.setOwnerReportedTimeShow(DateUtils.dateSimple(businessplanningeffectdetailVO.getOwnerReportedTime()));
            }
            if (businessplanningeffectdetailVO.getOwnerApprovedTime() != null) {
                businessplanningeffectdetailVO.setOwnerApprovedTimeShow(DateUtils.dateSimple(businessplanningeffectdetailVO.getOwnerApprovedTime()));
            }
        }

        return allList;
    }

    /**
     * 导出页面数据处理children
     *
     * @param list
     */
    private List<BusinessplanningeffectdetailVO> handleList(List<BusinessplanningeffectdetailVO> list, List<BusinessplanningeffectdetailVO> concatList) {
        if (list == null || list.size() == 0) {
            return concatList;
        }

        for (int i = 0; i < list.size(); i++) {
            BusinessplanningeffectdetailVO businessplanningeffectdetailVO = list.get(i);
            List<BusinessplanningeffectdetailVO> children = businessplanningeffectdetailVO.getChildren();
            if (children != null && children.size() > 0) {
                concatList.addAll(children);
                handleList(children, concatList);
            }
        }

        return concatList;
    }
}
