package com.ejianc.business.change.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.busniessplan.bean.BusinessplanningeffectEntity;
import com.ejianc.business.busniessplan.bean.BusinessplanningeffectdetailEntity;
import com.ejianc.business.busniessplan.bean.PlanprojectEntity;
import com.ejianc.business.busniessplan.bean.PlanprojectdetailEntity;
import com.ejianc.business.busniessplan.service.IBusinessplanningeffectService;
import com.ejianc.business.busniessplan.service.IPlanprojectService;
import com.ejianc.business.busniessplan.service.IPlanprojectdetailService;
import com.ejianc.business.busniessplan.vo.BusinessplanningeffectVO;
import com.ejianc.business.busniessplan.vo.PlanprojectVO;
import com.ejianc.business.busniessplan.vo.PlanprojectdetailVO;
import com.ejianc.business.change.bean.ChangePlanprojectEntity;
import com.ejianc.business.change.bean.ChangebusinessplanningeffectEntity;
import com.ejianc.business.change.service.IChangebusinessplanningeffectService;
import com.ejianc.business.change.vo.ChangebusinessplaneffectdetailVO;
import com.ejianc.business.change.vo.ChangebusinessplanningeffectVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;




/**
 * 项目商务策划效果变更
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("changebusinessplanningeffect")
public class ChangebusinessplanningeffectController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IPlanprojectService planprojectService;
    @Autowired
    private IPlanprojectdetailService planprojectdetailService;


    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IChangebusinessplanningeffectService service;
    @Autowired
    private IBusinessplanningeffectService businessplanningeffectService;

    /**
     * 初始化更详情页面
     *
     * @return
     */
    @GetMapping(value = "queryDetailByBusinessplanningeffectId")
    @ResponseBody
    public CommonResponse<ChangebusinessplanningeffectVO> queryDetailByBusinessplanningeffectId(@RequestParam(value = "businessplanningeffectId") Long businessplanningeffectId) {
        BusinessplanningeffectEntity businessplanningeffectVO = businessplanningeffectService.selectById(businessplanningeffectId);
        ChangebusinessplanningeffectVO changeVO = BeanMapper.map(businessplanningeffectVO, ChangebusinessplanningeffectVO.class);
        Long id = IdWorker.getId();
        changeVO.setBusinessplanningeffectId(businessplanningeffectId);
        changeVO.setBillState(null);
        changeVO.setCreateTime(null);
        changeVO.setCreateUserCode(null);
        changeVO.setTenantId(null);
        changeVO.setUpdateTime(null);
        changeVO.setUpdateUserCode(null);
        changeVO.setId(id);

        //策划立项子表数据
        QueryWrapper<PlanprojectEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("dr", 0);
        queryWrapper.eq("project_id", businessplanningeffectVO.getProjectId());
        queryWrapper.in("bill_state", 1,3);
        List<PlanprojectEntity> entityList = planprojectService.list(queryWrapper);

        QueryWrapper<PlanprojectdetailEntity> queryWrapper1 = new QueryWrapper<>();
        queryWrapper1.eq("dr", 0);
        queryWrapper1.eq("mid", entityList.get(0).getId());
        List<PlanprojectdetailEntity> list = planprojectdetailService.list(queryWrapper1);
        entityList.get(0).setPlanprojectdetailEntities(list);
        PlanprojectVO entity1 = BeanMapper.map(entityList.get(0), PlanprojectVO.class);
        List<PlanprojectdetailVO> businessplanningeffectdetailEntities = entity1.getPlanprojectdetailEntities();
        for(PlanprojectdetailVO planprojectdetailVO : businessplanningeffectdetailEntities){
            planprojectdetailVO.setId(IdWorker.getId());
        }
        List<PlanprojectdetailVO> planprojectdetailVOList = businessplanningeffectdetailEntities.stream()
                .collect(Collectors.collectingAndThen(Collectors.toCollection(
                        () -> new TreeSet<>(Comparator.comparing(PlanprojectdetailVO::getCategoryAndName))), ArrayList::new));

        Map<String, PlanprojectdetailVO> map = planprojectdetailVOList.stream().collect(Collectors.toMap(PlanprojectdetailVO::getCategoryAndName, Function.identity()));

        //子表
        List<ChangebusinessplaneffectdetailVO> changebusinessplaneffectdetailVO = new ArrayList<>();
        List<BusinessplanningeffectdetailEntity> businessplanningeffectdetailList = businessplanningeffectVO.getBusinessplanningeffectdetailEntities();
        Map<String, BusinessplanningeffectdetailEntity> mapZ = new HashMap<>();
        if(businessplanningeffectdetailList!=null&&businessplanningeffectdetailList.size()>0){
            ArrayList<BusinessplanningeffectdetailEntity> businessplanningeffectdetailEntityArrayList = businessplanningeffectdetailList.stream()
                    .collect(Collectors.collectingAndThen(Collectors.toCollection(
                            () -> new TreeSet<>(Comparator.comparing(BusinessplanningeffectdetailEntity::getCategoryAndName))), ArrayList::new));
            mapZ = businessplanningeffectdetailEntityArrayList.stream().collect(Collectors.toMap(BusinessplanningeffectdetailEntity::getCategoryAndName, Function.identity()));

            for(BusinessplanningeffectdetailEntity entity : businessplanningeffectdetailList){
                ChangebusinessplaneffectdetailVO vo = BeanMapper.map(entity, ChangebusinessplaneffectdetailVO.class);
                vo.setMid(id);
                vo.setCreateTime(null);
                vo.setCreateUserCode(null);
                vo.setTenantId(null);
                vo.setUpdateTime(null);
                vo.setUpdateUserCode(null);
                vo.setRowState("edit");
                vo.setId(IdWorker.getId());
                changebusinessplaneffectdetailVO.add(vo);

            }
//            List<ChangebusinessplaneffectdetailVO> resChangebusinessplaneffectdetail = createTreeData(changebusinessplaneffectdetailVO);

        }

        for (PlanprojectdetailVO planprojectdetailVO : businessplanningeffectdetailEntities){
            if (!mapZ.containsKey(planprojectdetailVO.getCategoryAndName())){
                ChangebusinessplaneffectdetailVO vo = BeanMapper.map(planprojectdetailVO, ChangebusinessplaneffectdetailVO.class);
                vo.setMid(id);
                vo.setCreateTime(null);
                vo.setCreateUserCode(null);
                vo.setTenantId(null);
                vo.setUpdateTime(null);
                vo.setUpdateUserCode(null);
                vo.setRowState("edit");
                vo.setId(IdWorker.getId());
                changebusinessplaneffectdetailVO.add(vo);
            }
        }

        changeVO.setBusinessplanningeffectdetailEntities(changebusinessplaneffectdetailVO);

        return CommonResponse.success("查询详情成功！", changeVO);

    }
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveChange", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ChangebusinessplanningeffectVO> saveOrUpdate(@RequestBody ChangebusinessplanningeffectVO saveOrUpdateVO) {
        return service.saveChange(saveOrUpdateVO);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ChangebusinessplanningeffectVO> queryDetail(Long id) {
    	ChangebusinessplanningeffectEntity entity = service.selectById(id);
    	ChangebusinessplanningeffectVO vo = BeanMapper.map(entity, ChangebusinessplanningeffectVO.class);


        //构建树形结构
        List<ChangebusinessplaneffectdetailVO> businessplanningeffectVO = vo.getBusinessplanningeffectdetailEntities();
        List<ChangebusinessplaneffectdetailVO> resBusinessplanningeffectVO = createTreeData(businessplanningeffectVO);
        vo.setBusinessplanningeffectdetailEntities(resBusinessplanningeffectVO);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BusinessplanningeffectVO> vos) {
        return service.deleteBusinessplanningeffect(vos);
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ChangebusinessplanningeffectVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<ChangebusinessplanningeffectEntity> page = service.queryPage(param,false);
        IPage<ChangebusinessplanningeffectVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ChangebusinessplanningeffectVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ChangebusinessplanningeffectEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Changebusinessplanningeffect-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refChangebusinessplanningeffectData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ChangebusinessplanningeffectVO>> refChangebusinessplanningeffectData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ChangebusinessplanningeffectEntity> page = service.queryPage(param,false);
        IPage<ChangebusinessplanningeffectVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ChangebusinessplanningeffectVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    public static List<ChangebusinessplaneffectdetailVO> createTreeData(List<ChangebusinessplaneffectdetailVO> list) {
        List<ChangebusinessplaneffectdetailVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();

        //循环list，放入listMap重
        Map<String, ChangebusinessplaneffectdetailVO> listMap = new HashMap<>();
        for(ChangebusinessplaneffectdetailVO item:list) {
            listMap.put(item.getTid().toString(), item);
        }

        for(int i =0; i<list.size(); i++) {
            ChangebusinessplaneffectdetailVO item = list.get(i);
            String parentId = (item.getTpid() != null) ? item.getTpid().toString():"";
            ChangebusinessplaneffectdetailVO parent = listMap.get(parentId);
            if(parent != null) {
                List<ChangebusinessplaneffectdetailVO> child = (List<ChangebusinessplaneffectdetailVO>) parent.getChildren();
                if(child != null) {
                    child.add(item);
                }else{
                    List<ChangebusinessplaneffectdetailVO> children = new ArrayList<ChangebusinessplaneffectdetailVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getTid());
            }
        }

        for(String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }
}
