/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.change.excel;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.change.service.IChangemaintargetdetailService;
import com.ejianc.business.change.vo.ChangemaintargetdetailVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"changeMaintargetExport"})
public class ExcelChangeMaintargetController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IChangemaintargetdetailService changemaintargetdetailService;

    @RequestMapping(value={"/downloadMaintarget"})
    @ResponseBody
    public void downloadTotalPrice(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"maintarget-import.xlsx", (String)"\u5546\u52a1\u7b56\u5212\u4e66\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportMaintarget"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportTotalPric(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<ChangemaintargetdetailVO> successList = new ArrayList<ChangemaintargetdetailVO>();
        ArrayList<ChangemaintargetdetailVO> errorList = new ArrayList<ChangemaintargetdetailVO>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            String[] innateSort = new String[]{"1", "2", "3", "4", "4.1", "4.2", "4.3", "5", "5.1", "5.2", "5.3", "5.4", "5.5", "6", "6.1", "6.2", "7", "8", "9", "10"};
            List<String> sortList = Arrays.asList(innateSort);
            String[] innateName = new String[]{"\u5411\u516c\u53f8\u4e0a\u7f34\u5229\u6da6", "\u9884\u7559\u98ce\u9669\u91d1", "\u9879\u76ee\u8ba1\u5212\u5b9e\u73b0\u5229\u6da6", "\u7ed3\u7b97\u786e\u6743\u76ee\u6807", "\u4e2d\u95f4\u786e\u6743\u7387", "\u4e2d\u95f4\u8ba1\u91cf\u786e\u8ba4\u7387", "\u4e2d\u95f4\u9636\u6bb5\u7ed3\u7b97\u76ee\u6807", "\u6210\u672c\u7ba1\u7406\u76ee\u6807", "\u81ea\u884c\u5b8c\u6210\u5408\u540c\u9020\u4ef7", "\u6807\u51c6\u6210\u672c\uff08\u542b\u7a0e\uff09", "\u8d23\u4efb\u6210\u672c\uff08\u542b\u7a0e\uff09", "\u9879\u76ee\u8ba1\u5212\u6210\u672c\uff08\u542b\u7a0e)", "\u6210\u672c\u8ba1\u5212\u964d\u4f4e\u989d", "\u5206\u4f9b\u65b9\u7ed3\u7b97\u76ee\u6807", "\u4f9b\u65b9\u7ed3\u7b97\u76ee\u6807", "\u5206\u5305\u7ed3\u7b97\u76ee\u6807", "\u5de5\u7a0b\u6b3e\u56de\u6536\u76ee\u6807", "\u8d28\u91cf\u76ee\u6807", "\u73b0\u573a\u7ba1\u7406\u76ee\u6807", "\u5b89\u5168\u548c\u73af\u5883\u76ee\u6807"};
            for (int i = 1; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                String sort = (String)datas.get(0);
                ChangemaintargetdetailVO maintargetdetailVO = new ChangemaintargetdetailVO();
                maintargetdetailVO.setId(IdWorker.getId());
                String projectName = (String)datas.get(1);
                maintargetdetailVO.setSort(StringUtils.isNotBlank((CharSequence)sort) ? sort : null);
                maintargetdetailVO.setProjectName(StringUtils.isNotBlank((CharSequence)projectName) ? projectName : null);
                maintargetdetailVO.setTarget(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(2))) ? (String)datas.get(2) : null);
                maintargetdetailVO.setRemarks(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(3))) ? (String)datas.get(3) : null);
                if (StringUtils.isEmpty((CharSequence)sort)) {
                    maintargetdetailVO.setErrorMsg("\u5e8f\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(maintargetdetailVO);
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)projectName)) {
                    maintargetdetailVO.setErrorMsg("\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(maintargetdetailVO);
                    continue;
                }
                if (i < innateSort.length + 1) {
                    if (!sortList.contains(sort)) {
                        maintargetdetailVO.setErrorMsg("\u5e8f\u53f7\u4e0e\u6a21\u677f\u4e0d\u4e00\u81f4");
                        errorList.add(maintargetdetailVO);
                        continue;
                    }
                    if (!sortList.contains(sort)) {
                        maintargetdetailVO.setErrorMsg("\u9879\u76ee\u4e0e\u6a21\u677f\u4e0d\u4e00\u81f4");
                        errorList.add(maintargetdetailVO);
                        continue;
                    }
                } else if (sortList.contains(sort)) {
                    maintargetdetailVO.setErrorMsg("\u5e8f\u53f7\u4e0d\u5141\u8bb8\u91cd\u590d");
                    errorList.add(maintargetdetailVO);
                    continue;
                }
                successList.add(maintargetdetailVO);
            }
        }
        List<ChangemaintargetdetailVO> resList = this.setTidAndTpid(successList);
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", resList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }

    private List<ChangemaintargetdetailVO> setTidAndTpid(List<ChangemaintargetdetailVO> originalList) {
        ArrayList<ChangemaintargetdetailVO> treeList = new ArrayList<ChangemaintargetdetailVO>();
        String currentTime = String.valueOf(System.currentTimeMillis());
        if (originalList != null && originalList.size() > 0) {
            for (int i = 0; i < originalList.size(); ++i) {
                ChangemaintargetdetailVO maintargetdetailVO = originalList.get(i);
                String sort = maintargetdetailVO.getSort();
                String[] arr = sort.split("\\.");
                maintargetdetailVO.setId(IdWorker.getId());
                maintargetdetailVO.setTid(currentTime + "_" + sort);
                if (arr.length == 1) {
                    maintargetdetailVO.setTpid("");
                } else if (arr.length > 1) {
                    maintargetdetailVO.setTpid(currentTime + "_" + sort.substring(0, sort.length() - 2));
                }
                treeList.add(maintargetdetailVO);
            }
        }
        return ExcelChangeMaintargetController.createTreeData(treeList);
    }

    public static List<ChangemaintargetdetailVO> createTreeData(List<ChangemaintargetdetailVO> list) {
        ArrayList<ChangemaintargetdetailVO> resp = new ArrayList<ChangemaintargetdetailVO>();
        ArrayList<String> rootItems = new ArrayList<String>();
        HashMap<String, ChangemaintargetdetailVO> listMap = new HashMap<String, ChangemaintargetdetailVO>();
        for (ChangemaintargetdetailVO item : list) {
            listMap.put(item.getTid().toString(), item);
        }
        for (int i = 0; i < list.size(); ++i) {
            ChangemaintargetdetailVO item;
            item = list.get(i);
            String parentId = item.getTpid() != null ? item.getTpid().toString() : "";
            ChangemaintargetdetailVO parent = (ChangemaintargetdetailVO)((Object)listMap.get(parentId));
            if (parent != null) {
                List<ChangemaintargetdetailVO> child = parent.getChildren();
                if (child != null) {
                    child.add(item);
                    continue;
                }
                ArrayList<ChangemaintargetdetailVO> children = new ArrayList<ChangemaintargetdetailVO>();
                children.add(item);
                parent.setChildren(children);
                continue;
            }
            rootItems.add(item.getTid());
        }
        for (String rootId : rootItems) {
            resp.add((ChangemaintargetdetailVO)((Object)listMap.get(rootId)));
        }
        return resp;
    }

    @RequestMapping(value={"/excelExportMaintargetFromDatabase"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportbusinessplanningeffectFromDatabase(@RequestBody ChangemaintargetdetailVO maintargetVO, HttpServletResponse response) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"mid", (Object)maintargetVO.getId());
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.changemaintargetdetailService.list((Wrapper)queryWrapper);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("maintarget-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelExportMaintargetFromPage"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportbusinessplanningeffectFromPage(@RequestBody List<ChangemaintargetdetailVO> list, HttpServletResponse response) {
        ArrayList<ChangemaintargetdetailVO> concatList = new ArrayList<ChangemaintargetdetailVO>();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                ChangemaintargetdetailVO maintargetdetailVO = list.get(i);
                maintargetdetailVO.setSort(String.valueOf(i + 1));
                concatList.add(maintargetdetailVO);
            }
        }
        List<ChangemaintargetdetailVO> allList = this.handleList(list, concatList);
        Collections.sort(allList, new Comparator<ChangemaintargetdetailVO>(){

            @Override
            public int compare(ChangemaintargetdetailVO o1, ChangemaintargetdetailVO o2) {
                return o1.getTid().compareTo(o2.getTid());
            }
        });
        HashMap<String, List<ChangemaintargetdetailVO>> beans = new HashMap<String, List<ChangemaintargetdetailVO>>();
        beans.put("records", allList);
        ExcelExport.getInstance().export("maintarget-export.xlsx", beans, response);
    }

    private List<ChangemaintargetdetailVO> handleList(List<ChangemaintargetdetailVO> list, List<ChangemaintargetdetailVO> concatList) {
        if (list == null || list.size() == 0) {
            return concatList;
        }
        for (int i = 0; i < list.size(); ++i) {
            ChangemaintargetdetailVO maintargetdetailVO = list.get(i);
            List<ChangemaintargetdetailVO> children = maintargetdetailVO.getChildren();
            if (children == null || children.size() <= 0) continue;
            concatList.addAll(children);
            this.handleList(children, concatList);
        }
        return concatList;
    }
}

