package com.ejianc.business.change.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.busniessplan.bean.ProjectworkplanEntity;
import com.ejianc.business.record.bean.RecordProjectworkplanEntity;
import com.ejianc.business.busniessplan.service.IProjectworkplanService;
import com.ejianc.business.record.service.IRecordProjectworkplanService;
import com.ejianc.business.change.vo.ChangeProjectworkplanVO;
import com.ejianc.business.change.vo.ChangeProjectworkplandetailVO;
import com.ejianc.business.change.service.IChangeProjectworkplanService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.checkerframework.checker.units.qual.A;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.change.mapper.ChangeProjectworkplanMapper;
import com.ejianc.business.change.bean.ChangeProjectworkplanEntity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 项目商务工作计划变更
 * 
 * @author generator
 * 
 */
@Service("changeProjectworkplanService")
public class ChangeProjectworkplanServiceImpl extends BaseServiceImpl<ChangeProjectworkplanMapper, ChangeProjectworkplanEntity> implements IChangeProjectworkplanService {

    @Autowired
    private IProjectworkplanService iProjectworkplanService;

    @Autowired
    private IChangeProjectworkplanService iChangeProjectworkplanService;

    @Autowired
    private IRecordProjectworkplanService iRecordProjectworkplanService;
    @Override
    public CommonResponse<ChangeProjectworkplanVO> saveChange(ChangeProjectworkplanVO saveOrUpdateVO) {
        //检验该单据是否存在
        boolean exitBill = false;
        if(saveOrUpdateVO.getId()!=null){
            ChangeProjectworkplanEntity e = this.getById(saveOrUpdateVO);
            if(e!=null){
                exitBill = true;
            }
        }
        ChangeProjectworkplanEntity entity = BeanMapper.map(saveOrUpdateVO, ChangeProjectworkplanEntity.class);
        //检验是否存在未生效的变更单据，若存在，则不能变更
        QueryWrapper<ChangeProjectworkplanEntity> queryWrapper = new QueryWrapper<ChangeProjectworkplanEntity>();
        queryWrapper.eq("original_id", saveOrUpdateVO.getOriginalId());
        queryWrapper.eq("dr", 0);
        queryWrapper.notIn("bill_state", 1, 3);
        if(saveOrUpdateVO.getId()!=null){
            queryWrapper.ne("id", saveOrUpdateVO.getId());
        }
        List<ChangeProjectworkplanEntity> exit = this.list(queryWrapper);
        if(exit!=null&&exit.size()>0){
            throw new BusinessException("已存在未完成的变更单据，不能新增新的变更单据");
        }
        ChangeProjectworkplanVO vo = BeanMapper.map(entity, ChangeProjectworkplanVO.class);
        vo.setProjectworkplandetailEntities(saveOrUpdateVO.getProjectworkplandetailEntities());
        if(!exitBill){
            //查询当前单据信息，将状态改为变更中
            ProjectworkplanEntity projectworkplanEntity = iProjectworkplanService.selectById(vo.getOriginalId());
            projectworkplanEntity.setChangeState("2");//状态改为变更中
            projectworkplanEntity.setChangeId(vo.getId());
            iProjectworkplanService.saveOrUpdate(projectworkplanEntity, false);
        }
        ChangeProjectworkplanEntity entity1 = BeanMapper.map(vo, ChangeProjectworkplanEntity.class);
        iChangeProjectworkplanService.saveOrUpdate(entity1,false);
        ChangeProjectworkplanVO vo2 = BeanMapper.map(entity1, ChangeProjectworkplanVO.class);
        vo2.setProjectworkplandetailEntities(createTreeData(vo2.getProjectworkplandetailEntities()));
        return CommonResponse.success("保存或修改单据成功！",vo2);
    }

    @Override
    public CommonResponse<String> delete(List<ChangeProjectworkplanVO> vos) {
        for(ChangeProjectworkplanVO vo : vos){
            ChangeProjectworkplanEntity entity = this.getById(vo.getId());
            ProjectworkplanEntity projectworkplanEntity = iProjectworkplanService.selectById(entity.getOriginalId());
            QueryWrapper<RecordProjectworkplanEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("dr", 0);
            queryWrapper.eq("original_id", projectworkplanEntity.getId());
            List<RecordProjectworkplanEntity> records = iRecordProjectworkplanService.list(queryWrapper);
            if(records!=null&&records.size()>0){
                projectworkplanEntity.setChangeState("3");//状态改为已变更
            }else{
                projectworkplanEntity.setChangeState("1");//状态改为未变更
            }
            projectworkplanEntity.setChangeId(null);
            iProjectworkplanService.saveOrUpdate(projectworkplanEntity, false);
        }
        this.removeByIds(vos.stream().map(ChangeProjectworkplanVO::getId).collect(Collectors.toList()),true);

        return CommonResponse.success("删除成功！");
    }

    /**
     * 构建树
     */
    public static List<ChangeProjectworkplandetailVO> createTreeData(List<ChangeProjectworkplandetailVO> list) {
        List<ChangeProjectworkplandetailVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();

        //循环list，放入listMap重
        Map<String, ChangeProjectworkplandetailVO> listMap = new HashMap<>();
        for (ChangeProjectworkplandetailVO item : list) {
            listMap.put(item.getTid().toString(), item);
        }

        for (int i = 0; i < list.size(); i++) {
            ChangeProjectworkplandetailVO item = list.get(i);
            String parentId = (item.getTpid() != null) ? item.getTpid().toString() : "";
            ChangeProjectworkplandetailVO parent = listMap.get(parentId);
            if (parent != null) {
                List<ChangeProjectworkplandetailVO> child = (List<ChangeProjectworkplandetailVO>) parent.getChildren();
                if (child != null) {
                    child.add(item);
                } else {
                    List<ChangeProjectworkplandetailVO> children = new ArrayList<ChangeProjectworkplandetailVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getTid());
            }
        }

        for (String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }

}
