package com.ejianc.business.change.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.busniessplan.bean.MaintargetEntity;
import com.ejianc.business.busniessplan.bean.SubpackageEntity;
import com.ejianc.business.busniessplan.service.IMaintargetService;
import com.ejianc.business.busniessplan.vo.MaintargetVO;
import com.ejianc.business.busniessplan.vo.MaintargetdetailVO;
import com.ejianc.business.change.bean.ChangeMaintargetEntity;
import com.ejianc.business.change.bean.ChangesubpackageEntity;
import com.ejianc.business.change.mapper.ChangeMaintargetMapper;
import com.ejianc.business.change.service.IChangeMaintargetService;
import com.ejianc.business.change.vo.ChangeMaintargetVO;
import com.ejianc.business.change.vo.ChangePlanprojectdetailVO;
import com.ejianc.business.change.vo.ChangemaintargetdetailVO;
import com.ejianc.business.change.vo.ChangesubpackageVO;
import com.ejianc.business.record.bean.RecordMaintargetEntity;
import com.ejianc.business.record.bean.RecordsubpackageEntity;
import com.ejianc.business.record.service.IRecordMaintargetService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;


/**
 * 项目主要目标变更
 * 
 * @author generator
 * 
 */
@Service("changeMaintargetService")
public class ChangeMaintargetServiceImpl extends BaseServiceImpl<ChangeMaintargetMapper, ChangeMaintargetEntity> implements IChangeMaintargetService {

    @Autowired
    private IMaintargetService maintargetService;
    @Autowired
    private IRecordMaintargetService recordMaintargetService;

    @Override
    public CommonResponse<ChangeMaintargetVO> saveChange(ChangeMaintargetVO saveOrUpdateVO) {
        //检验该单据是否存在
        boolean exitBill = false;
        if(saveOrUpdateVO.getId()!=null){
            ChangeMaintargetEntity e = this.getById(saveOrUpdateVO);
            if(e!=null){
                exitBill = true;
            }
        }
        ChangeMaintargetEntity entity = BeanMapper.map(saveOrUpdateVO, ChangeMaintargetEntity.class);
        //检验是否存在未生效的变更单据，若存在，则不能变更
        QueryWrapper<ChangeMaintargetEntity> queryWrapper = new QueryWrapper<ChangeMaintargetEntity>();
        queryWrapper.eq("maintarget_id", saveOrUpdateVO.getMaintargetId());
        queryWrapper.eq("dr", 0);
        queryWrapper.notIn("bill_state", 1, 3);
        if(saveOrUpdateVO.getId()!=null){
            queryWrapper.ne("id", saveOrUpdateVO.getId());
        }
        List<ChangeMaintargetEntity> exit = this.list(queryWrapper);
        if(exit!=null&&exit.size()>0){
            throw new BusinessException("已存在未完成的变更单据，不能新增新的变更单据");
        }

        //处理子表数据
        //项目主要目标子表
        this.saveOrUpdate(entity, false);

        ChangeMaintargetVO vo = BeanMapper.map(entity, ChangeMaintargetVO.class);
        vo.setMaintargetdetailEntities(saveOrUpdateVO.getMaintargetdetailEntities());
        vo.setRecordMaintargetList(saveOrUpdateVO.getRecordMaintargetList());
        if(!exitBill){
            //查询当前项目主要目标信息，将状态改为变更中
            MaintargetEntity maintargetEntity = maintargetService.selectById(vo.getMaintargetId());
            maintargetEntity.setChangeState("2");//状态改为变更中
            maintargetEntity.setChangeId(vo.getId());
            maintargetService.saveOrUpdate(maintargetEntity, false);
        }

        //构建树形结构
        List<ChangemaintargetdetailVO> maintargetdetailEntities = vo.getMaintargetdetailEntities();
        List<ChangemaintargetdetailVO> treeData = createTreeData(maintargetdetailEntities);
        vo.setMaintargetdetailEntities(treeData);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    @Override
    public CommonResponse<String> deleteMaintarget(List<ChangeMaintargetVO> vos) {
        for(ChangeMaintargetVO vo : vos){
            ChangeMaintargetEntity changeMaintarget = this.getById(vo.getId());
            MaintargetEntity maintargetEntity = maintargetService.selectById(changeMaintarget.getMaintargetId());
            QueryWrapper<RecordMaintargetEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("dr", 0);
            queryWrapper.eq("maintarget_id", changeMaintarget.getMaintargetId());
            List<RecordMaintargetEntity> records = recordMaintargetService.list(queryWrapper);
            if(records!=null&&records.size()>0){
                maintargetEntity.setChangeState("3");//状态改为已变更
            }else{
                maintargetEntity.setChangeState("1");//状态改为未变更
            }
            maintargetEntity.setChangeId(null);
            maintargetService.saveOrUpdate(maintargetEntity, false);
        }
        this.removeByIds(vos.stream().map(ChangeMaintargetVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    public static List<ChangemaintargetdetailVO> createTreeData(List<ChangemaintargetdetailVO> list) {
        List<ChangemaintargetdetailVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();

        //循环list，放入listMap重
        Map<String, ChangemaintargetdetailVO> listMap = new HashMap<>();
        for(ChangemaintargetdetailVO item:list) {
            listMap.put(item.getTid().toString(), item);
        }

        for(int i =0; i<list.size(); i++) {
            ChangemaintargetdetailVO item = list.get(i);
            String parentId = (item.getTpid() != null) ? item.getTpid().toString():"";
            ChangemaintargetdetailVO parent = listMap.get(parentId);
            if(parent != null) {
                List<ChangemaintargetdetailVO> child = (List<ChangemaintargetdetailVO>) parent.getChildren();
                if(child != null) {
                    child.add(item);
                }else{
                    List<ChangemaintargetdetailVO> children = new ArrayList<ChangemaintargetdetailVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getTid());
            }
        }

        for(String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }
}
