package com.ejianc.business.change.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.busniessplan.bean.CountersignatureEntity;
import com.ejianc.business.busniessplan.bean.FundrecoveryplanEntity;
import com.ejianc.business.busniessplan.service.IFundrecoveryplanService;
import com.ejianc.business.busniessplan.vo.CountersignatureVO;
import com.ejianc.business.busniessplan.vo.FundrecoveryplanVO;
import com.ejianc.business.change.bean.ChangeFundrecoveryplanEntity;
import com.ejianc.business.change.bean.ChangecountersignatureEntity;
import com.ejianc.business.change.mapper.ChangeFundrecoveryplanMapper;
import com.ejianc.business.change.service.IChangeFundrecoveryplanService;
import com.ejianc.business.change.vo.ChangeFundrecoveryplanVO;
import com.ejianc.business.record.bean.RecordFundrecoveryplanEntity;
import com.ejianc.business.record.bean.RecordcountersignatureEntity;
import com.ejianc.business.record.service.IRecordFundrecoveryplanService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import java.util.List;
import java.util.stream.Collectors;


/**
 * 项目资金回收流程策划变更
 * 
 * @author generator
 * 
 */
@Service("changeFundrecoveryplanService")
public class ChangeFundrecoveryplanServiceImpl extends BaseServiceImpl<ChangeFundrecoveryplanMapper, ChangeFundrecoveryplanEntity> implements IChangeFundrecoveryplanService {

    @Autowired
    private IFundrecoveryplanService fundrecoveryplanService;
    @Autowired
    private IRecordFundrecoveryplanService recordFundrecoveryplanService;
    @Override
    public CommonResponse<ChangeFundrecoveryplanVO> saveChange(ChangeFundrecoveryplanVO saveOrUpdateVO) {
        //检验该单据是否存在
        boolean exitBill = false;
        if(saveOrUpdateVO.getId()!=null){
            ChangeFundrecoveryplanEntity e = this.getById(saveOrUpdateVO);
            if(e!=null){
                exitBill = true;
            }
        }
        ChangeFundrecoveryplanEntity entity = BeanMapper.map(saveOrUpdateVO, ChangeFundrecoveryplanEntity.class);
        //检验是否存在未生效的变更单据，若存在，则不能变更
        QueryWrapper<ChangeFundrecoveryplanEntity> queryWrapper = new QueryWrapper<ChangeFundrecoveryplanEntity>();
        queryWrapper.eq("fundrecoveryplanning_id", saveOrUpdateVO.getFundrecoveryplanningId());
        queryWrapper.eq("dr", 0);
        queryWrapper.notIn("bill_state", 1, 3);
        if(saveOrUpdateVO.getId()!=null){
            queryWrapper.ne("id", saveOrUpdateVO.getId());
        }
        List<ChangeFundrecoveryplanEntity> exit = this.list(queryWrapper);
        if(exit!=null&&exit.size()>0){
            throw new BusinessException("已存在未完成的变更单据，不能新增新的变更单据");
        }

        //处理子表数据
        //限额设计指标分析子表
        this.saveOrUpdate(entity, false);

        ChangeFundrecoveryplanVO vo = BeanMapper.map(entity, ChangeFundrecoveryplanVO.class);
        vo.setFundrecoveryplanningdetailEntities(saveOrUpdateVO.getFundrecoveryplanningdetailEntities());
        vo.setRecordFundrecoveryplanList(saveOrUpdateVO.getRecordFundrecoveryplanList());
        if(!exitBill){
            //查询当前合同信息，将状态改为变更中
            FundrecoveryplanEntity fundrecoveryplanEntity = fundrecoveryplanService.selectById(vo.getFundrecoveryplanningId());
            fundrecoveryplanEntity.setChangeState("2");//状态改为变更中
            fundrecoveryplanEntity.setChangeId(vo.getId());
            fundrecoveryplanService.saveOrUpdate(fundrecoveryplanEntity, false);
        }
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    @Override
    public CommonResponse<String> deleteFundrecoveryplan(List<FundrecoveryplanVO> vos) {
        for(FundrecoveryplanVO vo : vos){
            ChangeFundrecoveryplanEntity entity = this.getById(vo.getId());
            FundrecoveryplanEntity fundrecoveryplanEntity = fundrecoveryplanService.selectById(entity.getFundrecoveryplanningId());
            QueryWrapper<RecordFundrecoveryplanEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("dr", 0);
            queryWrapper.eq("fundrecoveryplanning_id", fundrecoveryplanEntity.getId());
            List<RecordFundrecoveryplanEntity> records = recordFundrecoveryplanService.list(queryWrapper);
            if(records!=null&&records.size()>0){
                fundrecoveryplanEntity.setChangeState("3");//状态改为已变更
            }else{
                fundrecoveryplanEntity.setChangeState("1");//状态改为未变更
            }
            fundrecoveryplanEntity.setChangeId(null);
            fundrecoveryplanService.saveOrUpdate(fundrecoveryplanEntity, false);
        }
        this.removeByIds(vos.stream().map(FundrecoveryplanVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
}
