package com.ejianc.business.change.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.busniessplan.bean.PlanprojectEntity;
import com.ejianc.business.busniessplan.bean.PlanprojectdetailEntity;
import com.ejianc.business.busniessplan.service.IPlanprojectService;
import com.ejianc.business.busniessplan.vo.PlanprojectdetailVO;
import com.ejianc.business.change.bean.ChangePlanprojectEntity;
import com.ejianc.business.change.bean.ChangePlanprojectdetailEntity;
import com.ejianc.business.change.controller.ChangePlanprojectController;
import com.ejianc.business.change.mapper.ChangePlanprojectMapper;
import com.ejianc.business.change.service.IChangePlanprojectService;
import com.ejianc.business.change.vo.ChangePlanprojectVO;
import com.ejianc.business.change.vo.ChangePlanprojectdetailVO;
import com.ejianc.business.record.bean.RecordPlanprojectEntity;
import com.ejianc.business.record.service.IRecordPlanprojectService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;


/**
 * 项目商务策划立项变更
 * 
 * @author generator
 * 
 */
@Service("changePlanprojectService")
public class ChangePlanprojectServiceImpl extends BaseServiceImpl<ChangePlanprojectMapper, ChangePlanprojectEntity> implements IChangePlanprojectService {

    @Autowired
    private IPlanprojectService planprojectService;
    @Autowired
    private IRecordPlanprojectService recordPlanprojectService;
    @Autowired
    private ChangePlanprojectController changePlanprojectController;
    @Override
    public CommonResponse<ChangePlanprojectVO> saveChange(ChangePlanprojectVO saveOrUpdateVO) {
        //检验该单据是否存在
        boolean exitBill = false;
        if(saveOrUpdateVO.getId()!=null){
            ChangePlanprojectEntity e = this.getById(saveOrUpdateVO);
            if(e!=null){
                exitBill = true;
            }
        }
        ChangePlanprojectEntity entity = BeanMapper.map(saveOrUpdateVO, ChangePlanprojectEntity.class);
        //检验是否存在未生效的变更单据，若存在，则不能变更
        QueryWrapper<ChangePlanprojectEntity> queryWrapper = new QueryWrapper<ChangePlanprojectEntity>();
        queryWrapper.eq("planproject_id", saveOrUpdateVO.getPlanprojectId());
        queryWrapper.eq("dr", 0);
        queryWrapper.notIn("bill_state", 1, 3);
        if(saveOrUpdateVO.getId()!=null){
            queryWrapper.ne("id", saveOrUpdateVO.getId());
        }
        List<ChangePlanprojectEntity> exit = this.list(queryWrapper);
        if(exit!=null&&exit.size()>0){
            throw new BusinessException("已存在未完成的变更单据，不能新增新的变更单据");
        }
        List<ChangePlanprojectdetailEntity> planprojectdetailEntities = entity.getPlanprojectdetailEntities();
        if (CollectionUtils.isNotEmpty(planprojectdetailEntities)){
            int i = 1;
            for (ChangePlanprojectdetailEntity planprojectdetailEntity : planprojectdetailEntities){
                planprojectdetailEntity.setSort(i);
                i = i+1;
            }
        }
        //处理子表数据
        //限额设计指标分析子表
        this.saveOrUpdate(entity, false);

        ChangePlanprojectVO vo = BeanMapper.map(entity, ChangePlanprojectVO.class);
        //构建子表树
//        List<ChangePlanprojectdetailVO> resPlanprojectdetailVO = changePlanprojectController.createTreeData(saveOrUpdateVO.getPlanprojectdetailEntities());
//        vo.setPlanprojectdetailEntities(resPlanprojectdetailVO);
//        vo.setRecordPlanprojectdetailList(saveOrUpdateVO.getRecordPlanprojectdetailList());
        if(!exitBill){
            //查询当前合同信息，将状态改为变更中
            PlanprojectEntity planprojectEntity = planprojectService.selectById(vo.getPlanprojectId());
            planprojectEntity.setChangeState("2");//状态改为变更中
            planprojectEntity.setChangeId(vo.getId());
            planprojectService.saveOrUpdate(planprojectEntity, false);
        }
        List<ChangePlanprojectdetailVO> planprojectdetailEntities1 = vo.getPlanprojectdetailEntities();
        if (CollectionUtils.isNotEmpty(planprojectdetailEntities1)){
            List<ChangePlanprojectdetailVO> list = planprojectdetailEntities1.stream().sorted(Comparator.comparing(ChangePlanprojectdetailVO::getSort))
                    .collect(Collectors.toList());
            vo.setPlanprojectdetailEntities(list);
        }
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    @Override
    public CommonResponse<String> delete(List<ChangePlanprojectVO> vos) {
        for(ChangePlanprojectVO vo : vos){
            ChangePlanprojectEntity entity = this.getById(vo.getId());
            PlanprojectEntity planprojectEntity = planprojectService.selectById(entity.getPlanprojectId());
            QueryWrapper<RecordPlanprojectEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("dr", 0);
            queryWrapper.eq("planproject_id", entity.getPlanprojectId());
            List<RecordPlanprojectEntity> records = recordPlanprojectService.list(queryWrapper);
            if(records!=null&&records.size()>0){
                planprojectEntity.setChangeState("3");//状态改为已变更
            }else{
                planprojectEntity.setChangeState("1");//状态改为未变更
            }
            planprojectEntity.setChangeId(null);
            planprojectService.saveOrUpdate(planprojectEntity, false);
        }
        this.removeByIds(vos.stream().map(ChangePlanprojectVO::getId).collect(Collectors.toList()),true);

        return CommonResponse.success("删除成功！");
    }
}
