package com.ejianc.business.change.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.busniessplan.bean.*;
import com.ejianc.business.change.bean.ChangeProjectworkplanEntity;
import com.ejianc.business.change.bean.ChangeProjectworkplandetailEntity;
import com.ejianc.business.record.bean.RecordProjectworkplanEntity;
import com.ejianc.business.record.bean.RecordProjectworkplandetailEntity;
import com.ejianc.business.busniessplan.service.IProjectworkplanService;
import com.ejianc.business.record.service.IRecordProjectworkplanService;
import com.ejianc.business.change.service.IChangeProjectworkplanService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.support.idworker.util.IdWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service("changeProjectworkplan") 
public class ChangeProjectworkplanBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	//业务类型
	private static final String Projectworkplan = "zjkj-projectworkplan";//项目商务工作计划
	private static final String ProjectworkplanT_CHANGE = "zjkj-projectworkplanChange";//项目商务工作计划变更
	private static final String Projectworkplan_RECORD = "zjkj-projectworkplanRecord";//项目商务工作计划变更记录

	//单据类型
	private static final String Projectworkplan_BILLTYPE_CODE = "BT202301000001";//项目商务工作计划
	private static final String Projectworkplan_CHANGE_BILLTYPE_CODE = "BT202301000003";//项目商务工作计划变更
	private static final String Projectworkplan_RECORD_BILLTYPE_CODE = "BT202210000046";//项目商务工作计划变更记录

	@Autowired
	private IAttachmentApi attachmentApi;
	@Autowired
	private IChangeProjectworkplanService iChangeProjectworkplanService;
	@Autowired
	private IProjectworkplanService iProjectworkplanService;
	@Autowired
	private IRecordProjectworkplanService iRecordProjectworkplanService;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		//1、获取目前单据信息、变更信息
		ChangeProjectworkplanEntity changeEntity = iChangeProjectworkplanService.selectById(billId);
		logger.info("变更单主表id=" + changeEntity.getId());
		ProjectworkplanEntity projectworkplanEntity = iProjectworkplanService.selectById(changeEntity.getOriginalId());
		logger.info("原始单据id=" + projectworkplanEntity.getId() + "主单据创建人" + projectworkplanEntity.getCreateUserCode());
		//获取历史版本条数
		QueryWrapper<RecordProjectworkplanEntity> recordWrapper = new QueryWrapper<>();
		recordWrapper.eq("original_id", projectworkplanEntity.getId());
		recordWrapper.eq("dr", 0);
		Integer count = iRecordProjectworkplanService.count(recordWrapper);
		logger.info("---------给变更记录表赋值--------");
		RecordProjectworkplanEntity recordProjectworkplanEntity = BeanMapper.map(projectworkplanEntity, RecordProjectworkplanEntity.class);
		Long recordId = IdWorker.getId();
		this.clearBaseData(recordProjectworkplanEntity);
		recordProjectworkplanEntity.setBillState(null);
		recordProjectworkplanEntity.setOriginalId(projectworkplanEntity.getId());
		recordProjectworkplanEntity.setProjectworkplanCode(projectworkplanEntity.getBillCode()+"-"+(count+1));
		recordProjectworkplanEntity.setId(recordId);
		recordProjectworkplanEntity.setBillCode(projectworkplanEntity.getBillCode());
		recordProjectworkplanEntity.setChangeReason(changeEntity.getChangeReason());
		recordProjectworkplanEntity.setEffectDate(new Date());
		logger.info("---------给变更记录子表赋值--------");
		List<ProjectworkplandetailEntity> projectworkplandetailEntities = projectworkplanEntity.getProjectworkplandetailEntities();
		if(projectworkplandetailEntities!=null&&projectworkplandetailEntities.size()>0){
			List<RecordProjectworkplandetailEntity> recordProjectworkplandetailEntities = new ArrayList<>();
				for(ProjectworkplandetailEntity entity : projectworkplandetailEntities){
				RecordProjectworkplandetailEntity reEntity = BeanMapper.map(entity, RecordProjectworkplandetailEntity.class);
				this.clearBaseData(reEntity);
				reEntity.setId(IdWorker.getId());
				reEntity.setOriginalId(entity.getId());
				recordProjectworkplandetailEntities.add(reEntity);
			}
			recordProjectworkplanEntity.setProjectworkplandetailEntities(recordProjectworkplandetailEntities);
		}
		logger.info("---------赋值附件信息--------");


		//复制附件信息到记录中
		String sourceBillType = "";
		//原单据类型
		sourceBillType = Projectworkplan_BILLTYPE_CODE;
		String targetBillType = "";
		//变更记录单剧类型
		targetBillType = Projectworkplan_RECORD_BILLTYPE_CODE;

		attachmentApi.copyFilesFromSourceBillToTargetBill(projectworkplanEntity.getId().toString(), sourceBillType, Projectworkplan , recordId.toString(), targetBillType, Projectworkplan_RECORD);
		iRecordProjectworkplanService.saveOrUpdate(recordProjectworkplanEntity, false);

		logger.info("---------修改当前单据状态--------");
		logger.info("创建人=" + projectworkplanEntity.getCreateUserCode());

		//3、修改当前单据状态
		ProjectworkplanEntity newProjectworkplanEntity = BeanMapper.map(changeEntity, ProjectworkplanEntity.class);
		newProjectworkplanEntity.setChangeState("3");//状态改为已变更
		newProjectworkplanEntity.setChangeId(null);
		newProjectworkplanEntity.setBillState(projectworkplanEntity.getBillState());
		newProjectworkplanEntity.setId(projectworkplanEntity.getId());
		newProjectworkplanEntity.setCreateTime(projectworkplanEntity.getCreateTime());
		newProjectworkplanEntity.setCreateUserCode(projectworkplanEntity.getCreateUserCode());
		newProjectworkplanEntity.setTenantId(projectworkplanEntity.getTenantId());
		newProjectworkplanEntity.setVersion(projectworkplanEntity.getVersion());


		logger.info("---------处理子表变更--------");
		List<ChangeProjectworkplandetailEntity> changeProjectworkplandetailEntities = changeEntity.getProjectworkplandetailEntities();
		if(changeProjectworkplandetailEntities != null && changeProjectworkplandetailEntities.size()>0) {
			List<ProjectworkplandetailEntity> newProjectworkplandetailList = BeanMapper.mapList(changeProjectworkplandetailEntities, ProjectworkplandetailEntity.class);

			//原始单据子表
			if (projectworkplandetailEntities != null && projectworkplandetailEntities.size() > 0) {
				ProjectworkplandetailEntity originalProjectworkplandetailInfo = projectworkplandetailEntities.get(0);

				for (int i = 0; i < changeProjectworkplandetailEntities.size(); i++) {
					ChangeProjectworkplandetailEntity changeProjectworkplandetail = changeProjectworkplandetailEntities.get(i);
					ProjectworkplandetailEntity newProjectworkplandetail = newProjectworkplandetailList.get(i);

					boolean isChangeUpdate = false;//true 变更更新数据 false 变更新增数据
					for (int j = 0; j < projectworkplandetailEntities.size(); j++) {
						ProjectworkplandetailEntity originalProjectworkplandetail = projectworkplandetailEntities.get(j);
						if (originalProjectworkplandetail.getId().equals(changeProjectworkplandetail.getOriginalId())) {

							newProjectworkplandetail.setId(originalProjectworkplandetail.getId());
							newProjectworkplandetail.setCreateTime(originalProjectworkplandetailInfo.getCreateTime());
							newProjectworkplandetail.setCreateUserCode(originalProjectworkplandetailInfo.getCreateUserCode());

							newProjectworkplandetail.setUpdateTime(changeProjectworkplandetail.getUpdateTime());
							newProjectworkplandetail.setUpdateUserCode(changeProjectworkplandetail.getCreateUserCode());

							isChangeUpdate = true;
							break;
						}
					}

					if (!isChangeUpdate) {//变更新增
						newProjectworkplandetail.setCreateTime(changeProjectworkplandetail.getUpdateTime());
						newProjectworkplandetail.setCreateUserCode(changeProjectworkplandetail.getCreateUserCode());
					}

					newProjectworkplandetail.setBillState(originalProjectworkplandetailInfo.getBillState());
					newProjectworkplandetail.setTenantId(originalProjectworkplandetailInfo.getTenantId());
					newProjectworkplandetail.setVersion(originalProjectworkplandetailInfo.getVersion());
				}
			}
			//原始单与变更单对比后（新增）
			newProjectworkplanEntity.setProjectworkplandetailEntities(newProjectworkplandetailList);
			//原始单与变更单对比后（删除）
			List<ProjectworkplandetailEntity> deleteDatas = new ArrayList<>();
			for (int i = 0; i < projectworkplandetailEntities.size(); i++) {
				ProjectworkplandetailEntity detail = projectworkplandetailEntities.get(i);
				boolean isSame = false;
				for (int j = 0; j < newProjectworkplandetailList.size(); j++) {
					ProjectworkplandetailEntity newDetail = newProjectworkplandetailList.get(j);
					if(detail.getId().equals(newDetail.getId())) {
						isSame = true;
					}
				}
				if(!isSame){//变更已删除行
					detail.setRowState("del");
					deleteDatas.add(detail);
				}
			}

			if(deleteDatas.size() > 0){
				newProjectworkplandetailList.addAll(deleteDatas);
				newProjectworkplanEntity.setProjectworkplandetailEntities(newProjectworkplandetailList);
			}
		}

		logger.info("---------保存--------");
		iProjectworkplanService.saveOrUpdate(newProjectworkplanEntity, false);

		sourceBillType = Projectworkplan_CHANGE_BILLTYPE_CODE;
		targetBillType = Projectworkplan_BILLTYPE_CODE;

		attachmentApi.copyFilesFromSourceBillToTargetBill(changeEntity.getId().toString(), sourceBillType, ProjectworkplanT_CHANGE, projectworkplanEntity.getId().toString(), targetBillType, Projectworkplan);
		iRecordProjectworkplanService.saveOrUpdate(recordProjectworkplanEntity, false);

		logger.info("---------结束--------");


		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}
	public void clearBaseData(BaseEntity entity){
		entity.setCreateTime(null);
		entity.setCreateUserCode(null);
		entity.setTenantId(null);
		entity.setUpdateTime(null);
		entity.setUpdateUserCode(null);
	}

}
