/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.busniessplan.excel;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.busniessplan.service.IPlanprojectdetailService;
import com.ejianc.business.busniessplan.vo.PlanprojectVO;
import com.ejianc.business.busniessplan.vo.PlanprojectdetailVO;
import com.ejianc.business.utils.DateUtils;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"planprojectExport"})
public class ExcelPlanprojectController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPlanprojectdetailService planprojectdetailService;

    @RequestMapping(value={"/downloadPlanproject"})
    @ResponseBody
    public void downloadTotalPrice(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"planproject-import.xlsx", (String)"\u9879\u76ee\u5546\u52a1\u7b56\u5212\u7acb\u9879\u6e05\u5355\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportPlanproject"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportTotalPric(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<PlanprojectdetailVO> successList = new ArrayList<PlanprojectdetailVO>();
        ArrayList<PlanprojectdetailVO> errorList = new ArrayList<PlanprojectdetailVO>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            ArrayList<String> planTypeList = new ArrayList<String>();
            planTypeList.add("1.1 \u5408\u540c\u6761\u4ef6\u4f18\u5316");
            planTypeList.add("1.2 \u7b7e\u8bc1\u7d22\u8d54");
            planTypeList.add("1.3 \u8bbe\u8ba1\u4f18\u5316\u3001\u8bbe\u8ba1\u53d8\u66f4");
            planTypeList.add("1.4 \u603b\u5305\u7ba1\u7406\u7b56\u5212");
            planTypeList.add("1.5 \u8ba4\u8d28\u8ba4\u4ef7\u4e0e\u91c7\u8d2d\u6548\u76ca");
            planTypeList.add("1.6 \u5176\u4ed6");
            planTypeList.add("2.1 \u8bbe\u8ba1\u4f18\u5316\u3001\u8bbe\u8ba1\u53d8\u66f4");
            planTypeList.add("2.2 \u65bd\u5de5\u7ec4\u7ec7\u53ca\u65b9\u6848\u4f18\u5316");
            planTypeList.add("2.3 \u94a2\u7b4b\u7ffb\u6837\u3001\u94a2\u7b4b\u7ba1\u63a7\u91cf\u5dee");
            planTypeList.add("2.4 \u5176\u4ed6");
            ArrayList<String> planStatusList = new ArrayList<String>();
            planStatusList.add("\u8ba1\u5212");
            planStatusList.add("\u5b9e\u65bd\u4e2d");
            planStatusList.add("\u5df2\u5b8c\u6210");
            ArrayList<String> planCategoryList = new ArrayList<String>();
            planCategoryList.add("\u5f00\u6e90");
            planCategoryList.add("\u8282\u6d41");
            for (int i = 1; i < result.size(); ++i) {
                String planStatus;
                List datas = (List)result.get(i);
                PlanprojectdetailVO planprojectdetailVO = new PlanprojectdetailVO();
                planprojectdetailVO.setId(IdWorker.getId());
                planprojectdetailVO.setPlanType(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(2))) ? (String)datas.get(2) : null);
                planprojectdetailVO.setPlanContent(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(3))) ? (String)datas.get(3) : null);
                planprojectdetailVO.setTargetAmount(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(5))) ? new BigDecimal((String)datas.get(5)) : null);
                planprojectdetailVO.setTakenMeasures(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(6))) ? (String)datas.get(6) : null);
                planprojectdetailVO.setPersonLiable(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(7))) ? (String)datas.get(7) : null);
                String arr = (String)datas.get(8);
                if (!DateUtils.grepDate(arr)) {
                    planprojectdetailVO.setErrorMsg("\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e");
                    errorList.add(planprojectdetailVO);
                    continue;
                }
                planprojectdetailVO.setProposedImplementationTime(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(8))) ? DateUtils.Date((String)datas.get(8)) : null);
                if (datas.get(0) == null || StringUtils.isBlank((CharSequence)((CharSequence)datas.get(0)))) {
                    planprojectdetailVO.setErrorMsg("\u7b56\u5212\u4e13\u9879\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                    errorList.add(planprojectdetailVO);
                    continue;
                }
                planprojectdetailVO.setCategoryAndName((String)datas.get(0));
                planprojectdetailVO.setPlanCategory(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(1))) ? (String)datas.get(1) : null);
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(1)))) {
                    planprojectdetailVO.setPlanStatus(null);
                } else {
                    planStatus = (String)datas.get(1);
                    if (planCategoryList.contains(planStatus)) {
                        planprojectdetailVO.setPlanStatus((String)datas.get(1));
                    } else {
                        planprojectdetailVO.setErrorMsg("\u7b56\u5212\u7c7b\u522b\u4e0d\u5bf9,\u53ea\u80fd\u662f \u5f00\u6e90,\u8282\u6d41");
                        errorList.add(planprojectdetailVO);
                        continue;
                    }
                }
                planprojectdetailVO.setPlanType(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(2))) ? (String)datas.get(2) : null);
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(2)))) {
                    planprojectdetailVO.setPlanType(null);
                } else {
                    String planType = (String)datas.get(2);
                    if (planTypeList.contains(planType)) {
                        planprojectdetailVO.setPlanType((String)datas.get(2));
                    } else {
                        planprojectdetailVO.setErrorMsg("\u7b56\u5212\u7c7b\u578b\u6709\u8bef");
                        errorList.add(planprojectdetailVO);
                        continue;
                    }
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(4)))) {
                    planprojectdetailVO.setPlanStatus(null);
                } else {
                    planStatus = (String)datas.get(4);
                    if (planStatusList.contains(planStatus)) {
                        planprojectdetailVO.setPlanStatus((String)datas.get(4));
                    } else {
                        planprojectdetailVO.setErrorMsg("\u7b56\u5212\u72b6\u6001\u53ea\u80fd\u662f :'\u8ba1\u5212,\u5b9e\u65bd\u4e2d,\u5df2\u5b8c\u6210!'");
                        errorList.add(planprojectdetailVO);
                        continue;
                    }
                }
                successList.add(planprojectdetailVO);
            }
        }
        ArrayList<PlanprojectdetailVO> resList = successList;
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", resList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        PlanprojectVO resVo = new PlanprojectVO();
        json.put("total", (Object)this.getTotalAmount(resList, resVo));
        return CommonResponse.success((Object)json);
    }

    private PlanprojectVO getTotalAmount(List<PlanprojectdetailVO> vos, PlanprojectVO resVo) {
        BigDecimal costEstimateTotal = new BigDecimal(0);
        BigDecimal reportAmountTotal = new BigDecimal(0);
        BigDecimal targetAmountTotal = new BigDecimal(0);
        BigDecimal completeAmountTotal = new BigDecimal(0);
        BigDecimal estimateProfitsTotal = new BigDecimal(0);
        for (PlanprojectdetailVO vo : vos) {
            if (vo.getCostEstimate() != null) {
                costEstimateTotal = costEstimateTotal.add(vo.getCostEstimate());
            }
            if (vo.getReportAmount() != null) {
                reportAmountTotal = reportAmountTotal.add(vo.getReportAmount());
            }
            if (vo.getTargetAmount() != null) {
                targetAmountTotal = targetAmountTotal.add(vo.getTargetAmount());
            }
            if (vo.getCompleteAmount() != null) {
                completeAmountTotal = completeAmountTotal.add(vo.getCompleteAmount());
            }
            if (vo.getEstimateProfits() == null) continue;
            estimateProfitsTotal = estimateProfitsTotal.add(vo.getEstimateProfits());
        }
        resVo.setCostEstimateTotal(costEstimateTotal);
        resVo.setReportAmountTotal(reportAmountTotal);
        resVo.setTargetAmountTotal(targetAmountTotal);
        resVo.setCompleteAmountTotal(completeAmountTotal);
        resVo.setEstimateProfitsTotal(estimateProfitsTotal);
        return resVo;
    }

    public static List<PlanprojectdetailVO> createTreeData(List<PlanprojectdetailVO> list) {
        ArrayList<PlanprojectdetailVO> resp = new ArrayList<PlanprojectdetailVO>();
        ArrayList<String> rootItems = new ArrayList<String>();
        HashMap<String, PlanprojectdetailVO> listMap = new HashMap<String, PlanprojectdetailVO>();
        for (PlanprojectdetailVO item : list) {
            listMap.put(item.getTid().toString(), item);
        }
        for (int i = 0; i < list.size(); ++i) {
            PlanprojectdetailVO item;
            item = list.get(i);
            String parentId = item.getTpid() != null ? item.getTpid().toString() : "";
            PlanprojectdetailVO parent = (PlanprojectdetailVO)((Object)listMap.get(parentId));
            if (parent != null) {
                List<PlanprojectdetailVO> child = parent.getChildren();
                if (child != null) {
                    child.add(item);
                    continue;
                }
                ArrayList<PlanprojectdetailVO> children = new ArrayList<PlanprojectdetailVO>();
                children.add(item);
                parent.setChildren(children);
                continue;
            }
            rootItems.add(item.getTid());
        }
        for (String rootId : rootItems) {
            resp.add((PlanprojectdetailVO)((Object)listMap.get(rootId)));
        }
        return resp;
    }

    @RequestMapping(value={"/excelExportPlanprojectFromDatabase"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportbusinessplanningeffectFromDatabase(@RequestBody PlanprojectVO planprojectVO, HttpServletResponse response) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"mid", (Object)planprojectVO.getId());
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.planprojectdetailService.list((Wrapper)queryWrapper);
        List<PlanprojectdetailVO> resList = BeanMapper.mapList((Iterable)list, PlanprojectdetailVO.class);
        resList = ExcelPlanprojectController.createTreeData(resList);
        ArrayList<PlanprojectdetailVO> records = new ArrayList<PlanprojectdetailVO>();
        for (PlanprojectdetailVO vo : resList) {
            records.add(vo);
            if (vo.getChildren() == null || vo.getChildren().size() <= 0) continue;
            this.splitList(vo.getChildren(), records);
        }
        HashMap<String, List<PlanprojectdetailVO>> beans = new HashMap<String, List<PlanprojectdetailVO>>();
        beans.put("records", this.handleSpecialField(records));
        ExcelExport.getInstance().export("planproject-export.xlsx", beans, response);
    }

    private List<PlanprojectdetailVO> handleSpecialField(List<PlanprojectdetailVO> resList) {
        for (int i = 0; i < resList.size(); ++i) {
            PlanprojectdetailVO planprojectdetailVO = resList.get(i);
            if (planprojectdetailVO.getCompleteTime() != null) {
                planprojectdetailVO.setCompleteTimeShow(DateUtils.dateSimple(planprojectdetailVO.getCompleteTime()));
            }
            if (planprojectdetailVO.getInitiateDate() != null) {
                planprojectdetailVO.setInitiateDateShow(DateUtils.dateSimple(planprojectdetailVO.getInitiateDate()));
            }
            if (planprojectdetailVO.getProposedCompleteTime() != null) {
                planprojectdetailVO.setProposedCompleteTimeShow(DateUtils.dateSimple(planprojectdetailVO.getProposedCompleteTime()));
            }
            if (planprojectdetailVO.getFinalCompleteTime() != null) {
                planprojectdetailVO.setFinalCompleteTimeShow(DateUtils.dateSimple(planprojectdetailVO.getFinalCompleteTime()));
            }
            if (planprojectdetailVO.getProposedImplementationTime() == null) continue;
            planprojectdetailVO.setProposedImplementationTimeShow(DateUtils.dateSimple(planprojectdetailVO.getProposedImplementationTime()));
        }
        return resList;
    }

    @RequestMapping(value={"/excelExportPlanprojectFromPage"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportbusinessplanningeffectFromPage(@RequestBody List<PlanprojectdetailVO> list, HttpServletResponse response) {
        HashMap<String, List<PlanprojectdetailVO>> beans = new HashMap<String, List<PlanprojectdetailVO>>();
        ArrayList<PlanprojectdetailVO> records = new ArrayList<PlanprojectdetailVO>();
        for (PlanprojectdetailVO vo : list) {
            records.add(vo);
            if (vo.getChildren() == null || vo.getChildren().size() <= 0) continue;
            this.splitList(vo.getChildren(), records);
        }
        beans.put("records", this.handleSpecialField(records));
        ExcelExport.getInstance().export("planproject-export.xlsx", beans, response);
    }

    private void splitList(List<PlanprojectdetailVO> list, List<PlanprojectdetailVO> records) {
        for (PlanprojectdetailVO vo : list) {
            records.add(vo);
            if (vo.getChildren() == null || vo.getChildren().size() <= 0) continue;
            this.splitList(vo.getChildren(), records);
        }
    }
}

