package com.ejianc.business.change.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.busniessplan.bean.BusinessplanningeffectEntity;
import com.ejianc.business.busniessplan.bean.BusinessplanningeffectdetailEntity;
import com.ejianc.business.busniessplan.bean.MaintargetEntity;
import com.ejianc.business.busniessplan.service.IBusinessplanningeffectService;
import com.ejianc.business.busniessplan.vo.BusinessplanningeffectVO;
import com.ejianc.business.busniessplan.vo.BusinessplanningeffectdetailVO;
import com.ejianc.business.busniessplan.vo.MaintargetVO;
import com.ejianc.business.change.bean.ChangeMaintargetEntity;
import com.ejianc.business.change.bean.ChangebusinessplaneffectdetailEntity;
import com.ejianc.business.change.bean.ChangebusinessplanningeffectEntity;
import com.ejianc.business.change.controller.ChangebusinessplanningeffectController;
import com.ejianc.business.change.mapper.ChangebusinessplanningeffectMapper;
import com.ejianc.business.change.service.IChangebusinessplanningeffectService;
import com.ejianc.business.change.vo.ChangebusinessplaneffectdetailVO;
import com.ejianc.business.change.vo.ChangebusinessplanningeffectVO;
import com.ejianc.business.record.bean.RecordMaintargetEntity;
import com.ejianc.business.record.bean.RecordbusinessplanningeffectEntity;
import com.ejianc.business.record.service.IRecordbusinessplanningeffectService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;


/**
 * 项目商务策划效果变更
 * 
 * @author generator
 * 
 */
@Service("changebusinessplanningeffectService")
public class ChangebusinessplanningeffectServiceImpl extends BaseServiceImpl<ChangebusinessplanningeffectMapper, ChangebusinessplanningeffectEntity> implements IChangebusinessplanningeffectService {

    @Autowired
    private IBusinessplanningeffectService businessplanningeffectService;
    @Autowired
    private ChangebusinessplanningeffectController changebusinessplanningeffectController;
    @Autowired
    private IRecordbusinessplanningeffectService recordbusinessplanningeffectService;

    @Override
    public CommonResponse<ChangebusinessplanningeffectVO> saveChange(ChangebusinessplanningeffectVO saveOrUpdateVO) {
        //检验该单据是否存在
        boolean exitBill = false;
        if(saveOrUpdateVO.getId()!=null){
            ChangebusinessplanningeffectEntity e = this.getById(saveOrUpdateVO);
            if(e!=null){
                exitBill = true;
            }
        }
        ChangebusinessplanningeffectEntity entity = BeanMapper.map(saveOrUpdateVO, ChangebusinessplanningeffectEntity.class);
        //检验是否存在未生效的变更单据，若存在，则不能变更
        QueryWrapper<ChangebusinessplanningeffectEntity> queryWrapper = new QueryWrapper<ChangebusinessplanningeffectEntity>();
        queryWrapper.eq("businessplanningeffect_id", saveOrUpdateVO.getBusinessplanningeffectId());
        queryWrapper.eq("dr", 0);
        queryWrapper.notIn("bill_state", 1, 3);
        if(saveOrUpdateVO.getId()!=null){
            queryWrapper.ne("id", saveOrUpdateVO.getId());
        }
        List<ChangebusinessplanningeffectEntity> exit = this.list(queryWrapper);
        if(exit!=null&&exit.size()>0){
            throw new BusinessException("已存在未完成的变更单据，不能新增新的变更单据");
        }
        List<ChangebusinessplaneffectdetailEntity> planprojectdetailEntities = entity.getBusinessplanningeffectdetailEntities();
        if (CollectionUtils.isNotEmpty(planprojectdetailEntities)){
            int i = 1;
            for (ChangebusinessplaneffectdetailEntity planprojectdetailEntity : planprojectdetailEntities){
                planprojectdetailEntity.setSort(i);
                i = i+1;
            }
        }

        //处理子表数据
        //限额设计指标分析子表
        this.saveOrUpdate(entity, false);

        ChangebusinessplanningeffectVO vo = BeanMapper.map(entity, ChangebusinessplanningeffectVO.class);
        //构建子表树
//        List<ChangebusinessplaneffectdetailVO> resBusinessplaneffectdetailVO = changebusinessplanningeffectController.createTreeData(saveOrUpdateVO.getBusinessplanningeffectdetailEntities());
//        vo.setBusinessplanningeffectdetailEntities(resBusinessplaneffectdetailVO);
        vo.setRecordbusinessplanningeffectList(saveOrUpdateVO.getRecordbusinessplanningeffectList());
        if(!exitBill){
            //查询当前合同信息，将状态改为变更中
            BusinessplanningeffectEntity businessplanningeffectEntity = businessplanningeffectService.selectById(vo.getBusinessplanningeffectId());
            businessplanningeffectEntity.setChangeState("2");//状态改为变更中
            businessplanningeffectEntity.setChangeId(vo.getId());
            businessplanningeffectService.saveOrUpdate(businessplanningeffectEntity, false);
        }

        List<ChangebusinessplaneffectdetailVO> planprojectdetailEntities1 = vo.getBusinessplanningeffectdetailEntities();
        if (CollectionUtils.isNotEmpty(planprojectdetailEntities1)){
            List<ChangebusinessplaneffectdetailVO> list1 = planprojectdetailEntities1.stream().sorted(Comparator.comparing(ChangebusinessplaneffectdetailVO::getSort))
                    .collect(Collectors.toList());
            vo.setBusinessplanningeffectdetailEntities(list1);
        }

        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    @Override
    public CommonResponse<String> deleteBusinessplanningeffect(List<BusinessplanningeffectVO> vos) {
        for(BusinessplanningeffectVO vo : vos){
            ChangebusinessplanningeffectEntity entity = this.getById(vo.getId());
            BusinessplanningeffectEntity businessplanningeffect = businessplanningeffectService.selectById(entity.getBusinessplanningeffectId());
            QueryWrapper<RecordbusinessplanningeffectEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("dr", 0);
            queryWrapper.eq("businessplanningeffect_id", entity.getBusinessplanningeffectId());
            List<RecordbusinessplanningeffectEntity> records = recordbusinessplanningeffectService.list(queryWrapper);
            if(records!=null&&records.size()>0){
                businessplanningeffect.setChangeState("3");//状态改为已变更
            }else{
                businessplanningeffect.setChangeState("1");//状态改为未变更
            }
            businessplanningeffect.setChangeId(null);
            businessplanningeffectService.saveOrUpdate(businessplanningeffect, false);
        }
        this.removeByIds(vos.stream().map(BusinessplanningeffectVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
}
