package com.ejianc.business.change.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.busniessplan.bean.PlanprojectEntity;
import com.ejianc.business.busniessplan.bean.PlanprojectdetailEntity;
import com.ejianc.business.busniessplan.service.IPlanprojectService;
import com.ejianc.business.change.bean.ChangePlanprojectEntity;
import com.ejianc.business.change.bean.ChangePlanprojectdetailEntity;
import com.ejianc.business.change.service.IChangePlanprojectService;
import com.ejianc.business.record.bean.RecordPlanprojectEntity;
import com.ejianc.business.record.bean.RecordPlanprojectdetailEntity;
import com.ejianc.business.record.service.IRecordPlanprojectService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service("changePlanproject") 
public class ChangePlanprojectBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	//业务类型
	private static final String Planproject = "zjkj-planproject";//项目商务策划立项
	private static final String Planproject_CHANGE = "zjkj-planprojectChange";//项目商务策划立项变更
	private static final String Planproject_RECORD = "zjkj-planprojectRecord";//项目商务策划立项变更记录

	//单据类型
	private static final String Planproject_BILLTYPE_CODE = "BT202202000013";//项目商务策划立项
	private static final String Planproject_CHANGE_BILLTYPE_CODE = "BT202202000057";//项目商务策划立项变更
	private static final String Planproject_RECORD_BILLTYPE_CODE = "BT202202000058";//项目商务策划立项变更记录

	@Autowired
	private IAttachmentApi attachmentApi;
	@Autowired
	private IChangePlanprojectService changePlanprojectService;
	@Autowired
	private IPlanprojectService planprojectService;
	@Autowired
	private IRecordPlanprojectService recordPlanprojectService;
	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		//1、获取目前单据信息、变更信息
		ChangePlanprojectEntity changeEntity = changePlanprojectService.selectById(billId);
		logger.info("变更单主表id=" + changeEntity.getPlanprojectId());
		PlanprojectEntity planprojectEntity = planprojectService.selectById(changeEntity.getPlanprojectId());
		logger.info("主单据id=" + changeEntity.getId() + "主单据创建人" + changeEntity.getCreateUserCode());

		//获取历史版本条数
		QueryWrapper<RecordPlanprojectEntity> recordWrapper = new QueryWrapper<>();
		recordWrapper.eq("planproject_id", planprojectEntity.getId());
		recordWrapper.eq("dr", 0);
		Integer count = recordPlanprojectService.count(recordWrapper);

		logger.info("---------给变更记录表赋值--------");
		RecordPlanprojectEntity recordPlanprojectEntity = BeanMapper.map(planprojectEntity, RecordPlanprojectEntity.class);
		Long recordId = IdWorker.getId();
		this.clearBaseData(recordPlanprojectEntity);
		recordPlanprojectEntity.setBillState(null);
		recordPlanprojectEntity.setPlanprojectId(planprojectEntity.getId());
		recordPlanprojectEntity.setPlanprojectCode(planprojectEntity.getBillCode()+"-"+(count+1));
		recordPlanprojectEntity.setId(recordId);
		recordPlanprojectEntity.setBillCode(planprojectEntity.getBillCode());
		recordPlanprojectEntity.setChangeReason(changeEntity.getChangeReason());
		recordPlanprojectEntity.setEffectTime(new Date());

		logger.info("---------给变更记录子表赋值--------");
		List<PlanprojectdetailEntity> planprojectdetailEntity = planprojectEntity.getPlanprojectdetailEntities();
		if(planprojectdetailEntity!=null&&planprojectdetailEntity.size()>0){
			List<RecordPlanprojectdetailEntity> recordPlanprojectdetailEntity = new ArrayList<>();
			for(PlanprojectdetailEntity entity : planprojectdetailEntity){
				RecordPlanprojectdetailEntity reEntity = BeanMapper.map(entity, RecordPlanprojectdetailEntity.class);
				this.clearBaseData(reEntity);
				reEntity.setMid(recordId);
				recordPlanprojectdetailEntity.add(reEntity);
				entity.setRowState("del");
			}
			recordPlanprojectEntity.setPlanprojectdetailEntities(recordPlanprojectdetailEntity);
		}
		logger.info("---------赋值附件信息--------");
		//复制附件信息到记录中
		String sourceBillType = "";
		//原单据类型
		sourceBillType = Planproject_BILLTYPE_CODE;
		String targetBillType = "";
		//变更记录单剧类型
		targetBillType = Planproject_RECORD_BILLTYPE_CODE;

		attachmentApi.copyFilesFromSourceBillToTargetBill(planprojectEntity.getId().toString(), sourceBillType, Planproject , recordId.toString(), targetBillType, Planproject_RECORD);
		recordPlanprojectService.saveOrUpdate(recordPlanprojectEntity, false);

		logger.info("---------修改当前单据状态--------");
		logger.info("创建人=" + planprojectEntity.getCreateUserCode());

		//3、修改当前单据状态
		PlanprojectEntity newPlanprojectEntity = BeanMapper.map(changeEntity, PlanprojectEntity.class);
		newPlanprojectEntity.setChangeState("3");//状态改为已变更
		newPlanprojectEntity.setChangeId(null);
		newPlanprojectEntity.setBillState(planprojectEntity.getBillState());
		newPlanprojectEntity.setId(planprojectEntity.getId());
		newPlanprojectEntity.setCreateTime(planprojectEntity.getCreateTime());
		newPlanprojectEntity.setCreateUserCode(planprojectEntity.getCreateUserCode());
		newPlanprojectEntity.setTenantId(planprojectEntity.getTenantId());
		newPlanprojectEntity.setVersion(planprojectEntity.getVersion());
		List<ChangePlanprojectdetailEntity> planprojectdetailEntities = changeEntity.getPlanprojectdetailEntities();
		if (CollectionUtils.isNotEmpty(planprojectdetailEntities)){
			BigDecimal targetAmountAll = planprojectdetailEntities.stream().map(ChangePlanprojectdetailEntity::getTargetAmount)
					.reduce(BigDecimal.ZERO, BigDecimal::add);
			newPlanprojectEntity.setTargetAmountTotal(targetAmountAll);


		}


		logger.info("---------处理子表变更--------");
		//子表
		//处理子表变更
		List<ChangePlanprojectdetailEntity> changePlanprojectdetailEntitiesList = changeEntity.getPlanprojectdetailEntities();
		if(changePlanprojectdetailEntitiesList!=null&&changePlanprojectdetailEntitiesList.size()>0){
			List<PlanprojectdetailEntity> newQuotaanalysisdetailList = BeanMapper.mapList(changePlanprojectdetailEntitiesList, PlanprojectdetailEntity.class);
			newQuotaanalysisdetailList.addAll(planprojectdetailEntity);
			//汇总行数
			long lineNum = changePlanprojectdetailEntitiesList.stream().count();
			newPlanprojectEntity.setLineNum((int)lineNum);
			newPlanprojectEntity.setPlanprojectdetailEntities(newQuotaanalysisdetailList);
		}



		logger.info("---------保存--------");
		planprojectService.saveOrUpdate(newPlanprojectEntity, false);

		sourceBillType = Planproject_CHANGE_BILLTYPE_CODE;
		targetBillType = Planproject_BILLTYPE_CODE;

		attachmentApi.copyFilesFromSourceBillToTargetBill(changeEntity.getId().toString(), sourceBillType, Planproject_CHANGE, planprojectEntity.getId().toString(), targetBillType, Planproject);
		recordPlanprojectService.saveOrUpdate(recordPlanprojectEntity, false);

		logger.info("---------结束--------");

		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	public void clearBaseData(BaseEntity entity){
		entity.setCreateTime(null);
		entity.setCreateUserCode(null);
		entity.setTenantId(null);
		entity.setUpdateTime(null);
		entity.setUpdateUserCode(null);
	}

}
