/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.contractpub.util;

import com.ejianc.business.contractpub.util.ConvertField;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanConvertorUtil {
    private static Logger logger = LoggerFactory.getLogger(BeanConvertorUtil.class);

    public static <S, T> T convert(S src, T target) throws Exception {
        Map<String, Field> targetFieldsMap = Arrays.stream(target.getClass().getDeclaredFields()).collect(Collectors.toMap(Field::getName, Function.identity(), (k1, k2) -> k2));
        Map<String, Field> targetSupFieldMap = Arrays.stream(target.getClass().getSuperclass().getDeclaredFields()).collect(Collectors.toMap(Field::getName, Function.identity(), (k1, k2) -> k2));
        return BeanConvertorUtil.convertBean(src, src.getClass().getDeclaredFields(), target, targetFieldsMap, targetSupFieldMap);
    }

    public static <S, T> T convert(S src, Class<T> targetClz) throws Exception {
        Map<String, Field> targetFieldsMap = Arrays.stream(targetClz.getDeclaredFields()).collect(Collectors.toMap(Field::getName, Function.identity(), (k1, k2) -> k2));
        Map<String, Field> targetSupFieldMap = Arrays.stream(targetClz.getSuperclass().getDeclaredFields()).collect(Collectors.toMap(Field::getName, Function.identity(), (k1, k2) -> k2));
        return BeanConvertorUtil.convertBean(src, src.getClass().getDeclaredFields(), targetClz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), targetFieldsMap, targetSupFieldMap);
    }

    private static <S, T> T convertBean(S src, Field[] srcFields, T targetInstance, Map<String, Field> targetFieldsMap, Map<String, Field> targetSupFieldMap) throws Exception {
        Class<?> targetClz = targetInstance.getClass();
        for (Field field : srcFields) {
            String[] curTargetFields;
            field.setAccessible(true);
            ArrayList<?> value = field.get(src);
            ConvertField annotation = field.getAnnotation(ConvertField.class);
            String annTargetFieldName = null;
            String typeName = null;
            if (null == annotation) continue;
            annTargetFieldName = StringUtils.isNotBlank((CharSequence)annotation.targetField()) ? annotation.targetField() : field.getName();
            for (String targetFieldName : curTargetFields = annTargetFieldName.split(",")) {
                typeName = field.getGenericType().getTypeName();
                if (annotation.targetFieldType().equals((Object)ConvertField.TargetType.CLASS)) {
                    List tmpList = null;
                    ArrayList targetList = null;
                    Map<String, Field> subTargetFieldsMap = null;
                    Map<String, Field> subTargetSupFieldMap = null;
                    Field[] subSrcFields = null;
                    String targetFieldTypeName = targetFieldsMap.get(targetFieldName).getGenericType().getTypeName();
                    Class<?> targetSubClass = Class.forName(targetFieldTypeName.substring(typeName.indexOf("<") + 1, targetFieldTypeName.indexOf(">")));
                    subTargetFieldsMap = Arrays.stream(targetSubClass.getDeclaredFields()).collect(Collectors.toMap(Field::getName, Function.identity(), (k1, k2) -> k2));
                    subTargetSupFieldMap = Arrays.stream(targetSubClass.getSuperclass().getDeclaredFields()).collect(Collectors.toMap(Field::getName, Function.identity(), (k1, k2) -> k2));
                    if (field.getGenericType().toString().indexOf("List") >= 0) {
                        tmpList = value;
                        targetList = new ArrayList();
                        if (CollectionUtils.isNotEmpty((Collection)tmpList)) {
                            for (Object item : tmpList) {
                                if (null == subSrcFields) {
                                    subSrcFields = item.getClass().getDeclaredFields();
                                }
                                targetList.add(BeanConvertorUtil.convertBean(item, subSrcFields, targetSubClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), subTargetFieldsMap, subTargetSupFieldMap));
                            }
                        }
                        value = targetList;
                    } else if (null != value) {
                        value = BeanConvertorUtil.convertBean(value, subSrcFields, targetSubClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), subTargetFieldsMap, subTargetSupFieldMap);
                    }
                }
                Class<?> c = BeanConvertorUtil.getMethodParamTypes(targetInstance, "set" + BeanConvertorUtil.captureName(targetFieldName));
                Method method = null;
                if (targetFieldsMap.containsKey(targetFieldName)) {
                    method = targetClz.getDeclaredMethod("set" + BeanConvertorUtil.captureName(targetFieldName), c);
                } else if (targetSupFieldMap.containsKey(targetFieldName)) {
                    method = targetClz.getSuperclass().getDeclaredMethod("set" + BeanConvertorUtil.captureName(targetFieldName), c);
                } else {
                    logger.error("\u76ee\u6807\u7c7b-{}\u53ca\u5176\u7236\u7c7b-{}\u4e2d\u672a\u627e\u5230\u5c5e\u6027-{}, \u8df3\u8fc7\u8be5\u5b57\u6bb5\u8d4b\u503c\uff01", new Object[]{targetClz.getName(), targetClz.getSuperclass().getName(), targetFieldName});
                    continue;
                }
                method.setAccessible(true);
                method.invoke(targetInstance, value);
            }
        }
        return targetInstance;
    }

    private static String captureName(String name) {
        name = name.substring(0, 1).toUpperCase() + name.substring(1);
        return name;
    }

    private static Class<?> getMethodParamTypes(Object classInstance, String methodName) {
        Method[] methods = classInstance.getClass().getMethods();
        Class<?> param = null;
        for (int i = 0; i < methods.length; ++i) {
            if (!methodName.equals(methods[i].getName())) continue;
            param = methods[i].getParameterTypes()[0];
        }
        return param;
    }
}

