package com.ejianc.framework.cache.serializer;

import java.io.Serializable;
import java.util.List;

public interface Serializer {

    /**
     * Java 内容树序列化回 byte[]
     *
     * @param data
     * @return
     */
    byte[] marshalToByte(Serializable data);


    /**
     * Java 内容树序列化回 String 数据
     *
     * @param data
     * @return
     */
    String marshalToString(Serializable data);

    /**
     * 将byte[]数据反序列化为java对象
     *
     * @param data
     * @return
     */
    Serializable unMarshal(byte[] data);


    /**
     * 将string数据反序列化为java对象
     *
     * @param data
     * @return
     */
    Serializable unMarshal(String data);


    /**
     * 将string数据反序列化为java对象
     *
     * @param dataList
     * @return
     */
    List<Serializable> unMarshal(List<byte[]> dataList);
}
