/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.cache;

import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.cache.redis.RedisPoolFactory;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.jedis.JedisClientConfiguration;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.Jackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.JdkSerializationRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springside.modules.nosql.redis.JedisTemplate;
import org.springside.modules.nosql.redis.pool.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

@Configuration
@ConfigurationProperties(prefix="ejc.redis")
public class CacheConfiguration {
    private static final String REDIS_DIRECT = "direct://";
    private int maxTotal = 10;
    private int maxIdle = 10;
    private int minIdle = 0;
    private long maxWaitMillis = -1L;
    private boolean testOnBorrow = false;
    private boolean testWhileIdle = false;
    private String hostName = "127.0.0.1";
    private int port = 6379;
    private String password;
    private int timeout = 2000;
    private int database = 0;

    @Bean
    public JedisPoolConfig getJedisPoolConfig() {
        JedisPoolConfig config = new JedisPoolConfig();
        config.setMaxTotal(this.maxTotal);
        config.setMaxIdle(this.maxIdle);
        config.setMinIdle(this.minIdle);
        config.setMaxWaitMillis(this.maxWaitMillis);
        config.setTestOnBorrow(this.testOnBorrow);
        config.setTestWhileIdle(this.testWhileIdle);
        return config;
    }

    @Bean
    public redis.clients.jedis.JedisPool getJedisPool() {
        return new redis.clients.jedis.JedisPool((GenericObjectPoolConfig)this.getJedisPoolConfig(), this.hostName, this.port, this.timeout, this.password, this.database);
    }

    @Bean
    public JedisConnectionFactory getJedisConnectionFactory() {
        RedisStandaloneConfiguration redisStandaloneConfiguration = new RedisStandaloneConfiguration();
        redisStandaloneConfiguration.setHostName(this.hostName);
        redisStandaloneConfiguration.setPort(this.port);
        redisStandaloneConfiguration.setDatabase(0);
        if (StringUtils.isNotBlank((String)this.password) && !"null".equalsIgnoreCase(this.password)) {
            redisStandaloneConfiguration.setPassword(RedisPassword.of((String)this.password));
        }
        JedisClientConfiguration.JedisPoolingClientConfigurationBuilder jpcb = (JedisClientConfiguration.JedisPoolingClientConfigurationBuilder)JedisClientConfiguration.builder();
        jpcb.poolConfig((GenericObjectPoolConfig)this.getJedisPoolConfig());
        JedisClientConfiguration jedisClientConfiguration = jpcb.build();
        JedisConnectionFactory jedisConnectionFactory = new JedisConnectionFactory(redisStandaloneConfiguration, jedisClientConfiguration);
        jedisConnectionFactory.afterPropertiesSet();
        return jedisConnectionFactory;
    }

    @Bean(value={"redisTemplate"})
    public RedisTemplate<String, Object> getRedisTemplate() {
        RedisTemplate template = new RedisTemplate();
        template.setConnectionFactory((RedisConnectionFactory)this.getJedisConnectionFactory());
        template.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        template.setValueSerializer((RedisSerializer)new JdkSerializationRedisSerializer());
        template.setHashKeySerializer((RedisSerializer)new StringRedisSerializer());
        template.setHashValueSerializer((RedisSerializer)new JdkSerializationRedisSerializer());
        template.afterPropertiesSet();
        return template;
    }

    @Bean(value={"jedisPool"})
    public JedisPool getRedisPoolFactory() {
        RedisPoolFactory redisPoolFactory = new RedisPoolFactory();
        String redisUrl = REDIS_DIRECT + this.hostName + ":" + this.port + "?poolSize=" + this.maxTotal + "&poolName=mypool";
        if (StringUtils.isNotBlank((String)this.password) && !"null".equalsIgnoreCase(this.password)) {
            redisUrl = redisUrl + "&password=" + this.password;
        }
        return redisPoolFactory.createJedisPool(redisUrl);
    }

    @Bean(value={"jedisTemplate"})
    public JedisTemplate getJedisTemplate() {
        JedisTemplate jedisTemplate = new JedisTemplate(this.getRedisPoolFactory());
        return jedisTemplate;
    }

    @Bean
    public CacheManager getCacheManager() {
        CacheManager cacheManager = new CacheManager();
        cacheManager.setJedisTemplate(this.getJedisTemplate());
        return cacheManager;
    }

    @Bean(value={"mpRedisTemplate"})
    public RedisTemplate<String, Object> mpRedisTemplate() {
        RedisTemplate redisTemplate = new RedisTemplate();
        redisTemplate.setConnectionFactory((RedisConnectionFactory)this.getJedisConnectionFactory());
        Jackson2JsonRedisSerializer jackson2JsonRedisSerializer = new Jackson2JsonRedisSerializer(Object.class);
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
        objectMapper.enableDefaultTyping(ObjectMapper.DefaultTyping.NON_FINAL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        jackson2JsonRedisSerializer.setObjectMapper(objectMapper);
        StringRedisSerializer redisSerializer = new StringRedisSerializer();
        redisTemplate.setKeySerializer((RedisSerializer)redisSerializer);
        redisTemplate.setHashKeySerializer((RedisSerializer)redisSerializer);
        redisTemplate.setValueSerializer((RedisSerializer)jackson2JsonRedisSerializer);
        redisTemplate.setHashValueSerializer((RedisSerializer)jackson2JsonRedisSerializer);
        redisTemplate.afterPropertiesSet();
        return redisTemplate;
    }

    public void setMaxTotal(int maxTotal) {
        this.maxTotal = maxTotal;
    }

    public void setMaxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
    }

    public void setMinIdle(int minIdle) {
        this.minIdle = minIdle;
    }

    public void setMaxWaitMillis(long maxWaitMillis) {
        this.maxWaitMillis = maxWaitMillis;
    }

    public void setTestOnBorrow(boolean testOnBorrow) {
        this.testOnBorrow = testOnBorrow;
    }

    public void setTestWhileIdle(boolean testWhileIdle) {
        this.testWhileIdle = testWhileIdle;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setDatabase(int database) {
        this.database = database;
    }
}

