package com.ejianc.framework.cache.redis;

import org.springside.modules.nosql.redis.pool.JedisPool;
import org.springside.modules.nosql.redis.pool.JedisPoolBuilder;

/**
 * RedisPoolFactory 
 */
public class RedisPoolFactory {
	/**
	 * 根据Spring传入的jedis配置URL创建一个JedisPool,以供JedisTemplate注入
	 * 
	 * @param url like direct://20.12.6.69:6379?poolSize=20&poolName=poolname
	 * 
	 * @return JedisPool
	 */
	public JedisPool createJedisPool(String url){
		return new JedisPoolBuilder().setUrl(url).buildPool();
	}
	
}

