/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.cache.redissonlock;

import com.ejianc.framework.cache.redissonlock.Locker;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;

public class RedissonLocker
implements Locker {
    private RedissonClient redissonClient;

    public RedissonLocker(RedissonClient redissonClient) {
        this.redissonClient = redissonClient;
    }

    @Override
    public void lock(String lockKey) {
        RLock lock = this.redissonClient.getLock(lockKey);
        lock.lock();
    }

    @Override
    public void unlock(String lockKey) {
        try {
            RLock lock = this.redissonClient.getLock(lockKey);
            lock.unlock();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void lock(String lockKey, int leaseTime) {
        RLock lock = this.redissonClient.getLock(lockKey);
        lock.lock((long)leaseTime, TimeUnit.SECONDS);
    }

    @Override
    public void lock(String lockKey, TimeUnit unit, int timeout) {
        RLock lock = this.redissonClient.getLock(lockKey);
        lock.lock((long)timeout, unit);
    }

    public void setRedissonClient(RedissonClient redissonClient) {
        this.redissonClient = redissonClient;
    }

    @Override
    public boolean tryLock(String lockKey) {
        RLock lock = this.redissonClient.getLock(lockKey);
        return lock.tryLock();
    }

    @Override
    public boolean tryLock(String lockKey, long waitTime, long leaseTime, TimeUnit unit) throws InterruptedException {
        RLock lock = this.redissonClient.getLock(lockKey);
        return lock.tryLock(waitTime, leaseTime, unit);
    }

    @Override
    public boolean isLocked(String lockKey) {
        RLock lock = this.redissonClient.getLock(lockKey);
        return lock.isLocked();
    }
}

