package com.ejianc.business.car.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.car.vo.MaintainLabourVO;
import com.ejianc.business.car.vo.MaintainMaterialVO;
import com.ejianc.business.car.vo.DispatchVO;

/**
 * 车辆维修
 * 
 * @author generator
 * 
 */
public class MaintainVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long carId; // 车牌号id
    private String carName; // 车辆名称 设备名称
    private String carCode; // 车牌号
    private Long carAreaId; // 车辆所在区域
    private String carAreaName; // 车辆所在区域
    private Long carProjectId; // 所属项目 车辆所在项目
    private String carProjectName; // 所属项目 车辆所在项目
    private Long orgId; // 所属组织
    private String orgName; // 所属组织
    private Long parentOrgId; // 所属上级组织
    private String parentOrgName; // 所属上级组织
    private Long carOrgId; // 所属公司 单据所属组织 
    private String carOrgName; // 所属公司 单据所属组织
    private BigDecimal maintainTaxMny; // 维修总金额
    private BigDecimal maintainMny; // 维修总金额(无税)
    private Date maintainDate; // 维修日期
    private Long employeeId; // 经办人
    private String employeeName; // 经办人
    private Long departmentId; // 经办部门
    private String departmentName; // 经办部门
    private String memo; // 备注
    private String billCode; // 单据编号

    private List<MaintainLabourVO> maintainLabourList = new ArrayList<>(); // 车辆维修-人工费
    private List<MaintainMaterialVO> maintainMaterialList = new ArrayList<>(); // 车辆维修-材料费
    private List<DispatchVO> dispatchList = new ArrayList<>(); // 车辆调度

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Long getCarId() {
        return carId;
    }

    public void setCarId(Long carId) {
        this.carId = carId;
    }
    public String getCarName() {
        return carName;
    }

    public void setCarName(String carName) {
        this.carName = carName;
    }
    public String getCarCode() {
        return carCode;
    }

    public void setCarCode(String carCode) {
        this.carCode = carCode;
    }
    public Long getCarAreaId() {
        return carAreaId;
    }

    public void setCarAreaId(Long carAreaId) {
        this.carAreaId = carAreaId;
    }
    public String getCarAreaName() {
        return carAreaName;
    }

    public void setCarAreaName(String carAreaName) {
        this.carAreaName = carAreaName;
    }
    public Long getCarProjectId() {
        return carProjectId;
    }

    public void setCarProjectId(Long carProjectId) {
        this.carProjectId = carProjectId;
    }
    public String getCarProjectName() {
        return carProjectName;
    }

    public void setCarProjectName(String carProjectName) {
        this.carProjectName = carProjectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Long getCarOrgId() {
        return carOrgId;
    }

    public void setCarOrgId(Long carOrgId) {
        this.carOrgId = carOrgId;
    }
    public String getCarOrgName() {
        return carOrgName;
    }

    public void setCarOrgName(String carOrgName) {
        this.carOrgName = carOrgName;
    }
    public BigDecimal getMaintainTaxMny() {
        return maintainTaxMny;
    }

    public void setMaintainTaxMny(BigDecimal maintainTaxMny) {
        this.maintainTaxMny = maintainTaxMny;
    }
    public BigDecimal getMaintainMny() {
        return maintainMny;
    }

    public void setMaintainMny(BigDecimal maintainMny) {
        this.maintainMny = maintainMny;
    }
    public Date getMaintainDate() {
        return maintainDate;
    }

    public void setMaintainDate(Date maintainDate) {
        this.maintainDate = maintainDate;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
     public List<MaintainLabourVO> getMaintainLabourList() {
        return maintainLabourList;
     }

     public void setMaintainLabourList(List<MaintainLabourVO> maintainLabourList) {
        this.maintainLabourList = maintainLabourList;
     }
     public List<MaintainMaterialVO> getMaintainMaterialList() {
        return maintainMaterialList;
     }

     public void setMaintainMaterialList(List<MaintainMaterialVO> maintainMaterialList) {
        this.maintainMaterialList = maintainMaterialList;
     }
     public List<DispatchVO> getDispatchList() {
        return dispatchList;
     }

     public void setDispatchList(List<DispatchVO> dispatchList) {
        this.dispatchList = dispatchList;
     }
}
